#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <syslog.h>
#include <arpa/inet.h>
#include <linux/sockios.h>
#include <net/if.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include "globals.h"
#include <unistd.h>
#include <sys/un.h>

#define SYSCONFD_UTIL_PATH     "/var/sysconfd_if/if0"

static int get_sockfd(void)
{
   static int sockfd = -1;

   if (sockfd == -1)
   {
      if ((sockfd = socket(PF_INET, SOCK_RAW, IPPROTO_RAW)) == -1)
      {
         perror("user: socket creating failed");
         return (-1);
      }
   }
   return sockfd;
}

int GetIpAddressStr(char *address, char *ifname)
{
   struct ifreq ifr;
   struct sockaddr_in *saddr;
   int fd;
   int succeeded = 0;

   fd = get_sockfd();
   if (fd >= 0 )
   {
      strncpy(ifr.ifr_name, ifname, IFNAMSIZ);
      ifr.ifr_addr.sa_family = AF_INET;
      if (ioctl(fd, SIOCGIFADDR, &ifr) == 0)
      {
         saddr = (struct sockaddr_in *)&ifr.ifr_addr;
         strcpy(address,inet_ntoa(saddr->sin_addr));
         succeeded = 1;
      }
      else
      {
         syslog(LOG_ERR, "Failure obtaining ip address of interface %s", ifname);
         strcpy(address, "0.0.0.0");
         succeeded = 0;
      }
   }
   return succeeded;
}

int getWanLinkStatus(void)
{
	FILE *fd;
	char buf[24];

	fd = fopen("/tmp/wanlink", "r");

	if(fd)
	{
		fgets(buf, sizeof(buf), fd);
		fclose(fd);

		return atoi(buf) == 0 ? 0 : 1;
	}

	return 1;
}

#if HAS_DEBUG /* cfho 2007-1121 */
void trace(int debuglevel, const char *format, ...)
{
  va_list ap;
  va_start(ap,format);
  if (g_vars.debug>=debuglevel) {
    vsyslog(LOG_DEBUG,format,ap);
  }
  va_end(ap);
}
#endif

#if HAS_OFFLINE_DOWNLOAD
/*****************************************************************
 * NAME: sysIsFileExisted
 * ---------------------------------------------------------------
 * FUNCTION:  Check whether the file is existed
 * INPUT:
 * OUTPUT:
 * Author:
 * Modify:
 ****************************************************************/
int sysIsFileExisted(const char *filename)
{
	int rval;
	// Check file existence.
	rval = access(filename, F_OK);
	
	return rval ? FALSE : TRUE;
}

/*****************************************************************
 * NAME: sysconf_util_request
 * ---------------------------------------------------------------
 * FUNCTION:
 * INPUT:
 * OUTPUT:
 * Author:   Norkay 2008-08-01
 * Modify:   Norkay 2008-08-22 '&'
 ****************************************************************/
static int sysconf_util_request(int s, const char *cmd, size_t cmd_len, char *reply, size_t *reply_len)
{
	struct timeval tv;
	int res;
	fd_set rfds;
	int len = cmd_len;
	
	// no send '&' if command string tail is '&'
	if(cmd[cmd_len-1] == '&')
	{
		len = cmd_len - 1;
	}
	
	if(send(s, cmd, len, 0) < 0)
		return -1;
	
	// no wait response if command string tail is '&'
		if(cmd[cmd_len-1] == '&')
		{
			strcpy(reply, "OK");
			*reply_len = 2;
			return 0;
		}
		
		for(;;)
		{
			tv.tv_sec = 40;
			tv.tv_usec = 0;
			FD_ZERO(&rfds);
			FD_SET(s, &rfds);
			res = select(s + 1, &rfds, NULL, NULL, &tv);
			if(FD_ISSET(s, &rfds))
			{
				res = recv(s, reply, *reply_len, 0);
				if(res < 0)
					return res;
				if(res > 0 && reply[0] == '<')
				{
					/* This is an unsolicited message from
					 * sysconfd, not the reply to the
					 * request. Use msg_cb to report this to the
					 * caller. */
					if ((size_t) res == *reply_len)
						res = (*reply_len) - 1;
					reply[res] = '\0';
					printf("[%s] [%d]\n", reply, res);
					continue;
				}
				*reply_len = res;
				break;
			}
			else
			{
				return -2;
			}
		}
		return 0;
}

/*****************************************************************
 * NAME: sysconf_util_cmd
 * ---------------------------------------------------------------
 * FUNCTION:  send command string to sysconfd and recevice response via sock
 * INPUT:
 * OUTPUT:
 * Author:   Norkay 2008-08-01
 * Modify:
 ****************************************************************/
int sysconf_util_cmd(char* cmdStr, char* replyStr)
{
	struct sockaddr_un local;
	struct sockaddr_un dest;
	int s = -1;
	int ret;
	char replyBuf[128];
	size_t replyLen;
	
	if(!sysIsFileExisted("/var/sysconfd_if/if0"))
	{
		return -3;
	}
	
	s = socket(PF_UNIX, SOCK_DGRAM, 0);
	if(s < 0)
	{
		return -1;
	}
	
	local.sun_family = AF_UNIX;
	snprintf(local.sun_path, sizeof(local.sun_path), "/var/sysconf_util_%d-%d", getpid(), 145);
	if(bind(s, (struct sockaddr *) &local, sizeof(local)) < 0)
	{
		close(s);
		return -1;
	}
	
	dest.sun_family = AF_UNIX;
	snprintf(dest.sun_path, sizeof(dest.sun_path), "%s", SYSCONFD_UTIL_PATH);
	if(connect(s, (struct sockaddr *) &dest, sizeof(dest)) < 0)
	{
		close(s);
		unlink(local.sun_path);
		return -1;
	}
	
	replyLen = sizeof(replyBuf) - 1;
	
	ret = sysconf_util_request(s, cmdStr, strlen(cmdStr), replyBuf, &replyLen);
	
	if(ret == -2)
	{
		printf("'%s' command timed out.\n", cmdStr);
		return -2;
	}
	else if(ret < 0)
	{
		printf("'%s' command failed.\n", cmdStr);
		return -1;
	}
	else
	{
		replyBuf[replyLen] = '\0';
		//printf("==>%s\n", replyBuf);
	}
	
	unlink(local.sun_path);
	close(s);
	
	if(replyStr)
	{
		strcpy(replyStr, replyBuf);
	}
	
	return 0;
}
#endif

#if HAS_UPNP_API
/*****************************************************************
* NAME: sysinteract
* ---------------------------------------------------------------
* FUNCTION:  
* INPUT:    
* OUTPUT:   
* Author:   
* Modify:   
****************************************************************/
int sysinteract(char *output, int outputlen, char *fmt, ...) 
{
	static char cmd_for_sysinteract[256];
	FILE *pipe;
	int c;
	//char cmd[256];
	int i;
	va_list ap;

	va_start(ap, fmt);
	vsnprintf(cmd_for_sysinteract, sizeof(cmd_for_sysinteract), fmt, ap);
	va_end(ap);

	memset(output, 0, outputlen);

	if((pipe = popen(cmd_for_sysinteract, "r")) == NULL)
	{
		goto err;
	}

	for(i = 0; ((c = fgetc(pipe)) != EOF) && (i < outputlen - 1); i++)
	{
		output[i] = (char) c;
	}
	output[i] = '\0';

	pclose(pipe);

	if(strlen(output) == 0)
	{
		goto err;
	}

	return 0;

err:
	strcpy(output, "---");
	return -1;
}
#endif
