#!/bin/bash

SIZE_16=`grep "FILE_SYSTEM_SIZE" ../.config |awk -F= '{print $2}' | awk -Fx '{print $2}'`    
FILE_SYSTEM_SIZE=`echo $((16#$SIZE_16))`

if [ $# != 1 ]; then
echo "usage: release_rootfs.sh  platform "
echo "ex   : release_rootfs.sh  Atheros "
exit 1
fi

echo `date +%F-%H:%M` > $FS_PATH/version

if [ $PLATFORM = "Ralink" ]; then
sed -e '/^#/d' $KERNEL_PATH/.config > $FS_PATH/mnt/scripts/.config
chmod 755 $FS_PATH/mnt/scripts/.config
romfs-inst.sh $FS_PATH/mnt/scripts/.config $FS_PATH/mnt/scripts/config.sh
rm -f $FS_PATH/mnt/scripts/.config
rm $IMG_PATH/pb42-squash*
$TOOL_PATH/mksquashfs $FS_PATH $IMG_PATH/pb42-squash -le
else

if [ $PLATFORM = "Atheros" ]; then
$TOOL_PATH/mksquashfs $FS_PATH $IMG_PATH/pb42-squash -noappend -b 16384 -all-root
fi
fi

chmod 644 $IMG_PATH/pb42-squash
dd if=$IMG_PATH/pb42-squash of=$IMG_PATH/pb42-squash_l bs=$FILE_SYSTEM_SIZE count=1 conv=sync
