#!/bin/sh -x

#
# $1 == u-boot/tools path
# $2 == kernel tree path
# $3 == optional additions to filename

MKIMAGE=$1/mkimage
VMLINUX=$2/vmlinux
VMLINUXBIN=$2/arch/mips/boot/vmlinux.bin

ENTRY=`readelf -a ${VMLINUX}|grep "Entry"|head -1|cut -d":" -f 2`
LDADDR=`readelf -a ${VMLINUX}|grep "\[ 1\]"|head -1|cut -d" " -f 26`

echo "**** Generating vmlinux.lzma.uImage ********";
${MKIMAGE} -A mips -O linux -T kernel -C lzma \
		-a 0x${LDADDR} -e ${ENTRY} -n "Linux Kernel Image"    \
		-d ${VMLINUXBIN}.lzma ${IMG_PATH}/vmlinux.lzma.uImage ;	
