/* Project Setting */
#define CFG_MTDBLK			"/dev/mtdblock3"
#define LANG_MTDBLK			"/dev/mtdblock4"
#define KERNEL_MTDBLK		"/dev/mtdblock5"
#define KERNEL_MTD			"/dev/mtd5"
#define FILE_SYSTEM_MTDBLK	"/dev/mtdblock6"
#define FILE_SYSTEM_MTD		"/dev/mtd6"

enum DUT_TYPE{
AP_MODE,
STA_MODE,
RT_MODE,
RPT_MODE,
WHP_MODE
};

/* Module Paths */
#define ETHERNET_MODULE_PATH	"/lib/modules/2.6.31/net/athrs_gmac.ko"
#define STATISTICS_MODULE		"/lib/modules/statistics_module.ko"

#define	MAX_WLAN_MOD			6
#define WLAN_MOD1_PATH			"/lib/modules/2.6.31/net/asf.ko"
#define WLAN_MOD2_PATH			"/lib/modules/2.6.31/net/adf.ko"
#define WLAN_MOD3_PATH			"/lib/modules/2.6.31/net/ath_hal.ko"
#define WLAN_MOD4_PATH			"/lib/modules/2.6.31/net/ath_rate_atheros.ko"
#define WLAN_MOD5_PATH			"/lib/modules/2.6.31/net/ath_dev.ko"
#define WLAN_MOD6_PATH			"/lib/modules/2.6.31/net/umac.ko"

/* Default definitions */
#define DEFAULT_HW_VER "V1"
#define DEFAULT_WIRELESS_DOMAIN	      	"0x10"		// Default Wireless Domain : USA(0x10)
#define	DEFAULT_DOMAIN_INDEX			5	// NA

#define DEFAULT_MAIN_IFACE			"eth0"
#define DEFAULT_BRIDGE_IFACE		"br0"
#define DEFAULT_LAN_IFACE			"eth1"
#define DEFAULT_WAN_IFACE			"eth0"
#define DEFAULT_WLAN_IFACE			"ath0"
#define DEFAULT_PPP_IFACE			"ppp0"
#define DEFAULT_SSID				"TRENDnet712"

/* Ethernet definitions */
#define MAX_PORT_NUM		5
#define WAN_PORT_NUM   		4
#define	ENABLE_PORT_PHY		0
#define	DISABLE_PORT_PHY	1

/* GPIO definitions */
#ifdef CONFIG_GPIO_MODULE
#define	GPIO_MODULE			"/lib/modules/gpio_module.ko"
#endif	// CONFIG_GPIO_MODULE

#ifdef CONFIG_WPS_GPIO
#define WPS_LED_GPIO		26
#endif 	// CONFIG_WPS_GPIO

#ifdef CONFIG_LED_GPIO
#define POWER_LED_GPIO1			20	// Green 
#define POWER_LED_GPIO2			27	// Orange

#ifdef CONFIG_INTERNET_LED
#define INTERNET_LED_GPIO1		17	// Green(0: Active)
#define INTERNET_LED_GPIO2		1	// Green(0: Active)
#define INTERNET_LED_GPIO3		23	// Orange
#endif	// CONFIG_INTERNET_LED

#ifdef CONFIG_WIRELESS_LED
#define WIRELESS_LED_GPIO		0
#endif	// CONFIG_WIRELESS_LED

#ifdef CONFIG_LAN_LED
#define PORT0_LED_GPIO			13
#define PORT1_LED_GPIO			14
#define PORT2_LED_GPIO			15
#define PORT3_LED_GPIO			16
#endif	// CONFIG_LAN_LED

#endif	// CONFIG_LED_GPIO

/* UPNP Definitions */
#define UPNP_MODEL_NAME 	"Trendnet 712 router"
#define UPNP_MANU_NAME 		"Trendnet"
#define UPNP_MANU_URL 		"http:/\/www.trendnet.com"

/* WPS Definitions */
#define WPS_MODEL_NAME			"Trendnet 712 Router"
#define WPS_SERIAL_NUMBER		"none"
#define DEVICE_MANUFACTURER 	"Trendnet"
#define DEVICE_VENDOR_NAME 	"Trendnet"

#define DEVICE_MANUFACTURER_URL	"http:/\/www.trendnet.com/"
#define DEVICE_SUPPORT_URL 		"http:/\/www.trendnet.com/products/proddetail.asp?prod=220_TEW-712BR"
#define DEVICE_BLOCK_URL 			"/login.htm"

#ifdef CONFIG_NTP
#define DEFAULT_MANUAL_YEAR		2011
#define DEFAULT_MANUAL_MONTH	1
#define DEFAULT_MANUAL_DAY		1	
#define DEFAULT_MANUAL_HOUR		0
#define DEFAULT_MANUAL_MIN		0
#define DEFAULT_MANUAL_SEC		0
#define	DEFAULT_TIME_ZONE		128
#endif	// CONFIG_NTP


#define CUSTOMER_DEVICE_NAME	"TEW-712BR"