/*
 * (C) Copyright 2000
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * Boot support
 */
#include <common.h>	// for u32 and cpu_to_le32
#include <command.h>
#include <watchdog.h>
#include "http.h"
#include <net.h>
#include "../httpd/uip.h"
#include "../httpd/uip_arp.h"
#include "../httpd/httpd.h"
#include "../httpd/uipopt.h"

#include <asm/addrspace.h>
#include "ar7240_soc.h"
#include "../cpu/mips/ar7240/ag7240.h"

struct eth_device *eth_pdev;
#define POWER_LED_GPIO	0x08000000

#define ETH_HEADER ((struct uip_eth_hdr *)&uip_buf[0])

int stop_delay = 0;	// to indicate when we should stop flashing the security led and udelay. Otherwise, uploading firmware will be very slow
int static_on = 0;

static uint led_counter = 0;
static uint prev_link = 0;


void set_static_led(){
	unsigned long gpio_func = ar7240_reg_rd(AR7240_GPIO_FUNC);
	unsigned long value = 0;
	int i;
	
	ar7240_reg_wr (AR7240_GPIO_FUNC, (gpio_func & 0xffffff03));	// to allow users to control the ethernet led by GPIO not by hardware, we need to set bit 0 to 0 for turning on the Lan port 4
	
	for (i = 0; i < 5; i++){
		if (athrs26_phy_is_link_alive(i)) {
			value |= (0x00002000 << i);			
		}
	}
	
	value |= POWER_LED_GPIO;	
	ar7240_reg_wr (AR7240_GPIO_OE, (POWER_LED_GPIO | 0x0001e000));		// enable GPIO output mode
	ar7240_reg_wr (AR7240_GPIO_OUT, value);	
}

int get_eth1_link(){
	ag7240_mac_t *mac;
	int link = 0;
		
	if (eth_pdev != NULL){
		mac = (ag7240_mac_t*)eth_pdev->priv;
		
		if (ag7240_check_link(mac) != 0){	// if an ethernet cable has been plugging into eth1 already
			link = 1;
		}
	}
	
	return link;
}

int check_eth1_link(){		
	int link = 0;
	int i;
	
	DECLARE_GLOBAL_DATA_PTR;	
	
	link = get_eth1_link();
	
	if (prev_link == 0){					
		if (link){			

			if (eth_init(gd->bd) < 0) {
				eth_halt();
				return(-1);
			}			
			
			eth_led_control();	
		}		
	}else{
		if (link == 0){
			eth_led_control();
		}
	}

	return link;
}

void control_power_led(){
	unsigned long io_data = 0;

	prev_link = check_eth1_link();
	
	if (stop_delay == 0){
		led_counter++;	
		io_data = POWER_LED_GPIO;
			
		if ((led_counter % 2) == 1){		
			ar7240_reg_wr (AR7240_GPIO_OUT, io_data);		
			NetSetTimeout (CFG_HZ, control_power_led);		
		}else{
			io_data = ~io_data & POWER_LED_GPIO;		
			ar7240_reg_wr (AR7240_GPIO_OUT, io_data);
			NetSetTimeout (CFG_HZ*2, control_power_led);			
		}	
	}
}

void http_handler(uchar * pkt, unsigned dest , unsigned src, unsigned len){
	// do nothing
}

int HttpStart(IPaddr_t host_ip){	
	int i;
		
	eth_pdev = eth_get_dev_by_name("eth1");
	
	prev_link = get_eth1_link();	
	
	if (prev_link){
		eth_led_control();	// turn on the lan led
	}
	// uip init
	printf("uip init...\r\n");
	uip_init();

	printf("http init...\r\n");
	httpd_init();
	
#if (__BYTE_ORDER == __BIG_ENDIAN)
	uip_hostaddr[0] = (htons((host_ip >> 16) & 0xffff));	// save the 2 bytes(MSB) of ip address
	uip_hostaddr[1] = (htons((host_ip & 0x0000ffff)));	// save the 2 bytes(LSB) of ip address	
#else	//(__BYTE_ORDER == __BIG_ENDIAN)
	uip_hostaddr[0] = (htons((host_ip & 0x0000ffff)));	// save the 2 bytes(MSB) of ip address
	uip_hostaddr[1] = (htons((host_ip >> 16) & 0xffff));	// save the 2 bytes(LSB) of ip address
#endif	// (__BYTE_ORDER == __BIG_ENDIAN)
	
	for(i = 0; i < 6; i++){	// don't use bd.bi_enetaddr, due to Memory Alignment
		uip_ethaddr[i] = eth_pdev->enetaddr[i];
	}
		
	uip_arp_netmask[0] = 0xffff;
	uip_arp_netmask[1] = htons(0xff00);

	ar7240_reg_wr(AR7240_GPIO_OE, POWER_LED_GPIO);
		
	static_on = 0;
	led_counter = 0;	
	NetSetTimeout (CFG_HZ/10, control_power_led);
	NetSetHandler(http_handler);
	
	return 0;
}
