#ifndef _NF_CONNTRACK_IPV6_H
#define _NF_CONNTRACK_IPV6_H

extern struct nf_conntrack_l3proto nf_conntrack_l3proto_ipv6;

extern struct nf_conntrack_l4proto nf_conntrack_l4proto_tcp6;
extern struct nf_conntrack_l4proto nf_conntrack_l4proto_udp6;
extern struct nf_conntrack_l4proto nf_conntrack_l4proto_icmpv6;

extern int nf_ct_frag6_init(void);
extern void nf_ct_frag6_cleanup(void);
#ifdef SUPPORT_CAMEO_SDK
extern struct sk_buff *nf_ct_frag6_gather(struct sk_buff *skb, u32 user);
#else // SUPPORT_CAMEO_SDK
extern struct sk_buff *nf_ct_frag6_gather(struct sk_buff *skb);
#endif // SUPPORT_CAMEO_SDK
extern void nf_ct_frag6_output(unsigned int hooknum, struct sk_buff *skb,
			       struct net_device *in,
			       struct net_device *out,
			       int (*okfn)(struct sk_buff *));

struct inet_frags_ctl;

#include <linux/sysctl.h>
extern struct ctl_table nf_ct_ipv6_sysctl_table[];

#endif /* _NF_CONNTRACK_IPV6_H*/
