/* $Id: upnphttp.h,v 1.24 2011/06/27 11:06:00 nanard Exp $ */ 
/* MiniUPnP project
 * http://miniupnp.free.fr/ or http://miniupnp.tuxfamily.org/
 * (c) 2006-2011 Thomas Bernard 
 * This software is subject to the conditions detailed
 * in the LICENCE file provided within the distribution */

#ifndef __UPNPHTTP_H__
#define __UPNPHTTP_H__

#include <netinet/in.h>
#include <sys/queue.h>

#include "config.h"

/* server: HTTP header returned in all HTTP responses : */
#define MINIUPNPD_SERVER_STRING	OS_VERSION " UPnP/1.0 MiniUPnPd/" MINIUPNPD_VERSION

/*
 states :
  0 - waiting for data to read
  1 - waiting for HTTP Post Content.
  ...
  >= 100 - to be deleted
*/
enum httpCommands {
	EUnknown = 0,
	EGet,
	EPost,
	EHead,
	ESubscribe,
	EUnSubscribe
};

struct upnphttp {
#ifdef ENABLE_IPV6
	int ipv6;
	struct in6_addr clientaddr_v6;
#endif
	int state;
	char HttpVer[16];
	/* request */
	char * req_buf;
	int req_buflen;
	int req_contentlen;
	int req_contentoff;     /* header length */
	int req_ConnectionClose;		/* HTTP 1.1 Connection: Close */
	int req_pipeline;				/* HTTP 1.1 Pipeline */
	enum httpCommands req_command;
	const char * req_soapAction;
	int req_soapActionLen;
#ifdef ENABLE_EVENTS
	const char * req_Callback;	/* For SUBSCRIBE */
	int req_CallbackLen;
	int req_Timeout;
	const char * req_SID;		/* For UNSUBSCRIBE */
	int req_SIDLen;
#endif
	uint32_t reqflags;
	int respflags;				/* see FLAG_* constants below */
	const char * req_AcceptLang;
	int req_AcceptLangLen;
	const char * req_NT;
	int req_NTLen;	
	int req_continue;			/* HTTP 1.1 100 Continue */
	/* response */
	char * res_buf;
	int res_buflen;
	int res_buf_alloclen;
	/*int res_contentlen;*/
	/*int res_contentoff;*/		/* header length */

	//TCP session dependant variables
	int socket;
	struct in_addr clientaddr;	/* client address */
	LIST_ENTRY(upnphttp) entries;
};

int upnphttp_cleansize;

/* Include the "Timeout:" header in response */
#define FLAG_TIMEOUT	0x01
/* Include the "SID:" header in response */
#define FLAG_SID		0x02

/* If set, the Content-Type is set to text/xml, otherwise it is text/xml */
#define FLAG_RANGE              0x04
#define FLAG_HOST               0x08

#define FLAG_HTML		0x80
#define FLAG_INVALID_REQ        0x10

/* New_upnphttp() */
struct upnphttp *
New_upnphttp(int);

/* CloseSocket_upnphttp() */
void
CloseSocket_upnphttp(struct upnphttp *);

/* Delete_upnphttp() */
void
Delete_upnphttp(struct upnphttp *);

/* Process_upnphttp() */
void
Process_upnphttp(struct upnphttp *);

/* BuildHeader_upnphttp()
 * build the header for the HTTP Response
 * also allocate the buffer for body data */
void
BuildHeader_upnphttp(struct upnphttp * h, int respcode,
                     const char * respmsg,
                     int bodylen);

/* BuildResp_upnphttp() 
 * fill the res_buf buffer with the complete
 * HTTP 200 OK response from the body passed as argument */
void
BuildResp_upnphttp(struct upnphttp *, const char *, int);

/* BuildResp2_upnphttp()
 * same but with given response code/message */
void
BuildResp2_upnphttp(struct upnphttp * h, int respcode,
                    const char * respmsg,
                    const char * body, int bodylen);

/* Error messages */
void
Send500(struct upnphttp *);
void
Send501(struct upnphttp *);

/* SendResp_upnphttp() */
void
SendResp_upnphttp(struct upnphttp *);

#endif

