.SS conntrack
This module, when combined with connection tracking, allows access to the
connection tracking state for this packet/connection.
.TP
[\fB!\fR] \fB\-\-ctstate\fP \fIstatelist\fP
\fIstatelist\fR is a comma separated list of the connection states to match.
Possible states are listed below.
.TP
[\fB!\fR] \fB\-\-ctproto\fP \fIl4proto\fP
Layer-4 protocol to match (by number or name)
.TP
[\fB!\fR] \fB\-\-ctorigsrc\fP \fIaddress\fP[\fB/\fP\fImask\fP]
.TP
[\fB!\fR] \fB\-\-ctorigdst\fP \fIaddress\fP[\fB/\fP\fImask\fP]
.TP
[\fB!\fR] \fB\-\-ctreplsrc\fP \fIaddress\fP[\fB/\fP\fImask\fP]
.TP
[\fB!\fR] \fB\-\-ctrepldst\fP \fIaddress\fP[\fB/\fP\fImask\fP]
Match against original/reply source/destination address
.TP
[\fB!\fR] \fB\-\-ctorigsrcport\fP \fIport\fP
.TP
[\fB!\fR] \fB\-\-ctorigdstport\fP \fIport\fP
.TP
[\fB!\fR] \fB\-\-ctreplsrcport\fP \fIport\fP
.TP
[\fB!\fR] \fB\-\-ctrepldstport\fP \fIport\fP
Match against original/reply source/destination port (TCP/UDP/etc.) or GRE key.
.TP
[\fB!\fR] \fB\-\-ctstatus\fP \fIstatelist\fP
\fIstatuslist\fR is a comma separated list of the connection statuses to match.
Possible statuses are listed below.
.TP
[\fB!\fR] \fB\-\-ctexpire\fP \fItime\fP[\fB:\fP\fItime\fP]
Match remaining lifetime in seconds against given value or range of values
(inclusive)
.TP
\fB\-\-ctdir\fP {\fBORIGINAL\fP|\fBREPLY\fP}
Match packets that are flowing in the specified direction. If this flag is not
specified at all, matches packets in both directions.
.PP
States for \fB\-\-ctstate\fP:
.TP
\fBINVALID\fR
meaning that the packet is associated with no known connection
.TP
\fBNEW\fR
meaning that the packet has started a new connection, or otherwise associated
with a connection which has not seen packets in both directions, and
.TP
\fBESTABLISHED\fR
meaning that the packet is associated with a connection which has seen packets
in both directions,
.TP
\fBRELATED\fR
meaning that the packet is starting a new connection, but is associated with an
existing connection, such as an FTP data transfer, or an ICMP error.
.TP
\fBSNAT\fR
A virtual state, matching if the original source address differs from the reply
destination.
.TP
\fBDNAT\fR
A virtual state, matching if the original destination differs from the reply
source.
.PP
Statuses for \fB\-\-ctstatus\fP:
.TP
\fBNONE\fR
None of the below.
.TP
\fBEXPECTED\fR
This is an expected connection (i.e. a conntrack helper set it up)
.TP
\fBSEEN_REPLY\fR
Conntrack has seen packets in both directions.
.TP
\fBASSURED\fR
Conntrack entry should never be early-expired.
.TP
\fBCONFIRMED\fR
Connection is confirmed: originating packet has left box.
.SS iprange
This matches on a given arbitrary range of IP addresses.
.TP
[\fB!\fR] \fB\-\-src\-range\fP \fIfrom\fP[\fB\-\fP\fIto\fP]
Match source IP in the specified range.
.TP
[\fB!\fR] \fB\-\-dst\-range\fP \fIfrom\fP[\fB\-\fP\fIto\fP]
Match destination IP in the specified range.
.SS length
This module matches the length of the layer-3 payload (e.g. layer-4 packet)
f a packet against a specific value
or range of values.
.TP
[\fB!\fP] \fB\-\-length\fP \fIlength\fP[\fB:\fP\fIlength\fP]
.SS mac
.TP
[\fB!\fP] \fB\-\-mac\-source\fP \fIaddress\fP
Match source MAC address.  It must be of the form XX:XX:XX:XX:XX:XX.
Note that this only makes sense for packets coming from an Ethernet device
and entering the
.BR PREROUTING ,
.B FORWARD
or
.B INPUT
chains.
.SS multiport
This module matches a set of source or destination ports.  Up to 15
ports can be specified.  A port range (port:port) counts as two
ports.  It can only be used in conjunction with
\fB\-p tcp\fP
or
\fB\-p udp\fP.
.TP
[\fB!\fP] \fB\-\-source\-ports\fP,\fB\-\-sports\fP \fIport\fP[\fB,\fP\fIport\fP|\fB,\fP\fIport\fP\fB:\fP\fIport\fP]...
Match if the source port is one of the given ports.  The flag
\fB\-\-sports\fP
is a convenient alias for this option. Multiple ports or port ranges are
separated using a comma, and a port range is specified using a colon.
\fB53,1024:65535\fP would therefore match ports 53 and all from 1024 through
65535.
.TP
[\fB!\fP] \fB\-\-destination\-ports\fP,\fB\-\-dports\fP \fIport\fP[\fB,\fP\fIport\fP|\fB,\fP\fIport\fP\fB:\fP\fIport\fP]...
Match if the destination port is one of the given ports.  The flag
\fB\-\-dports\fP
is a convenient alias for this option.
.TP
[\fB!\fP] \fB\-\-ports\fP \fIport\fP[\fB,\fP\fIport\fP|\fB,\fP\fIport\fP\fB:\fP\fIport\fP]...
Match if either the source or destination ports are equal to one of
the given ports.
.SS state
This module, when combined with connection tracking, allows access to
the connection tracking state for this packet.
.TP
[\fB!\fP] \fB\-\-state\fP \fIstate\fP
Where state is a comma separated list of the connection states to
match.  Possible states are
.B INVALID
meaning that the packet could not be identified for some reason which
includes running out of memory and ICMP errors which don't correspond to any
known connection,
.B ESTABLISHED
meaning that the packet is associated with a connection which has seen
packets in both directions,
.B NEW
meaning that the packet has started a new connection, or otherwise
associated with a connection which has not seen packets in both
directions, and
.B RELATED
meaning that the packet is starting a new connection, but is
associated with an existing connection, such as an FTP data transfer,
or an ICMP error.
.SS tcp
These extensions can be used if `\-\-protocol tcp' is specified. It
provides the following options:
.TP
[\fB!\fP] \fB\-\-source\-port\fP,\fB\-\-sport\fP \fIport\fP[\fB:\fP\fIport\fP]
Source port or port range specification. This can either be a service
name or a port number. An inclusive range can also be specified,
using the format \fIfirst\fP\fB:\fP\fIlast\fP.
If the first port is omitted, "0" is assumed; if the last is omitted,
"65535" is assumed.
If the first port is greater than the second one they will be swapped.
The flag
\fB\-\-sport\fP
is a convenient alias for this option.
.TP
[\fB!\fP] \fB\-\-destination\-port\fP,\fB\-\-dport\fP \fIport\fP[\fB:\fP\fIport\fP]
Destination port or port range specification.  The flag
\fB\-\-dport\fP
is a convenient alias for this option.
.TP
[\fB!\fP] \fB\-\-tcp\-flags\fP \fImask\fP \fIcomp\fP
Match when the TCP flags are as specified.  The first argument \fImask\fP is the
flags which we should examine, written as a comma-separated list, and
the second argument \fIcomp\fP is a comma-separated list of flags which must be
set.  Flags are:
.BR "SYN ACK FIN RST URG PSH ALL NONE" .
Hence the command
.nf
 iptables \-A FORWARD \-p tcp \-\-tcp\-flags SYN,ACK,FIN,RST SYN
.fi
will only match packets with the SYN flag set, and the ACK, FIN and
RST flags unset.
.TP
[\fB!\fP] \fB\-\-syn\fP
Only match TCP packets with the SYN bit set and the ACK,RST and FIN bits
cleared.  Such packets are used to request TCP connection initiation;
for example, blocking such packets coming in an interface will prevent
incoming TCP connections, but outgoing TCP connections will be
unaffected.
It is equivalent to \fB\-\-tcp\-flags SYN,RST,ACK,FIN SYN\fP.
If the "!" flag precedes the "\-\-syn", the sense of the
option is inverted.
.TP
[\fB!\fP] \fB\-\-tcp\-option\fP \fInumber\fP
Match if TCP option set.
.SS tcpmss
This matches the TCP MSS (maximum segment size) field of the TCP header.  You can only use this on TCP SYN or SYN/ACK packets, since the MSS is only negotiated during the TCP handshake at connection startup time.
.TP
[\fB!\fP] \fB\-\-mss\fP \fIvalue\fP[\fB:\fP\fIvalue\fP]
Match a given TCP MSS value or range.
.SS time
This matches if the packet arrival time/date is within a given range. All
options are optional, but are ANDed when specified.
.TP
\fB\-\-datestart\fP \fIYYYY\fP[\fB\-\fP\fIMM\fP[\fB\-\fP\fIDD\fP[\fBT\fP\fIhh\fP[\fB:\fP\fImm\fP[\fB:\fP\fIss\fP]]]]]
.TP
\fB\-\-datestop\fP \fIYYYY\fP[\fB\-\fP\fIMM\fP[\fB\-\fP\fIDD\fP[\fBT\fP\fIhh\fP[\fB:\fP\fImm\fP[\fB:\fP\fIss\fP]]]]]
.IP
Only match during the given time, which must be in ISO 8601 "T" notation.
The possible time range is 1970-01-01T00:00:00 to 2038-01-19T04:17:07.
.IP
If \-\-datestart or \-\-datestop are not specified, it will default to 1970-01-01
and 2038-01-19, respectively.
.TP
\fB\-\-timestart\fP \fIhh\fP\fB:\fP\fImm\fP[\fB:\fP\fIss\fP]
.TP
\fB\-\-timestop\fP \fIhh\fP\fB:\fP\fImm\fP[\fB:\fP\fIss\fP]
.IP
Only match during the given daytime. The possible time range is 00:00:00 to
23:59:59. Leading zeroes are allowed (e.g. "06:03") and correctly interpreted
as base-10.
.TP
[\fB!\fR] \fB\-\-monthdays\fP \fIday\fP[\fB,\fP\fIday\fP...]
.IP
Only match on the given days of the month. Possible values are \fB1\fR
to \fB31\fR. Note that specifying \fB31\fR will of course not match
on months which do not have a 31st day; the same goes for 28- or 29-day
February.
.TP
[\fB!\fR] \fB\-\-weekdays\fP \fIday\fP[\fB,\fP\fIday\fP...]
.IP
Only match on the given weekdays. Possible values are \fBMon\fR, \fBTue\fR,
\fBWed\fR, \fBThu\fR, \fBFri\fR, \fBSat\fR, \fBSun\fR, or values from \fB1\fR
to \fB7\fR, respectively. You may also use two-character variants (\fBMo\fP,
\fBTu\fR, etc.).
.TP
\fB\-\-utc\fP
.IP
Interpret the times given for \fB\-\-datestart\fP, \fB\-\-datestop\fP,
\fB\-\-timestart\fP and \fB\-\-timestop\fP to be UTC.
.TP
\fB\-\-localtz\fP
.IP
Interpret the times given for \fB\-\-datestart\fP, \fB\-\-datestop\fP,
\fB\-\-timestart\fP and \fB\-\-timestop\fP to be local kernel time. (Default)
.PP
EXAMPLES. To match on weekends, use:
.IP
\-m time \-\-weekdays Sa,Su
.PP
Or, to match (once) on a national holiday block:
.IP
\-m time \-\-datestart 2007\-12\-24 \-\-datestop 2007\-12\-27
.PP
Since the stop time is actually inclusive, you would need the following stop
time to not match the first second of the new day:
.IP
\-m time \-\-datestart 2007\-01\-01T17:00 \-\-datestop 2007\-01\-01T23:59:59
.PP
During lunch hour:
.IP
\-m time \-\-timestart 12:30 \-\-timestop 13:30
.PP
The fourth Friday in the month:
.IP
\-m time \-\-weekdays Fr \-\-monthdays 22,23,24,25,26,27,28
.PP
(Note that this exploits a certain mathematical property. It is not possible to
say "fourth Thursday OR fourth Friday" in one rule. It is possible with
multiple rules, though.)
.SS udp
These extensions can be used if `\-\-protocol udp' is specified. It
provides the following options:
.TP
[\fB!\fP] \fB\-\-source\-port\fP,\fB\-\-sport\fP \fIport\fP[\fB:\fP\fIport\fP]
Source port or port range specification.
See the description of the
\fB\-\-source\-port\fP
option of the TCP extension for details.
.TP
[\fB!\fP] \fB\-\-destination\-port\fP,\fB\-\-dport\fP \fIport\fP[\fB:\fP\fIport\fP]
Destination port or port range specification.
See the description of the
\fB\-\-destination\-port\fP
option of the TCP extension for details.
