#include "defs.h"
#include <linux/sockios.h>
#include "switch-api.h"
#include <unistd.h>
#include <sys/ioctl.h>

extern char swinterface[8];

static void 
IpAddrToMacAddr(uint32 group, fal_mac_addr_t *mac)
{
    group = ntohl(group);
    
    mac->addr[0] = 0x01;
    mac->addr[1] = 0x00;
    mac->addr[2] = 0x5e;
    mac->addr[3] = (group >> 16) & 0x7f;
    mac->addr[4] = (group >> 8) & 0xff;
    mac->addr[5] = group & 0xff;
    
}

int addMFdb(uint32 group, uint32 port){


    int s = -1;
    struct ifreq ifr = {};
    arl_struct_t arl;
    fal_mac_addr_t macAddr;

    if(port > 31) return -1;
    
    if(0 > (s=socket(AF_INET, SOCK_DGRAM, 0))) {
        return -1;
    }

    //memcpy(ifr.ifr_name, IF_NAME, IFNAMSIZ);
    memcpy(ifr.ifr_name, swinterface, IFNAMSIZ);
    IpAddrToMacAddr(group, &macAddr);
    memcpy(&arl.hwaddr,&macAddr,6);

    arl.port_map = port;
    arl.sa_drop = 0;

    memcpy(&ifr.ifr_ifru.ifru_mtu,&arl,sizeof(arl_struct_t));

    if (ioctl(s, ATHSIOCDEVPRIVATE|0xd, &ifr) < 0) {
        close(s);
        return -1;
    } 
    log_msg(LOG_DEBUG, 0, "addMFdb group %x port %d.\n",group,port);
    close(s);
    return 0;
}

int delMFdb(uint32 group){

    int s = -1;
    struct ifreq ifr = {};
    arl_struct_t arl;
    fal_mac_addr_t macAddr;

    if(0 >= (s=socket(AF_INET, SOCK_DGRAM, 0))) {
        return -1;
    }

    //memcpy(ifr.ifr_name, IF_NAME, IFNAMSIZ);
    memcpy(ifr.ifr_name, swinterface, IFNAMSIZ);
    IpAddrToMacAddr(group, &macAddr);
    memcpy(&arl.hwaddr,&macAddr,6);
   
    memcpy(&ifr.ifr_ifru.ifru_mtu,&arl,sizeof(arl_struct_t));

    if (ioctl(s, ATHSIOCDEVPRIVATE|0xe, &ifr) < 0) {
        close(s);
        return -1;
    }

    log_msg(LOG_DEBUG, 0, "delMFdb group %x.OK.\n",group);
    close(s);
    return 0;
}

//0: switch off the unkown multicast packets over vlan. 1: allow the unknown multicaset packets over vlans.
int setMultiOnVlan(int enable)
{
    int s = -1;
    struct ifreq ifr;
      
    if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        return -1;

    //memcpy(ifr.ifr_name, IF_NAME, IFNAMSIZ);
    memcpy(ifr.ifr_name, swinterface, IFNAMSIZ);

    ifr.ifr_ifru.ifru_ivalue = enable;

    if (ioctl(s, ATHSIOCDEVPRIVATE|0xf, &ifr) != 0) {
	   close(s);
	   return -1;
    }

    close(s);    log_msg(LOG_DEBUG, 0,"setMultiOnVlan %d.\n",enable);
    return 0;
}


int enableHwIGMPS(void)
{
    int s = -1;
    struct ifreq ifr;
    uint32 port_id;
    if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        return -1;
    //memcpy(ifr.ifr_name, IF_NAME, IFNAMSIZ);
    memcpy(ifr.ifr_name, swinterface, IFNAMSIZ);
	
    for(port_id = 1; port_id <= SW_MAX_NR_PORTS; port_id++){
#ifdef AR7241
		ifr.ifr_ifru.ifru_ivalue = port_id | (0x1 << 7);
#else
		// AR7240 used, for older switch driver
		ifr.ifr_ifru.ifru_ivalue = port_id;
#endif
        if (ioctl(s, ATHSIOCDEVPRIVATE|0x8, &ifr) != 0) {
			close(s);
			log_msg(LOG_DEBUG, 0,"enableHwIGMPS Fail!.\n");
			return -1;
        }
    } 
    close(s);    
    log_msg(LOG_DEBUG, 0,"enableHwIGMPS OK.\n");
    return 0;
}

int disableHwIGMPS(void)
{
    int s = -1;
    struct ifreq ifr;
    uint32 port_id;
       
    if ((s = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
        return -1;

    //memcpy(ifr.ifr_name, IF_NAME, IFNAMSIZ);
    memcpy(ifr.ifr_name, swinterface, IFNAMSIZ);
    for(port_id = 1; port_id <= SW_MAX_NR_PORTS; port_id++){
        ifr.ifr_ifru.ifru_ivalue = port_id;
#ifdef AR7241
		// AR7241 new switch driver used same ioctl to enable / disable igmpsnooping
		if (ioctl(s, ATHSIOCDEVPRIVATE|0x8, &ifr) != 0) {
#else
		// AR7240 used, for older switch driver
		if (ioctl(s, ATHSIOCDEVPRIVATE|0x9, &ifr) != 0) {
#endif
	   close(s);
	   return -1;
        }
    } 
    close(s);
    log_msg(LOG_DEBUG, 0,"disableHwIGMPS OK.\n");
    return 0;
}
