#include "defs.h"

static int igmpSState = 0;
    
// Local function Prototypes
int igmpProxyInit(void);
void igmpProxyCleanUp(void);

void 
setIgmpSState(int state)
{
    igmpSState = state;
}

int
getIgmpSState()
{
    return igmpSState;
}

/**
*   Handles the initial startup of IGMP SNOOPING
*/
int
igmpSnoopInit()
{
    log_msg(LOG_DEBUG, 0, "igmpSnoopInit...");
    initFdbTable();
    enableHwIGMPS();
    //Disable unknown multicast packets over vlans. 
    setMultiOnVlan(0);
    //Insert 224.0.0.1 into ARL table
    addMFdb(0xe0000001,30);
    //Insert 239.255.255.0 into ARL table
    addMFdb(0xEFFFFFFA,29);

    //initSnoopBr();
    
    return 1;
}

/**
*   Clean up all on exit...
*/
void
igmpSnoopCleanUp()
{
    log_msg(LOG_DEBUG, 0, "igmpSnoopCleanUp...");
    //clearSnoopBr();

    //Enable unknow multicaset packets over vlans.
    setMultiOnVlan(1);

    // delete 224.0.0.1 from ARL table.
    delMFdb(0xe0000001);  
  
    clearAllFdbs();
    disableHwIGMPS();

}
