#include "project.h"

/* conver unsigned long to string */
#define  PUSH_IPADDR(ip)\
   (unsigned)(ip&0xff),\
   (unsigned)((ip>>8)&0xff),\
   (unsigned)((ip>>16)&0xff),\
   (unsigned)(ip>>24)

/* NULL definitions */
#define NULL_IP				"0.0.0.0"
#define NULL_MAC			"00:00:00:00:00:00"
#define NULL_WPS_PIN		"00000000"

/* Factory default definitions */
#define NONE_FACTORY_DEFAULT	0
#define FACTORY_DEFAULT			1

/* System commands */
#define INSMOD_CMD			"insmod"
#define	RMMOD_CMD			"rmmod"

#define SYS_INFO_MTD		"/dev/mtdblock2"
#define SYS_INFO_FILE		"/var/tmp/sys_info.txt"
#define SYS_BUF_SIZE		0x10000
typedef struct {
	char hw_ver[4];
	char lan_mac[18];
	char wan_mac[18];
	char domain[5];
#ifdef CONFIG_SUPPORT_CUSTOM_SSID
	char ssid[33];
#endif	// CONFIG_SUPPORT_CUSTOM_SSID

#ifdef CONFIG_SUPPORT_CUSTOM_KEY
	char key[16];
#endif	// CONFIG_SUPPORT_CUSTOM_KEY
} system_info;

#ifdef CONFIG_MULTI_LANG_SUPPORT
#define LANG_VER				"/www/xml/lang_ver.txt"
#define WWW_LANG_XML			"/www/xml/lang.xml"
#define WWW_MSG_XML				"/www/xml/msg.xml"
#define WWW_HELP_XML			"/www/xml/help.xml"
#define WWW_HINTS_XML			"/www/xml/hints.xml"
#define TMP_LANG_VER			"/tmp/lang_ver.txt"
#define TMP_LANG_XML			"/tmp/lang.xml"
#define TMP_MSG_XML				"/tmp/msg.xml"
#define TMP_HELP_XML			"/tmp/help.xml"
#define TMP_HINTS_XML			"/tmp/hints.xml"
#define LANG_CHECKSUM			"/var/tmp/lang_checksum"

#define DEFAULT_XML_FOLDER		"/www/default_xml"
#define DEFAULT_LANG_XML		"/www/default_xml/lang.xml"
#define DEFAULT_MSG_XML			"/www/default_xml/msg.xml"
#define DEFAULT_HELP_XML		"/www/default_xml/help.xml"
#define DEFAULT_HINTS_XML		"/www/default_xml/hints.xml"

#ifdef CONFIG_MULTI_LANG_IN_FLASH
#define LANGUAGE_FILE			"/tmp/lang.tgz"
#define LANG_IN_FLASH			"/var/tmp/lang_in_flash"	// 0: indicate that there is no language package in flash, 1: indicate that there is a language package in flash
#endif	// CONFIG_MULTI_LANG_IN_FLASH
#endif	// CONFIG_MULTI_LANG_SUPPORT

/* Wireless definitions */
typedef struct {
	int  number;	
	char country[25];
	char country_code[3];			// country abbreviate(ISO3166)
	char country_id[5];				// country ID
	char version_abbr[6];			// for D-Link version.txt
	char chklst_abbr[8];			// for chklst.txt
	char door;						// I: indoor, O: outdoor
	char country_region;			// 0: channels 1-11, 1: channels 1-13, 2: channels 10-11, 3: channels 10-13, 4: channel 14, 5: channels 1-14, 6: channels 3-9, 7: channels 5-13	
	char channel_num;				// number of channel
} wlan_domain;

#ifdef CONFIG_MULTI_LANG_SUPPORT
typedef struct {
	char lang_str[10];
	char major_ver[6];
	char minor_ver[4];
	char check_sum[12];
} language_info;
#endif	// CONFIG_MULTI_LANG_SUPPORT

/* Web Server definitions */
#ifdef CONFIG_LIGHTTPD
#define WEB_LOG_DIR					"/var/log/lighttpd"
#define WEB_CONF_FILE				"/etc/lighttpd/lighttpd.conf"
#define LIGHTTPD_USER_CONF			"/etc/lighttpd/lighttpd.user"
#endif	// CONFIG_LIGHTTPD

#ifdef CONFIG_HNAP
#define SETROUTERLANSETTINGS_FILE	"/var/tmp/SetRouterLanSettings"
#define SETWLANRADIO_FILE			"/var/tmp/SetWLanRadio"
#define HNAP_REBOOT_FILE			"/var/tmp/HNAP_Reboot"
#endif //CONFIG_HNAP

/* Daemon PID definitions */
#define SYSTEM_MANAGER_PID			"/var/run/system_manager.pid"
#define UDHCPD_PID					"/var/run/udhcpd.pid"	// must be as same as pidfile in /var/etc/udhcpd.conf

#ifdef CONFIG_WPS
#define WPS_GPIO_PID				"/var/run/wps_gpio.pid"
#endif	// CONFIG_WPS

#ifdef CONFIG_WAN_MANAGER
#define PPPOE_0_PID					"/var/run/ppp0.pid"		// must be as same as pidfile created by pppd
#define PPTP_PID					"/var/run/ppp-pptp.pid"	// must be as same as pidfile created by pppd
#define L2TP_PID					"/var/run/l2tp.pid"		// must be as same as pidfile created by pppd
#define PPP_REDIAL_PID				"/var/run/ppp_redial.pid"
#define PPP_MONITOR_PID				"/var/run/ppp_monitor.pid"
#define WANTIMER_PID				"/var/run/wan_timer.pid"
#define WAN_LED_CONTROL_PID			"/var/run/wan_led_control.pid"

#define WAN_UP_TIME_FILE			"/var/tmp/wan_connect_time.tmp"
#define PPP_MONITOR_CONFIG_FILE 	"/var/etc/ppp_monitor_config"		
#define WAN_AUTO_FILE			    "/var/tmp/wan_autodetect.txt"
#endif	// CONFIG_WAN_MANAGER

#ifdef CONFIG_SUPPORT_USB3G
#define USB_MONITOR_PID			"/var/run/usb_monitor.pid"
#endif	// CONFIG_SUPPORT_USB3G

#ifdef CONFIG_SUPPORT_WEBFILE_ACCESS
#define WEBFILE_MONITOR_PID			"/var/run/webfile_monitor.pid"

#ifdef CONFIG_DDNS
#define WIZARD_DDNS_INFO			"/var/tmp/wizard_ddns_info"
#endif	// CONFIG_DDNS

#endif	// CONFIG_SUPPORT_WEBFILE_ACCESS

/* udhcp definitions */
#define DHCPC_DNS_SCRIPT			"/usr/share/udhcpc/default.bound-dns"
#define DHCPC_NODNS_SCRIPT			"/usr/share/udhcpc/default.bound-nodns"
#define DEFAULT_UDHCPD_CONF			"/etc/udhcpd.conf"
#define UDHCPD_CONF					"/var/etc/udhcpd.conf"
#define DEFAULT_LEASES_FILE		"/etc/udhcpd.leases"
#define DHCPD_REVOKE_FILE			"/var/tmp/dhcp_revoke"
#define DHCPC_SERVER_FILE			"/var/tmp/dhcp_server.txt"
#define DHCPC_GATEWAY_FILE			"/var/tmp/dhcp_gateway.txt"	// must be as same as code in daemons/udhcp/dhcpc.c
#define DHCPC_COMMAND_FILE			"/var/etc/dhcpc_cmd.sh"	
#define DHCPC_LEASE_FILE			"/var/tmp/dhcpc.tmp"
#define PPP_RESOLV_FILE				"/var/etc/resolv.conf"

#define CLIENT_LIST_FILE			"/var/tmp/local_lan_ip"			
#define CLIENT_LIST_TMP_FILE		"/var/tmp/local_lan_ip_tmp"					
#define HTML_LEASES_FILE			"/var/misc/html.leases"			
#define LEASES_FILE					"/var/misc/udhcpd.leases"		

/* DNS definitions */
#ifdef CONFIG_IPV6_SUPPORT
#define RESOLVFILE					"/etc/resolv_ipv4.conf"
#define RESOLVFILE_IPV6				"/etc/resolv_ipv6.conf"
#define RESOLVFILE_ALL				"/etc/resolv.conf"
#else
#define RESOLVFILE					"/etc/resolv.conf"
#endif	//CONFIG_IPV6_SUPPORT

#ifdef CONFIG_UDHCPD_NETBIOS
#define DHCPD_DYNAMIC_SCOPE			"/var/tmp/dhcpd_dynamic_scope"		
#define DHCPD_DYNAMIC_NODE_TYPE		"/var/tmp/dhcpd_dynamic_node_type"	
#define DHCPD_DYNAMIC_WINS_SERVER	"/var/tmp/dhcpd_dynamic_wins_server"	
#endif //CONFIG_UDHCPD_NETBIOS

/* Firewall definitions */
#define FIREWALL_SIGNAL_FILE		"/var/tmp/firewall_signal"

/* QoS definitions */
#ifdef CONFIG_QOS_SUPPORT	
#define BANDWIDTH_RESULT_FILE		"/var/tmp/bandwidth_result.txt"
#endif	//CONFIG_QOS_SUPPORT

/* static route script */
#define STATIC_ROUTE_FILE			"/var/etc/sroute.sh"
#define CLEAR_SROUTE_FILE			"/var/etc/clean_sroute.sh"
#define MROUTE_FILE					"/var/etc/igmpproxy.conf"

#ifdef CONFIG_SYSLOGD
/* syslogd definitions */
#define MAX_LOG_SIZE				20 /*KB*/
#define LOG_FILE					"/var/log/messages"
#define LOG_DIE_FILE   				"/var/log/message_die_bak"
#endif // CONFIG_SYSLOGD

#ifdef CONFIG_NTP
#define TIMER_PID					"/var/run/timer.pid"
#endif	// CONFIG_NTP

#ifdef CONFIG_WLAN_MANAGER
#define WLAN_STATE_FILE				"/var/tmp/wifi_state"

#ifdef CONFIG_WLAN_SCHEDULE
#define WLAN_SCHEDULE_PID			"/var/run/wlan_schedule.pid"
#endif	// CONFIG_WLAN_SCHEDULE
#endif	// CONFIG_WLAN_MANAGER

#ifdef CONFIG_MASS_PRODUCE
#define MP_TEST_FILE				"/tmp/test_mode"
#define MP_WWW_FILE					"/www/test_mode.txt"
#endif	//CONFIG_MASS_PRODUCE

#ifdef CONFIG_DDNS
#define DDNS_STATUS_FILE   			"/var/tmp/ddns_status"
#define DDNS_STATUS_INFO   			"/var/tmp/ddns_status_info"
#endif	// CONFIG_DDNS

#ifdef CONFIG_WPS
#define WPS_STATUS_FILE 			"/var/tmp/wps_success"
#define WSC_NOTIFIER				"/proc/wsc_notifier"

#ifdef CONFIG_HOSTAPD
#define	WPS_CRED_FILE				"/var/tmp/wps_cred"
#endif	// CONFIG_HOSTAPD

#endif	// CONFIG_WPS

#ifdef CONFIG_FIREWALL_MFORWARD
/* IGMP Multicast Memberships */
#define IGMPPROXY_PID				"/var/run/igmpproxy.pid"
#define IGMP_GROUP_FILE				"/var/tmp/igmp_group.conf"
#endif	// CONFIG_FIREWALL_MFORWARD

/* IPv6 definitions */
#ifdef CONFIG_IPV6_SUPPORT

//DHCP
#define DHCP6C_CONF_FILE			"/var/etc/dhcp6c.conf"	// rc/wan.c
#define DHCP6C_SCRIPT_FILE			"/etc/dhcp6c-script"	// rc/wan.c	
#define DHCP6S_CONF_FILE			"/var/etc/dhcp6s.conf"			// rc/sutil
#define DHCP6S_LEASE_FILE			"/var/misc/dhcp6s.lease"		// rc/sutil

#define CLIENT_MAC_IPV6				"/tmp/client_mac_ipv6"
#define RADVD_CONF_FILE				"/var/etc/radvd.conf"			// httpd/sutil/timer
#define RDNSSD_SCRIPT_FILE			"/etc/rdnssd-script"	// rc/wan.c

#define IPV6_CLIENT_LIST			"/var/tmp/ipv6_client_list"		// timer
#define IPV6_CLIENT_INFO			"/var/tmp/ipv6_client_info"		// timer/httpd
#define IPV6_CLIENT_RESULT			"/var/tmp/ipv6_client_result"	// httpd
#define IPV6_DOMAIN_NAME_INFO		"/var/tmp/ipv6_domain_name_info"	//6to4 relay

#define IPV6_6RD_DHCP_INFO			"/var/tmp/ipv6_6rd_dhcp_info"

#define IPV6_STATIC_ROUTE_FILE		"/var/etc/sroute6.sh"
#define IPV6_CLEAR_SROUTE_FILE		"/var/etc/clean_sroute6.sh"

#endif //CONFIG_IPV6_SUPPORT

#define STATISTIC_INFO				"/tmp/statistic_info"

#if defined(SOHO_STA) || defined(SOHO_REPEATER) || defined(SOHO_HOTSPOT)
#define SITE_SURVEY_INFO			"/var/tmp/site_survey_info"
#endif // defined(SOHO_STA) || defined(SOHO_REPEATER) || defined(SOHO_HOTSPOT)

#if defined(SOHO_AP) || defined(SOHO_STA) || defined(SOHO_REPEATER) || defined(SOHO_HOTSPOT)
#define CONN_STATUS_FILE			"/var/tmp/conn_status"
#endif	// defined(SOHO_AP) || defined(SOHO_STA) || defined(SOHO_REPEATER) || defined(SOHO_HOTSPOT)	

#ifdef CONFIG_MODE_GPIO
#define	CURRENT_MODE_FILE			"/var/tmp/device_mode"
#endif	// 	CONFIG_MODE_GPIO

#ifdef CONFIG_DLNA
#define MINIDLNA_PID				"/var/run/minidlna.pid"
#endif	//CONFIG_DLNA

/* Tx & Rx definitions */
#define	RX_BYTES			0
#define RX_PACKETS			1
#define RX_ERROR			2
#define	RX_DROP				3
#define	RX_FIFO				4
#define	RX_FRAME			5
#define	RX_COMPRESSED		6
#define	RX_MULTICAST		7
#define	TX_BYTES			8
#define	TX_PACKETS			9
#define	TX_ERROR			10
#define	TX_DROP				11
#define	TX_FIFO				12
#define	TX_COLLS			13
#define	TX_CARRIER			14
#define	TX_COMPRESSED		15

/* State definitions */
#define SYS_IDLE						0
#define SYS_BUSY						1

/* Signal definitions */
#define REBOOT_SIGNAL					32
#define HW_DEFAULT_SIGNAL				33		// a signal for pressing the reset button over 5 seconds
#define SW_DEFAULT_SIGNAL				34		// a signal for clicking the restore to default button on GUI
#define LAN_FREE_SIGNAL					35
#define WLAN_FREE_SIGNAL				36
#define DAEMON_FREE_SIGNAL				37
#define WAN_FREE_SIGNAL					38
#define CABLE_UP_SIGNAL					39
#define CABLE_DOWN_SIGNAL				40
#define SYSTEM_READY_SIGNAL				41
#define UPDATE_HOSTNAME_SIGNAL			42

#ifdef CONFIG_WAN_MANAGER
#define WAN_OFFLINE_SIGNAL				43
#define WAN_READY_SIGNAL				44
#define WAN_SUSPENSE_SIGNAL				45
#define WAN_DROP_CONN_SIGNAL			46
#endif	// CONFIG_WAN_MANAGER

#ifdef SOHO_STA 
#define RESET_SWITCH_SIGNAL				47
#endif	//  SOHO_STA 

#define CREATE_DEFAULT_SIGNAL			48

#ifdef CONFIG_LAN_MANAGER
// Lan signal definitions
#define SIG_LAN_MIN						49
#define SIG_LAN_MAX						61
#define INIT_LAN_SIGNAL					SIG_LAN_MIN
#define SETUP_LAN_SIGNAL				(SIG_LAN_MIN + 1)
#define LAN_FIREWALL_SIGNAL				(SIG_LAN_MIN + 2)

#ifdef CONFIG_UDHCPD_REVOKE
#define REVOKE_DHCP_SIGNAL				(SIG_LAN_MIN + 3)
#endif	// 	CONFIG_UDHCPD_REVOKE

#ifdef CONFIG_HNAP
#define HNAP_LAN_SIGNAL					(SIG_LAN_MIN + 4)
#endif	// CONFIG_HNAP

#if defined(SOHO_AP) || defined(SOHO_STA)	
#define STATIC_LAN_SIGNAL				(SIG_LAN_MIN + 5)
#define LAN_CONNECT_READY_SIGNAL		(SIG_LAN_MIN + 6)
#endif	// defined(SOHO_AP) || defined(SOHO_STA)

#ifdef CONFIG_WSC_UPNP
#define WSC_UPNP_SIGNAL					(SIG_LAN_MIN + 7)
#endif	//CONFIG_WSC_UPNP

#ifdef CONFIG_IPV6_SUPPORT
#define LAN_STATEFUL_DHCP6C_SIGNAL			(SIG_LAN_MIN + 8)
#define LAN_STATELESS_DHCP6C_SIGNAL			(SIG_LAN_MIN + 9)
#endif	//CONFIG_IPV6_SUPPORT

#ifdef CONFIG_DLINK_DEVICE_MANAGE_SPEC
#define DEVICE_MANAGE_SIGNAL			(SIG_LAN_MIN + 10)
#endif	// CONFIG_DLINK_DEVICE_MANAGE_SPEC

#ifdef SOHO_STA 
#define	START_WLAN_CLI_SIGNAL			(SIG_LAN_MIN + 11)
#endif	//  SOHO_STA 

#define RESTART_DHCPD_SIGNAL			(SIG_LAN_MIN + 12)

#endif	// 	CONFIG_LAN_MANAGER

#ifdef CONFIG_WAN_MANAGER
// Wan signal definitions
#define SIG_WAN_MIN						62
#define SIG_WAN_MAX						87
#define INIT_WAN_SIGNAL					SIG_WAN_MIN
#define SETUP_WAN_SIGNAL				(SIG_WAN_MIN + 1)
#define STOP_WAN_SIGNAL					(SIG_WAN_MIN + 2)
#define WAN_CONNECT_READY_SIGNAL		(SIG_WAN_MIN + 3)
#define WAN_FIREWALL_SIGNAL				(SIG_WAN_MIN + 4)
#define WAN_CONNECT_SIGNAL				(SIG_WAN_MIN + 5)
#define PPP_CONNECT_SIGNAL				(SIG_WAN_MIN + 6)
#define WAN_DISCONNECT_SIGNAL			(SIG_WAN_MIN + 7)
#define WAN_CABLE_PLUG_SIGNAL			(SIG_WAN_MIN + 8)
#define IDLE_TIMEOUT_SIGNAL				(SIG_WAN_MIN + 9)

#ifdef CONFIG_STATIC_ROUTE	
#define WAN_STATIC_ROUTE				(SIG_WAN_MIN + 10)
#endif	//CONFIG_STATIC_ROUTE

#ifdef CONFIG_QOS_SUPPORT	
#define AUTOBW_QOS_SIGNAL				(SIG_WAN_MIN + 11)
#endif	//CONFIG_QOS_SUPPORT

#ifdef CONFIG_IPV6_SUPPORT
#define STATEFUL_DHCP6C_SIGNAL			(SIG_WAN_MIN + 12)
#define STATELESS_DHCP6C_SIGNAL			(SIG_WAN_MIN + 13)
#define IPV6_LAN_SIGNAL					(SIG_WAN_MIN + 14)
#define IPV6_RESTART_SIGNAL				(SIG_WAN_MIN + 15)
#define IPV6_PPPOE_UP_SIGNAL			(SIG_WAN_MIN + 16)
#define IPV6_PPPOE_CONNECT_SIGNAL		(SIG_WAN_MIN + 17)
#define IPV6_PPPOE_IDLE_TIMEOUT			(SIG_WAN_MIN + 18)
#define IPV6_WAN_CONNECT_SIGNAL			(SIG_WAN_MIN + 19)
#define IPV6_WAN_DISCONNECT_SIGNAL		(SIG_WAN_MIN + 20)
#define IPV6_WIZARD_SIGNAL				(SIG_WAN_MIN + 21)
#define IPV6_DHCP6C_RELEASE_SIGNAL		(SIG_WAN_MIN + 22)
#define IPV6_DHCP6C_RENEW_SIGNAL		(SIG_WAN_MIN + 23)
#endif	//CONFIG_IPV6_SUPPORT

#define RESET_STATS_SIGNAL 				(SIG_WAN_MIN + 24)
#define WAN_WIZARD_SIGNAL				(SIG_WAN_MIN + 25)
#endif	// 	CONFIG_WAN_MANAGER

#ifdef CONFIG_WLAN_MANAGER
// Wireless signal definitions
#define SIG_WLAN_MIN					88
#define SIG_WLAN_MAX					109
#define INIT_WLAN_SIGNAL				SIG_WLAN_MIN
#define	SETUP_WLAN_SIGNAL				(SIG_WLAN_MIN + 1)
#define	ENABLE_WLAN_SIGNAL				(SIG_WLAN_MIN + 2)
#define	DISABLE_WLAN_SIGNAL				(SIG_WLAN_MIN + 3)
#define RESET_WLAN_STATS_SIGNAL			(SIG_WLAN_MIN + 4)

#ifdef CONFIG_HOSTAPD
#define HOSTAPD_SIGNAL 					(SIG_WLAN_MIN + 5)
#define RESTART_HOSTAPD_SIGNAL			(SIG_WLAN_MIN + 6)
#endif //CONFIG_HOSTAPD

#ifdef CONFIG_HNAP
#define HNAP_WLAN_SIGNAL				(SIG_WLAN_MIN + 7)
#endif	// CONFIG_HNAP

#ifdef CONFIG_WPS
#define WPS_PBC_SIGNAL				(SIG_WLAN_MIN + 8)
#define WPS_PIN_SIGNAL				(SIG_WLAN_MIN + 9)
#define UPDATE_WPS_SIGNAL			(SIG_WLAN_MIN + 10)

//#ifdef SOHO_HOTSPOT	
//#define WHP_WPS_PBC_SIGNAL			(SIG_WLAN_MIN + 11)
//#define WHP_WPS_PIN_SIGNAL			(SIG_WLAN_MIN + 12)
//#endif	//SOHO_HOTSPOT

//#define BRING_UP_WLAN_IFACE_SIGNAL	(SIG_WLAN_MIN + 13)
#ifdef CONFIG_PBC5
#define WPS_PBC5_SIGNAL				(SIG_WLAN_MIN + 11)
#define STOP_PBC5_SIGNAL			(SIG_WLAN_MIN + 12)
#endif  // CONFIG_PBC5
#define	RESET_WSC_SSID_SIGNAL		(SIG_WLAN_MIN + 13)
#endif	// CONFIG_WPS

#ifdef CONFIG_CLONE_STA_MAC
#define	CLONE_CLIENT_MAC_SIGNAL			(SIG_WLAN_MIN + 14)
#endif	// CONFIG_CLONE_STA_MAC

#ifdef CONFIG_WLAN_MAC_FILTER
#define WLAN_MAC_FILTER_SIGNAL		(SIG_WLAN_MIN + 15)
#endif	// CONFIG_WLAN_MAC_FILTER

#define RADIUS_DAEMON_SIGNAL		(SIG_WLAN_MIN + 16)

#if defined(SOHO_STA) || defined(SOHO_REPEATER) || defined(SOHO_HOTSPOT)
#define SITE_SURVEY_SIGNAL			(SIG_WLAN_MIN + 17)
#define RESET_WLAN_CLIENT_SIGNAL	(SIG_WLAN_MIN + 18)
#endif // defined(SOHO_STA) || defined(SOHO_REPEATER) || defined(SOHO_HOTSPOT)

#ifdef CONFIG_GUEST_ZONE
#define ENABLE_GUEST_ZONE_SIGNAL		(SIG_WLAN_MIN + 19)
#define DISABLE_GUEST_ZONE_SIGNAL		(SIG_WLAN_MIN + 20)
#endif // CONFIG_GUEST_ZONE
#endif	// 	CONFIG_WLAN_MANAGER

#ifdef CONFIG_DAEMON_MANAGER
// Daemon signal definitions
#define SIG_DAEMON_MIN					109
#define SETUP_DAEMON_SIGNAL				SIG_DAEMON_MIN

#ifdef CONFIG_SYSLOGD
#define SYSLOGD_SIGNAL					(SIG_DAEMON_MIN + 1)
#endif	// CONFIG_SYSLOGD

#ifdef CONFIG_NTP
#define NTP_SIGNAL						(SIG_DAEMON_MIN + 2)
#define UPDATE_NTP_SIGNAL				(SIG_DAEMON_MIN + 3)
#endif	// CONFIG_NTP

#ifdef CONFIG_DDNS
#define DDNS_SIGNAL						(SIG_DAEMON_MIN + 4)

#ifdef CONFIG_SUPPORT_WEBFILE_ACCESS
#define WIZARD_DDNS_SIGNAL				(SIG_DAEMON_MIN + 17)
#endif	// CONFIG_SUPPORT_WEBFILE_ACCESS

#endif	// CONFIG_DDNS

#ifdef CONFIG_HNAP
#define LIGHTTPD_USER_SIGNAL 			(SIG_DAEMON_MIN + 5)
#endif //CONFIG_HNAP

#ifdef CONFIG_MINIUPNPD
#define MINIUPNPD_SIGNAL 				(SIG_DAEMON_MIN + 6)
#endif //CONFIG_MINIUPNPD

#ifdef CONFIG_LLD2D
#define LLD2D_SIGNAL 					(SIG_DAEMON_MIN + 7)
#endif //CONFIG_LLD2D

#ifdef CONFIG_WPS
#define WPS_SIGNAL 						(SIG_DAEMON_MIN + 8)
#define WPS_LED_ON						(SIG_DAEMON_MIN + 9)
#define WPS_LED_OFF 					(SIG_DAEMON_MIN + 10)
#endif //CONFIG_WPS

#ifdef CONFIG_DNSMASQ
#define DNSMASQ_SIGNAL					(SIG_DAEMON_MIN + 11)
#endif //CONFIG_DNSMASQ


#ifdef CONFIG_WLAN_SCHEDULE
#define WLAN_SCHEDULE_SIGNAL			(SIG_DAEMON_MIN + 12)
#endif // CONFIG_WLAN_SCHEDULE

#ifdef CONFIG_HTTPS_SUPPORT
#define HTTPS_SIGNAL					(SIG_DAEMON_MIN + 13)
#endif	//CONFIG_HTTPS_SUPPORT

#if defined(CONFIG_DLNA) || defined(CONFIG_SUPPORT_WEBFILE_ACCESS)
#define MINIDLNA_SIGNAL					(SIG_DAEMON_MIN + 14)
#endif	//defined(CONFIG_DLNA) || defined(CONFIG_SUPPORT_WEBFILE_ACCESS)

#ifdef CONFIG_SUPPORT_WEBFILE_ACCESS
#define WEBFILE_ACCESS_SIGNAL			(SIG_DAEMON_MIN + 15)
#endif	// CONFIG_SUPPORT_WEBFILE_ACCESS

#ifdef CONFIG_SUPPORT_MDNS
#define	MDNS_SIGNAL						(SIG_DAEMON_MIN + 16)
#endif	// CONFIG_SUPPORT_MDNS

#ifdef CONFIG_MY_DLINK
#define	MYDLINK_AGENT_START_SIGNAL						(SIG_DAEMON_MIN + 18)
#define	MYDLINK_AGENT_STOP_SIGNAL						(SIG_DAEMON_MIN + 19)
#endif	// CONFIG_SUPPORT_MDNS


#endif	// 	CONFIG_DAEMON_MANAGER


#ifdef CONFIG_XML_AGENT
#define WIDGETD_PID		"/var/run/widgetd.pid"

#define WIDGET_PWD_SHMKEY ((key_t) 7888)
#define WIDGET_PWD_SHMSIZE	64 //is char buffer

#define WIDGET_SALT_SHMKEY ((key_t) 7889)
#define WIDGET_SALT_SHMSIZE	128

#define WIDGET_LOGIN_SHMKEY ((key_t) 7890)
#define WIDGET_LOGIN_SHMSIZE	64

#define WIDGET_SYSTEM_DB_SHMKEY ((key_t) 7891)
#define WIDGET_SYSTEM_DB_SHMSIZE	4096

#define WIDGET_LAN_DB_SHMKEY ((key_t) 7892)
#define WIDGET_LAN_DB_SHMSIZE	2048

#define WIDGET_WLAN_DB_SHMKEY ((key_t) 7893)
#define WIDGET_WLAN_DB_SHMSIZE	4096

#define WIDGET_TIME_DB_SHMKEY ((key_t) 7894)
#define WIDGET_TIME_DB_SHMSIZE	2048

#define WIDGET_WPS_DB_SHMKEY ((key_t) 7895)
#define WIDGET_WPS_DB_SHMSIZE	2048

#define WIDGET_SCHEDULER_DB_SHMKEY ((key_t) 7896)
#define WIDGET_SCHEDULER_DB_SHMSIZE	8192

#define WIDGET_LOG_DB_SHMKEY ((key_t) 7897)
#define WIDGET_LOG_DB_SHMSIZE	2048

#define WIDGET_FILTER_DB_SHMKEY ((key_t) 7898)
#define WIDGET_FILTER_DB_SHMSIZE	14336

#define WIDGET_WAN_DB_SHMKEY ((key_t) 7899)
#define WIDGET_WAN_DB_SHMSIZE	4096

#define WIDGET_DMZ_DB_SHMKEY ((key_t) 7900)
#define WIDGET_DMZ_DB_SHMSIZE	2048

#define WIDGET_DDNS_DB_SHMKEY ((key_t) 7901)
#define WIDGET_DDNS_DB_SHMSIZE	2048

#define WIDGET_DHCPSERVER_DB_SHMKEY ((key_t) 7902)
#define WIDGET_DHCPSERVER_DB_SHMSIZE	2048

#define WIDGET_MISCCONFIG_DB_SHMKEY ((key_t) 7903)
#define WIDGET_MISCCONFIG_DB_SHMSIZE	2048

#define WIDGET_VIRTUALSERVER_DB_SHMKEY ((key_t) 7904)
#define WIDGET_VIRTUALSERVER_DB_SHMSIZE	8192

#define WIDGET_PORTFORWARDING_DB_SHMKEY ((key_t) 7905)
#define WIDGET_PORTFORWARDING_DB_SHMSIZE	8192

#define WIDGET_APPLICATIONRULE_DB_SHMKEY ((key_t) 7906)
#define WIDGET_APPLICATIONRULE_DB_SHMSIZE	8192

#define WIDGET_STATICROUTE_DB_SHMKEY ((key_t) 7907)
#define WIDGET_STATICROUTE_DB_SHMSIZE	8192

#define WIDGET_ROUTINGTABLE_DB_SHMKEY ((key_t) 7908)
#define WIDGET_ROUTINGTABLE_DB_SHMSIZE	8192

#define WIDGET_QOS_DB_SHMKEY ((key_t) 7909)
#define WIDGET_QOS_DB_SHMSIZE	256

#define WIDGET_SYSTEM_SHMKEY ((key_t) 7910)
#define WIDGET_SYSTEM_SHMSIZE	1024

#define WIDGET_LAN_SHMKEY ((key_t) 7911)
#define WIDGET_LAN_SHMSIZE	1024

#define WIDGET_DHCPSERVER_SHMKEY ((key_t) 7912)
#define WIDGET_DHCPSERVER_SHMSIZE	1024

#define WIDGET_DDNS_SHMKEY ((key_t) 7913)
#define WIDGET_DDNS_SHMSIZE	1024

#endif	//CONFIG_XML_AGENT

/*******************************************************/
