#include <netinet/ip6.h>
#define IPV6ADDRLEN		40

#define LINK_LOCAL_INFO			"/var/tmp/link_local_info"		// httpd/sutil
#define IPV6_WAN_INFO				"/var/tmp/ipv6_wan_info"		
#define IPV6_LAN_INFO				"/var/tmp/ipv6_lan_info"		
#define IPV6_GW_INFO			"/var/tmp/ipv6_gw_info"		
#define IPV6_AUTODETECT_STATE	"/var/tmp/ipv6_autodetect.txt"

#ifdef CONFIG_IPV6_PPPoE
#define PPP6_OPTIONS 			"/var/etc/options_06"		
#define PPPOE_06_PID			"/var/run/ppp6.pid"		// must be as same as pidfile created by pppd		
#define PAP6_SECRETS			"/var/etc/pap-secrets-v6"	//defined in ppp/pathnames.h
#define CHAP6_SECRETS			"/var/etc/chap-secrets-v6"	//defined in ppp/pathnames.h
#define CHAP6_REMOTE_NAME 		"CAMEO"
#define PPPOE6_COMMAND_FILE		"/var/etc/pppoe6_cmd.sh"

#define PPP6_REDIAL_PID			"/var/run/ppp6_redial.pid"
#define PPP6_MONITOR_PID			"/var/run/ppp6_monitor.pid"
#define WANTIMER6_PID		"/var/run/wan_timer6.pid"
#endif	//CONFIG_IPV6_PPPoE


extern char reading_file[20];
char wan_iface[WAN_IFACE_LEN];
char bridge_iface[BRIDGE_IFACE_LEN];

enum IPV6_WAN_TYPE{
	IPV6_WAN_LINKLOCAL,
	IPV6_WAN_STATIC,
	IPV6_WAN_AUTOCONFIG,
	IPV6_WAN_AUTODETECT,
	IPV6_WAN_6TO4,
	IPV6_WAN_6IN4,
	IPV6_WAN_6RD,
	IPV6_WAN_PPPOE
};

enum AUTOCONFIG_TYPE{
SLAAC_RDNSS,
SLAAC_STATELESS_DHCP,
STATEFUL_DHCPV6
};

enum AUTODETECT_STATE{
WIZ_INITINAL,
WIZ_TRY_PPP6,
WIZ_TRY_AUTOCONFIG,
WIZ_PPP6,
WIZ_AUTOCONFIG,
WIZ_PPP_FAIL,
WIZ_FAIL
};

typedef struct ipv6_ra_struct{
char radvd_prefix[32];
int autoconfig_type;
int dhcp_pd_enable;
char dhcp_pd_len[3];
char AdvManagedFlag[4];
char AdvOtherConfigFlag[4];
char AdvAutonomous[4];
char primary_dns[IPV6ADDRLEN];
char secondary_dns[IPV6ADDRLEN];
char dnssl_string[1024];
int manual_dns_enable;
//int AdvDefaultLifetime;
int p_lifetime;
int v_lifetime;
}IPV6_RA_STRUCT;

typedef struct ipv6_dhcp_struct{
char start_suffix[5];
char end_suffix[5];
char start_addr[IPV6ADDRLEN];
char end_addr[IPV6ADDRLEN];
char primary_dns[IPV6ADDRLEN];
char secondary_dns[IPV6ADDRLEN];
char dnssl_string[1024];
int manual_dns_enable;
int autoconfig_type;
int p_lifetime;
int v_lifetime;
int dhcp_pd_enable;
int dhcp_pd_lan;
}IPV6_DHCP_STRUCT;

typedef struct ipv6_6rd_struct{
char ipv6_6rd_prefix[IPV6ADDRLEN];
char relay_domainname[20];
int ipv4_mask_len;
int ipv6_6rd_prefix_len;
}IPV6_6RD_STRUCT;

struct html_leases_ipv6{
	char hostname[64];
	char ipv6_address[128];
	char mac[32];
};

/* define prototype here */
void get_ipv6_prefix (char *, char *, int);
void get_ipv6_wan_default_gw(char *);
void get_ip_from_domain_name(char *, char *);
void get_ipv6_dns(char *, char *);
void get_ipv6_dnssl(char *, char *);
void get_v6_prefix_with_len(struct in6_addr *, int);
void get_v4_prefix_with_len(struct in_addr *, int);
struct in6_addr* get_correct_in6_addr(char *, struct in6_addr *);
void copy_mac_to_eui64(char *, char *);
int get_ipv6_mtu(void);
int get_ipv6_autodetect_state(void);
int set_ipv6_autodetect_state(int);
void get_ipv6_lan_link_local_ip(char *);
void get_ipv6_lan_ip(char *);
void get_ipv6_wan_ip(char *);
void get_ipv6_phy_wan_link_local_ip(char *);
int get_ipv6_wan_type(void);
void get_ipv6_wan_iface(char *);

//ap mode
enum IPV6_LAN_TYPE{
	IPV6_LAN_LINKLOCAL,
	IPV6_LAN_STATIC,
	IPV6_LAN_AUTOCONFIG,
};

int get_ipv6_lan_type(void);
