
#ifdef CONFIG_DATABASE
#include <sqlite3.h>
#include "db_api.h"
#else	// CONFIG_DATABASE

#ifdef CONFIG_LINUX_NVRAM
#include "nvram.h"

#define DEFAULT_NVRAM_FILE		"/etc/nvram.default"
#define	DEV_NVRAM_KO			"/lib/modules/devnvram.ko"
#endif	// CONFIG_LINUX_NVRAM

#define MAX_ROW_NUM		40		// the maximum row number we can hold
#define	MAX_COL_NUM		15		// the maximum column we can hold

#define ENTRY_NAME_LEN	35
#define ENTRY_VALUE_LEN	1024

typedef struct {
    char name[ENTRY_NAME_LEN+1];
    char value[ENTRY_VALUE_LEN+1];    
} data_entry;

#endif // CONFIG_DATABASE

#define MAX_ENTRY_ROW	MAX_ROW_NUM
#define MAX_ENTRY_COL	MAX_COL_NUM
#define ware_entry data_entry

#define MIDWARE_OK			0
#define MIDWARE_ERR			1

typedef struct {
	int row_num;		// number of ware_entry's row
	int col_num;		// number of column in one row
	ware_entry entry[MAX_ENTRY_ROW][MAX_ENTRY_COL];
} midware_entry;

typedef struct {
	midware_entry *entry_list;
	int (*get_entry)(char *reading_file, char *table_name, midware_entry *in_entry, midware_entry *out_entry);
	int (*set_entry)(char *reading_file, char *table_name, ware_entry *in_entry, int entry_num);
	int (*update_entry)(char *reading_file, char *table_name, ware_entry *in_entry, int entry_num);
	int (*delete_entry)(char *reading_file, char *table_name, ware_entry *in_entry, int entry_num);	
	int (*update_original_fields)(char *reading_file, char *table_name, ware_entry *in_entry, int entry_num);
} midware_obj;
