/*
 * Copyright (c) 2010, Atheros Communications Inc.
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _ETH_RX_DBG_H_
#define _ETH_RX_DBG_H_

#define  MAX_NUM_MARKERS  4
#define  MAX_NUM_STREAMS  4

/* Structure to hold marker information
 */
struct marker_info {
    u_int16_t  offset;     /* Marker offset in bytes wrt start of the wbuf     */
	u_int16_t  num_bytes;  /* Width of the marker field in bytes - max 4 bytes */
    u_int32_t  match;      /* Marker pattern match value- used as packet filter */
};

/* Video debug structure 
 * Used to hold marker, rx sequence number & timestamp information
 */ 
struct eth_dbg {
	/* Marker information per stream */                       
    struct     marker_info markers[MAX_NUM_STREAMS][MAX_NUM_MARKERS];
	u_int16_t  rxseq_offset;    /* Pkt seq number offset in bytes wrt wbuf start        */
	u_int16_t  rxseq_num_bytes; /* Number of bytes that make up the pkt seq num field   */
	u_int16_t  time_offset;     /* Pkt timestamp offset in bytes wrt wbuf start         */   
	u_int16_t  time_num_bytes;	/* Number of bytes that make up the pkt timestamp field */
};

/* Video debug parameters - set using ethdebug program 
 * These parameters are used to provide the user with an interface to set markers for filtering
 * received packets & finding the locations of the rxsequence numbers/timestamps within the wbuf
 * The markers can be used to look for signatures of pkts generated by standard test tools like
 * chariot/iperf. These marker fields can be extracted from the wbuf by looking at the offset wrt
 * the start of the wbuf & extracting the number of bytes that correspond to this marker. The
 * extracted marker can then be compared with a matching pattern & filtered appropriately.
 * The rx sequence number & timetamp can also be extracted from the wbuf by looking at the offset 
 * wrt the start of the wbuf & extracting the number of bytes that correspond to the rx seq num &
 * timestamp respectively. These can be used to detect pkt losses and for jitter measurements
 */ 
struct eth_dbg_params {
	u_int32_t vi_dbg_cfg;            /* Video debug configuration - Bit0- enable dbg */
	u_int8_t  vi_num_streams;        /* Number of streams */
	u_int8_t  vi_stream_num;         /* the stream number whose markers are being set */
    u_int8_t  vi_num_markers;        /* total number of markers used to filter pkts */   
    u_int8_t  vi_marker_num;         /* the marker number whose parameters (offset, size & match) are being set */
    u_int32_t vi_marker_offset_size; /* byte offset from skb start (upper 16 bits) & size in bytes(lower 16 bits) */
    u_int32_t vi_marker_match;       /* marker pattern match used in filtering */
    u_int32_t vi_rxseq_offset_size;  /* Rx Seq num offset skb start (upper 16 bits) & size in bytes(lower 16 bits) */
	u_int32_t vi_rx_seq_rshift;      /* right-shift value in case field is not word aligned */
	u_int32_t vi_rx_seq_max;         /* Max Rx seq number */ 
	u_int32_t vi_rx_seq_drop;        /* Indicator to the debug app that a particular seq num has been dropped */ 
	u_int32_t vi_time_offset_size;   /* Timestamp offset skb start (upper 16 bits) & size in bytes(lower 16 bits) */
    u_int32_t vi_dbg_restart;        /* set to 1 to re-initialize counters/parameters */   
    struct eth_dbg vi_dbg;
};

#endif
