
#define __KERNEL__               1
#define HAVE_EXTERNAL_FLASH_MAP  1

#include "gconfig.h"
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifdef USER_DEFINITION_FLASH_MAP

static char *modelname;
static char fname[100];

struct file_element
{
    char *name;
    char *subname;
    char *mtdname;
};

struct file_element filename[]={
/* Bootloader */    {"Bootloader",  "",      "Bootloader"},
/* Config */        {"Config",      "",      "Config"},
/* Factory */       {"Factory",     "",      "Factory"},
/* Kernel */        {"uImage",      "",      "Kernel"},
/* app */           {"apps",        ".sqsh", "app"},
/* backup */        {"backup",      "",      "backup"},
#ifndef CP_APPSCORE_TO_SDRAM
/* appscore */      {"appscore",    "",      "appscore"},
#endif
/* manufacture */   {"factoryapps", ".sqsh", "manufacture"},
/* storage */       {"storage",     "",      "storage"},
};

int file_size(int mtd_index)
{
    FILE *fp;
    int fsize=0;

    sprintf(fname, "/tftpboot/%s%s%s", filename[mtd_index].name, modelname, filename[mtd_index].subname);

    if((fp=fopen(fname, "r")) != NULL)
    {
        fseek(fp,0,SEEK_END);
        fsize=ftell(fp);
        fclose(fp);
    }

    //printf("\n\n%s, size = %x\n", fname, fsize);
    return fsize;
}

int mtd_size(int mtd_index)
{
    int i, size;
    
    size = sizeof(physmap_partitions_t)/sizeof(struct mtd_partition_t);

    for(i=0; i<size; i++)
    {
        if(0==strcmp(physmap_partitions_t[i].name, filename[mtd_index].mtdname))
            return physmap_partitions_t[i].size;
    }
    return 0;
}

#define FILE_MTD_INFO  "/tftpboot/mtd_info.txt"
#define mprintf(a,b...) printf(b); fprintf(a,b) 

int main(int argc, char *argv[])
{
    int i, size, fsize, msize;
    FILE *fd;
    
    
    if(2!=argc)
    {
        printf("mtdcheck ESR-9750\n");
        return 0;
    }

    modelname = argv[1];

    size = sizeof(physmap_partitions_t)/sizeof(struct mtd_partition_t);

    fd = fopen(FILE_MTD_INFO, "w");

    if(NULL==fd)
      return 0;

    for(i=0; i<size; i++)
    {
        fsize = file_size(i);
        if(0==fsize) continue;

        msize = mtd_size(i);
        if(0==msize) continue;
            
        /* print on screen */
        mprintf(fd, "===============================================\n");
        mprintf(fd, "MTD Name: %s \n", filename[i].mtdname);
        mprintf(fd, "      MTD Space = 0x%x byte\n", msize);
        mprintf(fd, "File Name: %s \n", fname);
        mprintf(fd, "      File Size = 0x%x byte\n", fsize);
        mprintf(fd, "    Used Space = 0x%x/0x%x = %d %%\n", fsize, msize, (100*fsize)/msize);
        mprintf(fd, "    Free Space = %d byte\n", msize - fsize);
        
    }
    
    fclose(fd);
        
    return 0;
}

#else
/* Dummy */
int main(int argc, char *argv[])
{
    printf("mtdcheck, Can't find Parittion Table. Skip!\n");
    return 0;
}
#endif
