#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <ctype.h>
#include    <time.h>
#include <sys/vfs.h> /* for statfs */
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

int isFileExisted(const char *filename)
{
        FILE *fp = NULL;

        if(filename==0)
        {
                printf("%s, filename is NULL!\n", __FUNCTION__);
                return 0;
        }

        fp = fopen(filename , "r");

        if(fp)
        {
                fclose(fp);
                return 1;
        }
        else
        {
                return 0;
        }
}

long getFileSize(const char *filename)
{
 
        FILE *fp;
        long fileSize=0;

        if(!isFileExisted(filename))
        {
                printf("%s:Open file(%s) error, existed\n", __FUNCTION__, filename);
                return 0;
        }

        fp = fopen(filename, "r");

        if(!fp)
        {
                printf("%s:Open file(%s) error\n", __FUNCTION__, filename);
                return 0;
        }

        fseek(fp, 0, SEEK_END);
        fileSize=ftell(fp);

        fclose(fp);

        return fileSize;
 
}
int checkFile(char *filename, long chksize)
{
    long fileSize;

    if (!filename) return 0;
    if (strlen(filename)==0) return 1;

    printf("File:%s chksize %ldB ", filename, chksize);

    if (!isFileExisted(filename))
    {
        printf("\nFile %s does not exit!!!\n", filename);
        return 0;
    }

    if (chksize==0)
    {
        printf("Skip %s\n", filename);
        return 1;
    }
    //printf("file size %ld\n", getFileSize(filename));
    fileSize=getFileSize(filename);
    if (fileSize==0)    
    {
        printf("File %s's size is Zero!\n", filename);
        return 0;
    }
    if (fileSize>9*chksize/10 && fileSize<11*chksize/10)
    {   
    //    printf("Filesize check [%s] OK.\n", filename);
        printf("OK.\n");
        return 1;
    }
    else
    {   
        printf(" Not OK!. Filesize %ld chksize. %ld\n", 
                fileSize, chksize);
        return 0;
    }


}
int main(int argc, char *argv[])
{
    //int fsize;
    char *filename;
    long chksize=0;
    //unsigned int fileSize=0;
    FILE *fp;
    char buf[255];
    char chkfilename[255];
    

    if (argc < 2)
    {
        printf ("\n\rUasge:     filesizechk [filenamelist]\n");
        exit(1);
    }
    filename=argv[1];


    if (!isFileExisted(filename))
    {
        printf("File %s does not exit!\n", filename);
        exit(1);
    }

    fp = fopen(filename, "r");

    while(fgets(buf, sizeof(buf), fp) != NULL)
    {
    
        //printf("[%s]\n",buf);      
        memset(chkfilename,0, sizeof(chkfilename));
        chksize=0;
        sscanf(buf,"%ld,%s",&chksize,chkfilename);
//        printf("[%s] %ld\n",chkfilename, chksize);      
        if (!checkFile(chkfilename, chksize)) exit(1);      
    } 



    return 0;
}
