#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>
#include    <ctype.h>
#include    <time.h>

int find_quote(char *buf, char *quote, char **start, char **end)
{
    char *str;
    int count = 0;

    str = strstr(buf, quote);
    if (str == 0)
        return -1;

    // Skip white space
    str += strlen(quote);

    while (*str && (*str == '\t' || *str == ' '))
        str++;

    if (*str != '\"')
        return -1;

    *start = str;

    // Find string end
    str++;
    while (*str && *str != 0x0a && *str != 0x0d)
    {
        if (*str == '\"')
        {
            str++;
            count++;
            break;
        }

        str++;
    }

    if (count == 0)
        return -1;

    *end = str;
    return 0;
}


int find_ver(char *buf, char *version, char **start, char **end)
{
    char *str;
    int count = 0;

    str = strstr(buf, version);
    if (str == 0)
        return -1;

    // Skip white space
    str += strlen(version);

    while (*str && (*str == '\t' || *str == ' '))
        str++;

    if (*str == 0)
        return -1;

    *start = str;

    // Find string end
    while (*str && *str != 0x0a && *str != 0x0d)
    {
        if (!isdigit(*str))
            break;

        str++;
        count++;
    }

    if (count == 0)
        return -1;

    *end = str;

    return atoi(*start);
}

int do_backup(char *filename)
{
    char backup_name[260];
    char buf[1024];
    FILE *fp1, *fp2;

    int len;

    // Read file to buffer
    if (strlen(filename) > 255)
    {
        printf("\nError:: File path too long to handle!");
        return -1;
    }

    // Do back up
    sprintf(backup_name, "%s.bak", filename);

    if ((fp1 = fopen (filename, "rb")) == 0)
    {
        printf("\nError:: Cannot open %s", filename);
        return -1;
    }
    if ((fp2 = fopen (backup_name, "wb")) == 0)
    {
        printf("\nError:: Canoot backup the file");
    }

    while ((len = fread(buf, 1, 1024, fp1)) != 0)
    {
        fwrite(buf, 1, len, fp2);
    }

    fclose(fp1);
    fclose(fp2);

    return 0;
}


int main(int argc, char *argv[])
{
	int fsize;
    FILE *fp;
    char *buf;

    char *major_start, *major_end;
    char *minor_start, *minor_end;
    char *release_start, *release_end;
    char *build_start, *build_end;
    char *code_start, *code_end;
    char *date_start, *date_end;

    int  major_ver;
    int  minor_ver;
    int  release_ver;
    int  build_ver;

    time_t  utime;
    struct tm *btime;
/*jaykung 20060907 add a new argument to be a Prefix*/
    char MAJOR_VERSION[30]={0};
    char MINOR_VERSION[30]={0};
    char RELEASE_VERSION[30]={0};
    char BUILD_VERSION[30]={0};
    char CODE_DATE[30]={0};
    char CODE_VERSION[30]={0};
    sprintf(MAJOR_VERSION,"%s_MAJOR_VERSION__",argv[2]);
    sprintf(MINOR_VERSION,"%s_MINOR_VERSION__",argv[2]);
    sprintf(RELEASE_VERSION,"%s_RELEASE_VERSION__",argv[2]);
    sprintf(BUILD_VERSION,"%s_BUILD_VERSION__",argv[2]);
    sprintf(CODE_VERSION,"%s_CODE_VERSION__",argv[2]);
    sprintf(CODE_DATE,"%s_CODE_DATE__",argv[2]);
//~jaykung
//     if (argc < 2)



    if (argc < 3)
    {
        printf ("\n\rUasge:     autover [version_file]"
                "\n\r           version_file - file contains the following example:"
                "\n\r           #define PreFix_MAJOR_VERSION__       1"
                "\n\r           #define PreFix_MINOR_VERSION__       2"
                "\n\r           #define PreFix_RELEASE_VERSION__     3"
                "\n\r           #define PreFix_BUILD_VERSION__       4"
                "\n\r           #define PreFix_CODE_VERSION__	     1.2.3"
                "\n\r           #define PreFix_CODE_DATE__           \"2002.02.20\""
                "\n\rThis program will increase the number of PreFix__BUILD_VERSION__ everytime you run it");
        return 0;
    }

    // Do back up
    if (do_backup(argv[1]) != 0)
        return 0;

    // Read file to buffer
    if ((fp=fopen(argv[1], "r+b")) == 0)
    {
        printf("\n\rCannot open %s !!\n", argv[1]);
        return 0;
    }

    fseek(fp, 0, SEEK_END);
    fsize = ftell(fp);
    rewind(fp);
    
    if ((buf = (char *)calloc(1, fsize*2)) == 0)
    {
        fclose(fp);
        printf("\n\rError:: Cannot allocate memory!");
        return 0;
    }

    fread(buf, 1, fsize, fp);
    fclose(fp);

    // Skip version string
    if ((major_ver = find_ver(buf, MAJOR_VERSION, &major_start, &major_end)) == -1)
    {
        printf("Error:: Cannot find %s!",MAJOR_VERSION);
        return 0;
    }
    
    if ((minor_ver = find_ver(major_end, MINOR_VERSION, &minor_start, &minor_end)) == -1)
    {
        printf("Error:: Cannot find %s!",MINOR_VERSION);
        return 0;
    }

    if ((release_ver = find_ver(minor_end, RELEASE_VERSION, &release_start, &release_end)) == -1)
    {
        printf("Error:: Cannot find %s!",RELEASE_VERSION);
        return 0;
    }

    if ((build_ver = find_ver(release_end, BUILD_VERSION, &build_start, &build_end)) == -1)
    {
        printf("Error:: Cannot find %s!",BUILD_VERSION);
        return 0;
    }

    if (find_quote(build_end, CODE_VERSION, &code_start, &code_end) != 0)
    {
        printf("Error:: Cannot find %s!",CODE_VERSION);
        return 0;
    }

    if (find_quote(code_end, CODE_DATE, &date_start, &date_end) != 0)
    {
        printf("Error:: Cannot find %s!",CODE_DATE);
        return 0;
    }
#if 0
    // Skip version string
    if ((major_ver = find_ver(buf, "__MAJOR_VERSION__", &major_start, &major_end)) == -1)
    {
        printf("Error:: Cannot find __MAJOR_VERSION__!");
        return ;
    }
    
    if ((minor_ver = find_ver(major_end, "__MINOR_VERSION__", &minor_start, &minor_end)) == -1)
    {
        printf("Error:: Cannot find __MINOR_VERSION__!");
        return ;
    }

    if ((build_ver = find_ver(minor_end, "__BUILD_VERSION__", &build_start, &build_end)) == -1)
    {
        printf("Error:: Cannot find __BUILD_VERSION__!");
        return ;
    }

    if (find_quote(build_end, "__CODE_VERSION__", &code_start, &code_end) != 0)
    {
        printf("Error:: Cannot find __CODE_VERSION__!");
        return ;
    }

    if (find_quote(code_end, "__CODE_DATE__", &date_start, &date_end) != 0)
    {
        printf("Error:: Cannot find __CODE_DATE__!");
        return ;
    }
#endif
    time(&utime);
    btime = localtime(&utime);

    //
    // Write back to file
    //
    if ((fp=fopen(argv[1], "w+b")) == 0)
    {
        printf("\n\rCannot open %s !!\n", argv[1]);
        return 0;
    }

    // Write build version
    fwrite(buf, 1, (build_start - buf), fp);
    fprintf(fp, "%d", ++build_ver);

    // Write __CODE_VERSION__
    fwrite(build_end, 1, (code_start - build_end), fp);
    fprintf(fp, "\"%d.%d.%d\"", major_ver, minor_ver, release_ver);

    // Write __CODE_DATE__
    fwrite(code_end, 1, (date_start - code_end), fp);
    fprintf(fp, "\"%.4d/%.2d/%.2d\"", btime->tm_year + 1900, btime->tm_mon+1, btime->tm_mday);

    // Write rest
    fwrite(date_end, 1, fsize - (date_end - buf), fp);

    fclose(fp);
    return 0;
}
