.SS addrtype
This module matches packets based on their 
.B address type.
Address types are used within the kernel networking stack and categorize
addresses into various groups.  The exact definition of that group depends on the specific layer three protocol.
.TP
The following address types are possible:
.TP
.BI "UNSPEC"
an unspecified address (i.e. 0.0.0.0)
.BI "UNICAST"
an unicast address
.BI "LOCAL"
a local address
.BI "BROADCAST"
a broadcast address
.BI "ANYCAST"
an anycast packet
.BI "MULTICAST"
a multicast address
.BI "BLACKHOLE"
a blackhole address
.BI "UNREACHABLE"
an unreachable address
.BI "PROHIBIT"
a prohibited address
.BI "THROW"
FIXME
.BI "NAT"
FIXME
.BI "XRESOLVE"
FIXME
.TP
.BI "--src-type " "type"
Matches if the source address is of given type
.TP
.BI "--dst-type " "type"
Matches if the destination address is of given type
.SS ah
This module matches the SPIs in Authentication header of IPsec packets.
.TP
.BR "--ahspi " "[!] \fIspi\fP[:\fIspi\fP]"
.SS comment
Allows you to add comments (up to 256 characters) to any rule.
.TP
.BI "--comment " "comment"
.TP
Example:
iptables -A INPUT -s 192.168.0.0/16 -m comment --comment "A privatized IP block"
.SS condition
This matches if a specific /proc filename is '0' or '1'.
.TP
.BI "--condition " "[!] \fIfilename\fP"
Match on boolean value stored in /proc/net/ipt_condition/filename file
.SS connbytes
Match by how many bytes or packets a connection (or one of the two
flows constituting the connection) have tranferred so far, or by
average bytes per packet.

The counters are 64bit and are thus not expected to overflow ;)

The primary use is to detect long-lived downloads and mark them to be
scheduled using a lower priority band in traffic control.

The transfered bytes per connection can also be viewed through
/proc/net/ip_conntrack and accessed via ctnetlink
.TP
[\fB!\fR]\fB --connbytes \fIfrom\fB:\fR[\fIto\fR]
match packets from a connection whose packets/bytes/average packet
size is more than FROM and less than TO bytes/packets. if TO is
omitted only FROM check is done. "!" is used to match packets not
falling in the range.
.TP
\fB--connbytes-dir\fR [\fBoriginal\fR|\fBreply\fR|\fBboth\fR]
which packets to consider
.TP
\fB--connbytes-mode\fR [\fBpackets\fR|\fBbytes\fR|\fBavgpkt\fR]
whether to check the amount of packets, number of bytes transferred or
the average size (in bytes) of all packets received so far. Note that
when "both" is used together with "avgpkt", and data is going (mainly)
only in one direction (for example HTTP), the average packet size will
be about half of the actual data packets.
.TP
Example:
iptables .. -m connbytes --connbytes 10000:100000 --connbytes-dir both --connbytes-mode bytes ...
.SS connlimit
Allows you to restrict the number of parallel TCP connections to a
server per client IP address (or address block).
.TP
[\fB!\fR] \fB--connlimit-above \fIn\fR
match if the number of existing tcp connections is (not) above n
.TP
.BI "--connlimit-mask " "bits"
group hosts using mask
.P
Examples:
.TP
# allow 2 telnet connections per client host
iptables -A INPUT -p tcp --syn --dport 23 -m connlimit --connlimit-above 2 -j REJECT
.TP
# you can also match the other way around:
iptables -A INPUT -p tcp --syn --dport 23 -m connlimit ! --connlimit-above 2 -j ACCEPT
.TP
# limit the nr of parallel http requests to 16 per class C sized \
network (24 bit netmask)
iptables -p tcp --syn --dport 80 -m connlimit --connlimit-above 16
--connlimit-mask 24 -j REJECT
.SS connmark
This module matches the netfilter mark field associated with a connection
(which can be set using the
.B CONNMARK
target below).
.TP
.BI "--mark " "value[/mask]"
Matches packets in connections with the given mark value (if a mask is
specified, this is logically ANDed with the mark before the
comparison).
.SS connrate
This module matches the current transfer rate in a connection.
.TP
.BI "--connrate " "[!] [\fIfrom\fP]:[\fIto\fP]"
Match against the current connection transfer rate being within 'from'
and 'to' bytes per second. When the "!" argument is used before the
range, the sense of the match is inverted.
.SS conntrack
This module, when combined with connection tracking, allows access to
more connection tracking information than the "state" match.
(this module is present only if iptables was compiled under a kernel
supporting this feature)
.TP
.BI "--ctstate " "state"
Where state is a comma separated list of the connection states to
match.  Possible states are
.B INVALID
meaning that the packet is associated with no known connection,
.B ESTABLISHED
meaning that the packet is associated with a connection which has seen
packets in both directions,
.B NEW
meaning that the packet has started a new connection, or otherwise
associated with a connection which has not seen packets in both
directions, and
.B RELATED
meaning that the packet is starting a new connection, but is
associated with an existing connection, such as an FTP data transfer,
or an ICMP error.
.B SNAT
A virtual state, matching if the original source address differs from
the reply destination.
.B DNAT
A virtual state, matching if the original destination differs from the
reply source.
.TP
.BI "--ctproto " "proto"
Protocol to match (by number or name)
.TP
.BI "--ctorigsrc " "[!] \fIaddress\fP[/\fImask\fP]"
Match against original source address
.TP
.BI "--ctorigdst " "[!] \fIaddress\fP[/\fImask\fP]"
Match against original destination address
.TP
.BI "--ctreplsrc " "[!] \fIaddress\fP[/\fImask\fP]"
Match against reply source address
.TP
.BI "--ctrepldst " "[!] \fIaddress\fB[/\fImask\fP]"
Match against reply destination address
.TP
.BI "--ctstatus " "[\fINONE|EXPECTED|SEEN_REPLY|ASSURED\fP][,...]"
Match against internal conntrack states
.TP
.BI "--ctexpire " "\fItime\fP[\fI:time\fP]"
Match remaining lifetime in seconds against given value
or range of values (inclusive)
.SS dccp
.TP
\fB--source-port\fR,\fB--sport \fR[\fB!\fR] \fIport\fR[\fB:\fIport\fR]
.TP
\fB--destination-port\fR,\fB--dport \fR[\fB!\fR] \fIport\fR[\fB:\fIport\fR]
.TP
\fB--dccp-types\fR [\fB!\fR] \fImask\fP
Match when the DCCP packet type is one of 'mask'. 'mask' is a comma-separated
list of packet types.  Packet types are: 
.BR "REQUEST RESPONSE DATA ACK DATAACK CLOSEREQ CLOSE RESET SYNC SYNCACK INVALID" .
.TP
\fB--dccp-option\fR [\fB!\fR\] \fInumber\fP
Match if DCP option set.
.SS dscp
This module matches the 6 bit DSCP field within the TOS field in the
IP header.  DSCP has superseded TOS within the IETF.
.TP
.BI "--dscp " "value"
Match against a numeric (decimal or hex) value [0-32].
.TP
.BI "--dscp-class " "\fIDiffServ Class\fP"
Match the DiffServ class. This value may be any of the
BE, EF, AFxx or CSx classes.  It will then be converted
into it's according numeric value.
.SS ecn
This allows you to match the ECN bits of the IPv4 and TCP header.  ECN is the Explicit Congestion Notification mechanism as specified in RFC3168
.TP
.BI "--ecn-tcp-cwr"
This matches if the TCP ECN CWR (Congestion Window Received) bit is set.
.TP
.BI "--ecn-tcp-ece"
This matches if the TCP ECN ECE (ECN Echo) bit is set.
.TP
.BI "--ecn-ip-ect " "num"
This matches a particular IPv4 ECT (ECN-Capable Transport). You have to specify
a number between `0' and `3'.
.SS esp
This module matches the SPIs in ESP header of IPsec packets.
.TP
.BR "--espspi " "[!] \fIspi\fP[:\fIspi\fP]"
.SS hashlimit
This patch adds a new match called 'hashlimit'.
The idea is to have something like 'limit', but either per
destination-ip or per (destip,destport) tuple.

It gives you the ability to express
.IP
 '1000 packets per second for every host in 192.168.0.0/16'
.IP
 '100 packets per second for every service of 192.168.1.1'
.P
with a single iptables rule.
.TP
.BI "--hashlimit " "rate"
A rate just like the limit match
.TP
.BI "--hashlimit-burst " "num"
Burst value, just like limit match
.TP
.BI "--hashlimit-mode " "dstip,srcip,dstport,srcport"
A comma-separated list of objects to take into consideration
.TP
.BI "--hashlimit-name " "foo"
The name for the /proc/net/ipt_hashlimit/foo entry
.TP
.BI "--hashlimit-htable-size " "num"
The number of buckets of the hash table
.TP
.BI "--hashlimit-htable-max " "num"
Maximum entries in the hash
.TP
.BI "--hashlimit-htable-expire " "num"
After how many miliseconds do hash entries expire
.TP
.BI "--hashlimit-htable-gcinterval " "num"
How many miliseconds between garbage collection intervals
.SS helper
This module matches packets related to a specific conntrack-helper.
.TP
.BI "--helper " "string"
Matches packets related to the specified conntrack-helper.
.RS
.PP
string can be "ftp" for packets related to a ftp-session on default port.
For other ports append -portnr to the value, ie. "ftp-2121".
.PP
Same rules apply for other conntrack-helpers.
.RE
.SS icmp
This extension can be used if `--protocol icmp' is specified.  It
provides the following option:
.TP
.BR "--icmp-type " "[!] \fItypename\fP"
This allows specification of the ICMP type, which can be a numeric
ICMP type, or one of the ICMP type names shown by the command
.nf
 iptables -p icmp -h
.fi
.SS iprange
This matches on a given arbitrary range of IPv4 addresses
.TP
.BI "[!]" "--src-range " "ip-ip"
Match source IP in the specified range.
.TP
.BI "[!]" "--dst-range " "ip-ip"
Match destination IP in the specified range.
.SS ipv4options
Match on IPv4 header options like source routing, record route,
timestamp and router-alert.
.TP
.B "--ssrr"
To match packets with the flag strict source routing.
.TP
.B "--lsrr"
To match packets with the flag loose source routing.
.TP
.B "--no-srr"
To match packets with no flag for source routing.
.TP
.B "\fR[\fB!\fR]\fB --rr"
To match packets with the RR flag.
.TP
.B "\fR[\fB!\fR]\fB --ts"
To match packets with the TS flag.
.TP
.B "\fR[\fB!\fR]\fB --ra"
To match packets with the router-alert option.
.TP
.B "\fR[\fB!\fR]\fB --any-opt"
To match a packet with at least one IP option, or no IP option
at all if ! is chosen.
.TP
Examples:
.TP
$ iptables -A input -m ipv4options --rr -j DROP
will drop packets with the record-route flag.
.TP
$ iptables -A input -m ipv4options --ts -j DROP
will drop packets with the timestamp flag.
.SS length
This module matches the length of a packet against a specific value
or range of values.
.TP
.BR "--length " "[!] \fIlength\fP[:\fIlength\fP]"
.SS limit
This module matches at a limited rate using a token bucket filter.
A rule using this extension will match until this limit is reached
(unless the `!' flag is used).  It can be used in combination with the
.B LOG
target to give limited logging, for example.
.TP
.BI "--limit " "rate"
Maximum average matching rate: specified as a number, with an optional
`/second', `/minute', `/hour', or `/day' suffix; the default is
3/hour.
.TP
.BI "--limit-burst " "number"
Maximum initial number of packets to match: this number gets
recharged by one every time the limit specified above is not reached,
up to this number; the default is 5.
.SS mac
.TP
.BR "--mac-source " "[!] \fIaddress\fP"
Match source MAC address.  It must be of the form XX:XX:XX:XX:XX:XX.
Note that this only makes sense for packets coming from an Ethernet device
and entering the
.BR PREROUTING ,
.B FORWARD
or
.B INPUT
chains.
.SS mark
This module matches the netfilter mark field associated with a packet
(which can be set using the
.B MARK
target below).
.TP
.BR "--mark " "\fIvalue\fP[/\fImask\fP]"
Matches packets with the given unsigned mark value (if a \fImask\fP is
specified, this is logically ANDed with the \fImask\fP before the
comparison).
.SS multiport
This module matches a set of source or destination ports.  Up to 15
ports can be specified.  A port range (port:port) counts as two
ports.  It can only be used in conjunction with
.B "-p tcp"
or
.BR "-p udp" .
.TP
.BR "--source-ports " "\fI[!] port\fP[,\fIport\fP[,\fIport:port\fP...]]"
Match if the source port is one of the given ports.  The flag
.B --sports
is a convenient alias for this option.
.TP
.BR "--destination-ports " "\fI[!] port\fP[,\fIport\fP[,\fIport:port\fP...]]"
Match if the destination port is one of the given ports.  The flag
.B --dports
is a convenient alias for this option.
.TP
.BR "--ports " "\fI[!] port\fP[,\fIport\fP[,\fIport:port\fP...]]"
Match if either the source or destination ports are equal to one of
the given ports.
.SS owner
This module attempts to match various characteristics of the packet
creator, for locally-generated packets.  It is only valid in the
.B OUTPUT
chain, and even this some packets (such as ICMP ping responses) may
have no owner, and hence never match.
.TP
.BI "--uid-owner " "userid"
Matches if the packet was created by a process with the given
effective user id.
.TP
.BI "--gid-owner " "groupid"
Matches if the packet was created by a process with the given
effective group id.
.TP
.BI "--pid-owner " "processid"
Matches if the packet was created by a process with the given
process id.
.TP
.BI "--sid-owner " "sessionid"
Matches if the packet was created by a process in the given session
group.
.TP
.BI "--cmd-owner " "name"
Matches if the packet was created by a process with the given command name.
(this option is present only if iptables was compiled under a kernel
supporting this feature)
.TP
.B NOTE: pid, sid and command matching are broken on SMP
.SS physdev
This module matches on the bridge port input and output devices enslaved
to a bridge device. This module is a part of the infrastructure that enables
a transparent bridging IP firewall and is only useful for kernel versions
above version 2.5.44.
.TP
.BR --physdev-in " [!] \fIname\fP"
Name of a bridge port via which a packet is received (only for
packets entering the
.BR INPUT ,
.B FORWARD
and
.B PREROUTING
chains). If the interface name ends in a "+", then any
interface which begins with this name will match. If the packet didn't arrive
through a bridge device, this packet won't match this option, unless '!' is used.
.TP
.BR --physdev-out " [!] \fIname\fP"
Name of a bridge port via which a packet is going to be sent (for packets
entering the
.BR FORWARD ,
.B OUTPUT
and
.B POSTROUTING
chains).  If the interface name ends in a "+", then any
interface which begins with this name will match. Note that in the
.BR nat " and " mangle
.B OUTPUT
chains one cannot match on the bridge output port, however one can in the
.B "filter OUTPUT"
chain. If the packet won't leave by a bridge device or it is yet unknown what
the output device will be, then the packet won't match this option, unless
'!' is used.
.TP
.RB "[!] " --physdev-is-in
Matches if the packet has entered through a bridge interface.
.TP
.RB "[!] " --physdev-is-out
Matches if the packet will leave through a bridge interface.
.TP
.RB "[!] " --physdev-is-bridged
Matches if the packet is being bridged and therefore is not being routed.
This is only useful in the FORWARD and POSTROUTING chains.
.SS pkttype
This module matches the link-layer packet type.
.TP
.BI "--pkt-type " "[\fIunicast\fP|\fIbroadcast\fP|\fImulticast\fP]"
.SS policy
This modules matches the policy used by IPsec for handling a packet.
.TP
.BI "--dir " "in|out"
Used to select whether to match the policy used for decapsulation or the
policy that will be used for encapsulation.
.B in
is valid in the
.B PREROUTING, INPUT and FORWARD
chains,
.B out
is valid in the
.B POSTROUTING, OUTPUT and FORWARD
chains.
.TP
.BI "--pol " "none|ipsec"
Matches if the packet is subject to IPsec processing.
.TP
.BI "--strict"
Selects whether to match the exact policy or match if any rule of
the policy matches the given policy.
.TP
.BI "--reqid " "id"
Matches the reqid of the policy rule. The reqid can be specified with
.B setkey(8)
using
.B unique:id
as level.
.TP
.BI "--spi " "spi"
Matches the SPI of the SA.
.TP
.BI "--proto " "ah|esp|ipcomp"
Matches the encapsulation protocol.
.TP
.BI "--mode " "tunnel|transport"
Matches the encapsulation mode.
.TP
.BI "--tunnel-src " "addr[/mask]"
Matches the source end-point address of a tunnel mode SA.
Only valid with --mode tunnel.
.TP
.BI "--tunnel-dst " "addr[/mask]"
Matches the destination end-point address of a tunnel mode SA.
Only valid with --mode tunnel.
.TP
.BI "--next"
Start the next element in the policy specification. Can only be used with
--strict
.SS quota
Implements network quotas by decrementing a byte counter with each
packet.
.TP
.BI "--quota " "bytes"
The quota in bytes.
.P
.SS realm
This matches the routing realm.  Routing realms are used in complex routing
setups involving dynamic routing protocols like BGP.
.TP
.BI "--realm " "[!] " "value[/mask]"
Matches a given realm number (and optionally mask). If not a number, value
can be a named realm from /etc/iproute2/rt_realms (mask can not be used in
that case).
.SS recent
Allows you to dynamically create a list of IP addresses and then match
against that list in a few different ways.

For example, you can create a `badguy' list out of people attempting
to connect to port 139 on your firewall and then DROP all future
packets from them without considering them.
.TP
.BI "--name " "name"
Specify the list to use for the commands. If no name is given then 'DEFAULT'
will be used.
.TP
[\fB!\fR] \fB--set\fR
This will add the source address of the packet to the list. If the
source address is already in the list, this will update the existing
entry. This will always return success (or failure if `!' is passed
in).
.TP
[\fB!\fR] \fB--rcheck\fR
Check if the source address of the packet is currently in
the list.
.TP
[\fB!\fR] \fB--update\fR
Like \fB--rcheck\fR, except it will update the "last seen" timestamp if it
matches.
.TP
[\fB!\fR] \fB--remove\fR
Check if the source address of the packet is currently in the list and
if so that address will be removed from the list and the rule will
return true. If the address is not found, false is returned.
.TP
[\fB!\fR] \fB--seconds \fIseconds\fR
This option must be used in conjunction with one of \fB--rcheck\fR or
\fB--update\fR. When used, this will narrow the match to only happen
when the address is in the list and was seen within the last given
number of seconds.
.TP
[\fB!\fR] \fB--hitcount \fIhits\fR
This option must be used in conjunction with one of \fB--rcheck\fR or
\fB--update\fR. When used, this will narrow the match to only happen
when the address is in the list and packets had been received greater
than or equal to the given value. This option may be used along with
\fB--seconds\fR to create an even narrower match requiring a certain
number of hits within a specific time frame.
.TP
\fB--rttl\fR
This option must be used in conjunction with one of \fB--rcheck\fR or
\fB--update\fR. When used, this will narrow the match to only happen
when the address is in the list and the TTL of the current packet
matches that of the packet which hit the \fB--set\fR rule. This may be
useful if you have problems with people faking their source address in
order to DoS you via this module by disallowing others access to your
site by sending bogus packets to you.
.P
Examples:
.IP
# iptables -A FORWARD -m recent --name badguy --rcheck --seconds 60 -j DROP

# iptables -A FORWARD -p tcp -i eth0 --dport 139 -m recent --name badguy --set -j DROP
.P
Official website (http://snowman.net/projects/ipt_recent/) also has
some examples of usage.

/proc/net/ipt_recent/* are the current lists of addresses and information 
about each entry of each list.

Each file in /proc/net/ipt_recent/ can be read from to see the current list
or written two using the following commands to modify the list:
.TP
echo xx.xx.xx.xx > /proc/net/ipt_recent/DEFAULT
to Add to the DEFAULT list
.TP
echo -xx.xx.xx.xx > /proc/net/ipt_recent/DEFAULT
to Remove from the DEFAULT list
.TP
echo clear > /proc/net/ipt_recent/DEFAULT
to empty the DEFAULT list.
.P
The module itself accepts parameters, defaults shown:
.TP
.BI "ip_list_tot=" "100"
Number of addresses remembered per table
.TP
.BI "ip_pkt_list_tot=" "20"
Number of packets per address remembered
.TP
.BI "ip_list_hash_size=" "0"
Hash table size. 0 means to calculate it based on ip_list_tot, default: 512
.TP
.BI "ip_list_perms=" "0644"
Permissions for /proc/net/ipt_recent/* files
.TP
.BI "debug=" "0"
Set to 1 to get lots of debugging info
.SS sctp
.TP
\fB--source-port\fR,\fB--sport \fR[\fB!\fR] \fIport\fR[\fB:\fIport\fR]
.TP
\fB--destination-port\fR,\fB--dport \fR[\fB!\fR] \fIport\fR[\fB:\fIport\fR]
.TP
\fB--chunk-types\fR [\fB!\fR] \fBall\fR|\fBany\fR|\fBonly \fIchunktype\fR[\fB:\fIflags\fR] [...]
The flag letter in upper case indicates that the flag is to match if set,
in the lower case indicates to match if unset.

Chunk types: DATA INIT INIT_ACK SACK HEARTBEAT HEARTBEAT_ACK ABORT SHUTDOWN SHUTDOWN_ACK ERROR COOKIE_ECHO COOKIE_ACK ECN_ECNE ECN_CWR SHUTDOWN_COMPLETE ASCONF ASCONF_ACK

chunk type            available flags      
.br
DATA                  U B E u b e         
.br
ABORT                 T t                 
.br
SHUTDOWN_COMPLETE     T t                 

(lowercase means flag should be "off", uppercase means "on")
.P
Examples:

iptables -A INPUT -p sctp --dport 80 -j DROP

iptables -A INPUT -p sctp --chunk-types any DATA,INIT -j DROP

iptables -A INPUT -p sctp --chunk-types any DATA:Be -j ACCEPT
.SS set
This modules macthes IP sets which can be defined by ipset(8).
.TP
.BR "--set " "setname flag[,flag...]"
where flags are
.BR "src"
and/or
.BR "dst" 
and there can be no more than six of them. Hence the command
.nf
 iptables -A FORWARD -m set --set test src,dst
.fi
will match packets, for which (depending on the type of the set) the source
address or port number of the packet can be found in the specified set. If 
there is a binding belonging to the mached set element or there is a default 
binding for the given set, then the rule will match the packet only if 
additionally (depending on the type of the set) the destination address or 
port number of the packet can be found in the set according to the binding.
.SS state
This module, when combined with connection tracking, allows access to
the connection tracking state for this packet.
.TP
.BI "--state " "state"
Where state is a comma separated list of the connection states to
match.  Possible states are
.B INVALID
meaning that the packet could not be identified for some reason which
includes running out of memory and ICMP errors which don't correspond to any
known connection,
.B ESTABLISHED
meaning that the packet is associated with a connection which has seen
packets in both directions,
.B NEW
meaning that the packet has started a new connection, or otherwise
associated with a connection which has not seen packets in both
directions, and
.B RELATED
meaning that the packet is starting a new connection, but is
associated with an existing connection, such as an FTP data transfer,
or an ICMP error.
.SS string
This modules matches a given string by using some pattern matching strategy. It requires a linux kernel >= 2.6.14.
.TP
.BI "--algo  " "bm|kmp"
Select the pattern matching strategy. (bm = Boyer-Moore, kmp = Knuth-Pratt-Morris)
.TP
.BI "--from " "offset"
Set the offset from which it starts looking for any matching. If not passed, default is 0.
.TP
.BI "--to " "offset"
Set the offset from which it starts looking for any matching. If not passed, default is the packet size.
.TP
.BI "--string " "pattern"
Matches the given pattern.
.BI "--hex-string " "pattern"
Matches the given pattern in hex notation.
.SS tcp
These extensions can be used if `--protocol tcp' is specified. It
provides the following options:
.TP
.BR "--source-port " "[!] \fIport\fP[:\fIport\fP]"
Source port or port range specification. This can either be a service
name or a port number. An inclusive range can also be specified,
using the format
.IR port : port .
If the first port is omitted, "0" is assumed; if the last is omitted,
"65535" is assumed.
If the second port greater then the first they will be swapped.
The flag
.B --sport
is a convenient alias for this option.
.TP
.BR "--destination-port " "[!] \fIport\fP[:\fIport\fP]"
Destination port or port range specification.  The flag
.B --dport
is a convenient alias for this option.
.TP
.BR "--tcp-flags " "[!] \fImask\fP \fIcomp\fP"
Match when the TCP flags are as specified.  The first argument is the
flags which we should examine, written as a comma-separated list, and
the second argument is a comma-separated list of flags which must be
set.  Flags are:
.BR "SYN ACK FIN RST URG PSH ALL NONE" .
Hence the command
.nf
 iptables -A FORWARD -p tcp --tcp-flags SYN,ACK,FIN,RST SYN
.fi
will only match packets with the SYN flag set, and the ACK, FIN and
RST flags unset.
.TP
.B "[!] --syn"
Only match TCP packets with the SYN bit set and the ACK,RST and FIN bits
cleared.  Such packets are used to request TCP connection initiation;
for example, blocking such packets coming in an interface will prevent
incoming TCP connections, but outgoing TCP connections will be
unaffected.
It is equivalent to \fB--tcp-flags SYN,RST,ACK,FIN SYN\fP.
If the "!" flag precedes the "--syn", the sense of the
option is inverted.
.TP
.BR "--tcp-option " "[!] \fInumber\fP"
Match if TCP option set.
.SS tcpmss
This matches the TCP MSS (maximum segment size) field of the TCP header.  You can only use this on TCP SYN or SYN/ACK packets, since the MSS is only negotiated during the TCP handshake at connection startup time.
.TP
.BI "[!] "--mss " value[:value]"
Match a given TCP MSS value or range.
.SS time
This matches if the packet arrival time/date is within a given range. All options are facultative.
.TP
.BI " --timestart " "value"
Match only if it is after `value' (Inclusive, format: HH:MM ; default 00:00).
.TP
.BI "--timestop  " "value"
Match only if it is before `value' (Inclusive, format: HH:MM ; default 23:59).
.TP
.BI "--days " "listofdays"
Match only if today is one of the given days. (format: Mon,Tue,Wed,Thu,Fri,Sat,Sun ; default everyday)
.TP
.BI "--datestart " "date"
Match only if it is after `date' (Inclusive, format: YYYY[:MM[:DD[:hh[:mm[:ss]]]]] ; h,m,s start from 0 ; default to 1970)
.TP
.BI "--datestop " "date"
Match only if it is before `date' (Inclusive, format: YYYY[:MM[:DD[:hh[:mm[:ss]]]]] ; h,m,s start from 0 ; default to 2037)
.SS tos
This module matches the 8 bits of Type of Service field in the IP
header (ie. including the precedence bits).
.TP
.BI "--tos " "tos"
The argument is either a standard name, (use
.br
 iptables -m tos -h
.br
to see the list), or a numeric value to match.
.SS ttl
This module matches the time to live field in the IP header.
.TP
.BI "--ttl-eq " "ttl"
Matches the given TTL value.
.TP
.BI "--ttl-gt " "ttl"
Matches if TTL is greater than the given TTL value.
.TP
.BI "--ttl-lt " "ttl"
Matches if TTL is less than the given TTL value.
.SS u32
U32 allows you to extract quantities of up to 4 bytes from a packet,
AND them with specified masks, shift them by specified amounts and
test whether the results are in any of a set of specified ranges.
The specification of what to extract is general enough to skip over
headers with lengths stored in the packet, as in IP or TCP header
lengths.

Details and examples are in the kernel module source.
.SS udp
These extensions can be used if `--protocol udp' is specified.  It
provides the following options:
.TP
.BR "--source-port " "[!] \fIport\fP[:\fIport\fP]"
Source port or port range specification.
See the description of the
.B --source-port
option of the TCP extension for details.
.TP
.BR "--destination-port " "[!] \fIport\fP[:\fIport\fP]"
Destination port or port range specification.
See the description of the
.B --destination-port
option of the TCP extension for details.
.SS unclean
This module takes no options, but attempts to match packets which seem
malformed or unusual.  This is regarded as experimental.
