/* Shared library add-on to iptables for TARPIT support */
#include <stdio.h>
#include <getopt.h>
#include <iptables.h>

#if HAS_IPTABLES_HELP
static void
help(void)
{
	fputs(
"TARPIT takes no options\n"
"\n", stdout);
}
#endif

static struct option opts[] = {
	{ 0 }
};

static int
parse(int c, char **argv, int invert, unsigned int *flags,
      const struct ipt_entry *entry,
      struct ipt_entry_target **target)
{
	return 0;
}

static void final_check(unsigned int flags)
{
}

#if HAS_IPTABLES_PRINT
static void
print(const struct ipt_ip *ip,
      const struct ipt_entry_target *target,
      int numeric)
{
}
#endif

#if HAS_IPTABLES_SAVE
static void save(const struct ipt_ip *ip, const struct ipt_entry_target *target)
{
}
#endif

static struct iptables_target tarpit = {
	.next		= NULL,
	.name		= "TARPIT",
	.version	= IPTABLES_VERSION,
	.size		= IPT_ALIGN(0),
	.userspacesize	= IPT_ALIGN(0),
#if HAS_IPTABLES_HELP
	.help		= &help,
#else
	.help       = 0,
#endif
	.parse		= &parse,
	.final_check	= &final_check,
#if HAS_IPTABLES_PRINT
	.print		= &print,
#else
	.print		= 0,
#endif
#if HAS_IPTABLES_SAVE
	.save		= &save,
#else
	.save       = 0,
#endif
	.extra_opts	= opts
};

void _init(void)
{
	register_target(&tarpit);
}
