/* Shared library add-on to iptables for rpc match */
#include <stdio.h>
#include <getopt.h>
#include <iptables.h>

#if HAS_IPTABLES_HELP
/* Function which prints out usage message. */
static void
help(void)
{
	printf(
"record_rpc v%s takes no options\n"
"\n", IPTABLES_VERSION);
}
#endif

static struct option opts[] = {
	{0}
};

/* Function which parses command options; returns true if it
   ate an option */
static int
parse(int c, char **argv, int invert, unsigned int *flags,
      const struct ipt_entry *entry,
      unsigned int *nfcache,
      struct ipt_entry_match **match)
{
	return 0;
}

/* Final check; must have specified --mac. */
static void final_check(unsigned int flags)
{
}

/* Prints out the union ipt_matchinfo. */
static void
print(const struct ipt_ip *ip,
      const struct ipt_entry_match *match,
      int numeric)
{
}

#if HAS_IPTABLES_SAVE
static void save(const struct ipt_ip *ip, const struct ipt_entry_match *match)
{
}
#endif

static
struct iptables_match record_rpc = { 
	.next		= NULL,
	.name 		= "record_rpc",
	.version	= IPTABLES_VERSION,
	.size		= IPT_ALIGN(0),
	.userspacesize	= IPT_ALIGN(0),
#if HAS_IPTABLES_HELP
    .help       = &help,
#else
    .help       = 0,
#endif
	.parse		= &parse,
	.final_check	= &final_check,
	.print		= &print,
#if HAS_IPTABLES_SAVE
    .save       = &save,
#else
    .save       = 0,
#endif
	.extra_opts	= opts
};

void _init(void)
{
	register_match(&record_rpc);
}
