/* vi: set sw=4 ts=4: */
/*
 * Utility routines.
 *
 * Copyright (C) 2007 Denis Vlasenko
 *
 * Licensed under GPL version 2, see file LICENSE in this tarball for details.
 */

#include "libbb.h"
//cfho 2007-1001, i don't know who turns it on in .config, so I hard code it here! 
// In uClibc 0.9.29 (or before), the clock_gettime is not implemented!
//#define ENABLE_MONOTONIC_SYSCALL 0
#if 0
//#if ENABLE_MONOTONIC_SYSCALL
#include <sys/syscall.h>

/* libc has incredibly messy way of doing this,
 * typically requiring -lrt. We just skip all this mess */
unsigned long long monotonic_us(void)
{
	struct timespec ts;
	if (syscall(__NR_clock_gettime, CLOCK_MONOTONIC, &ts))
		bb_error_msg_and_die("clock_gettime(MONOTONIC) failed");
	return ts.tv_sec * 1000000ULL + ts.tv_nsec/1000;
}
unsigned monotonic_sec(void)
{
	struct timespec ts;
	if (syscall(__NR_clock_gettime, CLOCK_MONOTONIC, &ts))
		bb_error_msg_and_die("clock_gettime(MONOTONIC) failed");
	return ts.tv_sec;
}
#else
#if 1 /*cfho 2007-1121, because the result gettimeofday
        may be affect by ntp client, so we use /proc/uptime*/
char myTimeBuf[80];
FILE *fp;
unsigned long long monotonic_us(void)
{
    struct timeval tv;
    fp = fopen("/proc/uptime", "r");
    if(fp == NULL) return 0;
    if (fgets(myTimeBuf, sizeof(myTimeBuf), fp) != NULL)
    {
        sscanf(myTimeBuf,"%ld.%ld",&(tv.tv_sec),&(tv.tv_usec));
    }
    fclose(fp);
    return tv.tv_sec * 1000000ULL + tv.tv_usec;

}

unsigned monotonic_sec(void)
{
    struct timeval tv;
    fp = fopen("/proc/uptime", "r");
    if(fp == NULL) return 0;
    if (fgets(myTimeBuf, sizeof(myTimeBuf), fp) != NULL)
    {
        sscanf(myTimeBuf,"%ld.%ld",&(tv.tv_sec),&(tv.tv_usec));
    }
    fclose(fp);
    return tv.tv_sec;

}

#else
unsigned long long monotonic_us(void)
{
	struct timeval tv;
	gettimeofday(&tv, NULL);
	return tv.tv_sec * 1000000ULL + tv.tv_usec;
}

unsigned monotonic_sec(void)
{
	return time(NULL);
}
#endif //cfho
#endif
