/* vi: set sw=4 ts=4: */
/*
 * Utility routines.
 *
 * Copyright (C) 2007 Denys Vlasenko
 *
 * Licensed under GPL version 2, see file LICENSE in this tarball for details.
 */

#include "libbb.h"

#if ENABLE_MONOTONIC_SYSCALL

#include <sys/syscall.h>
/* Old glibc (< 2.3.4) does not provide this constant. We use syscall
 * directly so this definition is safe. */
#ifndef CLOCK_MONOTONIC
#define CLOCK_MONOTONIC 1
#endif

/* libc has incredibly messy way of doing this,
 * typically requiring -lrt. We just skip all this mess */
static void get_mono(struct timespec *ts)
{
//cfho 2007-1001, i don't know who turns it on in .config, so I hard code it here! 
// In uClibc 0.9.29 (or before), the clock_gettime is not implemented!
#if 1 //cfho
char myTimeBuf[80];
FILE *fp;
    struct timeval tv;
    fp = fopen("/proc/uptime", "r");
    if(fp != NULL)
    {
        if (fgets(myTimeBuf, sizeof(myTimeBuf), fp) != NULL)
        {
            sscanf(myTimeBuf,"%ld.%ld",&(tv.tv_sec),&(tv.tv_usec));
        }
        fclose(fp);
        //return tv.tv_sec * 1000000ULL + tv.tv_usec;
    
        ts->tv_sec=tv.tv_sec * 1000000ULL;
        ts->tv_nsec=tv.tv_usec*1000;
    }

#else

	if (syscall(__NR_clock_gettime, CLOCK_MONOTONIC, ts))
		bb_error_msg_and_die("clock_gettime(MONOTONIC) failed");
#endif //cfho
}
unsigned long long FAST_FUNC monotonic_ns(void)
{
	struct timespec ts;
	get_mono(&ts);
	return ts.tv_sec * 1000000000ULL + ts.tv_nsec;
}
unsigned long long FAST_FUNC monotonic_us(void)
{
	struct timespec ts;
	get_mono(&ts);
	return ts.tv_sec * 1000000ULL + ts.tv_nsec/1000;
}
unsigned FAST_FUNC monotonic_sec(void)
{
	struct timespec ts;
	get_mono(&ts);
	return ts.tv_sec;
}

#else

unsigned long long FAST_FUNC monotonic_ns(void)
{
	struct timeval tv;
	gettimeofday(&tv, NULL);
	return tv.tv_sec * 1000000000ULL + tv.tv_usec * 1000;
}
unsigned long long FAST_FUNC monotonic_us(void)
{
	struct timeval tv;
	gettimeofday(&tv, NULL);
	return tv.tv_sec * 1000000ULL + tv.tv_usec;
}
unsigned FAST_FUNC monotonic_sec(void)
{
	return time(NULL);
}

#endif
