/*****************************************************************************
;
;   (C) Unpublished Work of SENAO Incorporated.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF SENAO INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) SENAO EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN SENAO WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF SENAO.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : ISD
;    Creator : John Chang
;    File    : logmanager.h
;    Abstract: Define the log manager constants and variables
;
;       Modification History:
;       By              Date     Ver.   Modification Description
;       --------------- -------- -----  --------------------------------------
;
;*****************************************************************************/
#ifndef _LOG_MANAGER_H
#define _LOG_MANAGER_H

#define LOG_SOCK_PATH    "/tmp/log_socket"

/* Log service type */
enum LOG_SERVICE_MASK
{
    LOG_SERVICE_MASK_SYSLOG = 1,
    LOG_SERVICE_MASK_EMAIL  = 1<<1,
    LOG_SERVICE_MASK_SNMP   = 1<<2
};

/* The logger */
enum LOG_LOGGER
{
    LOG_LOGGER_SYSTEM = 0,
    LOG_LOGGER_DOS,
    LOG_LOGGER_ACL,
    LOG_LOGGER_DHCP,
    LOG_LOGGER_VOIP,



    /* count the number */
    LOG_LOGGER_COUNT
};

enum LOGGER_MASK
{
    LOG_LOGGER_MASK_SYSTEM = 1<<0,
    LOG_LOGGER_MASK_DOS    = 1<<1,
    LOG_LOGGER_MASK_ACL    = 1<<2,
    LOG_LOGGER_MASK_DHCP   = 1<<3,
    LOG_LOGGER_MASK_VOIP   = 1<<4,
};

struct logger_config
{
    int  id;
    int  mask;
    const char *name;
    const char *daemon;
};

static struct logger_config logger_info[]=
{
    { LOG_LOGGER_SYSTEM, LOG_LOGGER_MASK_SYSTEM,  "[SYSTEM]",   "systemd" },
    { LOG_LOGGER_DOS,    LOG_LOGGER_MASK_DOS,     "[DoS]",      "dosd"    },
    { LOG_LOGGER_ACL,    LOG_LOGGER_MASK_ACL,     "[ACL]",      "acld"    },
    { LOG_LOGGER_DHCP,   LOG_LOGGER_MASK_DHCP,    "[DHCP]",     "dhcpd"   },
    { LOG_LOGGER_VOIP,   LOG_LOGGER_MASK_VOIP,    "[VoIP]",     "voipd"   }
};

#endif /* _LOG_MANAGER_H */
