/*****************************************************************************
;
;   (C) Unpublished Work of SENAO Incorporated.  All Rights Reserved.
;
;       THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
;       PROPRIETARY AND TRADESECRET INFORMATION OF SENAO INCORPORATED.
;       ACCESS TO THIS WORK IS RESTRICTED TO (I) SENAO EMPLOYEES WHO HAVE A
;       NEED TO KNOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS
;       AND (II) ENTITIES OTHER THAN SENAO WHO HAVE ENTERED INTO APPROPRIATE
;       LICENSE AGREEMENTS.  NO PART OF THIS WORK MAY BE USED, PRACTICED,
;       PERFORMED, COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,
;       ABBRIDGED, CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST,
;       TRANSFORMED OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF SENAO.
;       ANY USE OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD
;       SUBJECT THE PERPERTRATOR TO CRIMINAL AND CIVIL LIABILITY.
;
;------------------------------------------------------------------------------
;
;    Project : ISD
;    Creator : John Chang
;    File    : logclient.c
;    Abstract: The Log Client
;
;       Modification History:
;       By              Date     Ver.   Modification Description
;       --------------- -------- -----  --------------------------------------
;
;*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <string.h>
#include <ctype.h>
#define READ_BUF_SIZE 50


int read_to_buf(const char *filename, void *buf, int bufSize)
{
    FILE *f;
    char *line;
        
    if(filename==0 || buf==0||bufSize==0)
    {
        printf("Err: %s, input errors!\n", __FUNCTION__);
        return -1;
    }

    memset(buf, 0x0, bufSize);
    
    if (!(f = fopen(filename, "r")))
    {
      printf("failed to read %s\n", filename);
      return -1;
    }

    line = fgets(buf, bufSize, f);
    if(0==line)
        bufSize = 0;
        
    fclose(f);
    
    return bufSize;
}
    
int FINDPROCID(const char *proc) 
{
    DIR *dir;
    struct dirent *next;
    char filename[READ_BUF_SIZE];
    char buffer[READ_BUF_SIZE];
    char name[READ_BUF_SIZE];
    int pid=0;

    memset(filename, 0, sizeof(filename));
    memset(buffer, 0, sizeof(buffer));
    memset(name, 0, sizeof(name));

    if(!proc)
    {
        printf("Err: %s proc is NULL!\n", __FUNCTION__);
        return -1;
    }

    dir = opendir("/proc");
    if(!dir) return -1;

    while((next = readdir(dir)) != NULL)
    {
        /* Must skip ".." since that is outside /proc */
        if(strcmp(next->d_name, "..") == 0)
            continue;

        /* If it isn't a number, we don't want it */
        if(!isdigit(*next->d_name))
            continue;

        /* 1~10 is system process */
        if(atoi(next->d_name) < 10)
            continue;

        sprintf(filename, "/proc/%s/status", next->d_name);

        if(!read_to_buf(filename, buffer, READ_BUF_SIZE-1))
        {
            continue;
        }

        /* Buffer should contain a string like "Name:   binary_name" */
        sscanf(buffer, "%*s %s", name);
        if(strcmp(name, proc) == 0)
        {
            pid=atoi(next->d_name);
            closedir(dir);  
            return pid;
        }
    }
    closedir(dir);  
    return pid;
}
/*****************************************************************
* NAME: main
* ---------------------------------------------------------------
* FUNCTION:  Entry function
* INPUT:
* OUTPUT:
* Author:   John Chang
* Modify:
****************************************************************/
int main(int argc, char *argv[])
{
    FILE *f;
    int pid;
    char *ptoolname, *pfilename;
    

    if( 3!=argc )
    {
    	printf("Example\n pptp_procid pptp /var/run/pptp.... \n");
        return 0;
    }
    
    ptoolname = argv[1];
    pfilename = argv[2];
    
    pid=FINDPROCID("pptp");
    
    printf("found pid = %d\n", pid);
    if(pid)
    {
        if (!(f = fopen(pfilename, "w")))
        {
            printf("failed to write %s\n", pfilename);
            return -1;
        }

        fprintf(f, "%d\n", pid);

        fclose(f);
    }else
    {
    	return -1;
    }
    
    return 0;
}
