#include <stdlib.h>
#include <stdio.h>
#include <net/route.h>
/*****************/
/*  FUNCTIONS    */
/*****************/

int main()
{
	char devname[64];
	unsigned long d, g, m, gateway;
	int flgs, ref, use, metric, mtu, win, ir;

	gateway = 0;
	FILE *fp = fopen("/proc/net/route", "r");

	if (fscanf(fp, "%*[^\n]\n") < 0) { /* Skip the first line. */
		goto ERROR;		   /* Empty or missing line, or read error. */
	}
	
	while (1) {
		int r;
		r = fscanf(fp, "%63s%lx%lx%X%d%d%d%lx%d%d%d\n",
				   devname, &d, &g, &flgs, &ref, &use, &metric, &m,
				   &mtu, &win, &ir);
		if (r != 11) {
			if ((r < 0) && feof(fp)) { /* EOF with no (nonspace) chars read. */
				break;
			}
 ERROR:
			printf("fscanf\n");
		}
		if (!(flgs & RTF_UP)) 
		{ /* Skip interfaces that are down. */
			continue;
		}
		gateway = g;
		printf("devname = %s, Gateway = %lx\n", devname, g);
	}
	
	fclose(fp);
	
	if( 0==gateway )
	{
	   printf("Default Gateway is not available\n");
	   return -1;
	}

        if ((fp = fopen("/tmp/gateway.dhcp", "w")) != NULL)
        {
	    fprintf(fp, "DHCPGW=%d.%d.%d.%d\n", (0xff&(gateway)>>0),
	                                        (0xff&(gateway)>>8),
	                                        (0xff&(gateway)>>16),
	                                        (0xff&(gateway)>>24) );
         }
        fclose(fp);
        
	printf("Gateway = %x\n", gateway);
	return 0;
}
