#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include "p80211ra.h"
#include "ra_oid.h"
#include "ra_driver.h"
#include "Utils.h"
/* 
 * entLAN_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */

oid    p80211idt_variables_oid[] = { 1, 2, 840, 10036 };

/* 
 * variable4 entLAN_variables:
 *   this variable defines function callbacks and type return information 
 *   for the entLAN mib section 
 */

struct variable7 p80211idt_variables[] = {
{DOT11TRANSMITTEDFRAGMENTCOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,1 }},
{DOT11MULTICASTTRANSMITTEDFRAMECOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,2 }},
{DOT11FAILEDCOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,3 }},
{DOT11RETRYCOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,4 }},
{DOT11MULTIPLERETRYCOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,5 }},
{DOT11FRAMEDUPLICATECOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,6 }},
{DOT11RTSSUCCESSCOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,7 }},
{DOT11RTSFAILURECOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,8 }},
{DOT11ACKFAILURECOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,9 }},
{DOT11RECEIVEDFRAGMENTCOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,10 }},
{DOT11MULTICASTRECEIVEDFRAMECOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,11 }},
{DOT11FCSERRORCOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,12 }},
{DOT11TRANSMITTEDFRAMECOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,13 }},
{DOT11WEPUNDECRYPTABLECOUNT, ASN_COUNTER, RONLY, var_dot11CountersEntry, 4, {2,2,1,14 }},
};
/*    (L = length of the oidsuffix) */


/** Initializes the ieee802dot11 module */
void
init_p80211idt(void)
{

    DEBUGMSGTL(("ieee802dot11", "Initializing\n"));

    /* register ourselves with the agent to handle our mib tree */
    REGISTER_MIB("ieee802dot11", p80211idt_variables, variable7,
               p80211idt_variables_oid);

    /* place any other initialization junk you need here */
}

/*
 * var_dot11CountersEntry():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */

unsigned char  *var_dot11CountersEntry(struct variable *vp, oid * name, size_t * length, int exact, size_t * var_len, WriteMethod ** write_method)
{
  static long     long_ret;
  static u_long   ulong_ret;
  static unsigned char string[SPRINT_MAX_LEN];
  int ifIndex;
  int s;
  NDIS_802_11_STATISTICS	*pStatistics = NULL;

	struct iwreq iwr;

    if (header_simple_table(vp, name, length, exact, var_len, write_method, 1) == MATCH_FAILED)
	    return NULL;

	s = socket(AF_INET, SOCK_DGRAM, 0);
	if (s < 0)
	{
			DBGPRINT("Socket error in IOCTL\n");
			return NULL;
	}

	strncpy(iwr.ifr_name, "ra0", IFNAMSIZ);
	iwr.u.data.flags = OID_802_11_STATISTICS;

	ioctl(s, RT_PRIV_IOCTL, &iwr);

	memcpy(pStatistics, iwr.u.data.pointer, iwr.u.data.length);

	close(s);

  switch (vp->magic) {
	case DOT11TRANSMITTEDFRAGMENTCOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->TransmittedFragmentCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11MULTICASTTRANSMITTEDFRAMECOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->MulticastTransmittedFrameCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11FAILEDCOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->FailedCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11RETRYCOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->RetryCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11MULTIPLERETRYCOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->MultipleRetryCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11FRAMEDUPLICATECOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->FrameDuplicateCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11RTSSUCCESSCOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->RTSSuccessCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11RTSFAILURECOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->RTSFailureCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11ACKFAILURECOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->ACKFailureCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11RECEIVEDFRAGMENTCOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->ReceivedFragmentCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11MULTICASTRECEIVEDFRAMECOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->MulticastReceivedFrameCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11FCSERRORCOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->FCSErrorCount.QuadPart;
		return (u_char *)&long_ret;
#if 0
	case DOT11TRANSMITTEDFRAMECOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->TransmittedFragmentCount.QuadPart;
		return (u_char *)&long_ret;
	case DOT11WEPUNDECRYPTABLECOUNT:
		*var_len = sizeof(long);
		long_ret = pStatistics->TransmittedFragmentCount.QuadPart;
		return (u_char *)&long_ret;
#endif
	default: 
 			return NULL; 
  }
  return NULL;
}
