/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.old-api.conf 14476 2006-04-18 17:36:51Z hardaker $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "entWlan.h"
#include "entOid.h"

#include <tokens.h>
#include <apcfg.h>
#include <wlanParameter.h>
#include <systeminfo.h>
#include "Utils.h"
/* 
 * entWlan_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */

static int op_mode;

oid entWlan_variables_oid[] = { ENTERPRISE_SENAO_PRODUCT_OID,5 };

WLANTokInfo wlanTokens[]={
    {
        WLAN1_ENABLE_TOK,
        WLAN11G_SSID_TOK,
        WLAN11G_AUTH_TOK,
        WLAN11G_ENC_TYPE_TOK,
        WLAN11G_WPAPASSPHRASE_TOK,
        WLAN11G_WPAPSK_KEYTYPE_TOK,
        WLAN11G_KEYID_TOK,
        WLAN11G_WEP_TOK,
        WLAN11G_KEYTYPE_TOK,
        {
            {WLAN11G_WEPKEY_0_TOK},{WLAN11G_WEPKEY_1_TOK},{WLAN11G_WEPKEY_2_TOK},{WLAN11G_WEPKEY_3_TOK}
        },//key
        WLAN_ISOLATED_ENABLE_TOK,
        WLAN11G_HIDESSID_TOK,
        WLAN11G_WMM_ENABLE_TOK,
        {
            {WLAN_8021X_ENABLE_TOK,WLAN_8021X_SERVIP_TOK,WLAN_8021X_SERVPORT_TOK,WLAN_8021X_SERVPW_TOK}
        },//802.1
        MACFILTER_ENABLE_TOK,
        MACFILTER_TOK
    }
#ifdef HAS_WLAN2_DEV
   ,{
        WLAN2_ENABLE_TOK,
        WLAN2_SSID_TOK,
        WLAN2_AUTH_TOK,
        WLAN2_ENC_TYPE_TOK,
        WLAN2_WPAPASSPHRASE_TOK,
        WLAN2_WPAPSK_KEYTYPE_TOK,
        WLAN2_KEYID_TOK,
        WLAN2_WEP_TOK,
        WLAN2_KEYTYPE_TOK,
        {
            {WLAN2_WEPKEY_0_TOK},{WLAN2_WEPKEY_1_TOK},{WLAN2_WEPKEY_2_TOK},{WLAN2_WEPKEY_3_TOK}
        },//key
        WLAN2_ISOLATED_ENABLE_TOK,
        WLAN2_HIDESSID_TOK,
        WLAN2_WMM_ENABLE_TOK,
        {
            {WLAN2_8021X_ENABLE_TOK,WLAN2_8021X_SERVIP_TOK,WLAN2_8021X_SERVPORT_TOK,WLAN2_8021X_SERVPW_TOK}
        },//802.1
        MACFILTER_ENABLE_TOK,
        MACFILTER_TOK
    }
#endif
#ifdef HAS_WLAN3_DEV
   ,{
        WLAN3_ENABLE_TOK,
        WLAN3_SSID_TOK,
        WLAN3_AUTH_TOK,
        WLAN3_ENC_TYPE_TOK,
        WLAN3_WPAPASSPHRASE_TOK,
        WLAN3_WPAPSK_KEYTYPE_TOK,
        WLAN3_KEYID_TOK,
        WLAN3_WEP_TOK,
        WLAN3_KEYTYPE_TOK,
        {
            {WLAN3_WEPKEY_0_TOK},{WLAN3_WEPKEY_1_TOK},{WLAN3_WEPKEY_2_TOK},{WLAN3_WEPKEY_3_TOK}
        },//key
        WLAN3_ISOLATED_ENABLE_TOK,
        WLAN3_HIDESSID_TOK,
        WLAN3_WMM_ENABLE_TOK,
        {
            {WLAN3_8021X_ENABLE_TOK,WLAN3_8021X_SERVIP_TOK,WLAN3_8021X_SERVPORT_TOK,WLAN3_8021X_SERVPW_TOK}
        },//802.1
        MACFILTER_ENABLE_TOK,
        MACFILTER_TOK
    }
#endif
#ifdef HAS_WLAN4_DEV
   ,{
        WLAN4_ENABLE_TOK,
        WLAN4_SSID_TOK,
        WLAN4_AUTH_TOK,
        WLAN4_ENC_TYPE_TOK,
        WLAN4_WPAPASSPHRASE_TOK,
        WLAN4_WPAPSK_KEYTYPE_TOK,
        WLAN4_KEYID_TOK,
        WLAN4_WEP_TOK,
        WLAN4_KEYTYPE_TOK,
        {
            {WLAN4_WEPKEY_0_TOK},{WLAN4_WEPKEY_1_TOK},{WLAN4_WEPKEY_2_TOK},{WLAN4_WEPKEY_3_TOK}
        },//key
        WLAN4_ISOLATED_ENABLE_TOK,
        WLAN4_HIDESSID_TOK,
        WLAN4_WMM_ENABLE_TOK,
        {
            {WLAN4_8021X_ENABLE_TOK,WLAN4_8021X_SERVIP_TOK,WLAN4_8021X_SERVPORT_TOK,WLAN4_8021X_SERVPW_TOK}
        },//802.1
        MACFILTER_ENABLE_TOK,
        MACFILTER_TOK
    }
#endif
};

/* 
 * variable4 entWlan_variables:
 *   this variable defines function callbacks and type return information 
 *   for the entWlan mib section 
 */

struct variable3 entWlan_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#define ENTOPMODE		1
{ENTOPMODE,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,1 }},
#define ENTRADIO		2
{ENTRADIO,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,2 }},
#define ENTAPMODE		3
{ENTAPMODE,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,3 }},
#define ENTBAND			4
{ENTBAND,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,4 }},
#define ENTESSIDNUM		5
{ENTESSIDNUM,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,5 }},
#define ENTCHANNEL		6
{ENTCHANNEL,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,6 }},
#define ENTDATARATE		7
{ENTDATARATE,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,7 }},
#define ENTNDATARATE	8
{ENTNDATARATE,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,8 }},
#define ENTTXPOWER		9
{ENTTXPOWER,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,9 }},
#define ENTBEACONINTERVAL		10
{ENTBEACONINTERVAL,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,10 }},
#define ENTDTIMPERIOD		11
{ENTDTIMPERIOD,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,11 }},
#define ENTFRAGMENTATIONTHRESHOLD		12
{ENTFRAGMENTATIONTHRESHOLD,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,12 }},
#define ENTRTSTHRESHOLD		13
{ENTRTSTHRESHOLD,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,13 }},
#define ENTCHANNELBANDWIDTH		14
{ENTCHANNELBANDWIDTH,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,14 }},
#define ENTPREAMBLETYPE		15
{ENTPREAMBLETYPE,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,15 }},
#define ENTCTSPROTECTION		16
{ENTCTSPROTECTION,  ASN_INTEGER,  RWRITE,  var_entWlan, 2,  { 1,16 }},

#define ENTWLANESSIDINFOINDEX		1
{ENTWLANESSIDINFOINDEX,  ASN_INTEGER,  RONLY,   var_entWlanESSIDInfoTable, 3,  { 2, 1, 1 }},
#define ENTESSID		2
{ENTESSID,  ASN_OCTET_STR,  RWRITE,  var_entWlanESSIDInfoTable, 3,  { 2, 1, 2 }},
#define ENTBROADCASTESSID		3
{ENTBROADCASTESSID,  ASN_INTEGER,  RWRITE,  var_entWlanESSIDInfoTable, 3,  { 2, 1, 3 }},
#define ENTWMM		4
{ENTWMM,  ASN_INTEGER,  RWRITE,  var_entWlanESSIDInfoTable, 3,  { 2, 1, 4 }},
#define ENTENCRYPTION		5
{ENTENCRYPTION,  ASN_INTEGER,  RWRITE,  var_entWlanESSIDInfoTable, 3,  { 2, 1, 5 }},
#define ENTWLANAUTHENTICATIONTYPE		6
{ENTWLANAUTHENTICATIONTYPE,  ASN_INTEGER,  RWRITE,  var_entWlanESSIDInfoTable, 3,  { 2, 1, 6 }},

#define ENTWLANESSIDINDEX		1
{ENTWLANESSIDINDEX,  ASN_INTEGER,  RONLY,   var_entWlanWepInfoTable, 3,  { 3, 1, 1 }},
#define ENTWLANWEPKEYID		2
{ENTWLANWEPKEYID,  ASN_INTEGER,  RWRITE,  var_entWlanWepInfoTable, 3,  { 3, 1, 2 }},
#define ENTWLANWEPKEY1VALUE		3
{ENTWLANWEPKEY1VALUE,  ASN_OCTET_STR,  RWRITE,  var_entWlanWepInfoTable, 3,  { 3, 1, 3 }},
#define ENTWLANWEPKEY2VALUE		4
{ENTWLANWEPKEY2VALUE,  ASN_OCTET_STR,  RWRITE,  var_entWlanWepInfoTable, 3,  { 3, 1, 4 }},
#define ENTWLANWEPKEY3VALUE		5
{ENTWLANWEPKEY3VALUE,  ASN_OCTET_STR,  RWRITE,  var_entWlanWepInfoTable, 3,  { 3, 1, 5 }},
#define ENTWLANWEPKEY4VALUE		6
{ENTWLANWEPKEY4VALUE,  ASN_OCTET_STR,  RWRITE,  var_entWlanWepInfoTable, 3,  { 3, 1, 6 }},

{ENTWLANESSIDINDEX,  ASN_INTEGER,  RONLY,   var_entWlanWPAInfoTable, 3,  { 4, 1, 1 }},
#define ENTPRESHAREDKEY		2
{ENTPRESHAREDKEY,  ASN_OCTET_STR,  RWRITE,  var_entWlanWPAInfoTable, 3,  { 4, 1, 2 }},

{ENTWLANESSIDINDEX,  ASN_INTEGER,  RONLY,   var_ent802dot1xInfoTable, 3,  { 5, 1, 1 }},
#define ENTRADIUSSERVERIPADDRESS		2
{ENTRADIUSSERVERIPADDRESS,  ASN_IPADDRESS,  RWRITE,  var_ent802dot1xInfoTable, 3,  { 5, 1, 2 }},
#define ENTRADIUSSERVERPORT		3
{ENTRADIUSSERVERPORT,  ASN_INTEGER,  RWRITE,  var_ent802dot1xInfoTable, 3,  { 5, 1, 3 }},
#define ENTRADIUSSERVERPASSWORD		4
{ENTRADIUSSERVERPASSWORD,  ASN_OCTET_STR,  RWRITE,  var_ent802dot1xInfoTable, 3,  { 5, 1, 4 }},
#define ENTWLAN802DOT1XENABLE		5
{ENTWLAN802DOT1XENABLE,  ASN_INTEGER,  RWRITE,  var_ent802dot1xInfoTable, 3,  { 5, 1, 5 }},
};
/*    (L = length of the oidsuffix) */

const char* wlanAuthModeStr[]={"OPEN","WEPAUTO","SHARED","WPAPSK","WPA","WPA2PSK","WPA2","WPA1WPA2","WPAPSKWPA2PSK"};
const char* wlanEncTypeStr[]={"NONE","WEP","TKIP","AES","TKIPAES"};

void set_entWlanCommon(int index, T_INT32 value)
{
    int dataRate[12]={1,2,5,11,6,9,12,18,24,36,48,54};
    int b_dataRate[8]={0,1,2,3,8,9,10,11};
    int g_dataRate[8]={0,1,2,3,4,5,6,7};
	int k;
	int fixedTxMode = 0;
	int rate=0;

#if FOR_EG_EOR7550
	apCfgGetValue(RADIO_2_OP_MODE_TOK, &op_mode);
#else
	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
#endif

	switch(index)
	{
	case ENTRADIO:
#if FOR_EG_EOR7550
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR || op_mode == RADIO_OPM_REPEATER_AP)
#else
			if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP || op_mode == SYS_OPM_WDSB)
#endif
			{
				SYSTEM("iwpriv "WLAN_G_DEV" set RadioOn=%d", value);
			}
#if HAS_WLAN_STA_FUNCTION
#if FOR_EG_EOR7550
			else if (op_mode == RADIO_OPM_CB || op_mode == RADIO_OPM_CR || op_mode == RADIO_OPM_REPEATER_STA)
#else
			else if (op_mode == SYS_OPM_CB || op_mode == SYS_OPM_CBRT)
#endif
			{
				SYSTEM("iwpriv "WLAN_G_DEV" %s",(value==1)?"radio_on":"radio_off");
			}
#endif
			break;
		case ENTAPMODE:
			break;
		case ENTBAND:
			SYSTEM("iwpriv "WLAN_G_DEV" set WirelessMode=%d",value);
			SYSTEM("iwpriv "WLAN_G_DEV" set HtOpMode=%d",(value==WIRELESSMODE_24G_N)?1:0); //0: MixedMode 1:GreenMode
			break;
		case ENTESSIDNUM:
			break;
		case ENTCHANNEL:
			SYSTEM("iwpriv "WLAN_G_DEV" set Channel=%d",value);
			break;
		case ENTDATARATE: /*When station can't use iwpriv to set data rate*/
#if FOR_EG_EOR7550
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR || op_mode == RADIO_OPM_REPEATER_AP)
#else
			if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP || op_mode == SYS_OPM_WDSB)
#endif
			{
				SYSTEM("iwpriv "WLAN_G_DEV" set TxRate=%d",value);
			}
			break;
		case ENTNDATARATE:
#if FOR_EG_EOR7550
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR || op_mode == RADIO_OPM_REPEATER_AP)
#else
			if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP || op_mode == SYS_OPM_WDSB)
#endif
			{
				rate = apCfgGetIntValue(WLAN11G_DATARATE_TOK);
			}
#if HAS_WLAN_STA_FUNCTION
#if FOR_EG_EOR7550
			else if (op_mode == RADIO_OPM_CB || op_mode == RADIO_OPM_CR || op_mode == RADIO_OPM_REPEATER_STA)
#else
			else if (op_mode == SYS_OPM_CB || op_mode == SYS_OPM_CBRT)
#endif
			{
				rate = apCfgGetIntValue(WLAN_STA_DATARATE_TOK);
			}
#endif

			if(rate !=0 && value==0)
			{
				for(k=0;k<12;k++)
				{
					if(rate==dataRate[k])
					{
						if(k>=4 && k<=11) fixedTxMode=2;//OFDM
						else if(k>=0 && k<=3) fixedTxMode=1;//CCK
						break;
					}
				}
				SYSTEM("iwpriv "WLAN_G_DEV" set FixedTxMode=%d",fixedTxMode);
				switch(fixedTxMode)
				{
					case 1://CCK b mode
						SYSTEM("iwpriv "WLAN_G_DEV" set HtMcs=%d",b_dataRate[k]);
						break;
					case 2://OFDM g mode
						SYSTEM("iwpriv "WLAN_G_DEV" set HtMcs=%d",g_dataRate[k-4]);
						break;
					default:
						break;
				}
			}
			else
			{
				SYSTEM("iwpriv "WLAN_G_DEV" set HtMcs=%d",value==0?33:value-1);
			}
			break;
		case ENTTXPOWER:
			SYSTEM("iwpriv "WLAN_G_DEV" set TxPower=%d",value);
			break;
		case ENTBEACONINTERVAL:
#if FOR_EG_EOR7550
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR || op_mode == RADIO_OPM_REPEATER_AP)
#else
			if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP || op_mode == SYS_OPM_WDSB)
#endif
			{
				SYSTEM("iwpriv "WLAN_G_DEV" set BeaconPeriod=%d",value);
			}
			break;
		case ENTDTIMPERIOD:
#if FOR_EG_EOR7550
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR || op_mode == RADIO_OPM_REPEATER_AP)
#else
			if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP || op_mode == SYS_OPM_WDSB)
#endif
			{
				SYSTEM("iwpriv "WLAN_G_DEV" set DtimPeriod=%d",value);
			}
			break;
		case ENTFRAGMENTATIONTHRESHOLD:
			SYSTEM("iwpriv "WLAN_G_DEV" set FragThreshold=%d",value);
			break;
		case ENTRTSTHRESHOLD:
			SYSTEM("iwpriv "WLAN_G_DEV" set RTSThreshold=%d",value);
			break;
		case ENTCHANNELBANDWIDTH:
			SYSTEM("iwpriv "WLAN_G_DEV" set HtBw=%d",value);
			break;
		case ENTPREAMBLETYPE:
			//Driver: TxPreamble 0:long preamble 1:short preamble
			SYSTEM("iwpriv "WLAN_G_DEV" set TxPreamble=%d",(value==2)?0:value);
			break;
		case ENTCTSPROTECTION:
			SYSTEM("iwpriv "WLAN_G_DEV" set BGProtection=%d",value);
			break;
	}

}

/** Initializes the entWlan module */
void
init_entWlan(void)
{

    DEBUGMSGTL(("entWlan", "Initializing\n"));

    /* register ourselves with the agent to handle our mib tree */
    REGISTER_MIB("entWlan", entWlan_variables, variable3,
               entWlan_variables_oid);

    /* place any other initialization junk you need here */
}

/*
 * var_entWlan():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_entWlan(struct variable *vp, 
                oid     *name, 
                size_t  *length, 
                int     exact, 
                size_t  *var_len, 
                WriteMethod **write_method)
{
    /* variables we may use later */
    static T_INT32 intValue;
	static int ap_mode;
	static int tmp_mode;
    
    if (header_generic(vp,name,length,exact,var_len,write_method) == MATCH_FAILED )
		return NULL;

#if FOR_EG_EOR7550
	apCfgGetValue(RADIO_2_OP_MODE_TOK, &op_mode);
	if(op_mode == RADIO_OPM_DISABLE)
	{
		return NULL;
	}
#else
	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
#endif

#if FOR_EG_EOR7550
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR || op_mode == RADIO_OPM_REPEATER_AP)
#else
	if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP || op_mode == SYS_OPM_WDSB)
#endif
	{
		switch (vp->magic)
		{
			case ENTOPMODE:
#if FOR_EG_EOR7550 != 1
				apCfgGetValue(SYS_OP_MODE_TOK, &intValue);
				if(intValue == SYS_OPM_APRP)
				{
					op_mode = REPEATER; /*Repeater*/
				}
				else if(intValue == SYS_OPM_WDSB)
				{
					op_mode = WDS_BRIDGE; /*WDS bridge*/
				}
				else if(intValue == SYS_OPM_CB || intValue == SYS_OPM_CBRT)
				{
					op_mode = CLIENT_BRIDGE; /*Client bridge*/
				}
				else
				{
					op_mode = AP; /*AP*/
				}
#endif
				*write_method = write_entWlan;
				*var_len = sizeof(op_mode);
				return (u_char*) &op_mode;
			case ENTRADIO:
				apCfgGetValue(WLAN11G_RADIO_TOK, &intValue);
				if(intValue!=TV_TRUE)
				{
					intValue = TV_FALSE;
				}
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
#if FOR_EG_EOR7550 != 1
			case ENTAPMODE:
				if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
				{
					apCfgGetValue(WLAN_AP_MODE_TOK, &intValue);
					if(intValue == AP_MODE_WDS)
					{
						ap_mode = 1; /*WDS*/
					}
					else
					{
						ap_mode = 0; /*AP*/
					}
					*var_len = sizeof(ap_mode);
					*write_method = write_entWlan;
					return (u_char*) &ap_mode;
				}
				else
				{
					return NULL;
				}
#endif
			case ENTBAND:
				apCfgGetValue(WLAN11G_MODE_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTESSIDNUM:
#if FOR_EG_EOR7550
				if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
#else
				/*Only AP or AP router support MultiSSID*/
				if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
#endif
				{
					apCfgGetValue(WLAN_SSID_NUM_TOK, &intValue);
				}
				else
				{
					return NULL;
				}
				*write_method = write_entWlan;
				*var_len = sizeof(intValue);
				return (u_char*) &intValue;
			case ENTCHANNEL:
				apCfgGetValue(WLAN11G_CHANNEL_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTDATARATE:
				apCfgGetValue(WLAN11G_DATARATE_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTNDATARATE:
				apCfgGetValue(WLAN_11N_DATERATE_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTTXPOWER:
				apCfgGetValue(WLAN11G_TXPOWER_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTBEACONINTERVAL:
				apCfgGetValue(WLAN11G_BEACON_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTDTIMPERIOD:
				apCfgGetValue(WLAN11G_DATABEACON_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTFRAGMENTATIONTHRESHOLD:
				apCfgGetValue(WLAN11G_FRAGMENT_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTRTSTHRESHOLD:
				apCfgGetValue(WLAN11G_THRESHOLD_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTCHANNELBANDWIDTH:
				apCfgGetValue(WLAN_11N_BW40_ENABLE_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTPREAMBLETYPE:
				apCfgGetValue(WLAN11G_PREAMBLE_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTCTSPROTECTION:
				apCfgGetValue(WLAN_BGPROTECTION_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			default:
				ERROR_MSG("");
		}
	}
#if HAS_WLAN_STA_FUNCTION
#if FOR_EG_EOR7550
	else if (op_mode == RADIO_OPM_CB || op_mode == RADIO_OPM_CR || op_mode == RADIO_OPM_REPEATER_STA)
#else
	else if (op_mode == SYS_OPM_CB || op_mode == SYS_OPM_CBRT)
#endif
	{
		switch (vp->magic)
		{
			case ENTOPMODE:
#if FOR_EG_EOR7550 != 1
				apCfgGetValue(SYS_OP_MODE_TOK, &intValue);
				if(intValue == SYS_OPM_APRP)
				{
					op_mode = REPEATER; /*Repeater*/
				}
				else if(intValue == SYS_OPM_WDSB)
				{
					op_mode = WDS_BRIDGE; /*WDS bridge*/
				}
				else if(intValue == SYS_OPM_CB || intValue == SYS_OPM_CBRT)
				{
					op_mode = CLIENT_BRIDGE; /*Client bridge*/
				}
				else
				{
					op_mode = AP; /*AP*/
				}
#endif
				*write_method = write_entWlan;
				*var_len = sizeof(op_mode);
				return (u_char*) &op_mode;
			case ENTRADIO:
				apCfgGetValue(WLAN_STA_RADIO_TOK, &intValue);
				if(intValue!=TV_TRUE)
				{
					intValue = TV_FALSE;
				}
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTBAND:
				apCfgGetValue(WLAN_STA_MODE_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTDATARATE:
				apCfgGetValue(WLAN_STA_DATARATE_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTNDATARATE:
				apCfgGetValue(WLAN_STA_11N_DATERATE_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTBEACONINTERVAL:
				apCfgGetValue(WLAN_STA_BEACON_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTDTIMPERIOD:
				apCfgGetValue(WLAN_STA_DATABEACON_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTFRAGMENTATIONTHRESHOLD:
				apCfgGetValue(WLAN_STA_FRAGMENT_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTRTSTHRESHOLD:
				apCfgGetValue(WLAN_STA_THRESHOLD_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			case ENTPREAMBLETYPE:
				apCfgGetValue(WLAN_STA_PREAMBLE_TOK, &intValue);
				*var_len = sizeof(intValue);
				*write_method = write_entWlan;
				return (u_char*) &intValue;
			default:
				ERROR_MSG("");
		}
	}
#endif
    return NULL;
}

int
write_entWlan(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    oid var;
    T_INT32 intValue;
    int returnValue;
	int i;
	static int sys_mode, original_sys_mode;
	int ap_mode;
	int route_enable;
    
    var = name[name_len-2];
    returnValue = TRUE;
#if FOR_EG_EOR7550
	apCfgGetValue(RADIO_2_OP_MODE_TOK, &op_mode);
#else
	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
#endif

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
				case ENTOPMODE:
#if FOR_EG_EOR7550
					return SNMP_ERR_NOTWRITABLE;
#else
					CHECK_INT(0,3);
#if FOR_EG_EAP9550
					if ( *((long*)var_val)  == CLIENT_BRIDGE)
						return SNMP_ERR_WRONGVALUE;
#endif
#endif
					break;
				case ENTRADIO:
					CHECK_INT(TV_TRUE,TV_FALSE);
					break;
#if FOR_EG_EOR7550 != 1
				case ENTAPMODE:
                    returnValue = apCfgTestValue(TYPE_APMODE, (int*)var_val);
                    break;
#endif
				case ENTBAND:
					if (var_val_type != ASN_INTEGER)
						return SNMP_ERR_WRONGTYPE;
					if (var_val_len > sizeof(long))
						return SNMP_ERR_WRONGLENGTH;
					if(!(*((long*)var_val) == WIRELESSMODE_24G_BG || *((long*)var_val) == WIRELESSMODE_24G_B || *((long*)var_val) == WIRELESSMODE_24G_G
						 || *((long*)var_val) == WIRELESSMODE_24G_GN || *((long*)var_val) == WIRELESSMODE_24G_BGN))
						return SNMP_ERR_WRONGVALUE;
				case ENTESSIDNUM:
#if FOR_EG_EOR7550
					if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
#else
					/*Only AP or AP router support MultiSSID*/
					if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
#endif
					{
						CHECK_INT(1,4);
					}
					else
					{
						return SNMP_ERR_NOTWRITABLE;
					}
					break;
				case ENTCHANNEL:
					CHECK_INT(1,14);
					break;
				case ENTDATARATE:
                    returnValue = apCfgTestValue(TYPE_11G_DATARATE, (int*)var_val);
					break;
				case ENTNDATARATE:
					CHECK_INT(0,16);  /*0 means Auto,MSC0~15*/
					break;
				case ENTTXPOWER:
                    returnValue = apCfgTestValue(TYPE_ATHEROS_TXPOWER, (int*)var_val);
					break;
				case ENTBEACONINTERVAL:
					CHECK_INT(20,1024);
					break;
				case ENTDTIMPERIOD:
					CHECK_INT(1,255);
					break;
				case ENTFRAGMENTATIONTHRESHOLD:
					CHECK_INT(256,2346);
					break;
				case ENTRTSTHRESHOLD:
					CHECK_INT(0,2347);
					break;
				case ENTCHANNELBANDWIDTH:
					CHECK_INT(0,1);
					break;
				case ENTPREAMBLETYPE:
					CHECK_INT(1,2);
					break;
				case ENTCTSPROTECTION:
					CHECK_INT(0,2);
					break;
            }
			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
			intValue = *(T_INT32 *) var_val;
#if FOR_EG_EOR7550
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR || op_mode == RADIO_OPM_REPEATER_AP)
#else
			if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP || op_mode == SYS_OPM_WDSB)
#endif
			{
				switch(var)
				{
#if FOR_EG_EOR7550 != 1
					case ENTOPMODE:
						apCfgGetValue(SYS_ROUTE_ENABLE_TOK, &route_enable);
						apCfgGetValue(SYS_OP_MODE_TOK, &original_sys_mode);
						if(intValue == WDS_BRIDGE)
						{
							sys_mode = SYS_OPM_WDSB;
							route_enable = 0;
						}
						else if(intValue == REPEATER)
						{
							sys_mode = SYS_OPM_APRP;
							route_enable = 0;
						}
						else if(intValue == CLIENT_BRIDGE)
						{
							if(route_enable)
							{
								sys_mode = SYS_OPM_CBRT;
							}
							else
							{
								sys_mode = SYS_OPM_CB;
							}
						}
						else
						{
							if(route_enable)
							{
								sys_mode = SYS_OPM_AR;
							}
							else
							{
								sys_mode = SYS_OPM_AP;
							}
						}
						/*when modify op mode, must modify route status*/
						apCfgSetIntValue(SYS_ROUTE_ENABLE_TOK, route_enable);
						returnValue = apCfgSetIntValue(SYS_OP_MODE_TOK, sys_mode);
						setSysOperationModeInfo(sys_mode);
						break;
#endif
					case ENTRADIO:
						if(intValue != TV_TRUE)
						{
							intValue = 0;
						}
						returnValue = apCfgSetIntValue(WLAN11G_RADIO_TOK, intValue);
#if FOR_EG_EOR7550 != 1
					case ENTAPMODE:
						apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
						if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
						{
							if(intValue == 1)
							{
								ap_mode = AP_MODE_WDS;
							}
							else
							{
								ap_mode = AP_MODE_AP; /*AP*/
							}
							returnValue = apCfgSetIntValue(WLAN_AP_MODE_TOK, ap_mode);
						}
						else
						{
							return SNMP_ERR_NOTWRITABLE;
						}
#endif
					case ENTBAND:
						returnValue = apCfgSetIntValue(WLAN11G_MODE_TOK, intValue);
						break;
					case ENTESSIDNUM:
						for (i=2;i<=WLAN_SSID_NUM;i++)
						{
							if(i<=intValue)
							{
								apCfgSetIntValue(wlanTokens[i-1].isEnable,1);
							}
							else
							{
								apCfgSetIntValue(wlanTokens[i-1].isEnable,0);
							}
						}
						returnValue = apCfgSetIntValue(WLAN_SSID_NUM_TOK, intValue);
						break;
					case ENTCHANNEL:
						returnValue = apCfgSetIntValue(WLAN11G_CHANNEL_TOK, intValue);
						break;
					case ENTDATARATE:
						returnValue = apCfgSetIntValue(WLAN11G_DATARATE_TOK, intValue);
						break;
					case ENTNDATARATE:
						returnValue = apCfgSetIntValue(WLAN_11N_DATERATE_TOK, intValue);
						break;
					case ENTTXPOWER:
						returnValue = apCfgSetIntValue(WLAN11G_TXPOWER_TOK, intValue);
						break;
					case ENTBEACONINTERVAL:
						returnValue = apCfgSetIntValue(WLAN11G_BEACON_TOK, intValue);
						break;
					case ENTDTIMPERIOD:
						returnValue = apCfgSetIntValue(WLAN11G_DATABEACON_TOK, intValue);
						break;
					case ENTFRAGMENTATIONTHRESHOLD:
						returnValue = apCfgSetIntValue(WLAN11G_FRAGMENT_TOK, intValue);
						break;
					case ENTRTSTHRESHOLD:
						returnValue = apCfgSetIntValue(WLAN11G_THRESHOLD_TOK, intValue);
						break;
					case ENTCHANNELBANDWIDTH:
						returnValue = apCfgSetIntValue(WLAN_11N_BW40_ENABLE_TOK, intValue);
						break;
					case ENTPREAMBLETYPE:
						returnValue = apCfgSetIntValue(WLAN11G_PREAMBLE_TOK, intValue);
						break;
					case ENTCTSPROTECTION:
						returnValue = apCfgSetIntValue(WLAN_BGPROTECTION_TOK, intValue);
						break;
				}
			}
#if HAS_WLAN_STA_FUNCTION
#if FOR_EG_EOR7550
			else if (op_mode == RADIO_OPM_CB || op_mode == RADIO_OPM_CR || op_mode == RADIO_OPM_REPEATER_STA)
#else
			else if (op_mode == SYS_OPM_CB || op_mode == SYS_OPM_CBRT)
#endif
			{
				switch(var)
				{
					case ENTRADIO:
						if(intValue != TV_TRUE)
						{
							intValue = 0;
						}
						returnValue = apCfgSetIntValue(WLAN_STA_RADIO_TOK, intValue);
					case ENTBAND:
						returnValue = apCfgSetIntValue(WLAN_STA_MODE_TOK, intValue);
						break;
					case ENTDATARATE:
						returnValue = apCfgSetIntValue(WLAN_STA_DATARATE_TOK, intValue);
						break;
					case ENTNDATARATE:
						returnValue = apCfgSetIntValue(WLAN_STA_11N_DATERATE_TOK, intValue);
						break;
					case ENTBEACONINTERVAL:
						returnValue = apCfgSetIntValue(WLAN_STA_BEACON_TOK, intValue);
						break;
					case ENTDTIMPERIOD:
						returnValue = apCfgSetIntValue(WLAN_STA_DATABEACON_TOK, intValue);
						break;
					case ENTFRAGMENTATIONTHRESHOLD:
						returnValue = apCfgSetIntValue(WLAN_STA_FRAGMENT_TOK, intValue);
						break;
					case ENTRTSTHRESHOLD:
						returnValue = apCfgSetIntValue(WLAN_STA_THRESHOLD_TOK, intValue);
						break;
					case ENTPREAMBLETYPE:
						returnValue = apCfgSetIntValue(WLAN_STA_PREAMBLE_TOK, intValue);
						break;
				}
			}
#endif

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			set_entWlanCommon(var, intValue);
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                
            }
            break;

		case COMMIT:
            switch(var)
            {
#if FOR_EG_EOR7550 != 1
				case ENTOPMODE:
					/*If value is not changed, will not reboot*/
					if(original_sys_mode != sys_mode)
					{
						SYSTEM("sysconf_cli reboot &");
					}
					break;
				case ENTAPMODE:
#endif
				case ENTESSIDNUM:
					SYSTEM("sysconf_cli applychanges checkAllModules &");
					break;
#if HAS_WLAN_STA_FUNCTION
				case ENTDATARATE: /*When station can't use iwpriv to set data rate*/
				case ENTBEACONINTERVAL:
				case ENTDTIMPERIOD:
#if FOR_EG_EOR7550
					if (op_mode == RADIO_OPM_CB || op_mode == RADIO_OPM_CR || op_mode == RADIO_OPM_REPEATER_STA)
#else
					if (op_mode == SYS_OPM_CB || op_mode == SYS_OPM_CBRT)
#endif
					{
						SYSTEM("sysconf_cli applychanges checkAllModules &");
					}
					break;
#endif //HAS_WLAN_STA_FUNCTION
			}
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}

/*
 * var_entWlanESSIDInfoTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_entWlan above.
 */
unsigned char *
var_entWlanESSIDInfoTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
    /* variables we may use later */
	static oid index;
	T_CHAR tokBuf[30];
	static int ssidNum;
    static T_UCHAR ssidValue[32+1];
    static int intValue;
	static int wlan_enable;

	/* 
   * This assumes that the table is a 'simple' table.
   *	See the implementation documentation for the meaning of this.
   *	You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *	you will need to provide the replacement code yourself.
   *	Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
    if (header_simple_table(vp,name,length,exact,var_len,write_method, WLAN_SSID_NUM) == MATCH_FAILED )
		return NULL;

	index = name[*length - 1];

#if FOR_EG_EOR7550
	apCfgGetValue(RADIO_2_OP_MODE_TOK, &op_mode);
	if(op_mode == RADIO_OPM_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
	{
		if(index > 1)
		{
			return NULL;
		}
	}
	else
	{
		return NULL;
	}
#else
	/*Only AP or AP router support MultiSSID*/
	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
	if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else if(op_mode == SYS_OPM_WDSB)
	{
		if(index > 1)
		{
			return NULL;
		}
	}
	else
	{
		return NULL;
	}
#endif

	/*Check whether wlan is enabled*/
    apCfgGetValue(wlanTokens[index-1].isEnable, &wlan_enable);
	if(!wlan_enable)
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */

#if FOR_EG_EOR7550
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
#else
	if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
#endif
	{
		switch(vp->magic) {
		case ENTWLANESSIDINFOINDEX:
			return (u_char*) &index;
		case ENTESSID:
			apCfgGetValue(wlanTokens[index-1].SSID, ssidValue);
			*var_len = strlen(ssidValue);
			*write_method = write_entWlanESSIDInfoTable;
			return (u_char*) &ssidValue;
		case ENTBROADCASTESSID:
			apCfgGetValue(wlanTokens[index-1].BroadcastSSID, &intValue);
			 if(intValue!=TV_TRUE)
			 {
				 intValue = TV_FALSE;
			 }
			*var_len = sizeof(intValue);
			*write_method = write_entWlanESSIDInfoTable;
			return (u_char*) &intValue;
		case ENTWMM:
			apCfgGetValue(wlanTokens[index-1].WmmCapable, &intValue);
			 if(intValue!=TV_TRUE)
			 {
				 intValue = TV_FALSE;
			 }
			*var_len = sizeof(intValue);
			*write_method = write_entWlanESSIDInfoTable;
			return (u_char*) &intValue;
		case ENTENCRYPTION:
			apCfgGetValue(wlanTokens[index-1].EncrypType, &intValue);
			*var_len = sizeof(intValue);
			*write_method = write_entWlanESSIDInfoTable;
			return (u_char*) &intValue;
		case ENTWLANAUTHENTICATIONTYPE:
			apCfgGetValue(wlanTokens[index-1].AuthMode, &intValue);
			*var_len = sizeof(intValue);
			*write_method = write_entWlanESSIDInfoTable;
			return (u_char*) &intValue;
		default:
			ERROR_MSG("");
		}
	}
/*Adonn 08-1008: TODO*/
#if FOR_EG_EOR7550
	else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
#else
	else if(op_mode == SYS_OPM_WDSB)
#endif
	{
		switch(vp->magic) {
		case ENTWLANESSIDINFOINDEX:
			return (u_char*) &index;
		case ENTESSID:
			apCfgGetValue(wlanTokens[index-1].SSID, ssidValue);
			*var_len = strlen(ssidValue);
			*write_method = write_entWlanESSIDInfoTable;
			return (u_char*) &ssidValue;
		case ENTENCRYPTION:
			apCfgGetValue(WLAN_WDS_SEC_TYPE_TOK, &intValue);
			*var_len = sizeof(intValue);
			*write_method = write_entWlanESSIDInfoTable;
			return (u_char*) &intValue;
		default:
			ERROR_MSG("");
		}
	}
    return NULL;
}

void set_entWlanESSIDInfoTable(int essidIndex, int var, u_char *var_val)
{
	T_INT32 intValue;

	intValue = *(T_INT32 *) var_val;
	switch(var)
	{
		case ENTESSID:
			SYSTEM("iwpriv "WLAN_DEV"%d set SSID=%s",essidIndex-1, var_val);
			break;
		case ENTBROADCASTESSID:
			if(intValue != TV_TRUE)
			{
				intValue = 0;
			}
			SYSTEM("iwpriv "WLAN_DEV"%d set HideSSID=%d",essidIndex-1, intValue);
			break;
		case ENTWMM:
			if(intValue != TV_TRUE)
			{
				intValue = 0;
			}
			SYSTEM("iwpriv "WLAN_DEV"%d set WmmCapable=%d",essidIndex-1, intValue);
			break;					
		case ENTENCRYPTION:
			SYSTEM("iwpriv "WLAN_DEV"%d set AuthMode=%s",essidIndex-1, wlanAuthModeStr[intValue]);
			break;
		case ENTWLANAUTHENTICATIONTYPE:
			SYSTEM("iwpriv "WLAN_DEV"%d set EncrypType=%s",essidIndex-1, wlanEncTypeStr[intValue]);
			break;
	}
}
    
int
write_entWlanESSIDInfoTable(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    oid var;
    T_INT32 intValue;
    int returnValue;
	int essidIndex;

	essidIndex = name[name_len-1];
    var = name[name_len-2];
    returnValue = TRUE;
#if FOR_EG_EOR7550
	apCfgGetValue(RADIO_2_OP_MODE_TOK, &op_mode);
#else
	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
#endif

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
#if FOR_EG_EOR7550
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
#else
			if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
#endif
			{
				switch(var)
				{
					case ENTESSID:
						returnValue = apCfgTestValue(TYPE_SSID, (char *)var_val);
						break;
					case ENTBROADCASTESSID:
						CHECK_INT(TV_TRUE,TV_FALSE);
						break;
					case ENTWMM:
						CHECK_INT(TV_TRUE,TV_FALSE);
						break;					
					case ENTENCRYPTION:
						CHECK_INT(0,4);
						break;
					case ENTWLANAUTHENTICATIONTYPE:
						CHECK_INT(0,8);
						break;
				}
			}
#if FOR_EG_EOR7550
			else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
#else
			else if(op_mode == SYS_OPM_WDSB)
#endif
			{
				switch(var)
				{
					case ENTESSID:
                    returnValue = apCfgTestValue(TYPE_SSID, (char *)var_val);
						break;			
					case ENTENCRYPTION:
						CHECK_INT(0,3);
						break;
				}
			}

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
#if FOR_EG_EOR7550
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
#else
			if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
#endif
			{
				switch(var)
				{
					case ENTESSID:
						returnValue = apCfgSetValue(wlanTokens[essidIndex-1].SSID, (T_CHAR*) var_val);
						break;
					case ENTBROADCASTESSID:
						intValue = *(T_INT32 *) var_val;
						if(intValue != TV_TRUE)
						{
							intValue = 0;
						}
						returnValue = apCfgSetIntValue(wlanTokens[essidIndex-1].BroadcastSSID, intValue);
						break;
					case ENTWMM:
						intValue = *(T_INT32 *) var_val;
						if(intValue != TV_TRUE)
						{
							intValue = 0;
						}
						returnValue = apCfgSetIntValue(wlanTokens[essidIndex-1].WmmCapable, intValue);
						break;					
					case ENTENCRYPTION:
						returnValue = apCfgSetValue(wlanTokens[essidIndex-1].EncrypType, (T_INT32 *) var_val);
						break;
					case ENTWLANAUTHENTICATIONTYPE:
						returnValue = apCfgSetValue(wlanTokens[essidIndex-1].AuthMode, (T_INT32 *) var_val);
						break;
				}
			}
#if FOR_EG_EOR7550
			else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
#else
			else if(op_mode == SYS_OPM_WDSB)
#endif
			{
				switch(var)
				{
					case ENTESSID:
						returnValue = apCfgSetValue(wlanTokens[essidIndex-1].SSID, (T_CHAR*) var_val);
						break;					
					case ENTENCRYPTION:
						returnValue = apCfgSetValue(WLAN_WDS_SEC_TYPE_TOK, (T_INT32 *) var_val);
						break;
				}
			}

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			set_entWlanESSIDInfoTable(essidIndex, var, var_val);
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                
            }
            break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}
/*
 * var_entWlanWepInfoTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_entWlan above.
 */
unsigned char *
var_entWlanWepInfoTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
    /* variables we may use later */
	static oid index;
	T_CHAR tokBuf[30];
    static int intValue;
	static int enc;
	static int wlan_enable;

	/* 
   * This assumes that the table is a 'simple' table.
   *	See the implementation documentation for the meaning of this.
   *	You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *	you will need to provide the replacement code yourself.
   *	Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
    if (header_simple_table(vp,name,length,exact,var_len,write_method, WLAN_SSID_NUM) == MATCH_FAILED )
		return NULL;

	index = name[*length - 1];

#if FOR_EG_EOR7550
	apCfgGetValue(RADIO_2_OP_MODE_TOK, &op_mode);
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
	{
		if(index > 1)
		{
			return NULL;
		}
	}
	else
	{
		return NULL;
	}
#else
	/*Only AP or AP router support MultiSSID*/
	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
	if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else if(op_mode == SYS_OPM_WDSB)
	{
		if(index > 1)
		{
			return NULL;
		}
	}
	else
	{
		return NULL;
	}
#endif

	/*Check whether wlan is enabled*/
    apCfgGetValue(wlanTokens[index-1].isEnable, &wlan_enable);
	if(!wlan_enable)
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */
#if FOR_EG_EOR7550
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
#else
	if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
#endif
	{
		switch(vp->magic) {
		case ENTWLANESSIDINDEX:
			return (u_char*) &index;
		case ENTWLANWEPKEYID:
			apCfgGetValue(wlanTokens[index-1].DefaultKeyId, &intValue);
			*var_len = sizeof(intValue);
			*write_method = write_entWlanWepInfoTable;
			return (u_char*) &intValue;
		case ENTWLANWEPKEY1VALUE:
		case ENTWLANWEPKEY2VALUE:
		case ENTWLANWEPKEY3VALUE:
		case ENTWLANWEPKEY4VALUE:
			*write_method = write_entWlanWepInfoTable;
			return NULL;
		default:
			ERROR_MSG("");
		}
	}
#if FOR_EG_EOR7550
	else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
#else
	else if(op_mode == SYS_OPM_WDSB)
#endif
	{
		switch(vp->magic) {
		case ENTWLANESSIDINDEX:
			return (u_char*) &index;
		case ENTWLANWEPKEYID:
			apCfgGetValue(WLAN_WDS_KEYID_TOK, &intValue);
			*var_len = sizeof(intValue);
			*write_method = write_entWlanWepInfoTable;
			return (u_char*) &intValue;
		case ENTWLANWEPKEY1VALUE:
		case ENTWLANWEPKEY2VALUE:
		case ENTWLANWEPKEY3VALUE:
		case ENTWLANWEPKEY4VALUE:
			*write_method = write_entWlanWepInfoTable;
			return NULL;
		default:
			ERROR_MSG("");
		}
	}
    return NULL;
}

void set_entWlanWepInfoTable(int essidIndex, int var, u_char *var_val)
{
	T_INT32 intValue;

	intValue = *(T_INT32 *) var_val;
	switch(var)
	{
	case ENTWLANWEPKEYID:
		SYSTEM("iwpriv "WLAN_DEV"%d set DefaultKeyID=%d",essidIndex-1, intValue);
		break;
	case ENTWLANWEPKEY1VALUE:
		SYSTEM("iwpriv "WLAN_DEV"%d set Key1=%s",essidIndex-1, var_val);
		break;
	case ENTWLANWEPKEY2VALUE:
		SYSTEM("iwpriv "WLAN_DEV"%d set Key2=%s",essidIndex-1, var_val);
		break;
	case ENTWLANWEPKEY3VALUE:
		SYSTEM("iwpriv "WLAN_DEV"%d set Key3=%s",essidIndex-1, var_val);
		break;
	case ENTWLANWEPKEY4VALUE:
		SYSTEM("iwpriv "WLAN_DEV"%d set Key4=%s",essidIndex-1, var_val);
		break;
	}
}

int
write_entWlanWepInfoTable(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    oid var;
    T_INT32 intValue;
    int returnValue;
	int essidIndex;

	essidIndex = name[name_len-1];
    var = name[name_len-2];
    returnValue = TRUE;
#if FOR_EG_EOR7550
	apCfgGetValue(RADIO_2_OP_MODE_TOK, &op_mode);
#else
	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
#endif

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
			case ENTWLANWEPKEYID:
				CHECK_INT(1,4);
				break;
			case ENTWLANWEPKEY1VALUE:
			case ENTWLANWEPKEY2VALUE:
			case ENTWLANWEPKEY3VALUE:
			case ENTWLANWEPKEY4VALUE:
				if (var_val_type != ASN_OCTET_STR)
					return SNMP_ERR_WRONGTYPE;
				returnValue = apCfgTestValue(TYPE_WEPKEY, (T_CHAR *)var_val);   
				break;

            }
			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
	case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
#if FOR_EG_EOR7550
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
#else
			if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
#endif
			{
				switch(var)
				{
				case ENTWLANWEPKEYID:
					returnValue = apCfgSetValue(wlanTokens[essidIndex-1].DefaultKeyId, (T_INT32 *) var_val);
					break;
				case ENTWLANWEPKEY1VALUE:
					returnValue = apCfgSetValue(wlanTokens[essidIndex-1].Key[0].KeyStr, (T_CHAR*) var_val);
					break;
				case ENTWLANWEPKEY2VALUE:
					returnValue = apCfgSetValue(wlanTokens[essidIndex-1].Key[1].KeyStr, (T_CHAR*) var_val);
					break;
				case ENTWLANWEPKEY3VALUE:
					returnValue = apCfgSetValue(wlanTokens[essidIndex-1].Key[2].KeyStr, (T_CHAR*) var_val);
					break;
				case ENTWLANWEPKEY4VALUE:
					returnValue = apCfgSetValue(wlanTokens[essidIndex-1].Key[3].KeyStr, (T_CHAR*) var_val);
					break;
				}
			}
#if FOR_EG_EOR7550
			else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
#else
			else if(op_mode == SYS_OPM_WDSB)
#endif
			{
				switch(var)
				{
				case ENTWLANWEPKEYID:
					returnValue = apCfgSetValue(WLAN_WDS_KEYID_TOK, (T_INT32 *) var_val);
					break;
				case ENTWLANWEPKEY1VALUE:
					returnValue = apCfgSetValue(WLAN_WDS_WEPKEY_0_TOK, (T_CHAR*) var_val);
					break;
				case ENTWLANWEPKEY2VALUE:
					returnValue = apCfgSetValue(WLAN_WDS_WEPKEY_1_TOK, (T_CHAR*) var_val);
					break;
				case ENTWLANWEPKEY3VALUE:
					returnValue = apCfgSetValue(WLAN_WDS_WEPKEY_2_TOK, (T_CHAR*) var_val);
					break;
				case ENTWLANWEPKEY4VALUE:
					returnValue = apCfgSetValue(WLAN_WDS_WEPKEY_3_TOK, (T_CHAR*) var_val);
					break;
				}
			}

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			set_entWlanWepInfoTable(essidIndex, var, var_val);
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                
            }
            break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}
/*
 * var_entWlanWPAInfoTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_entWlan above.
 */
unsigned char *
var_entWlanWPAInfoTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
    /* variables we may use later */
	static oid index;
	T_CHAR tokBuf[30];
    static int intValue;
	static int enc;
	static int wlan_enable;

	/* 
   * This assumes that the table is a 'simple' table.
   *	See the implementation documentation for the meaning of this.
   *	You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *	you will need to provide the replacement code yourself.
   *	Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
    if (header_simple_table(vp,name,length,exact,var_len,write_method, WLAN_SSID_NUM) == MATCH_FAILED )
		return NULL;

	index = name[*length - 1];

#if FOR_EG_EOR7550
	apCfgGetValue(RADIO_2_OP_MODE_TOK, &op_mode);
	if(op_mode == RADIO_OPM_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
	{
		if(index > 1)
		{
			return NULL;
		}
	}
	else
	{
		return NULL;
	}
#else
	/*Only AP or AP router support MultiSSID*/
	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
	if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else if(op_mode == SYS_OPM_WDSB)
	{
		if(index > 1)
		{
			return NULL;
		}
	}
	else
	{
		return NULL;
	}
#endif

	/*Check whether wlan is enabled*/
    apCfgGetValue(wlanTokens[index-1].isEnable, &wlan_enable);
	if(!wlan_enable)
		return NULL;
    /* 
   * this is where we do the value assignments for the mib results.
   */
    switch(vp->magic) {
    case ENTWLANESSIDINDEX:
        return (u_char*) &index;
	case ENTPRESHAREDKEY:
		*write_method = write_entWlanWPAInfoTable;
		break;
    default:
      	ERROR_MSG("");
    }
    return NULL;
}

void set_entWlanWPAInfoTable(int essidIndex, int var, u_char *var_val)
{
	switch(var)
	{
	case ENTPRESHAREDKEY:
		SYSTEM("iwpriv "WLAN_DEV"%d set WPAPSK=%s",essidIndex-1, var_val);
		break;
	}
}

int
write_entWlanWPAInfoTable(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    oid var;
    T_INT32 intValue;
    int returnValue;
	oid essidIndex;

	essidIndex = name[name_len-1];
    var = name[name_len-2];
    returnValue = TRUE;

#if FOR_EG_EOR7550
	apCfgGetValue(RADIO_2_OP_MODE_TOK, &op_mode);
#else
	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
#endif

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
			case ENTPRESHAREDKEY:
				if (var_val_type != ASN_OCTET_STR)
					return SNMP_ERR_WRONGTYPE;
				returnValue = apCfgTestValue(TYPE_WPA_PASSPHRASE, (T_CHAR *)var_val);   
				break;

            }
			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;		
	case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
#if FOR_EG_EOR7550
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
#else
			if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
#endif
			{
				switch(var)
				{
				case ENTPRESHAREDKEY:
					returnValue = apCfgSetValue(wlanTokens[essidIndex-1].WpaPsk, (T_CHAR *) var_val);
					break;
				}
			}
#if FOR_EG_EOR7550
			else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
#else
			else if(op_mode == SYS_OPM_WDSB)
#endif
			{
				switch(var)
				{
				case ENTPRESHAREDKEY:
					returnValue = apCfgSetValue(WLAN_WDS_WPAPASSPHRASE_TOK, (T_CHAR *) var_val);
					break;
				}
			}

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			set_entWlanWPAInfoTable(essidIndex, var, var_val);
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                
            }
            break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}

/*
 * var_ent802dot1xInfoTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_entWlan above.
 */
unsigned char *
var_ent802dot1xInfoTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
    /* variables we may use later */
	static oid index;
    static int intValue;
    static T_IPADDR ipValue;
	static int isIeee802dot1xEnable;
	static int wlan_enable;

	/* 
   * This assumes that the table is a 'simple' table.
   *	See the implementation documentation for the meaning of this.
   *	You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *	you will need to provide the replacement code yourself.
   *	Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
    if (header_simple_table(vp,name,length,exact,var_len,write_method, WLAN_SSID_NUM) == MATCH_FAILED )
		return NULL;

	index = name[*length - 1];

#if FOR_EG_EOR7550
	/*Only run 802.1x in AP mode. For CB or CR, Use AP profile for 802.1x*/
	apCfgGetValue(RADIO_2_OP_MODE_TOK, &op_mode);
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else
	{
		return NULL;
	}
#else
	/*Only AP or AP router support MultiSSID*/
	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
	if(op_mode == SYS_OPM_AR || op_mode == SYS_OPM_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else
	{
		return NULL;
	}
#endif

	/*Check whether wlan is enabled*/
    apCfgGetValue(wlanTokens[index-1].isEnable, &wlan_enable);
	if(!wlan_enable)
		return NULL;
    /* 
   * this is where we do the value assignments for the mib results.
   */
    switch(vp->magic) {		
    case ENTWLANESSIDINDEX:
        return (u_char*) &index;
	case ENTRADIUSSERVERIPADDRESS:
		apCfgGetValue(wlanTokens[index-1].ieee8021x[0].IP, &ipValue);          
		ipValue = htonl(ipValue);            
		*var_len = sizeof(ipValue);
		*write_method = write_ent802dot1xInfoTable;
		return (u_char*)&ipValue;
	case ENTRADIUSSERVERPORT:
		apCfgGetValue(wlanTokens[index-1].ieee8021x[0].Port, &intValue);
		*var_len = sizeof(intValue);
		*write_method = write_ent802dot1xInfoTable;
		return (u_char*) &intValue;
	case ENTRADIUSSERVERPASSWORD:
		*write_method = write_ent802dot1xInfoTable;
		return NULL;
	case ENTWLAN802DOT1XENABLE:
		apCfgGetValue(wlanTokens[index-1].ieee8021x[0].Enable, &intValue);
		 if(intValue!=TV_TRUE)
		 {
			 intValue = TV_FALSE;
		 }
		*var_len = sizeof(intValue);
		*write_method = write_ent802dot1xInfoTable;
		return (u_char*) &intValue;
    default:
      	ERROR_MSG("");
    }
    return NULL;
}


void set_ent802dot1xInfoTable(int essidIndex, int var, u_char *var_val)
{
	int enc;
	int auth;
	int intValue;

	intValue = *(T_INT32 *) var_val;

	switch(var)
	{
	case ENTRADIUSSERVERIPADDRESS:
		//SYSTEM("iwpriv "WLAN_DEV"%d set RADIUS_Server=%s",essidIndex-1, var_val);
		//break;
	case ENTRADIUSSERVERPORT:
		//SYSTEM("iwpriv "WLAN_DEV"%d set RADIUS_Port=%s",essidIndex-1, intValue);
		//break;
	case ENTRADIUSSERVERPASSWORD:
		//SYSTEM("iwpriv "WLAN_DEV"%d set RADIUS_Key=%s",essidIndex-1, var_val);
		break;
	case ENTWLAN802DOT1XENABLE:
		apCfgGetValue(wlanTokens[essidIndex-1].EncrypType, &enc);
		apCfgGetValue(wlanTokens[essidIndex-1].AuthMode, &auth);
		if(intValue != TV_TRUE)
		{
			intValue = 0;
		}
		if(enc == WLAN_ENC_NONE || enc == WLAN_ENC_WEP)
		{
			SYSTEM("iwpriv "WLAN_DEV"%d set IEEE8021X=%d",essidIndex-1, intValue);
		}
		else
		{
			SYSTEM("iwpriv "WLAN_DEV"%d set IEEE8021X=0",essidIndex-1);
		}
		break;
	}
}

int
write_ent802dot1xInfoTable(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    oid var;
    T_INT32 intValue;
    int returnValue;
	int essidIndex;
    T_IPADDR ipOutput;
    static T_IPADDR oldIPValue;

	essidIndex = name[name_len-1];
    var = name[name_len-2];
    returnValue = TRUE;

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
			case ENTPRESHAREDKEY:
				CHECK_IPADDRESS();  
				break;
			case ENTRADIUSSERVERPORT:
				CHECK_INT(1, 65535);
				break;
			case ENTRADIUSSERVERPASSWORD:
				if (var_val_type != ASN_OCTET_STR)
					return SNMP_ERR_WRONGTYPE;
				returnValue = apCfgTestValue(TYPE_STR, (T_CHAR *)var_val);
				break;
			case ENTWLAN802DOT1XENABLE:
				CHECK_INT(TV_TRUE,TV_FALSE);
				break;
            }
			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
            switch(var)
            {
			case ENTRADIUSSERVERIPADDRESS:
				apCfgGetValue(wlanTokens[essidIndex-1].ieee8021x[0].IP, &oldIPValue);
				ipOutput = ntohl(*(u_long*)var_val);
				returnValue = apCfgSetValue(wlanTokens[essidIndex-1].ieee8021x[0].IP,&ipOutput);
				break;
			case ENTRADIUSSERVERPORT:
				returnValue = apCfgSetValue(wlanTokens[essidIndex-1].ieee8021x[0].Port,(T_INT32 *) var_val);
				break;
			case ENTRADIUSSERVERPASSWORD:
				returnValue = apCfgSetValue(wlanTokens[essidIndex-1].ieee8021x[0].Password,(T_CHAR *) var_val);
				break;
			case ENTWLAN802DOT1XENABLE:
				intValue = *(T_INT32 *) var_val;
				if(intValue != TV_TRUE)
				{
					intValue = 0;
				}
				returnValue = apCfgSetIntValue(wlanTokens[essidIndex-1].ieee8021x[0].Enable,intValue);
				break;
            }

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			set_ent802dot1xInfoTable(essidIndex, var, var_val);
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                case ENTRADIUSSERVERIPADDRESS:
                    apCfgSetValue(wlanTokens[essidIndex-1].ieee8021x[0].IP, &oldIPValue);
					break;
            }
            break;

		case COMMIT:
			switch(var)
			{
			case ENTRADIUSSERVERIPADDRESS:
			case ENTRADIUSSERVERPORT:
			case ENTRADIUSSERVERPASSWORD:
				SYSTEM("sysconf_cli applychanges checkAllModules &");
				break;
			}
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}
