/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.old-api.conf 14476 2006-04-18 17:36:51Z hardaker $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "entWAN.h"
#include "entOid.h"

#include <sap_ostypes.h>
#include <tokens.h>
#include <apcfg.h>
#include <apcfg_nsr9750.h>
#include <gconfig.h>
#include <systeminfo.h>
#include "Utils.h"
/* 
 * entLAN_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */

oid entWAN_variables_oid[] = { ENTERPRISE_SENAO_PRODUCT_OID,3 };

/* 
 * variable4 entLAN_variables:
 *   this variable defines function callbacks and type return information 
 *   for the entLAN mib section 
 */

struct variable1 entWAN_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#define ENTROUTERENABLE		1
{ENTROUTERENABLE,  ASN_INTEGER,  RWRITE,  var_entWAN, 1,  { 1 }},

};
/*    (L = length of the oidsuffix) */


/** Initializes the entLAN module */
void
init_entWAN(void)
{

    DEBUGMSGTL(("entWAN", "Initializing\n"));

    /* register ourselves with the agent to handle our mib tree */
    REGISTER_MIB("entWAN", entWAN_variables, variable1,
               entWAN_variables_oid);

    /* place any other initialization junk you need here */
}

/*
 * var_entLAN():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_entWAN(struct variable *vp, 
                oid     *name, 
                size_t  *length, 
                int     exact, 
                size_t  *var_len, 
                WriteMethod **write_method)
{
    //static unsigned char string[MAX_STR_LEN];
    //int ifIndex;
    static int iValue;
	static int op_mode;

    if (header_generic(vp, name, length, exact, var_len, write_method) == MATCH_FAILED)
        return NULL;
    //ifIndex = name[*length-1];

	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
	if(op_mode==SYS_OPM_APRP || op_mode==SYS_OPM_WDSB)
	{
		switch(vp->magic)
		{
		case ENTROUTERENABLE:
			return NULL;
		}
	}

    switch(vp->magic)
    {     
		case ENTROUTERENABLE:
             apCfgGetValue(SYS_ROUTE_ENABLE_TOK, &iValue);
			 if(iValue!=TV_TRUE)
			 {
				 iValue = TV_FALSE;
			 }
             *var_len = sizeof(iValue);
             *write_method = write_entWAN;
             return (u_char*) &iValue;                    
        default:
			ERROR_MSG("");
    }
    return NULL;   
}


int write_entWAN(int action,
                        u_char * var_val,
                        u_char var_val_type,
                        size_t var_val_len,
                        u_char * statP, oid * name, size_t name_len)
{
    int var;
	int returnValue;
    T_INT32 intValue;
	int sys_mode;
	static int original_route_enable;

    var = name[name_len-2];
    returnValue = TRUE;

     switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         *  Candice 09/24/2003
         */
            switch(var)
            {
                case ENTROUTERENABLE:
					CHECK_INT(TV_TRUE,TV_FALSE);
                    break;
                
            }
            if(returnValue == FALSE)
            {
                return SNMP_ERR_WRONGVALUE;
            }
            break;
		case ACTION:
		 	intValue = *(T_INT32 *) var_val;
            switch(var)
            {
			case ENTROUTERENABLE:
				apCfgGetValue(SYS_OP_MODE_TOK, &sys_mode);
				apCfgGetValue(SYS_ROUTE_ENABLE_TOK, &original_route_enable);
				if(sys_mode == SYS_OPM_WDSB || sys_mode == SYS_OPM_APRP)
				{
					return SNMP_ERR_NOTWRITABLE;
				}
				if(intValue != TV_TRUE)
				{
					intValue = 0;
				}
				returnValue = apCfgSetIntValue(SYS_ROUTE_ENABLE_TOK,intValue);
				if(returnValue == TRUE)
				{
					setSysOperationModeInfo(sys_mode);
				}
				break;
            }
            if(returnValue == FALSE)
            {
				return SNMP_ERR_WRONGVALUE;
            }
			apCfgUpdateModifiedData();
            break;

        case UNDO:
            switch(var)
            {

            }
            break;
		case COMMIT:
			switch(var)
			{
			case ENTROUTERENABLE:
				intValue = *(T_INT32 *) var_val;
				if(intValue != TV_TRUE)
				{
					intValue = 0;
				}
				/*If value is not changed, will not reboot*/
				if(intValue != original_route_enable)
				{
					SYSTEM("sysconf_cli reboot &");
				}
				break;
			}
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;


    }
    return SNMP_ERR_NOERROR;
    
} 


