/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.old-api.conf 14476 2006-04-18 17:36:51Z hardaker $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "entSystem.h"
#include "entOid.h"

#include <gconfig.h>
#include <sysUtilMisc.h>
#include <sysFile.h>
#include <syscore.h>
#include <appsver.h>
#include <tokens.h>
#include <apcfg.h>
#include "Utils.h"

#define KNLAPPVER_FILE   "/var/knlappver.txt"
#define SYS_STRING_LEN	256
//#define ENABLE_ADMINIDLETIMEOUT

/* 
 * entSystem_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */

oid entSystem_variables_oid[] = { ENTERPRISE_SENAO_PRODUCT_OID,1 };

/* 
 * variable4 entSystem_variables:
 *   this variable defines function callbacks and type return information 
 *   for the entSystem mib section 
 */

struct variable1 entSystem_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#ifdef ENABLE_ADMINIDLETIMEOUT
#define ENTADMINIDLETIMEOUT		1
{ENTADMINIDLETIMEOUT,  ASN_INTEGER,  RWRITE,  var_entSystem, 1,  { 1 }},
#endif
#define ENTPASSWORD		2
{ENTPASSWORD,  ASN_OCTET_STR,  RWRITE,  var_entSystem, 1,  { 2 }},
#define ENTSYSMODEL		3
{ENTSYSMODEL,  ASN_OCTET_STR,  RONLY ,  var_entSystem, 1,  { 3 }},
#define ENTSYSOPMODE		4
{ENTSYSOPMODE,  ASN_INTEGER,  RONLY ,  var_entSystem, 1,  { 4 }},
#define ENTSYSUPTIME		5
{ENTSYSUPTIME,  ASN_TIMETICKS,  RONLY ,  var_entSystem, 1,  { 5 }},
#define ENTHWVERSION		6
{ENTHWVERSION,  ASN_OCTET_STR,  RONLY ,  var_entSystem, 1,  { 6 }},
#define ENTSN		7
{ENTSN,  ASN_OCTET_STR,  RONLY ,  var_entSystem, 1,  { 7 }},
#define ENTKENELVERSION		8
{ENTKENELVERSION,  ASN_OCTET_STR,  RONLY ,  var_entSystem, 1,  { 8 }},
#define ENTAPPVERSION		9
{ENTAPPVERSION,  ASN_OCTET_STR,  RONLY ,  var_entSystem, 1,  { 9 }},
#define ENTRESET		10
{ENTRESET,  ASN_INTEGER,  RWRITE,  var_entSystem, 1,  { 10 }},
#define ENTRESETTODEFAULT		11
{ENTRESETTODEFAULT,  ASN_INTEGER,  RWRITE,  var_entSystem, 1,  { 11 }},
#define ENTAPPLYMODULES		12
{ENTAPPLYMODULES,  ASN_INTEGER,  RWRITE,  var_entSystem, 1,  { 12 }},

};
/*    (L = length of the oidsuffix) */


/** Initializes the entSystem module */
void
init_entSystem(void)
{

    DEBUGMSGTL(("entSystem", "Initializing\n"));

    /* register ourselves with the agent to handle our mib tree */
    REGISTER_MIB("entSystem", entSystem_variables, variable1,
               entSystem_variables_oid);

    /* place any other initialization junk you need here */
}

/*
 * var_entSystem():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_entSystem(struct variable *vp, 
                oid     *name, 
                size_t  *length, 
                int     exact, 
                size_t  *var_len, 
                WriteMethod **write_method)
{
    /* variables we may use later */
    static T_CHAR str[SYS_STRING_LEN];
	static u_long ulong_ret;

    if (header_generic(vp,name,length,exact,var_len,write_method) == MATCH_FAILED )
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */
	memset(str, 0, sizeof(str));

    switch(vp->magic) {
#ifdef ENABLE_ADMINIDLETIMEOUT
	case ENTADMINIDLETIMEOUT:
		ulong_ret = apCfgGetIntValue(HTTP_REMOTE_IDLETIME_TOK);
        *write_method = write_entSystem;
        return (u_char*) &ulong_ret;
#endif
	case ENTPASSWORD:
		*write_method = write_entSystem;
        return NULL;
    case ENTSYSMODEL:
        strcpy(str, VENDOR_MODE);
		*var_len = strlen(str);
        return (u_char*) str;
	case ENTSYSOPMODE:
		ulong_ret = apCfgGetIntValue(SYS_OP_MODE_TOK);
        return (u_char*) &ulong_ret;
	case ENTSYSUPTIME:
		ulong_ret = get_uptime();
        return ((u_char *) & ulong_ret);
    case ENTHWVERSION:
        strcpy(str, getHwVer());
		*var_len = strlen(str);
        return (u_char*) str;
    case ENTSN:
		strcpy(str, apCfgGetStrValue(SYS_SN_TOK));
		*var_len = strlen(str);
        return (u_char*) str;
    case ENTKENELVERSION:
		{
			FILE *fp;
			char buf[30];
			int firstByte = 0,secondByte = 0,thirdByte = 0;
			if (!sysIsFileExisted(KNLAPPVER_FILE))
			{
				printf("Err: %s: %s does not exist!\n", __FUNCTION__, KNLAPPVER_FILE); 
			}
			else
			{
				fp = fopen(KNLAPPVER_FILE, "r");
				while(fgets(buf, sizeof(buf), fp) != NULL) 
				{
					sscanf(buf,"%d.%d.%d",&firstByte,&secondByte,&thirdByte);
				}
				fclose(fp); 
			}
			sprintf(str,"%d.%d.%d",firstByte,secondByte,thirdByte);//get it from cat /var/knlappver.txt
		}
		*var_len = strlen(str);
        return (u_char*) str;
    case ENTAPPVERSION:
        strcpy(str, APPS_CODE_VERSION__);
		*var_len = strlen(str);
        return (u_char*) str;
    case ENTRESET:
        *write_method = write_entSystem;
        return NULL;
    case ENTRESETTODEFAULT:
        *write_method = write_entSystem;
        return NULL;
    case ENTAPPLYMODULES:
        *write_method = write_entSystem;
        return NULL;
    default:
      ERROR_MSG("");
    }
    return NULL;
}

int write_entSystem(int action,
                        u_char * var_val,
                        u_char var_val_type,
                        size_t var_val_len,
                        u_char * statP, oid * name, size_t name_len)
{

    oid var;
    T_INT32 intValue;
	int returnValue;
    
    var = name[name_len-2];
    returnValue = TRUE;

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
#ifdef ENABLE_ADMINIDLETIMEOUT
                case ENTADMINIDLETIMEOUT:
                    CHECK_INT(1,1000);
                    break;
#endif
                case ENTPASSWORD:
					CHECK_STR(12);
                    break;
                case ENTRESET:
                case ENTRESETTODEFAULT:
				case ENTAPPLYMODULES:
                    CHECK_INT(1,2);
                    break;
            }
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
			intValue = *(T_INT32 *) var_val;
            switch(var)
            {
#ifdef ENABLE_ADMINIDLETIMEOUT
				case ENTADMINIDLETIMEOUT:
					returnValue = apCfgSetIntValue(HTTP_REMOTE_IDLETIME_TOK, intValue);
					if(returnValue==FALSE)
					{
						return SNMP_ERR_WRONGVALUE;
					}
					apCfgUpdateModifiedData();
                    break;
#endif
				case ENTPASSWORD:
					returnValue = apCfgSetValue(HTTP_REMOTE_PW_TOK, (T_CHAR *) var_val);
					if(returnValue==FALSE)
					{
						return SNMP_ERR_WRONGVALUE;
					}
					apCfgUpdateModifiedData();
                    break;
				case ENTRESET:
					if(intValue==1)
						SYSTEM("sysconf_cli reboot &");
                    break;
				case ENTRESETTODEFAULT:
					if(intValue==1)
						SYSTEM("sysconf_cli restore2def &");
					break;
				case ENTAPPLYMODULES:
					if(intValue==1)
						SYSTEM("sysconf_cli applychanges checkAllModules &");
					break;
            }
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                
            }
            break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}

