/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.old-api.conf 14476 2006-04-18 17:36:51Z hardaker $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "entSNMP.h"
#include "entOid.h"

#include <tokens.h>
#include <apcfg.h>
#include <apcfg_nsr9750.h>
#include "Utils.h"

#define MAX_COMMUNITY_NAME_LEN	32
#define SNMP_TABLE_SIZE			2


#define ENTSNMPSTATUS		1
#define ENTSNMPVERTYPE		2

#define ENTSNMPCOMMUNITYINDEX		1
#define ENTSNMPCOMMUNITYNAME		2
#define ENTSNMPCOMMUNITYTYPE		3
#define ENTSNMPCOMMUNITYVALID		4

#define ENTTRAPSTATUS					1
#define ENTTRAPVER						2
#define ENTTRAPRECEIVERIPADDRESS		3
#define ENTTRAPRECEIVERCOMMUNITYNAME	4
/* 
 * entSNMP_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */

oid entSNMP_variables_oid[] = { ENTERPRISE_SENAO_PRODUCT_OID,6 };

/* 
 * variable1 entSNMP_variables:
 *   this variable defines function callbacks and type return information 
 *   for the entSNMP mib section 
 */

struct variable3 entSNMP_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
{ENTSNMPSTATUS,  ASN_INTEGER,  RWRITE,  var_entSNMP, 1,  { 1 }},
{ENTSNMPVERTYPE,  ASN_INTEGER,  RWRITE,  var_entSNMP, 1,  { 2 }},

{ENTSNMPCOMMUNITYINDEX,  ASN_INTEGER,  RONLY,   var_entSNMPCommunityTable, 3,  { 3, 1, 1 }},
{ENTSNMPCOMMUNITYNAME,  ASN_OCTET_STR,  RWRITE,  var_entSNMPCommunityTable, 3,  { 3, 1, 2 }},
{ENTSNMPCOMMUNITYTYPE,  ASN_INTEGER,  RONLY,  var_entSNMPCommunityTable, 3,  { 3, 1, 3 }},
{ENTSNMPCOMMUNITYVALID,  ASN_INTEGER,  RONLY,  var_entSNMPCommunityTable, 3,  { 3, 1, 4 }},
#if HAS_SNMP_TRAP_SUPPORT
{ENTTRAPSTATUS,  ASN_INTEGER,  RWRITE,  var_entSNMPTrap, 2,  { 4,1 }},
{ENTTRAPVER,  ASN_INTEGER,  RWRITE,  var_entSNMPTrap, 2,  { 4,2 }},
{ENTTRAPRECEIVERIPADDRESS,  ASN_IPADDRESS,  RWRITE,  var_entSNMPTrap, 2,  { 4,3 }},
{ENTTRAPRECEIVERCOMMUNITYNAME,  ASN_OCTET_STR,  RWRITE,  var_entSNMPTrap, 2,  { 4,4 }},
#endif
};
/*    (L = length of the oidsuffix) */


/** Initializes the entSNMP module */
void
init_entSNMP(void)
{

    DEBUGMSGTL(("entSNMP", "Initializing\n"));

    /* register ourselves with the agent to handle our mib tree */
    REGISTER_MIB("entSNMP", entSNMP_variables, variable3,
               entSNMP_variables_oid);

	
    /* place any other initialization junk you need here */
}

/*
 * var_entSNMP():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_entSNMP(struct variable *vp, 
                oid     *name, 
                size_t  *length, 
                int     exact, 
                size_t  *var_len, 
                WriteMethod **write_method)
{
    /* variables we may use later */
    static long long_ret;

    if (header_generic(vp,name,length,exact,var_len,write_method) == MATCH_FAILED )
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */
    switch(vp->magic) {
    case ENTSNMPSTATUS:
        *write_method = write_entSNMP;
        long_ret = apCfgGetIntValue(SNMPD_ENABLE_TOK);
		 if(long_ret!=TV_TRUE)
		 {
			 long_ret = TV_FALSE;
		 }
        *var_len = sizeof(long_ret);
        return (u_char*) &long_ret;
    case ENTSNMPVERTYPE:
        *write_method = write_entSNMP;
        long_ret = apCfgGetIntValue(SNMPD_COMMUNITY_VER_1_TOK);
		*var_len = sizeof(long_ret);
        return (u_char*) &long_ret;
    default:
      ERROR_MSG("");
    }
    return NULL;
}

/*
 * var_entSNMPCommunityTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_entSNMP above.
 */
unsigned char *
var_entSNMPCommunityTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
	oid currentClient;
	T_CHAR communityNameTokenBuf[MAX_COMMUNITY_NAME_LEN];
	static T_CHAR communityName[MAX_COMMUNITY_NAME_LEN+1];
	static int communityType=1;
	static int communityValid=1;
	static long communityIndex;

	/* 
   * This assumes that the table is a 'simple' table.
   *	See the implementation documentation for the meaning of this.
   *	You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *	you will need to provide the replacement code yourself.
   *	Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
    if (header_simple_table(vp,name,length,exact,var_len,write_method, SNMP_TABLE_SIZE) == MATCH_FAILED )
		return NULL;


	currentClient = name[*length - 1];


	if(currentClient > SNMP_TABLE_SIZE)
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */

    switch(vp->magic) {
	case ENTSNMPCOMMUNITYINDEX:
		communityIndex = currentClient;
		*var_len = sizeof(communityIndex);
        return (u_char*) &communityIndex;
    case ENTSNMPCOMMUNITYNAME:
        *write_method = write_entSNMPCommunityTable;
		sprintf(communityNameTokenBuf, SNMPD_COMMUNITY_COMMUNITY_TOK "%d", currentClient);
		strncpy(communityName, apCfgGetStrValue(communityNameTokenBuf), MAX_COMMUNITY_NAME_LEN+1);
        *var_len = strlen(communityName);
        return (u_char*) &communityName;
    case ENTSNMPCOMMUNITYTYPE:
		if(currentClient == 1)  /*RW Community*/
		{
			communityType = 2;
		}
		else /*RO Community*/
		{
			communityType = 1;
		}
		*var_len = sizeof(communityType);
        return (u_char*) &communityType;
	case ENTSNMPCOMMUNITYVALID:
		 if(communityValid!=TV_TRUE)
		 {
			 communityValid = TV_FALSE;
		 }
		*var_len = sizeof(communityValid);
        return (u_char*) &communityValid;
    default:
      ERROR_MSG("");
    }
    return NULL;
}

/*
 * var_entSNMPTrap():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
#if HAS_SNMP_TRAP_SUPPORT
unsigned char *
var_entSNMPTrap(struct variable *vp, 
                oid     *name, 
                size_t  *length, 
                int     exact, 
                size_t  *var_len, 
                WriteMethod **write_method)
{
    /* variables we may use later */
	static int iValue;
    static T_IPADDR ipValue;
	static T_CHAR trapCommunityName[MAX_COMMUNITY_NAME_LEN+1];

    if (header_generic(vp,name,length,exact,var_len,write_method) == MATCH_FAILED )
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */

    switch(vp->magic) {
    case ENTTRAPSTATUS:
        *write_method = write_entSNMPTrap;
        iValue = apCfgGetIntValue(SNMPD_TRAP_ENABLE_TOK);
		 if(iValue!=TV_TRUE)
		 {
			 iValue = TV_FALSE;
		 }
		*var_len = sizeof(iValue);
        return (u_char*) &iValue;
    case ENTTRAPVER:
        *write_method = write_entSNMPTrap;
        iValue = apCfgGetIntValue(SNMPD_TRAP_VER_1_TOK);
		*var_len = sizeof(iValue);
        return (u_char*) &iValue;
    case ENTTRAPRECEIVERIPADDRESS:
        *write_method = write_entSNMPTrap;
		apCfgGetValue(SNMPD_TRAP_IP_1_TOK, &ipValue);
		ipValue = htonl(ipValue);
        *var_len = sizeof(ipValue);
        return (u_char*) &ipValue;
    case ENTTRAPRECEIVERCOMMUNITYNAME:
        *write_method = write_entSNMPTrap;
		strncpy(trapCommunityName, apCfgGetStrValue(SNMPD_TRAP_COMMUNITY_1_TOK), MAX_COMMUNITY_NAME_LEN+1);
		*var_len = strlen(trapCommunityName);
		return (u_char*) &trapCommunityName;
    default:
      ERROR_MSG("");
    }
    return NULL;
}
#endif

int write_entSNMP(int action,
                        u_char * var_val,
                        u_char var_val_type,
                        size_t var_val_len,
                        u_char * statP, oid * name, size_t name_len)
{

    oid var;
    T_INT32 intValue;
    int returnValue;
    
    var = name[name_len-2];
    returnValue = TRUE;

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
				case ENTSNMPSTATUS:
					CHECK_INT(TV_TRUE,TV_FALSE);
					break;
				case ENTSNMPVERTYPE:
                    CHECK_INT(0,3);
                    break;
            }
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
			intValue = *(T_INT32 *) var_val;
            switch(var)
            {
				case ENTSNMPSTATUS:
					if(intValue != TV_TRUE)
					{
						intValue = 0;
					}
					returnValue = apCfgSetIntValue(SNMPD_ENABLE_TOK, intValue);
                    break;
				case ENTSNMPVERTYPE:
					returnValue = apCfgSetIntValue(SNMPD_COMMUNITY_VER_1_TOK, intValue);
                    break;
            }

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                
            }
            break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}

int write_entSNMPCommunityTable(int action,
                        u_char * var_val,
                        u_char var_val_type,
                        size_t var_val_len,
                        u_char * statP, oid * name, size_t name_len)
{

	T_CHAR communityNameTokenBuf[MAX_COMMUNITY_NAME_LEN];
	oid communityIndex;
	int returnValue;
	oid var;

	communityIndex = name[name_len-1];
    var = name[name_len-2];
    returnValue = TRUE;

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
				case ENTSNMPCOMMUNITYNAME:
					CHECK_STR(MAX_COMMUNITY_NAME_LEN);
                    returnValue = apCfgTestValue(TYPE_STR, (T_CHAR*)var_val);
                    break;      
            }
            if(returnValue == FALSE)
            {
                return SNMP_ERR_WRONGVALUE;
            }
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
            switch(var)
            {
                case ENTSNMPCOMMUNITYNAME:
                    sprintf(communityNameTokenBuf, SNMPD_COMMUNITY_COMMUNITY_TOK "%d",communityIndex);
                    returnValue = apCfgSetValue(communityNameTokenBuf, (T_CHAR*)var_val);
                    break;
            }
            if(returnValue == FALSE)
            {
                return SNMP_ERR_WRONGVALUE;
            }
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                
            }
            break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}

#if HAS_SNMP_TRAP_SUPPORT
int write_entSNMPTrap(int action,
                        u_char * var_val,
                        u_char var_val_type,
                        size_t var_val_len,
                        u_char * statP, oid * name, size_t name_len)
{

    oid var;
    T_INT32 intValue;
	int returnValue;
    T_IPADDR ipOutput;
    T_IPADDR oldIPValue;

    var = name[name_len-2];
    returnValue = TRUE;

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
				case ENTTRAPSTATUS:
					CHECK_INT(TV_TRUE,TV_FALSE);
					break;
				case ENTTRAPVER:
                    CHECK_INT(0,3);
                    break;
				case ENTTRAPRECEIVERIPADDRESS:
					CHECK_IPADDRESS();
					break;
				case ENTTRAPRECEIVERCOMMUNITYNAME:
					CHECK_STR(MAX_COMMUNITY_NAME_LEN);
                    returnValue = apCfgTestValue(TYPE_STR, (T_CHAR*)var_val);
					break;
            }
			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
            switch(var)
            {
				case ENTSNMPSTATUS:
					intValue = *(T_INT32 *) var_val;
					if(intValue != TV_TRUE)
					{
						intValue = 0;
					}
					returnValue = apCfgSetIntValue(SNMPD_TRAP_ENABLE_TOK, intValue);
                    break;
				case ENTSNMPVERTYPE:
					returnValue = apCfgSetValue(SNMPD_TRAP_VER_1_TOK, (T_INT32 *) var_val);
                    break;
				case ENTTRAPRECEIVERIPADDRESS:
					apCfgGetValue(LAN_IPADDR_TOK, &oldIPValue);
                    ipOutput = ntohl(*(u_long*)var_val);
                    returnValue = apCfgSetValue(SNMPD_TRAP_IP_1_TOK,&ipOutput);
                    break;
				case ENTTRAPRECEIVERCOMMUNITYNAME:
					returnValue = apCfgSetValue(SNMPD_TRAP_COMMUNITY_1_TOK, (T_CHAR*)var_val);
					break;
            }

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                case ENTTRAPRECEIVERIPADDRESS:
                    apCfgSetValue(SNMPD_TRAP_VER_1_TOK, &oldIPValue);
					break;
            }
            break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}
#endif

