/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.old-api.conf 14476 2006-04-18 17:36:51Z hardaker $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "entMacFilter.h"
#include "entOid.h"

#include <tokens.h>
#include <apcfg.h>
#include <apcfg_nsr9750.h>
#include <filter.h>
#include "Utils.h"

/* 
 * entMacFilter_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */

oid entMacFilter_variables_oid[] = { ENTERPRISE_SENAO_PRODUCT_OID,4 };

/* 
 * variable4 entMacFilter_variables:
 *   this variable defines function callbacks and type return information 
 *   for the entMacFilter mib section 
 */

struct variable3 entMacFilter_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#define ENTLANMACFILTERINGENABLE		1
{ENTLANMACFILTERINGENABLE,  ASN_INTEGER,  RWRITE,  var_entMacFilter, 1,  { 1 }},
#define ENTLANMACFILTERINGMODE		2
{ENTLANMACFILTERINGMODE,  ASN_INTEGER,  RWRITE,  var_entMacFilter, 1,  { 2 }},

#define ENTMACADDRESSINDEX		3
{ENTMACADDRESSINDEX,  ASN_INTEGER,  RONLY,   var_entLanMacFilterTable, 3,  { 3, 1, 1 }},
#define ENTMACADDRESS		4
{ENTMACADDRESS,  ASN_OCTET_STR,  RONLY,   var_entLanMacFilterTable, 3,  { 3, 1, 2 }},
#define ENTMACFILTERINGVALID		5
{ENTMACFILTERINGVALID,  ASN_INTEGER,  RONLY,   var_entLanMacFilterTable, 3,  { 3, 1, 3 }},
};
/*    (L = length of the oidsuffix) */


/** Initializes the entMacFilter module */
void
init_entMacFilter(void)
{

    DEBUGMSGTL(("entMacFilter", "Initializing\n"));

    /* register ourselves with the agent to handle our mib tree */
    REGISTER_MIB("entMacFilter", entMacFilter_variables, variable3,
               entMacFilter_variables_oid);

    /* place any other initialization junk you need here */
}

/*
 * var_entMacFilter():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_entMacFilter(struct variable *vp, 
                oid     *name, 
                size_t  *length, 
                int     exact, 
                size_t  *var_len, 
                WriteMethod **write_method)
{
    /* variables we may use later */
    static long long_ret;

    if (header_generic(vp,name,length,exact,var_len,write_method) == MATCH_FAILED )
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */
    switch(vp->magic) {
    case ENTLANMACFILTERINGENABLE:
        *write_method = write_entMacFilter;
        long_ret = apCfgGetIntValue(LANMACFILTER_ENABLE_TOK);
		if(long_ret!=TV_TRUE)
		{
			long_ret = TV_FALSE;
		}
		*var_len = sizeof(long_ret);
        return (u_char*) &long_ret;
    case ENTLANMACFILTERINGMODE:
        *write_method = write_entMacFilter;
        long_ret = apCfgGetIntValue(LANMACFILTER_MODE_TOK);
		*var_len = sizeof(long_ret);
        return (u_char*) &long_ret;
    default:
      ERROR_MSG("");
    }
    return NULL;
}

/*
 * var_entMacFilterTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_entMacFilter above.
 */
unsigned char *
var_entLanMacFilterTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
	oid index;
	macfiltering_t m;
	static int iValue;
	T_UINT8 macValue[MAX_MAC_ADDR_LEN_IN_BYTE];
	static T_CHAR macStr[18];

	/* 
   * This assumes that the table is a 'simple' table.
   *	See the implementation documentation for the meaning of this.
   *	You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *	you will need to provide the replacement code yourself.
   *	Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
    if (header_simple_table(vp,name,length,exact,var_len,write_method, NUM_LAN_MAC_FILTERS) == MATCH_FAILED )
		return NULL;


	index = name[*length - 1];


	if(index > NUM_LAN_MAC_FILTERS)
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */

	apCfgGetValue2(&m, LANMACFILTER_TOK "%d", index);

    switch(vp->magic) {
	case ENTMACADDRESSINDEX:
		iValue = m.uId;
        return (u_char*) &iValue;
    case ENTMACADDRESS:
		memcpy(macValue, m.mac, MAX_MAC_ADDR_LEN_IN_BYTE);
		sprintf(macStr, MAC_PATTERN_WITH_COLON,
            macValue[0]&0xff,macValue[1]&0xff,macValue[2]&0xff,
            macValue[3]&0xff,macValue[4]&0xff,macValue[5]&0xff);
        *var_len = strlen(macStr);
        return (u_char*) macStr;
    case ENTMACFILTERINGVALID:
		iValue = m.isEnable;
		if(iValue!=TV_TRUE)
		{
			iValue = TV_FALSE;
		}
		return (u_char*) &iValue;
    default:
      ERROR_MSG("");
    }
    return NULL;
}



int
write_entMacFilter(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    int var;
    T_INT32 intValue;
    int returnValue;
    
    var = name[name_len-2];
    returnValue = TRUE;

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
				case ENTLANMACFILTERINGENABLE:
					CHECK_INT(TV_TRUE,TV_FALSE);
					break;
				case ENTLANMACFILTERINGMODE:
                    CHECK_INT(0,1);
                    break;
            }
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
			intValue = *(T_INT32 *) var_val;
            switch(var)
            {
				case ENTLANMACFILTERINGENABLE:
					if(intValue != TV_TRUE)
					{
						intValue = 0;
					}
					returnValue = apCfgSetIntValue(LANMACFILTER_ENABLE_TOK, intValue);
                    break;
				case ENTLANMACFILTERINGMODE:
					returnValue = apCfgSetIntValue(LANMACFILTER_MODE_TOK, intValue);
                    break;
            }

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                
            }
            break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}


