/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.old-api.conf 14476 2006-04-18 17:36:51Z hardaker $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "entLAN.h"
#include "entOid.h"

#include <sap_ostypes.h>
#include <tokens.h>
#include <apcfg.h>
#include <apcfg_nsr9750.h>
#include <gconfig.h>
#include "Utils.h"
/* 
 * entLAN_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */

oid entLAN_variables_oid[] = { ENTERPRISE_SENAO_PRODUCT_OID,2 };

/* 
 * variable4 entLAN_variables:
 *   this variable defines function callbacks and type return information 
 *   for the entLAN mib section 
 */

struct variable1 entLAN_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#define ENTLANIP		1
{ENTLANIP,  ASN_IPADDRESS,  RWRITE,  var_entLAN, 1,  { 1 }},
#define ENTLANSUBNETMASK		2
{ENTLANSUBNETMASK,  ASN_IPADDRESS,  RWRITE,  var_entLAN, 1,  { 2 }},
#define ENTSTPENABLE		3
{ENTSTPENABLE,  ASN_INTEGER,  RWRITE,  var_entLAN, 1,  { 3 }},
#define ENTDHCPENABLE		4
{ENTDHCPENABLE,  ASN_INTEGER,  RWRITE,  var_entLAN, 1,  { 4 }},
#define ENTIPPOOLSTART		5
{ENTIPPOOLSTART,  ASN_IPADDRESS,  RWRITE,  var_entLAN, 1,  { 5 }},
#define ENTIPPOOLEND		6
{ENTIPPOOLEND,  ASN_IPADDRESS,  RWRITE,  var_entLAN, 1,  { 6 }},
#define ENTIPLEASETIME		7
{ENTIPLEASETIME,  ASN_INTEGER,  RWRITE,  var_entLAN, 1,  { 7 }},

};
/*    (L = length of the oidsuffix) */


/** Initializes the entLAN module */
void
init_entLAN(void)
{

    DEBUGMSGTL(("entLAN", "Initializing\n"));

    /* register ourselves with the agent to handle our mib tree */
    REGISTER_MIB("entLAN", entLAN_variables, variable1,
               entLAN_variables_oid);

    /* place any other initialization junk you need here */
}

/*
 * var_entLAN():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_entLAN(struct variable *vp, 
                oid     *name, 
                size_t  *length, 
                int     exact, 
                size_t  *var_len, 
                WriteMethod **write_method)
{
    //static unsigned char string[MAX_STR_LEN];
    //int ifIndex;
    static int iValue;
    static T_IPADDR ipValue;
	static int op_mode;

    if (header_generic(vp, name, length, exact, var_len, write_method) == MATCH_FAILED)
        return NULL;
    //ifIndex = name[*length-1];

	apCfgGetValue(SYS_OP_MODE_TOK, &op_mode);
	if(op_mode!=SYS_OPM_AR && op_mode!=SYS_OPM_CBRT
#if HAS_AP_DHCP_SERVER
	   && op_mode!=SYS_OPM_AP
#endif
#if HAS_OP_MODE_ARRP
	   && op_mode!=SYS_OPM_ARRP
#endif
#if FOR_EG_EOR7550
	   && op_mode!=SYS_OPM_WDSRRP
#endif
	   )
	{
		switch(vp->magic)
		{
		case ENTDHCPENABLE:
		case ENTIPPOOLSTART:
		case ENTIPPOOLEND:
		case ENTIPLEASETIME:
			return NULL;
		}
	}

    switch(vp->magic)
    {
        case ENTLANIP:
             apCfgGetValue(LAN_IPADDR_TOK, &ipValue);
             ipValue = htonl(ipValue);
             *var_len = sizeof(ipValue);
             *write_method = write_entLAN;
             return(u_char*)&ipValue; 
        case ENTLANSUBNETMASK:
             apCfgGetValue(LAN_MASK_TOK, &ipValue);
             ipValue = htonl(ipValue);             
             *var_len = sizeof(ipValue);
             *write_method = write_entLAN;
             return(u_char*)&ipValue;             
		case ENTSTPENABLE:
             apCfgGetValue(STP_ENABLE_TOK, &iValue);
			 if(iValue!=TV_TRUE)
			 {
				 iValue = TV_FALSE;
			 }
             *var_len = sizeof(iValue);
             *write_method = write_entLAN;
             return (u_char*) &iValue;                    
        case ENTDHCPENABLE:
			 apCfgGetValue(DHCPD_ENABLE_TOK, &iValue);
			 if(iValue!=TV_TRUE)
			 {
				 iValue = TV_FALSE;
			 }
             *var_len = sizeof(iValue);
             *write_method = write_entLAN;
             return (u_char*) &iValue;
        case ENTIPPOOLSTART:
            apCfgGetValue(DHCPD_START_1_TOK, &ipValue);          
            ipValue = htonl(ipValue);            
            *var_len = sizeof(ipValue);
            *write_method = write_entLAN;
            return (u_char*)&ipValue;
        case ENTIPPOOLEND:
            apCfgGetValue(DHCPD_END_1_TOK, &ipValue);
             ipValue = htonl(ipValue);            
            *var_len = sizeof(ipValue);
            *write_method = write_entLAN;
            return (u_char*)&ipValue;
        case ENTIPLEASETIME:
            apCfgGetValue(DHCPD_MINLEASE_TIME_TOK, &iValue);
            *var_len = sizeof(iValue);
            *write_method = write_entLAN;
            return (u_char*) &iValue;
        default:
			ERROR_MSG("");
    }
    return NULL;   
}


int write_entLAN(int action,
                        u_char * var_val,
                        u_char var_val_type,
                        size_t var_val_len,
                        u_char * statP, oid * name, size_t name_len)
{
    oid var;
    int leaseTime;
    T_INT32 intValue;
	int returnValue;
    T_IPADDR ipOutput;
    static T_IPADDR oldIPValue;
    static T_IPADDR dhcpStartIp,dhcpEndIp,lanIp,maskIp;
    T_IPADDR domain;
    T_BOOL isOk;

    var = name[name_len-2];
    returnValue = TRUE;
    isOk = TRUE;
     switch (action) {
        case RESERVE1:
        apCfgGetValue(LAN_IPADDR_TOK, &lanIp);
        apCfgGetValue(LAN_MASK_TOK, &maskIp);   
        
        domain = lanIp & maskIp;

            switch(var)
            {
                case ENTLANIP:                  
                case ENTLANSUBNETMASK:
					CHECK_IPADDRESS();
                    break;            
				case ENTSTPENABLE:
				case ENTDHCPENABLE:
					CHECK_INT(TV_TRUE,TV_FALSE);
                    break;              
				case ENTIPPOOLSTART:
					CHECK_IPADDRESS();
					{
						apCfgGetValue(DHCPD_END_1_TOK, &dhcpEndIp);
						if(!(domain == (ntohl((*(u_long*)var_val)) & maskIp)))
						{
							isOk = FALSE;
						}
						if(ntohl((*(u_long*)var_val))>=dhcpEndIp)
						{
							isOk = FALSE;
						}    
					}
					break;                 
				case ENTIPPOOLEND:
					CHECK_IPADDRESS();
					{
						apCfgGetValue(DHCPD_START_1_TOK, &dhcpStartIp);
						if(!(domain == (ntohl((*(u_long*)var_val)) & maskIp)))
						{
							isOk = FALSE;                      
						}
						if(ntohl((*(u_long*)var_val))<=dhcpStartIp)
						{
							isOk = FALSE;
						}    
					}
					break;
                case ENTIPLEASETIME:
                    CHECK_INT(0,8);
                    break;
                
            }
            if(returnValue == FALSE || isOk == FALSE)
            {
                return SNMP_ERR_WRONGVALUE;
            }
            break;
        case ACTION:
            switch(var)
            {
                case ENTLANIP:
                    apCfgGetValue(LAN_IPADDR_TOK, &oldIPValue);
                    ipOutput = ntohl(*(u_long*)var_val);
                    isOk = apCfgSetValue(LAN_IPADDR_TOK,&ipOutput);
                    break;
                case ENTLANSUBNETMASK:
                    apCfgGetValue(LAN_MASK_TOK, &oldIPValue);
                    ipOutput = ntohl(*(u_long*)var_val);
                    isOk = apCfgSetValue(LAN_MASK_TOK,&ipOutput);
                    break;
				case ENTSTPENABLE:
					intValue = *(T_INT32 *) var_val;
					if(intValue != TV_TRUE)
					{
						intValue = 0;
					}
                    apCfgSetIntValue(STP_ENABLE_TOK,intValue);
                    break;
				case ENTDHCPENABLE:
					intValue = *(T_INT32 *) var_val;
					if(intValue != TV_TRUE)
					{
						intValue = 0;
					}
                    apCfgSetIntValue(DHCPD_ENABLE_TOK,intValue);
                    break;
                case ENTIPPOOLSTART:
                    apCfgGetValue(DHCPD_START_1_TOK, &dhcpStartIp);
                    ipOutput = ntohl(*(u_long*)var_val);
                    isOk = apCfgSetValue(DHCPD_START_1_TOK,&ipOutput);
                    break;
                case ENTIPPOOLEND:
                    apCfgGetValue(DHCPD_END_1_TOK, &dhcpEndIp);
                    ipOutput = ntohl(*(u_long*)var_val);
                    isOk = apCfgSetValue(DHCPD_END_1_TOK,&ipOutput);
                    break;
                case ENTIPLEASETIME:
                    isOk = apCfgSetValue(DHCPD_MINLEASE_TIME_TOK,(int*)var_val);
                    break;
               
            }
            if(isOk == FALSE)
            {
				return SNMP_ERR_WRONGVALUE;
            }
			apCfgUpdateModifiedData();
            break;

        case UNDO:
            switch(var)
            {

                case ENTLANIP:
                    apCfgSetValue(LAN_IPADDR_TOK,&oldIPValue);
                    break;
                case ENTLANSUBNETMASK:
                    apCfgSetValue(LAN_MASK_TOK,&oldIPValue);
                    break;
				case ENTSTPENABLE:
                    break;
                case ENTDHCPENABLE:
					break;
                case ENTIPPOOLSTART:
                    apCfgSetValue(DHCPD_START_1_TOK,&dhcpStartIp);
                    break;
                case ENTIPPOOLEND:
                     apCfgSetValue(DHCPD_END_1_TOK,&dhcpEndIp);
                     break;
                case ENTIPLEASETIME:
                    break;
            }
            break;


    }
    return SNMP_ERR_NOERROR;
    
} 


