/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.old-api.conf 14476 2006-04-18 17:36:51Z hardaker $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "entAthWlan.h"
#include "entOid.h"

#include <tokens.h>
#include <apcfg.h>
#include <wlanParameter.h>
#include <systeminfo.h>
#include "Utils.h"

#define IWPRIV_ATH "iwpriv.ath"

/* 
 * entWlan_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */

oid entAthWlan_variables_oid[] = { ENTERPRISE_SENAO_PRODUCT_OID,7 };


/* 
 * variable4 entWlan_variables:
 *   this variable defines function callbacks and type return information 
 *   for the entWlan mib section 
 */

struct variable3 entAthWlan_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#define ENTOPMODE		1
{ENTOPMODE,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,1 }},
#define ENTBAND			4
{ENTBAND,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,4 }},
#define ENTESSIDNUM		5
{ENTESSIDNUM,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,5 }},
#define ENTCHANNEL		6
{ENTCHANNEL,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,6 }},
#define ENTDATARATE		7
{ENTDATARATE,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,7 }},
#define ENTTXPOWER		9
{ENTTXPOWER,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,9 }},
#define ENTBEACONINTERVAL		10
{ENTBEACONINTERVAL,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,10 }},
#define ENTDTIMPERIOD		11
{ENTDTIMPERIOD,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,11 }},
#define ENTFRAGMENTATIONTHRESHOLD		12
{ENTFRAGMENTATIONTHRESHOLD,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,12 }},
#define ENTRTSTHRESHOLD		13
{ENTRTSTHRESHOLD,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,13 }},
#define ENTPREAMBLETYPE		15
{ENTPREAMBLETYPE,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,15 }},
#define ENTCTSPROTECTION		16
{ENTCTSPROTECTION,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,16 }},
#define ENTDISTANCE		17
{ENTDISTANCE,  ASN_INTEGER,  RWRITE,  var_entAthWlan, 2,  { 1,17 }},


#define ENTWLANESSIDINFOINDEX		1
{ENTWLANESSIDINFOINDEX,  ASN_INTEGER,  RONLY,   var_entAthWlanESSIDInfoTable, 3,  { 2, 1, 1 }},
#define ENTESSID		2
{ENTESSID,  ASN_OCTET_STR,  RWRITE,  var_entAthWlanESSIDInfoTable, 3,  { 2, 1, 2 }},
#define ENTBROADCASTESSID		3
{ENTBROADCASTESSID,  ASN_INTEGER,  RWRITE,  var_entAthWlanESSIDInfoTable, 3,  { 2, 1, 3 }},
#define ENTWMM		4
{ENTWMM,  ASN_INTEGER,  RWRITE,  var_entAthWlanESSIDInfoTable, 3,  { 2, 1, 4 }},
#define ENTENCRYPTION		5
{ENTENCRYPTION,  ASN_INTEGER,  RWRITE,  var_entAthWlanESSIDInfoTable, 3,  { 2, 1, 5 }},
#define ENTWLANAUTHENTICATIONTYPE		6
{ENTWLANAUTHENTICATIONTYPE,  ASN_INTEGER,  RWRITE,  var_entAthWlanESSIDInfoTable, 3,  { 2, 1, 6 }},

#define ENTWLANESSIDINDEX		1
{ENTWLANESSIDINDEX,  ASN_INTEGER,  RONLY,   var_entAthWlanWepInfoTable, 3,  { 3, 1, 1 }},
#define ENTWLANWEPKEYID		2
{ENTWLANWEPKEYID,  ASN_INTEGER,  RWRITE,  var_entAthWlanWepInfoTable, 3,  { 3, 1, 2 }},
#define ENTWLANWEPKEY1VALUE		3
{ENTWLANWEPKEY1VALUE,  ASN_OCTET_STR,  RWRITE,  var_entAthWlanWepInfoTable, 3,  { 3, 1, 3 }},
#define ENTWLANWEPKEY2VALUE		4
{ENTWLANWEPKEY2VALUE,  ASN_OCTET_STR,  RWRITE,  var_entAthWlanWepInfoTable, 3,  { 3, 1, 4 }},
#define ENTWLANWEPKEY3VALUE		5
{ENTWLANWEPKEY3VALUE,  ASN_OCTET_STR,  RWRITE,  var_entAthWlanWepInfoTable, 3,  { 3, 1, 5 }},
#define ENTWLANWEPKEY4VALUE		6
{ENTWLANWEPKEY4VALUE,  ASN_OCTET_STR,  RWRITE,  var_entAthWlanWepInfoTable, 3,  { 3, 1, 6 }},

{ENTWLANESSIDINDEX,  ASN_INTEGER,  RONLY,   var_entAthWlanWPAInfoTable, 3,  { 4, 1, 1 }},
#define ENTPRESHAREDKEY		2
{ENTPRESHAREDKEY,  ASN_OCTET_STR,  RWRITE,  var_entAthWlanWPAInfoTable, 3,  { 4, 1, 2 }},

{ENTWLANESSIDINDEX,  ASN_INTEGER,  RONLY,   var_entAth802dot1xInfoTable, 3,  { 5, 1, 1 }},
#define ENTRADIUSSERVERIPADDRESS		2
{ENTRADIUSSERVERIPADDRESS,  ASN_IPADDRESS,  RWRITE,  var_entAth802dot1xInfoTable, 3,  { 5, 1, 2 }},
#define ENTRADIUSSERVERPORT		3
{ENTRADIUSSERVERPORT,  ASN_INTEGER,  RWRITE,  var_entAth802dot1xInfoTable, 3,  { 5, 1, 3 }},
#define ENTRADIUSSERVERPASSWORD		4
{ENTRADIUSSERVERPASSWORD,  ASN_OCTET_STR,  RWRITE,  var_entAth802dot1xInfoTable, 3,  { 5, 1, 4 }},
#define ENTWLAN802DOT1XENABLE		5
{ENTWLAN802DOT1XENABLE,  ASN_INTEGER,  RWRITE,  var_entAth802dot1xInfoTable, 3,  { 5, 1, 5 }},
};

static int op_mode=0;

/*    (L = length of the oidsuffix) */

/** Initializes the entWlan module */
void
init_entAthWlan(void)
{

    DEBUGMSGTL(("entWlan", "Initializing\n"));

    /* register ourselves with the agent to handle our mib tree */
    REGISTER_MIB("entWlan", entAthWlan_variables, variable3,
               entAthWlan_variables_oid);

    /* place any other initialization junk you need here */
}

#if 0
void set_entAthWlanCommon(int index, T_INT32 value)
{
    int dataRate[12]={1,2,5,11,6,9,12,18,24,36,48,54};
    int b_dataRate[8]={0,1,2,3,8,9,10,11};
    int g_dataRate[8]={0,1,2,3,4,5,6,7};
	int k;
	int fixedTxMode = 0;


	switch(index)
	{
		case ENTOPMODE:
			break;
		case ENTBAND:
			break;
		case ENTESSIDNUM:
			break;
		case ENTCHANNEL:
			break;
		case ENTDATARATE:
			//SYSTEM("iwpriv "WLAN_G_DEV" set TxRate=%d",apCfgGetIntValue(oidWlanCommonTok[index - 1]));
			break;
		case ENTTXPOWER:
			//SYSTEM("iwpriv "WLAN_G_DEV" set TxPower=%d",apCfgGetIntValue(oidWlanCommonTok[index - 1]));
			break;
		case ENTBEACONINTERVAL:
			/* Set the beaconinterval */
			SYSTEM(IWPRIV_ATH ATH_DEV" bintval %s", apCfgGetStrValue(ATH1_TOK _BEACON_TOK));
			break;
		case ENTDTIMPERIOD:
			/* Set the Data BeaconRate */
			SYSTEM(IWPRIV_ATH ATH_DEV" dtim_period %s", apCfgGetStrValue(ATH1_TOK _DATABEACON_TOK));
			break;
		case ENTFRAGMENTATIONTHRESHOLD:
			//SYSTEM("iwpriv "WLAN_G_DEV" set FragThreshold=%d",apCfgGetIntValue(oidWlanCommonTok[index - 1]));
			break;
		case ENTRTSTHRESHOLD:
			//SYSTEM("iwpriv "ATH_DEV" set RTSThreshold=%d",apCfgGetIntValue(oidWlanCommonTok[index - 1]));
			break;
		case ENTPREAMBLETYPE:
			//Driver: TxPreamble 0:long preamble 1:short preamble
			SYSTEM(IWPRIV_ATH ATH_DEV" shpreamble %d", apCfgGetIntValue(ATH1_TOK _PREAMBLE_TOK)==1?1:0);
			break;
		case ENTCTSPROTECTION:
			//SYSTEM("iwpriv "WLAN_G_DEV" set BGProtection=%d",apCfgGetIntValue(oidWlanCommonTok[index - 1]));
			break;
	}

}
#endif

/*
 * var_entWlan():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_entAthWlan(struct variable *vp, 
                oid     *name, 
                size_t  *length, 
                int     exact, 
                size_t  *var_len, 
                WriteMethod **write_method)
{
    /* variables we may use later */
    static int intValue;
    
    if (header_generic(vp,name,length,exact,var_len,write_method) == MATCH_FAILED )
		return NULL;

	apCfgGetValue2(&op_mode, RADIO_1_OP_MODE_TOK);
	if(op_mode == RADIO_OPM_DISABLE)
	{
		return NULL;
	}

	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR || op_mode == RADIO_OPM_REPEATER_AP)
	{
		switch (vp->magic)
		{
			case ENTOPMODE:
				apCfgGetValue2(&intValue, RADIO_1_OP_MODE_TOK);
				*var_len = sizeof(intValue);
				return (u_char*) &intValue;
			case ENTBAND:
				apCfgGetValue2(&intValue, ATH1_TOK _MODE_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTESSIDNUM:
				if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
				{
					apCfgGetValue2(&intValue, ATH1_TOK _SSID_NUM_TOK);
					*write_method = write_entAthWlan;
				}
				else
				{
					intValue = 1;
				}
				*var_len = sizeof(intValue);
				return (u_char*) &intValue;
			case ENTCHANNEL:
				apCfgGetValue2(&intValue, ATH1_TOK _CHANNEL_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTDATARATE:
				apCfgGetValue2(&intValue, ATH1_TOK _DATARATE_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTTXPOWER:
				apCfgGetValue2(&intValue, ATH1_TOK _TXPOWER_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTBEACONINTERVAL:
				apCfgGetValue2(&intValue, ATH1_TOK _BEACON_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTDTIMPERIOD:
				apCfgGetValue2(&intValue, ATH1_TOK _DATABEACON_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTFRAGMENTATIONTHRESHOLD:
				apCfgGetValue2(&intValue, ATH1_TOK _FRAGMENT_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTRTSTHRESHOLD:
				apCfgGetValue2(&intValue, ATH1_TOK _THRESHOLD_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTPREAMBLETYPE:
				apCfgGetValue2(&intValue, ATH1_TOK _PREAMBLE_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTCTSPROTECTION:
				apCfgGetValue2(&intValue, ATH1_TOK _BGPROTECTION_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTDISTANCE:
				//apCfgGetValue2(&intValue, ATH1_TOK _DISTANCE_TOK);
				apCfgGetValue2(&intValue, ATH1_TOK _ACKTIME_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			default:
				ERROR_MSG("");
		}
	}
#if HAS_WLAN_STA_FUNCTION
	else if (op_mode == RADIO_OPM_CB || op_mode == RADIO_OPM_CR || op_mode == RADIO_OPM_REPEATER_STA) 
	{
		switch (vp->magic)
		{
			case ENTOPMODE:
				apCfgGetValue2(&intValue, RADIO_1_OP_MODE_TOK);
				*var_len = sizeof(intValue);
				return (u_char*) &intValue;
			case ENTBAND:
				apCfgGetValue2(&intValue, ATH1_TOK _STA_TOK _MODE_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTDATARATE:
				apCfgGetValue2(&intValue, ATH1_TOK _STA_TOK _DATARATE_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTFRAGMENTATIONTHRESHOLD:
				apCfgGetValue2(&intValue, ATH1_TOK _STA_TOK _FRAGMENT_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTRTSTHRESHOLD:
				apCfgGetValue2(&intValue, ATH1_TOK _STA_TOK _THRESHOLD_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTPREAMBLETYPE:
				apCfgGetValue2(&intValue, ATH1_TOK _STA_TOK _PREAMBLE_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			case ENTDISTANCE:
				//apCfgGetValue2(&intValue, ATH1_TOK _DISTANCE_TOK);
				apCfgGetValue2(&intValue, ATH1_TOK _ACKTIME_TOK);
				*var_len = sizeof(intValue);
				*write_method = write_entAthWlan;
				return (u_char*) &intValue;
			default:
				ERROR_MSG("");
		}
	}
#endif
    return NULL;
}


int
write_entAthWlan(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    oid var;
    T_INT32 intValue;
    int returnValue;
	int i;
    
    var = name[name_len-2];
    returnValue = TRUE;

	apCfgGetValue2(&op_mode, RADIO_1_OP_MODE_TOK);

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
				case ENTBAND:
                    returnValue = apCfgTestValue(TYPE_ATH11ABG_MODE, (int*)var_val);
					break;
				case ENTESSIDNUM:
					if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
					{
						CHECK_INT(1,4);
					}
					else
					{
						CHECK_INT(1,1);
					}
					break;
				case ENTCHANNEL:
					CHECK_INT(1,14); //Adonn 08-1015: TODO
					break;
				case ENTDATARATE:
                    returnValue = apCfgTestValue(TYPE_11G_DATARATE, (int*)var_val);
					break;
				case ENTTXPOWER:
                    returnValue = apCfgTestValue(TYPE_ATHEROS_TXPOWER, (int*)var_val);
					break;
				case ENTBEACONINTERVAL:
					CHECK_INT(25,1000);
					break;
				case ENTDTIMPERIOD:
					CHECK_INT(1,255);
					break;
				case ENTFRAGMENTATIONTHRESHOLD:
					CHECK_INT(256,2346);
					break;
				case ENTRTSTHRESHOLD:
					CHECK_INT(0,2347);
					break;
				case ENTPREAMBLETYPE:
					CHECK_INT(1,2);
					break;
				case ENTCTSPROTECTION:
					CHECK_INT(0,2);
					break;
				case ENTDISTANCE:
					//CHECK_INT(1,250000);
					CHECK_INT(21,191);
					break;
            }
			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
			intValue = *(T_INT32 *) var_val;

			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR || op_mode == RADIO_OPM_REPEATER_AP)
			{
				switch(var)
				{
					case ENTBAND:
						returnValue = apCfgSetIntValue(ATH1_TOK _MODE_TOK, intValue);
						break;
					case ENTESSIDNUM:
						for (i=2;i<=WLAN_SSID_NUM;i++)
						{
							if(i<=intValue)
							{
								apCfgSetIntValue2(1, ATH_TOK"%d"_ENABLE_TOK, i);
							}
							else
							{
								apCfgSetIntValue2(0, ATH_TOK"%d"_ENABLE_TOK, i);
							}
						}
						returnValue = apCfgSetIntValue(ATH1_TOK _SSID_NUM_TOK, intValue);
						break;
					case ENTCHANNEL:
						returnValue = apCfgSetIntValue(ATH1_TOK _CHANNEL_TOK, intValue);
						break;
					case ENTDATARATE:
						returnValue = apCfgSetIntValue(ATH1_TOK _DATARATE_TOK, intValue);
						break;
					case ENTTXPOWER:
						returnValue = apCfgSetIntValue(ATH1_TOK _TXPOWER_TOK, intValue);
						break;
					case ENTBEACONINTERVAL:
						returnValue = apCfgSetIntValue(ATH1_TOK _BEACON_TOK, intValue);
						break;
					case ENTDTIMPERIOD:
						returnValue = apCfgSetIntValue(ATH1_TOK _DATABEACON_TOK, intValue);
						break;
					case ENTFRAGMENTATIONTHRESHOLD:
						returnValue = apCfgSetIntValue(ATH1_TOK _FRAGMENT_TOK, intValue);
						break;
					case ENTRTSTHRESHOLD:
						returnValue = apCfgSetIntValue(ATH1_TOK _THRESHOLD_TOK, intValue);
						break;
					case ENTPREAMBLETYPE:
						returnValue = apCfgSetIntValue(ATH1_TOK _PREAMBLE_TOK, intValue);
						break;
					case ENTCTSPROTECTION:
						returnValue = apCfgSetIntValue(ATH1_TOK _BGPROTECTION_TOK, intValue);
						break;
					case ENTDISTANCE:
						//returnValue = apCfgSetIntValue(ATH1_TOK _DISTANCE_TOK, intValue);
						returnValue = apCfgSetIntValue(ATH1_TOK _ACKTIME_TOK, intValue);
						break;
				}
			}
#if HAS_WLAN_STA_FUNCTION
			else if (op_mode == RADIO_OPM_CB || op_mode == RADIO_OPM_CR || op_mode == RADIO_OPM_REPEATER_STA)
			{
				switch(var)
				{
					case ENTBAND:
						returnValue = apCfgSetIntValue2(intValue, ATH1_TOK _STA_TOK _MODE_TOK);
						break;
					case ENTDATARATE:
						returnValue = apCfgSetIntValue2(intValue, ATH1_TOK _STA_TOK _DATARATE_TOK);
						break;
					case ENTFRAGMENTATIONTHRESHOLD:
						returnValue = apCfgSetIntValue2(intValue, ATH1_TOK _STA_TOK _FRAGMENT_TOK);
						break;
					case ENTRTSTHRESHOLD:
						returnValue = apCfgSetIntValue2(intValue, ATH1_TOK _STA_TOK _THRESHOLD_TOK);
						break;
					case ENTPREAMBLETYPE:
						returnValue = apCfgSetIntValue2(intValue, ATH1_TOK _STA_TOK _PREAMBLE_TOK);
						break;
					case ENTDISTANCE:
						//returnValue = apCfgSetIntValue(ATH1_TOK _DISTANCE_TOK, intValue);
						returnValue = apCfgSetIntValue(ATH1_TOK _ACKTIME_TOK, intValue);
						break;
				}
			}
#endif

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			//set_entWlanCommon(var, intValue);
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                
            }
            break;

		case COMMIT:
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR || op_mode == RADIO_OPM_REPEATER_AP)
			{
				switch(var)
				{
					case ENTBAND:
					case ENTESSIDNUM:
					case ENTCHANNEL:
					case ENTDATARATE:
					case ENTTXPOWER:
					case ENTBEACONINTERVAL:
					case ENTDTIMPERIOD:
					case ENTFRAGMENTATIONTHRESHOLD:
					case ENTRTSTHRESHOLD:
					case ENTPREAMBLETYPE:
					//case ENTCTSPROTECTION:
					case ENTDISTANCE:
						SYSTEM("sysconf_cli applychanges checkAllModules &");
						break;
				}
			}
#if HAS_WLAN_STA_FUNCTION
			else if(op_mode == RADIO_OPM_CB || op_mode == RADIO_OPM_CR || op_mode == RADIO_OPM_REPEATER_STA)
			{
				switch(var)
				{
					case ENTBAND:
					case ENTDATARATE:
					case ENTFRAGMENTATIONTHRESHOLD:
					case ENTRTSTHRESHOLD:
					case ENTPREAMBLETYPE:
					case ENTDISTANCE:
						SYSTEM("sysconf_cli applychanges checkAllModules &");
						break;
				}
			}
#endif
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}


/*
 * var_entWlanESSIDInfoTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_entWlan above.
 */
unsigned char *
var_entAthWlanESSIDInfoTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
    /* variables we may use later */
	static oid index;
	T_CHAR tokBuf[30];
	static int ssidNum;
    static T_UCHAR ssidValue[32+1];
    static int intValue;
	static int wlan_enable;

	/* 
   * This assumes that the table is a 'simple' table.
   *	See the implementation documentation for the meaning of this.
   *	You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *	you will need to provide the replacement code yourself.
   *	Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
    if (header_simple_table(vp,name,length,exact,var_len,write_method, WLAN_SSID_NUM) == MATCH_FAILED )
		return NULL;

	index = name[*length - 1];

	apCfgGetValue(RADIO_1_OP_MODE_TOK, &op_mode);
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
	{
		if(index > 1)
		{
			return NULL;
		}
	}
	else
	{
		return NULL;
	}

	/*Check whether wlan is enabled*/
	apCfgGetValue2(&wlan_enable, ATH_TOK"%d"_ENABLE_TOK, index);
	if(!wlan_enable)
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
	{
		switch(vp->magic) {
		case ENTWLANESSIDINFOINDEX:
			return (u_char*) &index;
		case ENTESSID:
			apCfgGetValue2(ssidValue, ATH_TOK"%d"_SSID_TOK, index);
			*var_len = strlen(ssidValue);
			*write_method = write_entAthWlanESSIDInfoTable;
			return (u_char*) &ssidValue;
		case ENTBROADCASTESSID:
			apCfgGetValue2(&intValue, ATH_TOK"%d"_HIDESSID_TOK, index);
			 if(intValue!=TV_TRUE)
			 {
				 intValue = TV_FALSE;
			 }
			*var_len = sizeof(intValue);
			*write_method = write_entAthWlanESSIDInfoTable;
			return (u_char*) &intValue;
		case ENTWMM:
			apCfgGetValue2(&intValue, ATH_TOK"%d"_WMM_ENABLE_TOK, index);
			 if(intValue!=TV_TRUE)
			 {
				 intValue = TV_FALSE;
			 }
			*var_len = sizeof(intValue);
			*write_method = write_entAthWlanESSIDInfoTable;
			return (u_char*) &intValue;
		case ENTENCRYPTION:
			apCfgGetValue2(&intValue, ATH_TOK"%d"_ENC_TYPE_TOK, index);
			*var_len = sizeof(intValue);
			*write_method = write_entAthWlanESSIDInfoTable;
			return (u_char*) &intValue;
		case ENTWLANAUTHENTICATIONTYPE:
			apCfgGetValue2(&intValue, ATH_TOK"%d"_AUTH_TOK, index);
			*var_len = sizeof(intValue);
			*write_method = write_entAthWlanESSIDInfoTable;
			return (u_char*) &intValue;
		default:
			ERROR_MSG("");
		}
	}
	else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
	{
		switch(vp->magic) {
		case ENTWLANESSIDINFOINDEX:
			return (u_char*) &index;
		case ENTESSID:
			apCfgGetValue2(ssidValue, ATH_TOK"%d"_SSID_TOK, index);
			*var_len = strlen(ssidValue);
			*write_method = write_entAthWlanESSIDInfoTable;
			return (u_char*) &ssidValue;
		case ENTENCRYPTION:
			apCfgGetValue2(&intValue, ATH_TOK"%d"_WDS_SEC_TYPE_TOK, index);
			*var_len = sizeof(intValue);
			*write_method = write_entAthWlanESSIDInfoTable;
			return (u_char*) &intValue;
		default:
			ERROR_MSG("");
		}
	}
    return NULL;
}

#if 0
void set_entWlanESSIDInfoTable(int essidIndex, int var, u_char *var_val)
{
	T_INT32 intValue;

	intValue = *(T_INT32 *) var_val;
	switch(var)
	{
		case ENTESSID:
			SYSTEM("iwpriv "WLAN_DEV"%d set SSID=%s",essidIndex-1, var_val);
			break;
		case ENTBROADCASTESSID:
			if(intValue != TV_TRUE)
			{
				intValue = 0;
			}
			SYSTEM("iwpriv "WLAN_DEV"%d set HideSSID=%d",essidIndex-1, intValue);
			break;
		case ENTWMM:
			if(intValue != TV_TRUE)
			{
				intValue = 0;
			}
			SYSTEM("iwpriv "WLAN_DEV"%d set WmmCapable=%d",essidIndex-1, intValue);
			break;					
		case ENTENCRYPTION:
			SYSTEM("iwpriv "WLAN_DEV"%d set AuthMode=%s",essidIndex-1, wlanAuthModeStr[intValue]);
			break;
		case ENTWLANAUTHENTICATIONTYPE:
			SYSTEM("iwpriv "WLAN_DEV"%d set EncrypType=%s",essidIndex-1, wlanEncTypeStr[intValue]);
			break;
	}
}
#endif
    
int
write_entAthWlanESSIDInfoTable(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    oid var;
    T_INT32 intValue;
    int returnValue;
	int essidIndex;

	essidIndex = name[name_len-1];
    var = name[name_len-2];
    returnValue = TRUE;
	apCfgGetValue(RADIO_1_OP_MODE_TOK, &op_mode);

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
			{
				switch(var)
				{
					case ENTESSID:
						returnValue = apCfgTestValue(TYPE_SSID, (char *)var_val);
						break;
					case ENTBROADCASTESSID:
						CHECK_INT(TV_TRUE,TV_FALSE);
						break;
					case ENTWMM:
						CHECK_INT(TV_TRUE,TV_FALSE);
						break;					
					case ENTENCRYPTION:
						CHECK_INT(0,4);
						break;
					case ENTWLANAUTHENTICATIONTYPE:
						CHECK_INT(0,8);
						break;
				}
			}
			else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
			{
				switch(var)
				{
					case ENTESSID:
						returnValue = apCfgTestValue(TYPE_SSID, (char *)var_val);
						break;				
					case ENTENCRYPTION:
						CHECK_INT(0,3);
						break;
				}
			}
			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
			{
				switch(var)
				{
					case ENTESSID:
						returnValue = apCfgSetValue2((T_CHAR*) var_val, ATH_TOK"%d"_SSID_TOK, essidIndex);
						break;
					case ENTBROADCASTESSID:
						intValue = *(T_INT32 *) var_val;
						if(intValue != TV_TRUE)
						{
							intValue = 0;
						}
						returnValue = apCfgSetIntValue2(intValue, ATH_TOK"%d"_HIDESSID_TOK, essidIndex);
						break;
					case ENTWMM:
						intValue = *(T_INT32 *) var_val;
						if(intValue != TV_TRUE)
						{
							intValue = 0;
						}
						returnValue = apCfgSetIntValue2(intValue, ATH_TOK"%d"_WMM_ENABLE_TOK, essidIndex);
						break;					
					case ENTENCRYPTION:
						returnValue = apCfgSetIntValue2((T_INT32 *) var_val, ATH_TOK"%d"_ENC_TYPE_TOK, essidIndex);
						break;
					case ENTWLANAUTHENTICATIONTYPE:
						returnValue = apCfgSetIntValue2((T_INT32 *) var_val, ATH_TOK"%d"_AUTH_TOK, essidIndex);
						break;
				}
			}
			else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
			{
				switch(var)
				{
					case ENTESSID:
						returnValue = apCfgSetValue2((T_CHAR*) var_val, ATH_TOK"%d"_SSID_TOK, essidIndex);
						break;					
					case ENTENCRYPTION:
						returnValue = apCfgSetIntValue2((T_INT32 *) var_val, ATH_TOK"%d"_WDS_SEC_TYPE_TOK, essidIndex);
						break;
				}
			}

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			//set_entAthWlanESSIDInfoTable(essidIndex, var, var_val);
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
             switch(var)
            {
                
            }
            break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
			{
				switch(var)
				{
					case ENTESSID:
					case ENTBROADCASTESSID:
					case ENTWMM:
					case ENTENCRYPTION:
					case ENTWLANAUTHENTICATIONTYPE:
						SYSTEM("sysconf_cli applychanges checkAllModules &");
						break;
				}
			}
			else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
			{
				switch(var)
				{
					case ENTESSID:
					case ENTENCRYPTION:
						SYSTEM("sysconf_cli applychanges checkAllModules &");
						break;
				}
			}
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}

/*
 * var_entWlanWepInfoTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_entWlan above.
 */
unsigned char *
var_entAthWlanWepInfoTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
    /* variables we may use later */
	static oid index;
	T_CHAR tokBuf[30];
    static int intValue;
	static int enc;
	static int wlan_enable;

	/* 
   * This assumes that the table is a 'simple' table.
   *	See the implementation documentation for the meaning of this.
   *	You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *	you will need to provide the replacement code yourself.
   *	Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
    if (header_simple_table(vp,name,length,exact,var_len,write_method, WLAN_SSID_NUM) == MATCH_FAILED )
		return NULL;

	index = name[*length - 1];

	/*For AP and WDS, we can get/set WEP information. For CB or CR, we use AP profile for WEP information*/
	apCfgGetValue(RADIO_1_OP_MODE_TOK, &op_mode);
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
	{
		if(index > 1)
		{
			return NULL;
		}
	}
	else
	{
		return NULL;
	}

	/*Check whether wlan is enabled*/
	apCfgGetValue2(&wlan_enable, ATH_TOK"%d"_ENABLE_TOK, index);
	if(!wlan_enable)
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
	{
		switch(vp->magic) {
		case ENTWLANESSIDINDEX:
			return (u_char*) &index;
		case ENTWLANWEPKEYID:
			apCfgGetValue2(&intValue, ATH_TOK"%d"_KEYID_TOK, index);
			*var_len = sizeof(intValue);
			*write_method = write_entAthWlanWepInfoTable;
			return (u_char*) &intValue;
		case ENTWLANWEPKEY1VALUE:
		case ENTWLANWEPKEY2VALUE:
		case ENTWLANWEPKEY3VALUE:
		case ENTWLANWEPKEY4VALUE:
			*write_method = write_entAthWlanWepInfoTable;
			return NULL;
		default:
			ERROR_MSG("");
		}
	}
	else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
	{
		switch(vp->magic) {
		case ENTWLANESSIDINDEX:
			return (u_char*) &index;
		case ENTWLANWEPKEYID:
			apCfgGetValue2(&intValue, ATH1_WDS_KEYID_TOK);
			*var_len = sizeof(intValue);
			*write_method = write_entAthWlanWepInfoTable;
			return (u_char*) &intValue;
		case ENTWLANWEPKEY1VALUE:
		case ENTWLANWEPKEY2VALUE:
		case ENTWLANWEPKEY3VALUE:
		case ENTWLANWEPKEY4VALUE:
			*write_method = write_entAthWlanWepInfoTable;
			return NULL;
		default:
			ERROR_MSG("");
		}
	}
    return NULL;
}

int
write_entAthWlanWepInfoTable(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    oid var;
    T_INT32 intValue;
    int returnValue;
	int essidIndex;

	essidIndex = name[name_len-1];
    var = name[name_len-2];
    returnValue = TRUE;
	apCfgGetValue(RADIO_1_OP_MODE_TOK, &op_mode);

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
			case ENTWLANWEPKEYID:
				CHECK_INT(1,4);
				break;
			case ENTWLANWEPKEY1VALUE:
			case ENTWLANWEPKEY2VALUE:
			case ENTWLANWEPKEY3VALUE:
			case ENTWLANWEPKEY4VALUE:
				if (var_val_type != ASN_OCTET_STR)
					return SNMP_ERR_WRONGTYPE;
				returnValue = apCfgTestValue(TYPE_WEPKEY, (T_CHAR *)var_val);   
				break;

            }
			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
			{
				switch(var)
				{
				case ENTWLANWEPKEYID:
					returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH_TOK"%d"_KEYID_TOK, essidIndex);
					break;
				case ENTWLANWEPKEY1VALUE:
					returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH_TOK"%d"_WEPKEY_0_TOK, essidIndex);
					break;
				case ENTWLANWEPKEY2VALUE:
					returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH_TOK"%d"_WEPKEY_1_TOK, essidIndex);
					break;
				case ENTWLANWEPKEY3VALUE:
					returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH_TOK"%d"_WEPKEY_2_TOK, essidIndex);
					break;
				case ENTWLANWEPKEY4VALUE:
					returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH_TOK"%d"_WEPKEY_3_TOK, essidIndex);
					break;
				}
			}
			else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
			{
				switch(var)
				{
				case ENTWLANWEPKEYID:
					returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH1_WDS_KEYID_TOK);
					break;
				case ENTWLANWEPKEY1VALUE:
					returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH1_WDS_WEPKEY_0_TOK);
					break;
				case ENTWLANWEPKEY2VALUE:
					returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH1_WDS_WEPKEY_1_TOK);
					break;
				case ENTWLANWEPKEY3VALUE:
					returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH1_WDS_WEPKEY_2_TOK);
					break;
				case ENTWLANWEPKEY4VALUE:
					returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH1_WDS_WEPKEY_3_TOK);
					break;
				}
			}

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                
            }
            break;
		case COMMIT:
            switch(var)
            {
				case ENTWLANWEPKEYID:
				case ENTWLANWEPKEY1VALUE:
				case ENTWLANWEPKEY2VALUE:
				case ENTWLANWEPKEY3VALUE:
				case ENTWLANWEPKEY4VALUE:
					SYSTEM("sysconf_cli applychanges checkAllModules &");
					break;
			}
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}
/*
 * var_entWlanWPAInfoTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_entWlan above.
 */
unsigned char *
var_entAthWlanWPAInfoTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
    /* variables we may use later */
	static oid index;
	T_CHAR tokBuf[30];
    static int intValue;
	static int enc;
	static int wlan_enable;

	/* 
   * This assumes that the table is a 'simple' table.
   *	See the implementation documentation for the meaning of this.
   *	You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *	you will need to provide the replacement code yourself.
   *	Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
    if (header_simple_table(vp,name,length,exact,var_len,write_method, WLAN_SSID_NUM) == MATCH_FAILED )
		return NULL;

	index = name[*length - 1];

	apCfgGetValue(RADIO_1_OP_MODE_TOK, &op_mode);
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
	{
		if(index > 1)
		{
			return NULL;
		}
	}
	else
	{
		return NULL;
	}

	/*Check whether wlan is enabled*/
	apCfgGetValue2(&wlan_enable, ATH_TOK"%d"_ENABLE_TOK, index);
	if(!wlan_enable)
		return NULL;

   /* this is where we do the value assignments for the mib results.
   */
    switch(vp->magic) {
		case ENTWLANESSIDINDEX:
			return (u_char*) &index;
		case ENTPRESHAREDKEY:
			*write_method = write_entAthWlanWPAInfoTable;
            break;
		default:
			ERROR_MSG("");
    }
    
    return NULL; 
}

#if 0
void set_entAthWlanWPAInfoTable(int essidIndex, int var, u_char *var_val)
{
	switch(var)
	{
	case ENTPRESHAREDKEY:
		break;
	}
}
#endif

int
write_entAthWlanWPAInfoTable(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    oid var;
    T_INT32 intValue;
    int returnValue;
	oid essidIndex;

	essidIndex = name[name_len-1];
    var = name[name_len-2];
    returnValue = TRUE;
	static int op_mode;

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
			case ENTPRESHAREDKEY:
				if (var_val_type != ASN_OCTET_STR)
					return SNMP_ERR_WRONGTYPE;
				returnValue = apCfgTestValue(TYPE_WPA_PASSPHRASE, (T_CHAR *)var_val);   
				break;

            }
			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
			if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
			{
				switch(var)
				{
				case ENTPRESHAREDKEY:
					returnValue = apCfgSetValue2((T_CHAR *) var_val, ATH_TOK"%d"_WPAPASSPHRASE_TOK);
					break;
				}
			}
			else if(op_mode == RADIO_OPM_WDSB || op_mode == RADIO_OPM_WDSR)
			{
				switch(var)
				{
				case ENTPRESHAREDKEY:
					returnValue = apCfgSetValue2((T_CHAR *) var_val, ATH1_WDS_WPAPASSPHRASE_TOK);
					break;
				}	
			}

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			//set_entWlanWPAInfoTable(essidIndex, var, var_val);
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
			case ENTPRESHAREDKEY:
				SYSTEM("sysconf_cli applychanges checkAllModules &");
				break;
            }
            break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}

/*
 * var_ent802dot1xInfoTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_entWlan above.
 */
unsigned char *
var_entAth802dot1xInfoTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
    /* variables we may use later */
	static oid index;
    static int intValue;
    static T_IPADDR ipValue;
	static int isIeee802dot1xEnable;
	static int wlan_enable;
	static int op_mode;

	/* 
   * This assumes that the table is a 'simple' table.
   *	See the implementation documentation for the meaning of this.
   *	You will need to provide the correct value for the TABLE_SIZE parameter
   *
   * If this table does not meet the requirements for a simple table,
   *	you will need to provide the replacement code yourself.
   *	Mib2c is not smart enough to write this for you.
   *    Again, see the implementation documentation for what is required.
   */
    if (header_simple_table(vp,name,length,exact,var_len,write_method, WLAN_SSID_NUM) == MATCH_FAILED )
		return NULL;

	index = name[*length - 1];

	/*Only run 802.1x in AP mode. For CB or CR, Use AP profile for 802.1x*/
	apCfgGetValue(RADIO_1_OP_MODE_TOK, &op_mode);
	if(op_mode == RADIO_OPM_AP || op_mode == RADIO_OPM_REPEATER_AP)
	{
		if(index > WLAN_SSID_NUM)
			return NULL;
	}
	else
	{
		return NULL;
	}

	/*Check whether wlan is enabled*/
	apCfgGetValue2(&wlan_enable, ATH_TOK"%d"_ENABLE_TOK, index);
	if(!wlan_enable)
		return NULL;

    /* 
   * this is where we do the value assignments for the mib results.
   */
    switch(vp->magic) {
    case ENTWLANESSIDINDEX:
        return (u_char*) &index;
	case ENTRADIUSSERVERIPADDRESS:
		apCfgGetValue2(&ipValue, ATH_TOK"%d"_8021X_SERVIP_TOK, index);         
		ipValue = htonl(ipValue);            
		*var_len = sizeof(ipValue);
		*write_method = write_entAth802dot1xInfoTable;
		return (u_char*)&ipValue;
	case ENTRADIUSSERVERPORT:
		apCfgGetValue2(&intValue, ATH_TOK"%d"_8021X_SERVPORT_TOK, index);        
		*var_len = sizeof(intValue);
		*write_method = write_entAth802dot1xInfoTable;
		return (u_char*) &intValue;
	case ENTRADIUSSERVERPASSWORD:
		*write_method = write_entAth802dot1xInfoTable;
		return NULL;
	case ENTWLAN802DOT1XENABLE:
		apCfgGetValue2(&intValue, ATH_TOK"%d"_8021X_ENABLE_TOK, index); 
		 if(intValue!=TV_TRUE)
		 {
			 intValue = TV_FALSE;
		 }
		*var_len = sizeof(intValue);
		*write_method = write_entAth802dot1xInfoTable;
		return (u_char*) &intValue;
    default:
      	ERROR_MSG("");
    }
    return NULL;
}

#if 0
void set_entAth02dot1xInfoTable(int essidIndex, int var, u_char *var_val)
{
	int enc;
	int auth;
	int intValue;

	intValue = *(T_INT32 *) var_val;

	switch(var)
	{
	case ENTRADIUSSERVERIPADDRESS:
		//SYSTEM("iwpriv "WLAN_DEV"%d set RADIUS_Server=%s",essidIndex-1, var_val);
		//break;
	case ENTRADIUSSERVERPORT:
		//SYSTEM("iwpriv "WLAN_DEV"%d set RADIUS_Port=%s",essidIndex-1, intValue);
		//break;
	case ENTRADIUSSERVERPASSWORD:
		//SYSTEM("iwpriv "WLAN_DEV"%d set RADIUS_Key=%s",essidIndex-1, var_val);
		break;
	case ENTWLAN802DOT1XENABLE:
		//apCfgGetValue(wlanTokens[essidIndex-1].EncrypType, &enc);
		//apCfgGetValue(wlanTokens[essidIndex-1].AuthMode, &auth);
		if(intValue != TV_TRUE)
		{
			intValue = 0;
		}
		if(enc == WLAN_ENC_NONE || enc == WLAN_ENC_WEP)
		{
			SYSTEM("iwpriv "WLAN_DEV"%d set IEEE8021X=%d",essidIndex-1, intValue);
		}
		else
		{
			SYSTEM("iwpriv "WLAN_DEV"%d set IEEE8021X=0",essidIndex-1);
		}
		break;
	}
}
#endif

int
write_entAth802dot1xInfoTable(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    oid var;
    T_INT32 intValue;
    int returnValue;
	int essidIndex;
    T_IPADDR ipOutput;
    static T_IPADDR oldIPValue;

	essidIndex = name[name_len-1];
    var = name[name_len-2];
    returnValue = TRUE;

    switch (action) {
        case RESERVE1:
        /*
         *  Check that the value being set is acceptable
         */
            switch(var)
            {
			case ENTPRESHAREDKEY:
				CHECK_IPADDRESS();  
				break;
			case ENTRADIUSSERVERPORT:
				CHECK_INT(1, 65535);
				break;
			case ENTRADIUSSERVERPASSWORD:
				if (var_val_type != ASN_OCTET_STR)
					return SNMP_ERR_WRONGTYPE;
				returnValue = apCfgTestValue(TYPE_STR, (T_CHAR *)var_val);
				break;
			case ENTWLAN802DOT1XENABLE:
				CHECK_INT(TV_TRUE,TV_FALSE);
				break;
            }
			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
            break;
        case RESERVE2:
			break;
        case FREE:
             /* Release any resources that have been allocated */
			break;
		case ACTION:
		      /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
            switch(var)
            {
			case ENTRADIUSSERVERIPADDRESS:
				apCfgGetValue2(&oldIPValue, ATH_TOK"%d"_8021X_SERVIP_TOK, essidIndex);
				ipOutput = ntohl(*(u_long*)var_val);
				returnValue = apCfgSetValue2(&ipOutput, ATH_TOK"%d"_8021X_SERVIP_TOK, essidIndex);
				break;
			case ENTRADIUSSERVERPORT:
				returnValue = apCfgSetValue2((T_INT32 *) var_val, ATH_TOK"%d"_8021X_SERVPORT_TOK, essidIndex);
				break;
			case ENTRADIUSSERVERPASSWORD:
				returnValue = apCfgSetValue2((T_CHAR *) var_val, ATH_TOK"%d"_8021X_SERVPW_TOK, essidIndex);
				break;
			case ENTWLAN802DOT1XENABLE:
				intValue = *(T_INT32 *) var_val;
				if(intValue != TV_TRUE)
				{
					intValue = 0;
				}
				returnValue = apCfgSetValue2(intValue, ATH_TOK"%d"_8021X_ENABLE_TOK, essidIndex);
				break;
            }

			if(returnValue == FALSE)
			{
				return SNMP_ERR_WRONGVALUE;
			}
			//set_ent802dot1xInfoTable(essidIndex, var, var_val);
			apCfgUpdateModifiedData();
            break;
        
		case UNDO:
			/* Back out any changes made in the ACTION case */
            switch(var)
            {
                case ENTRADIUSSERVERIPADDRESS:
                    apCfgSetValue2(&oldIPValue, ATH_TOK"%d"_8021X_SERVIP_TOK, essidIndex);
					break;
            }
            break;

		case COMMIT:
			switch(var)
			{
			case ENTRADIUSSERVERIPADDRESS:
			case ENTRADIUSSERVERPORT:
			case ENTRADIUSSERVERPASSWORD:
			case ENTWLAN802DOT1XENABLE:
				SYSTEM("sysconf_cli applychanges checkAllModules &");
				break;
			}
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */
			break;

    }
    
    return SNMP_ERR_NOERROR;  
}

