#ifndef _UTILS_H
#define _UTILS_H

#define CHECK_INT(min, max) \
	do { \
		if (var_val_type != ASN_INTEGER)  \
            return SNMP_ERR_WRONGTYPE;    \
        if (var_val_len > sizeof(long)) \
            return SNMP_ERR_WRONGLENGTH;  \
        if ( *((long*)var_val)  < (min) || *((long*)var_val) > (max) ) \
            return SNMP_ERR_WRONGVALUE; \
	} while (0)
	
#define CHECK_STR(maxLen)\
    do { \
        if (var_val_type != ASN_OCTET_STR) \
            return SNMP_ERR_WRONGTYPE; \
        if (var_val_len > (maxLen)) \
            return SNMP_ERR_WRONGLENGTH; \
        } while (0)
        
#define CHECK_IPADDRESS()\
    do { \
        if (var_val_type != ASN_IPADDRESS) \
            return SNMP_ERR_WRONGTYPE; \
        } while (0)



#define RETURN_INT(ret, val)\
	do { \
		(ret) = (val); \
		*var_len = sizeof(u_long); \
		return (u_char *) &(ret); \
	} while(0)
	
#define RETURN_STR(ret, val, len) \
	do {  \
		memcpy((ret), (val), (len)); ret[(len)] = 0; \
		*var_len = (len); \
		return (u_char *) (ret); \
	} while(0)

		
#define RETURN_COUNTER64(ret, lowest, highest) \
	do {  \
       ((ret).low) = (lowest);  \
       ((ret).high) = (highest);  \
       *var_len = sizeof(ret);   \
       return (struct counter64 *) &(ret); \
	} while(0)	 




#endif
