/*
** apinfoc.c -- the apinfo client for apinfos.c; demonstrates unix sockets
*/

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include "apinfo_client.h"

//#define SOCK_PATH "/home/qoo/apinfo_socket"

int apinfo_open(void)
{
    int s, len;
    struct sockaddr_un remote;

    if ((s = socket(AF_UNIX, SOCK_STREAM, 0)) == -1) 
    {
        perror("apinfo_open(): socket");
        return 0;
    }

    printf("Trying to connect...\n");

    remote.sun_family = AF_UNIX;
    strcpy(remote.sun_path, SOCK_PATH);
    len = strlen(remote.sun_path) + sizeof(remote.sun_family);
    if (connect(s, (struct sockaddr *)&remote, len) == -1) {
        perror("connect");
        return 0;
    }

    printf("Connected.\n");


    return s;
}

int apinfo_read(unsigned int s, unsigned int index, unsigned char *pdata, int data_len)
{
    int t;
    struct timeval tv;
    int res;
    fd_set rfds;

    apinfo_data apinfo;

    apinfo.type  = APINFO_GET;
    apinfo.index = index;
//    apinfo.pdata = pdata;

    if (send(s, (void *)&apinfo, sizeof(apinfo), 0) == -1)
       {
          perror("send");
          return -1;
       }

    //for(;;)
    {
        tv.tv_sec = 1;  /* 1 second */
        tv.tv_usec = 0;
        FD_ZERO(&rfds);
        FD_SET(s, &rfds);
        res = select(s + 1, &rfds, NULL, NULL, &tv);

        if (FD_ISSET(s, &rfds))
        {

            if ((t=recv(s, (void *)&apinfo, sizeof(apinfo), 0)) > 0)
            {
                if(index != apinfo.index)
                {
                    printf("Reset connection\n");
                    return -1;
                }
		memcpy(pdata, apinfo.data, data_len);
		pdata[data_len]='\0';
                printf("echo> %d", apinfo.status);
            } else
            {
                if (t < 0)
                  perror("apinfo_write: recv");
                else
                {
                  printf("Server closed connection\n");
                }

                return -1;
            }
        }
    }

/*
    if (FD_ISSET(s, &rfds)) 
    {
       if ((t=recv(s, (void *)&apinfo, sizeof(apinfo), 0)) > 0)
          {
  	     memcpy(pdata, apinfo.data, APINFO_MAX_LEN);

             printf("echo> %s", pdata);
          } else
          {
             if (t < 0)
                perror("apinfo_write: recv");
             else
                printf("Server closed connection\n");
             return -1;
          }
    }
*/
    return apinfo.status;
    
}

int apinfo_write(unsigned int s, unsigned int index, unsigned char *pdata, int data_len)
{
    int t;
    struct timeval tv;
    int res;
    fd_set rfds;

    apinfo_data apinfo;
    
    apinfo.type  = APINFO_SET;
    apinfo.index = index;
    apinfo.data_len = data_len;
    memcpy(apinfo.data, pdata, data_len);

    if (send(s, (void *)&apinfo, sizeof(apinfo), 0) == -1) 
       {
          perror("send");
          return -1;
       }

    //for(;;)
    {
        tv.tv_sec = 1; /* 1 second */
        tv.tv_usec = 0;
        FD_ZERO(&rfds);
        FD_SET(s, &rfds);
        res = select(s + 1, &rfds, NULL, NULL, &tv);

        if (FD_ISSET(s, &rfds))
        {

            if ((t=recv(s, (void *)&apinfo, sizeof(apinfo), 0)) > 0) 
            {
		if(index != apinfo.index)
		{
		    printf("Reset connection\n");
		    return -1;
		}
                printf("echo> %d", apinfo.status);
            } else 
            {
                if (t < 0) 
		  perror("apinfo_write: recv");
                else 
                {
		  printf("Server closed connection\n");
                }
                
                return -1;
            }
        }
    }

    return 0;
}

int apinfo_close(int s)
{
    close(s);
    return 0;
}

