#include "xat.h"

UCHAR BROADCAST_ADDR[MAC_ADDR_LEN] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
UCHAR ATH_MAC_ADDR[MAC_ADDR_LEN] = {0x00, 0x02, 0x6f, 0x11, 0x22, 0x33};

extern XATProtoOps XATProtoIPHandle;
extern XATProtoOps XATProtoARPHandle;
extern XATProtoOps XATProtoPPPoEDisHandle;
extern XATProtoOps XATProtoPPPoESesHandle;
extern XATProtoOps XATProtoIPv6Handle;

extern UCHAR SNAP_802_1H[];
extern UCHAR SNAP_BRIDGE_TUNNEL[];

#define MAX_XAT_NODE_ENTRY_NUM  128 // We support maxima 128 node entry for our system
#define XAT_NODE_ENTRY_SIZE 40 //28 // bytes   //change to 40 for IPv6Mac Table

typedef struct _XATNodeEntry
{
    UCHAR data[XAT_NODE_ENTRY_SIZE];
    struct _XATNodeEntry *next;
}XATNodeEntry, *PXATNodeEntry;


#ifdef KMALLOC_BATCH
//static XATNodeEntry *XATNodeEntryPoll = NULL;
#endif

RTMP_ADAPTER gAd;
ULONG    RTDebugLevel=0xffff;

static XATProtoTable XATProtoTb[]=
{
    {ETH_P_IP,          &XATProtoIPHandle},         // IP handler
    {ETH_P_ARP,         &XATProtoARPHandle},        // ARP handler
    {ETH_P_PPP_DISC,    &XATProtoPPPoEDisHandle},   // PPPoE discovery stage handler
    {ETH_P_PPP_SES,     &XATProtoPPPoESesHandle},   // PPPoE session stage handler
    {ETH_P_IPV6,        &XATProtoIPv6Handle},       // IPv6 handler
};

#define MAX_XAT_SUPPORT_PROTO_NUM (sizeof(XATProtoTb)/sizeof(XATProtoTable))


/* --------------------------------- Public Function-------------------------------- */
// pAd MUST allow to be NULL
NDIS_STATUS os_malloc(
    IN  PRTMP_ADAPTER pAd,
    OUT PUCHAR *mem,
    IN  ULONG  size)
{   
//    printk("os_alloc_mem size %ld: ",size);
    *mem = (PUCHAR) kmalloc(size, GFP_ATOMIC);
    //printk("%s\n", (*mem)?"OK":"Failed");
    //printk("mem address 0x%x\n", (int)mem);
    if (*mem)
        return (NDIS_STATUS_SUCCESS);
    else
        return (NDIS_STATUS_FAILURE);
}
// pAd MUST allow to be NULL
NDIS_STATUS os_mfree(
    IN  PRTMP_ADAPTER pAd,
    IN  PUCHAR mem)
{
    
    ASSERT(mem);
    kfree(mem);
    return (NDIS_STATUS_SUCCESS);
}


NDIS_STATUS XATDBEntryFree(
    IN XAT_STRUCT   *pMatStruct, 
    IN PUCHAR       NodeEntry)
{
#ifdef KMALLOC_BATCH
    XATNodeEntry *pPtr, *pXATNodeEntryPoll;

    pXATNodeEntryPoll = (XATNodeEntry *)pAd->MatCfg.XATNodeEntryPoll;
    pPtr = (XATNodeEntry *)NodeEntry;
    NdisZeroMemory(pPtr, sizeof(XATNodeEntry));
    if (pXATNodeEntryPoll->next)
    {
        pPtr->next = pXATNodeEntryPoll->next;
        pXATNodeEntryPoll->next = pPtr;
    } else {
        pXATNodeEntryPoll->next = pPtr;
    }
#else
    os_mfree(NULL, NodeEntry);
#endif

    return TRUE;

}

PUCHAR XATDBEntryAlloc(IN XAT_STRUCT *pMatStruct, IN UINT32 size)
{
#ifdef KMALLOC_BATCH
    XATNodeEntry *pPtr = NULL, *pXATNodeEntryPoll;
    pXATNodeEntryPoll = (XATNodeEntry *)pMatStruct->pXATNodeEntryPoll;
    
    if (pXATNodeEntryPoll->next)
    {
        pPtr = pXATNodeEntryPoll->next;
        pXATNodeEntryPoll->next = pPtr->next;
    }
    
#else
    UCHAR *pPtr = NULL;

    os_malloc(NULL, (PUCHAR *)&pPtr, size);
    //pPtr = kmalloc(size, MEM_ALLOC_FLAG);

#endif

    return (PUCHAR)pPtr;
}


VOID dumpPkt(PUCHAR pHeader, int len)
{
    int i;
    char *tmp;

    tmp = pHeader;

    printk("--StartDump\n");
    for(i=0;i<len; i++)
    {
        if ( (i%16==0) && (i!=0))
            printk("\n");
        printk("%02x ", tmp[i]& 0xff);
    }
    printk("\n--EndDump\n");

    return;
}


/*
    ========================================================================
    Routine Description:
        For each out-going packet, check the upper layer protocol type if need
        to handled by our APCLI convert engine. If yes, call corresponding handler 
        to handle it.
        
    Arguments:
        pAd     =>Pointer to our adapter
        pPkt    =>pointer to the 802.11 header of outgoing packet 
        ifIdx   =>Interface Index want to dispatch to.

    Return Value:
        Success =>
            TRUE
            Mapped mac address if found, else return specific default mac address 
            depends on the upper layer protocol type.
        Error   =>
            FALSE.

    Note:
        1.the pPktHdr must be a 802.3 packet.
        2.Maybe we need a TxD arguments?
        3.We check every packet here including group mac address becasue we need to
          handle DHCP packet.
    ========================================================================
 */
PUCHAR XATEngineTxHandle(
    IN PRTMP_ADAPTER    pAd,
    IN PNDIS_PACKET     pPkt,
    IN UINT             ifIdx)
{
    PUCHAR      pLayerHdr = NULL, pPktHdr = NULL,  pMacAddr = NULL;
    UINT16      protoType;
    INT         i;
    struct _XATProtoOps     *pHandle = NULL;
    PUCHAR  retSkb = NULL;
    BOOLEAN bVLANPkt = FALSE;


    if(pAd->MatCfg.status != XAT_ENGINE_STAT_INITED)
        return NULL;
    
    pPktHdr = GET_OS_PKT_DATAPTR(pPkt);
    if (!pPktHdr)
        return NULL;
    
    // Get the upper layer protocol type of this 802.3 pkt.
    protoType = OS_NTOHS(*((UINT16 *)(pPktHdr + 12)));

    // handle 802.1q enabled packet. Skip the VLAN tag field to get the protocol type.
    if (protoType == 0x8100)
    {
        protoType = OS_NTOHS(*((UINT16 *)(pPktHdr + 12 + 4)));
        bVLANPkt = TRUE;
    }

    DBGPRINT(RT_DEBUG_INFO,("%s(): protoType=0x%04x\n", __FUNCTION__, protoType));
    
    // For differnet protocol, dispatch to specific handler
    for (i=0; i < MAX_XAT_SUPPORT_PROTO_NUM; i++)
    {
        if (protoType == XATProtoTb[i].protocol)
        {
            pHandle = XATProtoTb[i].pHandle;    // the pHandle must not be null!
            pLayerHdr = bVLANPkt ? (pPktHdr + XAT_VLAN_ETH_HDR_LEN) : (pPktHdr + XAT_ETHER_HDR_LEN);
#ifdef CONFIG_AP_SUPPORT
#ifdef APCLI_SUPPORT
            IF_DEV_CONFIG_OPMODE_ON_AP(pAd)
                pMacAddr = &pAd->ApCfg.ApCliTab[ifIdx].CurrentAddress[0];
#endif // APCLI_SUPPORT //
#endif // CONFIG_AP_SUPPORT //

#ifdef CONFIG_STA_SUPPORT
#ifdef STA_XAT_SUPPORT        
                //pMacAddr=&pAd->CurrentAddress[0];
                pMacAddr=&ATH_MAC_ADDR[0];
#endif //STA_XAT_SUPPORT
#endif // CONFIG_STA_SUPPORT //

            if (pHandle->tx!=NULL)
                retSkb = pHandle->tx((PVOID)&pAd->MatCfg, RTPKT_TO_OSPKT(pPkt), pLayerHdr, pMacAddr);

            return retSkb;
        }
    }
    return retSkb;
}


/*
    ========================================================================
    Routine Description:
        Depends on the Received packet, check the upper layer protocol type
        and search for specific mapping table to find out the real destination 
        MAC address.
        
    Arguments:
        pAd     =>Pointer to our adapter
        pPkt    =>pointer to the 802.11 header of receviced packet 
        infIdx  =>Interface Index want to dispatch to.

    Return Value:
        Success =>
            Mapped mac address if found, else return specific default mac address 
            depends on the upper layer protocol type.
        Error   =>
            NULL

    Note:
    ========================================================================
 */
PUCHAR XATEngineRxHandle(
    IN PRTMP_ADAPTER    pAd,
    IN PNDIS_PACKET     pPkt,
    IN UINT             infIdx)
{
    PUCHAR              pMacAddr = NULL;
    PUCHAR      pLayerHdr = NULL, pPktHdr = NULL;
    UINT16      protoType;
    INT         i =0;
    struct _XATProtoOps     *pHandle = NULL;


    if(pAd->MatCfg.status != XAT_ENGINE_STAT_INITED)
        return NULL;

    pPktHdr = GET_OS_PKT_DATAPTR(pPkt);
    if (!pPktHdr)
        return NULL;

    // If it's a multicast/broadcast packet, we do nothing.
    if (IS_GROUP_MAC(pPktHdr))
        return NULL;

    // Get the upper layer protocol type of this 802.3 pkt and dispatch to specific handler
    protoType = OS_NTOHS(*((UINT16 *)(pPktHdr + 12)));
    DBGPRINT(RT_DEBUG_INFO, ("%s(): protoType=0x%04x\n", __FUNCTION__, protoType));
    for (i=0; i<MAX_XAT_SUPPORT_PROTO_NUM; i++)
    {
        if (protoType == XATProtoTb[i].protocol)
        {
            pHandle = XATProtoTb[i].pHandle;    // the pHandle must not be null!
            pLayerHdr = (pPktHdr + XAT_ETHER_HDR_LEN);
//          RTMP_SEM_LOCK(&XATDBLock);
            if(pHandle->rx!=NULL)
                pMacAddr = pHandle->rx((PVOID)&pAd->MatCfg, RTPKT_TO_OSPKT(pPkt), pLayerHdr, NULL);
//          RTMP_SEM_UNLOCK(&XATDBLock);
            break;
        }
    }

    if (pMacAddr)
        NdisMoveMemory(pPktHdr, pMacAddr, MAC_ADDR_LEN);

    return NULL;

}

 


NDIS_STATUS XATEngineExit(
    IN RTMP_ADAPTER *pAd)
{
    struct _XATProtoOps     *pHandle = NULL;
    int i;

    if(pAd->MatCfg.status == XAT_ENGINE_STAT_EXITED)
        return TRUE;
    
    // For each registered protocol, we call it's exit handler.
    for (i=0; i<MAX_XAT_SUPPORT_PROTO_NUM; i++)
    {
            pHandle = XATProtoTb[i].pHandle;
            if (pHandle->exit!=NULL)
            pHandle->exit(&pAd->MatCfg);
    }

#ifdef KMALLOC_BATCH
    // Free the memory used to store node entries.
    if (pAd->MatCfg.pXATNodeEntryPoll)
    {
        os_mfree(pAd, pAd->MatCfg.pXATNodeEntryPoll);
        pAd->MatCfg.pXATNodeEntryPoll = NULL;
    }
#endif

    pAd->MatCfg.status = XAT_ENGINE_STAT_EXITED;
    
    return TRUE;
    
}

PUCHAR  getBROADCAST_ADDR(void)
{
    return (&BROADCAST_ADDR[0]);
}

PUCHAR  getStaMac_ADDR(void)
{
    return (&ATH_MAC_ADDR[0]);
}

void  setStaMac_ADDR(UCHAR *pMac)
{
    memcpy(&ATH_MAC_ADDR[0], pMac, MAC_ADDR_LEN);
    printk("***New STA MAC for XAT: %02x:%02x:%02x:%02x:%02x:%02x ***\n",
            ATH_MAC_ADDR[0],ATH_MAC_ADDR[1],ATH_MAC_ADDR[2],
            ATH_MAC_ADDR[3],ATH_MAC_ADDR[4],ATH_MAC_ADDR[5]);
}


RTMP_ADAPTER *getAd(void)
{
    return &gAd;
}

NDIS_STATUS XATEngineInit(
    IN RTMP_ADAPTER *pAd)
{
    XATProtoOps     *pHandle = NULL;
    int i, status;
    printk("===========> XATEngineInit \n");
/* Set fix MAC*/
    gAd.CurrentAddress[0]=0x00;
    gAd.CurrentAddress[1]=0x02;
    gAd.CurrentAddress[2]=0x6F;
    gAd.CurrentAddress[3]=0x44;
    gAd.CurrentAddress[4]=0x06;
    gAd.CurrentAddress[5]=0x76;

    printk("BROADCAST_ADDR addr 0x%x\n",(int) &BROADCAST_ADDR[0]);
    printk("pAd addr 0x%x\n",(int) pAd);
    printk("pMatCfg addr 0x%x\n",(int) &pAd->MatCfg);
    if(pAd->MatCfg.status == XAT_ENGINE_STAT_INITED)
        return TRUE;
    
#ifdef KMALLOC_BATCH
    // Allocate memory for node entry, we totally allocate 128 entries and link them together.
    pAd->MatCfg.pXATNodeEntryPoll = kmalloc(sizeof(XATNodeEntry) * MAX_XAT_NODE_ENTRY_NUM, GFP_KERNEL);
    if (pAd->MatCfg.pXATNodeEntryPoll != NULL)
    {
        XATNodeEntry *pPtr=NULL;

        NdisZeroMemory(pAd->MatCfg.pXATNodeEntryPoll, sizeof(XATNodeEntry) * MAX_XAT_NODE_ENTRY_NUM);
        pPtr = pAd->MatCfg.pXATNodeEntryPoll;
        for (i = 0; i < (MAX_XAT_NODE_ENTRY_NUM -1); i++)
        {
            pPtr->next = (XATNodeEntry *)(pPtr+1);
            pPtr = pPtr->next;
        }
        pPtr->next = NULL;
    } else {
        return FALSE;
    }
#endif

    // For each specific protocol, call it's init function.
    for (i = 0; i < MAX_XAT_SUPPORT_PROTO_NUM; i++)
    {
        printk("i %d \n", i);
            pHandle = XATProtoTb[i].pHandle;
        ASSERT(pHandle);
            if (pHandle->init != NULL)
        {
            status = pHandle->init(&pAd->MatCfg);
            if (status == FALSE) 
            {
                DBGPRINT(RT_DEBUG_ERROR, ("XATEngine Init Protocol (0x%x) failed, Stop the XAT Funciton initialization failed!\n", XATProtoTb[i].protocol));
                goto init_failed;
            }
            DBGPRINT(RT_DEBUG_TRACE, ("XATEngine Init Protocol (0x%04x) success!\n", XATProtoTb[i].protocol));
        }
    }

    NdisAllocateSpinLock(&pAd->MatCfg.XATDBLock);
    pAd->MatCfg.pPriv = (VOID *)pAd;
    pAd->MatCfg.status = XAT_ENGINE_STAT_INITED;

    return TRUE;

init_failed:
    // For each specific protocol, call it's exit function.
    for (i = 0; i < MAX_XAT_SUPPORT_PROTO_NUM; i++)
    {
        if ((pHandle = XATProtoTb[i].pHandle) != NULL)
        {
            if (pHandle->exit != NULL)
            {
                status = pHandle->exit(&pAd->MatCfg);
                if (status == FALSE)
                    goto init_failed;
            }
        }
    }

#ifdef KMALLOC_BATCH
    if (pAd->MatCfg.pXATNodeEntryPoll)
        os_mfree(pAd, pAd->MatCfg.pXATNodeEntryPoll);
    pAd->MatCfg.status = XAT_ENGINE_STAT_EXITED;
#endif // KMALLOC_BATCH //

    return FALSE;
    
}


EXPORT_SYMBOL(XATEngineExit);
EXPORT_SYMBOL(XATEngineInit);
EXPORT_SYMBOL(XATEngineTxHandle);
EXPORT_SYMBOL(XATEngineRxHandle);
EXPORT_SYMBOL(getBROADCAST_ADDR);
EXPORT_SYMBOL(getStaMac_ADDR);
EXPORT_SYMBOL(setStaMac_ADDR);
//EXPORT_SYMBOL(dumpPkt);
EXPORT_SYMBOL(getAd);
