
#ifdef XAT_SUPPORT
#include "rt_linux.h"
#include "rtmp.h"
#include "xat.h"

extern PUCHAR  getStaMac_ADDR(void);

static NDIS_STATUS XATProto_IP_Init(XAT_STRUCT *pMatCfg);
static NDIS_STATUS XATProto_IP_Exit(XAT_STRUCT *pMatCfg);
static PUCHAR XATProto_IP_Rx(XAT_STRUCT *pMatCfg, PNDIS_PACKET pSkb, PUCHAR pLayerHdr, PUCHAR pMacAddr);
static PUCHAR XATProto_IP_Tx(XAT_STRUCT *pMatCfg, PNDIS_PACKET pSkb, PUCHAR pLayerHdr, PUCHAR pMacAddr);

static NDIS_STATUS XATProto_ARP_Init(XAT_STRUCT *pMatCfg);
static NDIS_STATUS XATProto_ARP_Exit(XAT_STRUCT *pMatCfg);
static PUCHAR XATProto_ARP_Rx(XAT_STRUCT *pMatCfg, PNDIS_PACKET pSkb, PUCHAR pLayerHdr, PUCHAR pMacAddr);
static PUCHAR XATProto_ARP_Tx(XAT_STRUCT *pMatCfg, PNDIS_PACKET pSkb,PUCHAR pLayerHdr, PUCHAR pMacAddr);

#define IPV4_ADDR_LEN 4

#define NEED_UPDATE_IPMAC_TB(Mac, IP) (IS_UCAST_MAC(Mac) && IS_GOOD_IP(IP))


typedef struct _IPMacMappingEntry
{
    UINT    ipAddr; // In network order
    UCHAR   macAddr[MAC_ADDR_LEN];
    ULONG   lastTime;
    struct _IPMacMappingEntry *pNext;
}IPMacMappingEntry, *PIPMacMappingEntry;


typedef struct _IPMacMappingTable
{
    BOOLEAN         valid;
    IPMacMappingEntry *hash[XAT_MAX_HASH_ENTRY_SUPPORT+1]; //0~63 for specific station, 64 for broadcast MacAddress
}IPMacMappingTable;

#if 0
static IPMacMappingTable IPMacTable=
{
    .valid = FALSE,
}; // Used for IP, ARP protocol
#endif

struct _XATProtoOps XATProtoIPHandle =
{
    .init = XATProto_IP_Init,
    .tx = XATProto_IP_Tx,
    .rx = XATProto_IP_Rx,
    .exit = XATProto_IP_Exit,
};

struct _XATProtoOps XATProtoARPHandle =
{
    .init = XATProto_ARP_Init,
    .tx = XATProto_ARP_Tx,
    .rx = XATProto_ARP_Rx,
    .exit =XATProto_ARP_Exit,
};




VOID dumpIPMacTb(
    IN XAT_STRUCT   *pMatCfg,
    IN int          index)
{
    IPMacMappingTable *pIPMacTable;
    IPMacMappingEntry *pHead;
    int startIdx, endIdx;


    pIPMacTable = (IPMacMappingTable *)pMatCfg->MatTableSet.IPMacTable;
    if (!pIPMacTable)
        return;
    
    if (!pIPMacTable->valid)
    {
        printk("%s():IPMacTable not init yet, so cannot do dump!\n", __FUNCTION__);
        return;
    }
    
    
    if(index < 0)
    {   // dump all.
        startIdx = 0;
        endIdx = XAT_MAX_HASH_ENTRY_SUPPORT;
    }
    else
    {   // dump specific hash index.
        startIdx = endIdx = index;
    }

    printk("%s():\n", __FUNCTION__);
    for(; startIdx<= endIdx; startIdx++)
    {
        pHead = pIPMacTable->hash[startIdx];
        while(pHead)
        {
                printk("IPMac[%d]:\n", startIdx);
                printk("\t:IP=0x%x,Mac=%02x:%02x:%02x:%02x:%02x:%02x, lastTime=0x%lx, next=%p\n", 
                    pHead->ipAddr, pHead->macAddr[0],pHead->macAddr[1],pHead->macAddr[2],
                    pHead->macAddr[3],pHead->macAddr[4],pHead->macAddr[5], pHead->lastTime,
                        pHead->pNext);
            pHead = pHead->pNext;
        }
    }
    printk("\t----EndOfDump!\n");
    
}


static inline NDIS_STATUS getDstIPFromIpPkt(
    IN PUCHAR pIpHdr, 
    IN UINT *dstIP)
{
    
    if (!pIpHdr)
        return FALSE;
    
    NdisMoveMemory(dstIP, (pIpHdr + 16), 4); //shift 16 for IP header len before DstIP.
//  DBGPRINT(RT_DEBUG_TRACE, ("%s(): Get the dstIP=0x%x\n", __FUNCTION__, *dstIP));
    
    return TRUE;
}

static inline NDIS_STATUS getSrcIPFromIpPkt(
    IN PUCHAR pIpHdr,
    IN UINT   *pSrcIP)
{
    
    if (!pIpHdr)
        return FALSE;
    
    NdisMoveMemory(pSrcIP, (pIpHdr + 12), 4); //shift 12 for IP header len before DstIP.
//  DBGPRINT(RT_DEBUG_TRACE, ("%s(): Get the srcIP=0x%x\n", __FUNCTION__, *pSrcIP));
    
    return TRUE;
    
}

static NDIS_STATUS IPMacTableUpdate(
    IN XAT_STRUCT       *pMatCfg,
    IN PUCHAR           pMacAddr,
    IN UINT             ipAddr)
{
    UINT                hashIdx;
    IPMacMappingTable *pIPMacTable;
    IPMacMappingEntry   *pEntry = NULL, *pPrev = NULL, *pNewEntry =NULL;
    ULONG           now;

    pIPMacTable = (IPMacMappingTable *)pMatCfg->MatTableSet.IPMacTable;

    if (!pIPMacTable)
        return FALSE;
        
    if (!pIPMacTable->valid)
        return FALSE;

    hashIdx = XAT_IP_ADDR_HASH_INDEX(ipAddr);

    pEntry = pPrev = pIPMacTable->hash[hashIdx];
    while(pEntry)
    {
        NdisGetSystemUpTime(&now);
        
        // Find a existed IP-MAC Mapping entry
        if (ipAddr == pEntry->ipAddr)
        {
            /*  DBGPRINT(RT_DEBUG_TRACE, ("%s(): Got the Mac(%02x:%02x:%02x:%02x:%02x:%02x) of mapped IP(%d.%d.%d.%d)\n",
                        __FUNCTION__, pEntry->macAddr[0],pEntry->macAddr[1],pEntry->macAddr[2], pEntry->macAddr[3],pEntry->macAddr[4],
                        pEntry->macAddr[5], (ipAddr>>24) & 0xff, (ipAddr>>16) & 0xff, (ipAddr>>8) & 0xff, ipAddr & 0xff)); 
            */
            // compare is useless. So we directly copy it into the entry.
            NdisMoveMemory(pEntry->macAddr, pMacAddr, 6);
            pEntry->lastTime = now;
            return TRUE;
        }
        else
        {   // handle the age-out situation
            //if ((Now - pEntry->lastTime) > XAT_TB_ENTRY_AGEOUT_TIME)
            if (RTMP_TIME_AFTER(now, pEntry->lastTime + XAT_TB_ENTRY_AGEOUT_TIME))
            {
                // Remove the aged entry
                if (pEntry == pIPMacTable->hash[hashIdx])
                {
                    pIPMacTable->hash[hashIdx]= pEntry->pNext;
                    pPrev = pIPMacTable->hash[hashIdx];
                }
                else 
                {   
                    pPrev->pNext = pEntry->pNext;
                }
                XATDBEntryFree(pMatCfg, (PUCHAR)pEntry);

                pEntry = (pPrev == NULL ? NULL: pPrev->pNext);
                pMatCfg->nodeCount--;
            } 
            else
            {
                pPrev = pEntry;
                pEntry = pEntry->pNext;
            }
        }
    }


    // Allocate a new IPMacMapping entry and insert into the hash
    pNewEntry = (IPMacMappingEntry *)XATDBEntryAlloc(pMatCfg, sizeof(IPMacMappingEntry));
    if (pNewEntry != NULL)
    {   
        pNewEntry->ipAddr = ipAddr;
        NdisMoveMemory(pNewEntry->macAddr, pMacAddr, 6);
        pNewEntry->pNext = NULL;
        NdisGetSystemUpTime(&pNewEntry->lastTime);

        if (pIPMacTable->hash[hashIdx] == NULL)
        {   // Hash list is empty, directly assign it.
            pIPMacTable->hash[hashIdx] = pNewEntry;
        } 
        else 
        {
            // Ok, we insert the new entry into the root of hash[hashIdx]
            pNewEntry->pNext = pIPMacTable->hash[hashIdx];
            pIPMacTable->hash[hashIdx] = pNewEntry;
        }
        //dumpIPMacTb(pMatCfg, hashIdx); //for debug

        pMatCfg->nodeCount++;

        return TRUE;
    }

    return FALSE;
}


static PUCHAR IPMacTableLookUp(
    IN XAT_STRUCT   *pMatCfg,
    IN UINT         ipAddr)
{
    IPMacMappingTable *pIPMacTable;
    UINT                hashIdx;
    IPMacMappingEntry   *pEntry = NULL;


    pIPMacTable = (IPMacMappingTable *)pMatCfg->MatTableSet.IPMacTable;

    if (!pIPMacTable)
        return NULL;
        
    if (!pIPMacTable->valid)
        return NULL;
    
    // Use hash to find out the location of that entry and get the Mac address.
    hashIdx = XAT_IP_ADDR_HASH_INDEX(ipAddr);

//  spin_lock_irqsave(&IPMacTabLock, irqFlag);
    pEntry = pIPMacTable->hash[hashIdx];
    while(pEntry)
    {
        if (pEntry->ipAddr == ipAddr)
        {
/*          DBGPRINT(RT_DEBUG_TRACE, ("%s(): dstMac=%02x:%02x:%02x:%02x:%02x:%02x for mapped dstIP(%d.%d.%d.%d)\n", 
                    __FUNCTION__, pEntry->macAddr[0],pEntry->macAddr[1],pEntry->macAddr[2],
                    pEntry->macAddr[3],pEntry->macAddr[4],pEntry->macAddr[5],
                    (ipAddr>>24) & 0xff, (ipAddr>>16) & 0xff, (ipAddr>>8) & 0xff, ipAddr & 0xff)); 
*/
            
            //Update the lastTime to prevent the aging before pDA processed!
            NdisGetSystemUpTime(&pEntry->lastTime);
            
            return pEntry->macAddr;
        }
        else
            pEntry = pEntry->pNext;
    }
    
    // We didn't find any matched Mac address, our policy is treat it as 
    // broadcast packet and send to all.
    return pIPMacTable->hash[IPMAC_TB_HASH_INDEX_OF_BCAST]->macAddr;
    
}


static NDIS_STATUS IPMacTable_RemoveAll(
    IN XAT_STRUCT *pMatCfg)
{
    IPMacMappingEntry *pEntry;
    IPMacMappingTable *pIPMacTable;
    INT     i;


    pIPMacTable = (IPMacMappingTable *)pMatCfg->MatTableSet.IPMacTable;

    if (!pIPMacTable)
        return TRUE;
    
    if (pIPMacTable->valid)
    {   
        pIPMacTable->valid = FALSE;
        for (i=0; i<IPMAC_TB_HASH_ENTRY_NUM; i++)
        {
            while((pEntry = pIPMacTable->hash[i]) != NULL)
            {
                pIPMacTable->hash[i] = pEntry->pNext;
                XATDBEntryFree(pMatCfg, (PUCHAR)pEntry);
            }
        }
    }

    kfree(pIPMacTable);
    pMatCfg->MatTableSet.IPMacTable = NULL;
    
    return TRUE;
    
}

//UCHAR BROADCAST_ADDR2[MAC_ADDR_LEN] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff};
static NDIS_STATUS IPMacTable_init(
    IN XAT_STRUCT *pMatCfg)
{
    IPMacMappingTable *pIPMacTable;
    IPMacMappingEntry *pEntry = NULL;

    //printk("pMatCfg addr 0x%x\n",(int) pMatCfg);
    //printk("BROADCAST_ADDR add 0x%x\n",(int) &BROADCAST_ADDR[0]);
    if (pMatCfg->MatTableSet.IPMacTable != NULL)
    {
        pIPMacTable = (IPMacMappingTable *)pMatCfg->MatTableSet.IPMacTable;
    }
    else
    {
        pMatCfg->MatTableSet.IPMacTable = kmalloc(sizeof(IPMacMappingTable), GFP_KERNEL);
        if (pMatCfg->MatTableSet.IPMacTable)
        {
            pIPMacTable = (IPMacMappingTable *)pMatCfg->MatTableSet.IPMacTable;
            NdisZeroMemory(pIPMacTable, sizeof(IPMacMappingTable));
        } 
        else
        {
            DBGPRINT(RT_DEBUG_ERROR, ("IPMacTable_init(): Allocate memory for IPMacTable failed!\n"));
            return FALSE;
        }
    }
    
    if (pIPMacTable->valid == FALSE)
    {
        //Set the last hash entry (hash[64]) as our default broadcast Mac address
        pEntry = (IPMacMappingEntry *)XATDBEntryAlloc(pMatCfg, sizeof(IPMacMappingEntry));
        if (!pEntry)
        {
            DBGPRINT(RT_DEBUG_ERROR, ("IPMacTable_init(): Allocate memory for IPMacTable broadcast entry failed!\n"));
            return FALSE;
        }
        //pEntry->ipAddr = 0;
        NdisZeroMemory(pEntry, sizeof(IPMacMappingEntry));
        //printk("BROADCAST_ADDR add 0x%x\n",(int) &BROADCAST_ADDR[0]);
#if 0
        printk("BROADCAST_ADDR %02x:%02x:%02x:%02x:%02x:%02x\n",
            BROADCAST_ADDR[0],BROADCAST_ADDR[1],BROADCAST_ADDR[2],
            BROADCAST_ADDR[3],BROADCAST_ADDR[4],BROADCAST_ADDR[5]);
#endif
        //NdisMoveMemory(&pEntry->macAddr[0], &BROADCAST_ADDR2[0], 6);
        NdisMoveMemory(&pEntry->macAddr[0], (PUCHAR)getBROADCAST_ADDR(), 6);

        pEntry->pNext = NULL;
        pIPMacTable->hash[IPMAC_TB_HASH_INDEX_OF_BCAST] = pEntry;
        pIPMacTable->valid = TRUE;
    }
    else
    {
        DBGPRINT(RT_DEBUG_TRACE, ("%s(): IPMacTable already inited!\n", __FUNCTION__));
    }
     return TRUE;
    
}


static NDIS_STATUS XATProto_ARP_Exit(
    IN XAT_STRUCT *pMatCfg)
{
    INT status;
        
    status = IPMacTable_RemoveAll(pMatCfg);

    return status;
}

static PUCHAR XATProto_ARP_Rx(
    IN XAT_STRUCT       *pMatCfg, 
    IN PNDIS_PACKET     pSkb,
    IN PUCHAR           pLayerHdr,
    IN PUCHAR           pMacAddr)
{
    PUCHAR pArpHdr = NULL, pRealMac = NULL;
    PUCHAR  tgtMac, tgtIP;
    BOOLEAN isUcastMac, isGoodIP;

    
    pArpHdr = pLayerHdr;

//dumpPkt(RTPKT_TO_OSPKT(pSkb)->data, RTPKT_TO_OSPKT(pSkb)->len);       
    // We just take care about the target(Mac/IP address) fields.
    tgtMac = pArpHdr + 18;
    tgtIP = tgtMac + 6;
        
    // isUcastMac = !(00:00:00:00:00:00|| mcastMac);
    isUcastMac = ((tgtMac[0]|tgtMac[1]|tgtMac[2]|tgtMac[3]|tgtMac[4]|tgtMac[5])!=0);
    isUcastMac &= ((tgtMac[0] && 0x1)==0);

    // isGoodIP = ip address is not 0.0.0.0
    isGoodIP = (*(UINT *)tgtIP != 0);

    DBGPRINT(RT_DEBUG_INFO, ("%s(): ARP Pkt=>tgtIP=%d.%d.%d.%d, tgtMac=%02x:%02x:%02x:%02x:%02x:%02x\n",
            __FUNCTION__, tgtIP[0], tgtIP[1], tgtIP[2], tgtIP[3],
            tgtMac[0],tgtMac[1],tgtMac[2],tgtMac[3],tgtMac[4],tgtMac[5]));
        
    if (isUcastMac && isGoodIP)
        pRealMac = IPMacTableLookUp(pMatCfg, *(UINT *)tgtIP);
        
    // For need replaced mac, we need to replace the targetMAC as correct one to make 
    // the real receiver can receive that.
    if (isUcastMac && pRealMac)
        NdisMoveMemory(tgtMac, pRealMac, MAC_ADDR_LEN);

    if (pRealMac == NULL)
//        pRealMac = &BROADCAST_ADDR[0];
          pRealMac = (PUCHAR)getBROADCAST_ADDR();
//      pRealMac = pIPMacTable->hash[IPMAC_TB_HASH_INDEX_OF_BCAST]->macAddr;
    
    return pRealMac;
}

static PUCHAR XATProto_ARP_Tx(
    IN XAT_STRUCT       *pMatCfg,
    IN PNDIS_PACKET     pSkb,
    IN PUCHAR           pLayerHdr,
    IN PUCHAR           pMacAddr)
{
    PUCHAR  pSMac, pSIP;
    BOOLEAN isUcastMac, isGoodIP;
    struct arphdr *arpHdr;
    PUCHAR pPktHdr;
 //   PNDIS_PACKET newSkb = NULL;

#if 1 //
    pMacAddr=getStaMac_ADDR();
#endif
#if 0
    printk("%s: pMacAddr =0x%x %02x:%02x:%02x:%02x:%02x:%02x\n", __FUNCTION__, (int) pMacAddr,
            pMacAddr[0],pMacAddr[1],pMacAddr[2],pMacAddr[3],pMacAddr[4],pMacAddr[5]);
#endif
    pPktHdr = RTPKT_TO_OSPKT(pSkb)->data;
    
    arpHdr = (struct arphdr *)pLayerHdr;

    // Check the arp header.
    // We just handle ether type hardware address and IPv4 internet 
    // address type and opcode is  ARP reuqest/response.
    if ((arpHdr->ar_hrd != OS_HTONS(ARPHRD_ETHER)) || (arpHdr->ar_pro != OS_HTONS(ETH_P_IP)) ||
        (arpHdr->ar_op != OS_HTONS(ARPOP_REPLY) && arpHdr->ar_op != OS_HTONS(ARPOP_REQUEST)))
        return NULL;

    // We just take care about the sender(Mac/IP address) fields.
    pSMac =(PUCHAR)(pLayerHdr + 8);
    pSIP = (PUCHAR)(pSMac + MAC_ADDR_LEN);
    
    isUcastMac = IS_UCAST_MAC(pSMac);
    isGoodIP = IS_GOOD_IP(*(UINT *)pSIP);
    
#if 0  
    printk("%s(): ARP Pkt=>senderIP=%d.%d.%d.%d, senderMac=%02x:%02x:%02x:%02x:%02x:%02x\n",
            __FUNCTION__, pSIP[0], pSIP[1], pSIP[2], pSIP[3],
            pSMac[0],pSMac[1],pSMac[2],pSMac[3],pSMac[4],pSMac[5]); 
#endif
    if (isUcastMac && isGoodIP)
        IPMacTableUpdate(pMatCfg, pSMac, *(UINT *)pSIP);

    // For outgoing unicast mac, we need to replace the senderMAC as ourself to make 
    // the receiver can send to us.
#if 1 //cfho
    if (isUcastMac)
    {
//        printk("---> isUcastMac \n");
        if (IS_VLAN_PACKET(RTPKT_TO_OSPKT(pSkb)->data))
            pSMac = (PUCHAR)(RTPKT_TO_OSPKT(pSkb)->data + XAT_VLAN_ETH_HDR_LEN + 8);
        else
            pSMac = (PUCHAR)(RTPKT_TO_OSPKT(pSkb)->data + XAT_ETHER_HDR_LEN + 8);

        ASSERT(pMacAddr);
        NdisMoveMemory(pSMac, pMacAddr, MAC_ADDR_LEN);
        //NdisMoveMemory((PUCHAR)(RTPKT_TO_OSPKT(pSkb)->data +6), pMacAddr, MAC_ADDR_LEN);
    }
    return pSkb;
#else
    if (isUcastMac)
    {
    printk("*** isUcastMac \n");
        if(skb_cloned(RTPKT_TO_OSPKT(pSkb))) 
        {
            newSkb = (PNDIS_PACKET)skb_copy(RTPKT_TO_OSPKT(pSkb), GFP_ATOMIC);
            if(newSkb) 
            {
                if (IS_VLAN_PACKET(RTPKT_TO_OSPKT(newSkb)->data))
                    pSMac = (PUCHAR)(RTPKT_TO_OSPKT(newSkb)->data + XAT_VLAN_ETH_HDR_LEN + 8);
                else
                    pSMac = (PUCHAR)(RTPKT_TO_OSPKT(newSkb)->data + XAT_ETHER_HDR_LEN + 8);
            }
        }

        ASSERT(pMacAddr);
        NdisMoveMemory(pSMac, pMacAddr, MAC_ADDR_LEN);
    }
    return (PUCHAR)newSkb;
#endif

}


static NDIS_STATUS XATProto_ARP_Init(
    IN XAT_STRUCT   *pMatCfg)
{
    BOOLEAN status = FALSE;

    status = IPMacTable_init(pMatCfg);
    
    return status;
}


static NDIS_STATUS XATProto_IP_Exit(
    IN XAT_STRUCT   *pMatCfg)
{
    INT status;
        
    status = IPMacTable_RemoveAll(pMatCfg);

    return status;
}


static PUCHAR XATProto_IP_Rx(
    IN XAT_STRUCT       *pMatCfg, 
    IN PNDIS_PACKET     pSkb,
    IN PUCHAR           pLayerHdr,
    IN PUCHAR           pDevMacAdr)
{
    PUCHAR   pMacAddr;
    UINT    dstIP;
    
    // Fetch the IP addres from the packet header.
    getDstIPFromIpPkt(pLayerHdr, &dstIP);

    DBGPRINT(RT_DEBUG_INFO, ("%s():Receive a IP pkt=>dstIP=0x%x!\n", __FUNCTION__, dstIP));
    pMacAddr = IPMacTableLookUp(pMatCfg, dstIP); 
    
    return pMacAddr;
}

static UCHAR  DHCP_MAGIC[]= {0x63, 0x82, 0x53, 0x63};
static PUCHAR XATProto_IP_Tx(
    IN XAT_STRUCT       *pMatCfg,
    IN PNDIS_PACKET     pSkb,
    IN PUCHAR           pLayerHdr,
    IN PUCHAR           pDevMacAdr)
{
    PUCHAR pSrcMac;
    PUCHAR pSrcIP;
    BOOLEAN needUpdate;
    PUCHAR pPktHdr;

    pPktHdr = RTPKT_TO_OSPKT(pSkb)->data;
    
    pSrcMac = pPktHdr + 6;
    pSrcIP = pLayerHdr + 12;

    DBGPRINT(RT_DEBUG_INFO, ("%s(): Transmit a IP Pkt=>srcIP=0x%x\n", __FUNCTION__, *(UINT *)pSrcIP));

    needUpdate = NEED_UPDATE_IPMAC_TB(pSrcMac, (*(UINT *)pSrcIP));
    if (needUpdate)
        IPMacTableUpdate(pMatCfg, pSrcMac, *(UINT *)pSrcIP);

    //For UDP packet, we need to check about the DHCP packet, to modify the flag of DHCP discovey/request as broadcast.
    if (*(pLayerHdr + 9) == 0x11)
    {
        PUCHAR udpHdr;
        UINT16 srcPort, dstPort;
        
        udpHdr = pLayerHdr + 20;
        srcPort = OS_NTOHS(*((UINT16 *)udpHdr));
        dstPort = OS_NTOHS(*((UINT16 *)(udpHdr+2)));
        
        if (srcPort==68 && dstPort==67) //It's a DHCP packet
        {
            PUCHAR bootpHdr;
            UINT16 bootpFlag;   
            
            bootpHdr = udpHdr + 8;
            bootpFlag = OS_NTOHS(*((UINT16 *)(bootpHdr+10)));
            DBGPRINT(RT_DEBUG_TRACE, ("is bootp packet! bootpFlag=0x%x\n", bootpFlag));
            if (bootpFlag != 0x8000) //check if it's a broadcast request.
            {
                PUCHAR dhcpHdr;
                
                dhcpHdr = bootpHdr + 236;
                
                DBGPRINT(RT_DEBUG_TRACE, ("the DHCP flag is a unicast, dhcp_magic=%02x:%02x:%02x:%02x\n", dhcpHdr[0], dhcpHdr[1], dhcpHdr[2], dhcpHdr[3]));
                if (NdisEqualMemory(dhcpHdr, DHCP_MAGIC, 4))
                {   
                    DBGPRINT(RT_DEBUG_TRACE, ("dhcp magic macthed!\n"));    
                    bootpFlag = OS_HTONS(0x8000);
                    NdisMoveMemory((bootpHdr+10), &bootpFlag, 2);   //Set the bootp flag as broadcast
                    NdisZeroMemory((udpHdr+6), 2); //modify the UDP chksum as zero
                }
            }   
        }
    }

    return NULL;
}


static NDIS_STATUS XATProto_IP_Init(
    IN XAT_STRUCT *pMatCfg)
{
    BOOLEAN status;
    printk("--> XATProto_IP_Init\n");
    status = IPMacTable_init(pMatCfg);
    
    return status;
}


static inline void IPintToIPstr(int ipint, char Ipstr[20])
{
     int temp = 0;
     
     temp = ipint & 0x000FF;
     sprintf(Ipstr, "%d.", temp);
     temp = (ipint>>8) & 0x000FF;
     sprintf(Ipstr, "%s%d.", Ipstr, temp);
     temp = (ipint>>16) & 0x000FF;
     sprintf(Ipstr, "%s%d.", Ipstr, temp);
     temp = (ipint>>24) & 0x000FF;
     sprintf(Ipstr, "%s%d", Ipstr, temp);
}


VOID getIPMacTbInfo(
    IN XAT_STRUCT *pMatCfg, 
    IN char *pOutBuf)
{
    IPMacMappingTable *pIPMacTable;
    IPMacMappingEntry *pHead;
    int startIdx, endIdx;
    char Ipstr[20] = {0};


    pIPMacTable = (IPMacMappingTable *)pMatCfg->MatTableSet.IPMacTable;
    if ((!pIPMacTable) || (!pIPMacTable->valid))
    {
        DBGPRINT(RT_DEBUG_TRACE, ("%s():IPMacTable not init yet!\n", __FUNCTION__));
        return;
    }
        
    // dump all.
    startIdx = 0;
    endIdx = XAT_MAX_HASH_ENTRY_SUPPORT;

    sprintf(pOutBuf, "\n");
    sprintf(pOutBuf+strlen(pOutBuf), "%-18s%-20s\n", "IP", "MAC");
    for(; startIdx< endIdx; startIdx++)
    {
        pHead = pIPMacTable->hash[startIdx];
        while(pHead)
        {
            if (strlen(pOutBuf) > (IW_PRIV_SIZE_MASK - 30))
                break;
            NdisZeroMemory(Ipstr, 20);
            IPintToIPstr(pHead->ipAddr, Ipstr);
            sprintf(pOutBuf+strlen(pOutBuf), "%-18s%02x:%02x:%02x:%02x:%02x:%02x\n",
                Ipstr, pHead->macAddr[0],pHead->macAddr[1],pHead->macAddr[2],
                pHead->macAddr[3],pHead->macAddr[4],pHead->macAddr[5]);
            pHead = pHead->pNext;
        }
    }
}

#endif   // endif of "XAT_SUPPORT"

