<html>
<head>
<title>TRENDNET | TEW-651BR | Wizard</title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
<link rel="stylesheet" href="style.css" type="text/css">
<script language="JavaScript" src="public_msg.js"></script>
<script language="JavaScript" src="public.js"></script>
<script type="text/JavaScript">	
/*IFDEF COMMENT*/
/*********************************************************************
Tip for tracing the wizard page:
Click Next:wz_next()
	verify settings of current page: is_verify_wz_pg()->
	save settings of current page: save_nvram()/save_nvram_wan()->
	initialize setting of next page: restore_nvram()/ restore_nvram_wan()->
	Re-layout page: wz_showhide()/wz_wan_showhide()
Click Back:wz_prev()
	Restore settings of previous page: restore_nvram()/ restore_nvram_wan()->
	Re-layout page: wz_showhide()/wz_wan_showhide()
Click Restart:send_request()
	append corresponding wan_type value to form_wz: append_wan()
Click Exit: wz_exit()	
*********************************************************************/
/*ENDIF COMMENT*/	
var wz_pg_min = 0;			/* First wizard page */
var wz_pg_prev = 0;			/* Last wizard page (only useful when we identify verify failures) */
var wz_pg_cur = 0;			/* Current wizard page */
var wz_pg_wan_setup = 4;	/* First page of WAN setup within wizard process */

var wz_hd = ["TEW-651BR Setup Wizard","Set Password","Choose Time Zone","Set LAN &amp; DHCP Server","Select Internet Connection Type","get by wz4_ConnType","Set Wireless LAN Connection","Setup Complete"];
/*DEF COMMENT*/ /*This array is mapping to wz_wan_xx table, so we should use CMO_UI_FLAG here*/
var wz_wan_hd = ["Set Dynamic IP Address", "Set Fixed IP Address", "Set PPPoE to obtain IP automatically", "Set PPPoE with a fixed IP Address", "Set PPTP Client", "Set L2TP Client", "Set BigPond", "Set PPPoe (Russia)", "Set PPTP Client (Russia)"];

var pwd_value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG";
/*	Set channelist temply, ioctl issue*/
//var wlan0_channel_list = "<% CmoGetStatus("wlan0_channel_list"); %>";
var wlan0_channel_list = "1,2,3,4,5,6,7,8,9,10,11";
var mac_clone_addr = "<% CmoGetStatus("mac_clone_addr"); %>";

/*DEF COMMENT*/ /*password verify*/
function verify_wz_pg_1(){		
	return check_pwd("wz1_pwd", "wz1_pwd_v");	
}

/*DEF COMMENT*/ /*lan verify*/
function verify_wz_pg_3(){	
	var ip = get_by_id("wz3_lan_ipaddr").value;
	var mask = get_by_id("wz3_lan_netmask").value;
	var dhcp = get_by_name("wz3_dhcpd_enable");
	var start_ip = get_by_id("wz3_dhcpd_start").value;
	var end_ip = get_by_id("wz3_dhcpd_end").value;
	var ip_addr_msg = replace_msg(all_ip_addr_msg,"IP address");
	var start_ip_addr_msg = replace_msg(all_ip_addr_msg,"Start IP address");
	var end_ip_addr_msg = replace_msg(all_ip_addr_msg,"End IP address");
	var temp_ip_obj = new addr_obj(ip.split("."), ip_addr_msg, false, false);
	var temp_mask_obj = new addr_obj(mask.split("."), subnet_mask_msg, false, false);
	var temp_start_ip_obj = new addr_obj(start_ip.split("."), start_ip_addr_msg, false, false);
	var temp_end_ip_obj = new addr_obj(end_ip.split("."), end_ip_addr_msg, false, false);
	if (!check_address(temp_ip_obj) || !check_mask(temp_mask_obj)){		
		return false;			
	}
	
	if (dhcp[0].checked){
		if (!check_address(temp_start_ip_obj) || !check_address(temp_end_ip_obj)){
			return false;
		}
		if (!check_domain(temp_ip_obj, temp_mask_obj, temp_start_ip_obj)){
			alert(addstr(msg[MSG2],"Start IP address"));
			return false;
		}
		if (!check_domain(temp_ip_obj, temp_mask_obj, temp_end_ip_obj)){
			alert(addstr(msg[MSG2],"End IP address"));
			return false;
		}
		if (!check_ip_order(temp_start_ip_obj, temp_end_ip_obj)){
			alert(msg[MSG4]);
			return false;
		}
	}	
	get_by_id("dhcpd_last_assign_ip").value = start_ip;
	return true;
}
/*DEF COMMENT*/ /*wireless verify*/
function verify_wz_pg_6(){		
	if ((get_checked_value(get_by_name("wz6_enable"))==1) && !check_ssid("wz6_ssid"))
		return false;
	return true;
}	
/*DEF COMMENT*/ /*wan dhcpc verify*/
function verify_wz_wan_0(){	
	var mac = "";
	for (var i = 1; i < 7; i++){
		mac += get_by_id("mac" + i).value;
		if (i < 6){
			mac += ":";
		}
	}

	if(check_mac_00(mac) == -59)
    {
        alert(msg[MSG59]);
        return false;
    }

	if ((mac != "00:00:00:00:00:00") && (mac != ":::::")){
		if (!check_mac_00(mac)){
			alert(msg[MSG5]);
			return false;
		}
	}	
	get_by_id("wzw0_mac").value = mac;
	return true;
}

function verify_wz_wan_1(){
	var ip = get_by_id("wzw1_wan_static_ipaddr").value;		
	var mask = get_by_id("wzw1_wan_static_netmask").value;
	var gateway = get_by_id("wzw1_wan_static_gw").value;
	var dns1 = get_by_id("wzw1_wan_primary_dns").value;
	var dns2 = get_by_id("wzw1_wan_secondary_dns").value;
	var ip_addr_msg = replace_msg(all_ip_addr_msg,"IP address");
	var gateway_msg = replace_msg(all_ip_addr_msg,"Gateway address");
	var dns1_addr_msg = replace_msg(all_ip_addr_msg,"DNS Server 1");
	var dns2_addr_msg = replace_msg(all_ip_addr_msg,"DNS Server 2");
	var temp_ip_obj = new addr_obj(ip.split("."), ip_addr_msg, false, false);
	var temp_mask_obj = new addr_obj(mask.split("."), subnet_mask_msg, false, false);
	var temp_gateway_obj = new addr_obj(gateway.split("."), gateway_msg, false, false);
	var temp_dns1_obj = new addr_obj(dns1.split("."), dns1_addr_msg, false, false);
	var temp_dns2_obj = new addr_obj(dns2.split("."), dns2_addr_msg, true, false);
	if (!check_lan_setting(temp_ip_obj, temp_mask_obj, temp_gateway_obj)){
		return false;
	}
	if (!check_address(temp_dns1_obj)){
		return false;
	}		
	if (dns2 != "" && dns2 != "0.0.0.0"){
		if (!check_address(temp_dns2_obj)){
			return false;
		}
	}
	return true;
}	

function verify_wz_wan_2(){
	if (!check_pwd("wzw2_pwd", "wzw2_pwd_v")){
		return false;
	}
	return true;
}
/*IFDEF CONFIG_POE*/
function verify_wz_wan_3(){	
	var ip = get_by_id("wzw3_ipaddr").value;
	var ip_addr_msg = replace_msg(all_ip_addr_msg,"IP address");
	var temp_ip_obj = new addr_obj(ip.split("."), ip_addr_msg, false, false);
	if (!check_pwd("wzw3_pwd", "wzw3_pwd_v")){
		return false;
	}
	if (!check_address(temp_ip_obj)){
		return false;
	}
	return true;
}
/*ENDIF CONFIG_POE*/
/*IFDEF CONFIG_PPTP*/
function verify_wz_wan_4(){
	return verify_wan_458("4");
}
/*ENDIF CONFIG_PPTP*/
/*IFDEF CONFIG_L2TP*/	
function verify_wz_wan_5(){
	return verify_wan_458("5");
}
/*ENDIF CONFIG_L2TP*/
/*IFDEF CONFIG_RUSPPTP*/	
function verify_wz_wan_8(){
	return verify_wan_458("8");
}	
/*ENDIF CONFIG_RUSPPTP*/
/*IFDEF CONFIG_BIGPOND*/
function verify_wz_wan_6(){
	return (!check_pwd("wzw6_pwd", "wzw6_pwd_v"))? false: true;	
}
/*ENDIF CONFIG_BIGPOND*/
/*IFDEF CONFIG_RUSPOE*/	
function verify_wz_wan_7(){
	var ip = get_by_id("wzw7_ipaddr").value;
	var pppoe_type = get_by_name("wzw7_dynamic");
	
	if (!check_pwd("wzw7_pwd", "wzw7_pwd_v")){
			return false;
	}
	if (pppoe_type[1].checked){		
		var ip_addr_msg = replace_msg(all_ip_addr_msg,"IP address");
		var temp_ip_obj = new addr_obj(ip.split("."), ip_addr_msg, false, false);		
		if (!check_address(temp_ip_obj)){
			return false;
		}
	}
	return true;
}
/*ENDIF CONFIG_RUSPOE*/

/*DEF COMMENT*//*wz wan page have the same layout*/
function verify_wan_458(page){
	var ip = get_by_id("wzw"+page+"_ipaddr").value;
	var mask = get_by_id("wzw"+page+"_netmask").value;
	var gateway = get_by_id("wzw"+page+"_gw").value;
	var ip_addr_msg = replace_msg(all_ip_addr_msg,"IP address");
	var gateway_msg = replace_msg(all_ip_addr_msg,"Gateway address");
	var temp_ip_obj = new addr_obj(ip.split("."), ip_addr_msg, false, false);
	var temp_mask_obj = new addr_obj(mask.split("."), subnet_mask_msg, false, false);
	var temp_gateway_obj = new addr_obj(gateway.split("."), gateway_msg, false, false);

	if (get_by_name("wzw"+page+"_dynamic")[1].checked){	
		if (!check_lan_setting(temp_ip_obj, temp_mask_obj, temp_gateway_obj)){
			return false;
		}
	}
	if(get_by_id("wzw"+page+"_server").value == ""){
   		alert(msg[MSG40]);
   		return false;
     }
	if (!check_pwd("wzw"+page+"_pwd", "wzw"+page+"_pwd_v")){
		return false;
	}
	return true;
}	
	
function is_verify_wz_pg(page){
	var is_verify = false;
	switch(parseInt(page)){		
		case wz_pg_wan_setup+1:	
			is_verify = eval("verify_wz_wan_"+get_checked_value(get_by_name("wz4_ConnType")))();
			break;
		case 1:
		case 3:
		case 6:
			is_verify = eval("verify_wz_pg_"+page)();
			break;
		default:
			is_verify = true;				
	}	
	return is_verify;
}

function is_modify_pwd(pwd){
 if(pwd==pwd_value)
 	return false;
 return true;	
}	
function save_nvram_wan(conntype){	
	switch(parseInt(conntype)){
		case 0:
			get_by_id("wan_mac").value = get_by_id("wzw0_mac").value;
			get_by_id("hostname").value = get_by_id("wzw0_hostname").value;
			break;
		case 1:	
			get_by_id("wan_specify_dns").value = (get_by_id("wzw1_wan_primary_dns").value =="" || get_by_id("wzw1_wan_primary_dns").value =="0.0.0.0")&& (get_by_id("wzw1_wan_secondary_dns").value =="" || get_by_id("wzw1_wan_secondary_dns").value =="0.0.0.0") 
			? 0 : 1;
			get_by_id("wan_static_ipaddr").value = get_by_id("wzw1_wan_static_ipaddr").value;
			get_by_id("wan_static_netmask").value = get_by_id("wzw1_wan_static_netmask").value;
			get_by_id("wan_static_gateway").value = get_by_id("wzw1_wan_static_gw").value;
			get_by_id("wan_primary_dns").value = get_by_id("wzw1_wan_primary_dns").value;
			get_by_id("wan_secondary_dns").value = get_by_id("wzw1_wan_secondary_dns").value;
			break;	
/*IFDEF CONFIG_POE*/
		case 2:
			get_by_id("wan_pppoe_username_00").value = get_by_id("wzw2_username").value;
			if(is_modify_pwd(get_by_id("wzw2_pwd").value)){
				get_by_id("wan_pppoe_password_00").value = get_by_id("wzw2_pwd").value;
				get_by_id("wzw2_pwd").value=pwd_value;
				get_by_id("wzw2_pwd_v").value=pwd_value;
			}	
			break;
		case 3:
			get_by_id("wan_pppoe_username_00").value = get_by_id("wzw3_username").value;
			if(is_modify_pwd(get_by_id("wzw3_pwd").value)){
				get_by_id("wan_pppoe_password_00").value = get_by_id("wzw3_pwd").value;
				get_by_id("wzw3_pwd").value=pwd_value;
				get_by_id("wzw3_pwd_v").value=pwd_value;
			}	
			get_by_id("wan_pppoe_ipaddr_00").value = get_by_id("wzw3_ipaddr").value;
			break;
/*ENDIF CONFIG_POE*/
/*IFDEF CONFIG_PPTP*/
		case 4:			
			get_by_id("wan_pptp_username").value = get_by_id("wzw4_username").value ;
			if(is_modify_pwd(get_by_id("wzw4_pwd").value)){
				get_by_id("wan_pptp_password").value = get_by_id("wzw4_pwd").value;
				get_by_id("wzw4_pwd").value=pwd_value;
				get_by_id("wzw4_pwd_v").value=pwd_value;
			}	
			get_by_id("wan_pptp_server_ip").value = get_by_id("wzw4_server").value;
			if((get_by_id("wan_pptp_dynamic").value = get_checked_value(get_by_name("wzw4_dynamic")))==1){
				get_by_id("wan_pptp_ipaddr").value = get_by_id("wzw4_ipaddr").value;
				get_by_id("wan_pptp_netmask").value = get_by_id("wzw4_netmask").value;
				get_by_id("wan_pptp_gateway").value = get_by_id("wzw4_gw").value;
			}
			break;
/*ENDIF CONFIG_PPTP*/
/*IFDEF CONFIG_L2TP*/
		case 5:			
			get_by_id("wan_l2tp_username").value = get_by_id("wzw5_username").value ;
			if(is_modify_pwd(get_by_id("wzw5_pwd").value)){
				get_by_id("wan_l2tp_password").value = get_by_id("wzw5_pwd").value;
				get_by_id("wzw5_pwd").value=pwd_value;
				get_by_id("wzw5_pwd_v").value=pwd_value;
			}	
			get_by_id("wan_l2tp_server_ip").value = get_by_id("wzw5_server").value;
			if((get_by_id("wan_l2tp_dynamic").value = get_checked_value(get_by_name("wzw5_dynamic")))==1){
				get_by_id("wan_l2tp_ipaddr").value = get_by_id("wzw5_ipaddr").value;
				get_by_id("wan_l2tp_netmask").value = get_by_id("wzw5_netmask").value;
				get_by_id("wan_l2tp_gateway").value = get_by_id("wzw5_gw").value;
			}			
			break;
/*ENDIF CONFIG_L2TP*/
/*IFDEF CONFIG_BIGPOND*/
		case 6:
			get_by_id("wan_bigpond_username").value = get_by_id("wzw6_username").value;
			if(is_modify_pwd(get_by_id("wzw6_pwd").value)){
				get_by_id("wan_bigpond_password").value = get_by_id("wzw6_pwd").value;
				get_by_id("wzw6_pwd").value=pwd_value;
				get_by_id("wzw6_pwd_v").value=pwd_value;
			}	
			get_by_id("wan_bigpond_auth").value = get_select_value(get_by_id("wzw6_auth"));			
			get_by_id("wan_bigpond_auth").value = get_by_id("wzw6_auth").value;
			get_by_id("wan_bigpond_server").value = get_by_id("wzw6_server").value;
			break;
/*ENDIF CONFIG_BIGPOND*/
/*IFDEF CONFIG_RUSPOE*/
		case 7:			
			get_by_id("wan_pppoe_username_00").value = get_by_id("wzw7_username").value;
			if(is_modify_pwd(get_by_id("wzw7_pwd").value)){
				get_by_id("wan_pppoe_password_00").value = get_by_id("wzw7_pwd").value;
				get_by_id("wzw7_pwd").value=pwd_value;
				get_by_id("wzw7_pwd_v").value=pwd_value;
			}	
			if((get_by_id("wan_pppoe_dynamic_00").value = get_checked_value(get_by_name("wzw7_dynamic")))==1)
				get_by_id("wan_pppoe_ipaddr_00").value = get_by_id("wzw7_ipaddr").value;
			break;
/*ENDIF CONFIG_RUSPOE*/
/*IFDEF CONFIG_RUSPPTP*/
		case 8:			
			get_by_id("wan_pptp_username").value = get_by_id("wzw8_username").value;
			if(is_modify_pwd(get_by_id("wzw8_pwd").value)){
				get_by_id("wan_pptp_password").value = get_by_id("wzw8_pwd").value;
				get_by_id("wzw8_pwd").value=pwd_value;
				get_by_id("wzw8_pwd_v").value=pwd_value;
			}	
			get_by_id("wan_pptp_server_ip").value = get_by_id("wzw8_server").value;
			if((get_by_id("wan_pptp_dynamic").value = get_checked_value(get_by_name("wzw8_dynamic")))==1){
				get_by_id("wan_pptp_ipaddr").value = get_by_id("wzw8_ipaddr").value;
				get_by_id("wan_pptp_netmask").value = get_by_id("wzw8_netmask").value;
				get_by_id("wan_pptp_gateway").value = get_by_id("wzw8_gw").value;
			}			
			break;
/*ENDIF CONFIG_RUSPPTP*/
	}	
}

function save_wan_type(){	
	var wan_type=get_checked_value(get_by_name("wz4_ConnType"));
/*DEF CONFIG_RUSPOE*/			get_by_id("wan_pppoe_russia_enable").value = 0;
/*DEF CONFIG_RUSPPTP*/			get_by_id("wan_pptp_russia_enable").value = 0;
	switch(parseInt(wan_type)){		
		case 0:
			get_by_id("wan_proto").value = "dhcpc";
			break;
		case 1:
			get_by_id("wan_proto").value = "static";
			break;
		case 2:
			get_by_id("wan_proto").value = "pppoe";
			get_by_id("wan_pppoe_dynamic_00").value ="1";
			break;
/*IFDEF	CONFIG_POE*/				
		case 3:	
			get_by_id("wan_proto").value = "pppoe";
			get_by_id("wan_pppoe_dynamic_00").value ="0";
			break;
/*ENDIF	CONFIG_POE*/	
/*IFDEF	CONFIG_PPTP*/			
		case 4:
			get_by_id("wan_proto").value = "pptp";
			break;
/*ENDIF	CONFIG_PPTP*/	
/*IFDEF	CONFIG_L2TP*/			
		case 5:
			get_by_id("wan_proto").value = "l2tp";
			break;
/*ENDIF	CONFIG_L2TP*/	
/*IFDEF	CONFIG_BIGPOND*/
		case 6:
			get_by_id("wan_proto").value = "bigpond";			
			break;
/*ENDIF	CONFIG_BIGPOND*/			
/*IFDEF	CONFIG_RUSPOE*/			
		case 7:
			get_by_id("wan_proto").value = "pppoe";
			get_by_id("wan_pppoe_russia_enable").value = 1;
/*DEF CONFIG_RUSPPTP*/			get_by_id("wan_pptp_russia_enable").value = 0;
			break;
/*ENDIF	CONFIG_RUSPOE*/			
/*IFDEF	CONFIG_RUSPPTP*/			
		case 8:
			get_by_id("wan_proto").value = "pptp";
/*DEF CONFIG_RUSPOE*/			get_by_id("wan_pppoe_russia_enable").value = 1;
			get_by_id("wan_pptp_russia_enable").value = 1;			
			break;
/*ENDIF	CONFIG_RUSPPTP*/			
	}	
}	

function save_nvram(page){		
	switch(parseInt(page)){
		case 1:
			if(is_modify_pwd(get_by_id("wz1_pwd").value)){
				get_by_id("admin_password").value = get_by_id("wz1_pwd").value;
				get_by_id("wz1_pwd").value=pwd_value;
				get_by_id("wz1_pwd_v").value=pwd_value;
			}	
			break;
		case 2:
			get_by_id("time_zone_area").value = get_by_id("wz2_time_zone").selectedIndex;
			break;
		case 3:
			get_by_id("lan_ipaddr").value = get_by_id("wz3_lan_ipaddr").value;
			get_by_id("lan_netmask").value = get_by_id("wz3_lan_netmask").value;
			get_by_id("dhcpd_enable").value = get_checked_value(get_by_name("wz3_dhcpd_enable"));
			get_by_id("dhcpd_start").value = get_by_id("wz3_dhcpd_start").value;
			get_by_id("dhcpd_end").value = get_by_id("wz3_dhcpd_end").value;
			break;	
		case wz_pg_wan_setup:			
			save_wan_type();
			break;	
		case wz_pg_wan_setup+1:		
			save_nvram_wan(get_checked_value(get_by_name("wz4_ConnType")));
			break;
		case 6:
			if((get_by_id("wlan0_enable").value = get_checked_value(get_by_name("wz6_enable")))==1){			
				get_by_id("wlan0_ssid").value = a_to_hex(get_by_id("wz6_ssid").value);
				get_by_id("wlan0_channel").value = get_select_value(get_by_id("wz6_channel"));
			}
			break;	
	}	
}	

function restore_wan_type(){
	var wan_mode = get_by_id("wan_proto").value;
	var wan_pppoe_mode = get_by_id("wan_pppoe_dynamic_00").value;
/*DEF CONFIG_RUSPOE*/	var rus_pppoe = get_by_id("wan_pppoe_russia_enable").value;
/*DEF CONFIG_RUSPPTP*/	var rus_pptp = get_by_id("wan_pptp_russia_enable").value;
	var ConnTypeValue = "";

/*IFDEF CONFIG_RUSPOE*/		
		if(wan_mode=="pppoe" && rus_pppoe =="1"){
			ConnTypeValue="7";				
		}else 
/*ENDIF CONFIG_RUSPOE*/
/*IFDEF CONFIG_RUSPPTP*/
		if(wan_mode=="pptp" && rus_pptp =="1"){
			ConnTypeValue="8";				
		}else 
/*ENDIF CONFIG_RUSPOE*/	
/*IFDEF CONFIG_BIGPOND*/
		if(wan_mode=="bigpond"){
			ConnTypeValue="6";
		}else 
/*ENDIF CONFIG_BIGPOND*/
		if(wan_mode=="pppoe"){
			if(wan_pppoe_mode =="0"){
				ConnTypeValue="3";
			}else{
				ConnTypeValue="2";
			}
		}else if(wan_mode=="pptp"){
			ConnTypeValue="4";
		}else if(wan_mode=="l2tp"){
			ConnTypeValue="5";
		}else if(wan_mode=="static"){
			ConnTypeValue="1";
		}else if(wan_mode=="dhcpc"){
			ConnTypeValue="0";
		}
		set_checked(ConnTypeValue,get_by_name("wz4_ConnType"));	
}

function set_channel(channel_list, current_channel,obj){	
	var ch = channel_list.split(",");	
	var count = 0;

	for (var i = 0; i < ch.length; i++){			
		var oOption = document.createElement("OPTION");						
		oOption.text = ch[i];
		oOption.value = ch[i];				
		obj.options[count++] = oOption;
		if (ch[i] == current_channel){
			oOption.selected = true;
		}        		
	}
}

function restore_nvram_wan(conntype){	
	var dat = get_by_id("wan_curr_ipaddr").value.split("/");
	switch(parseInt(conntype)){
		case 0:			
			set_mac(get_by_id("wan_mac").value, ":");
			get_by_id("wzw0_hostname").value = get_by_id("hostname").value;			
			break;
		case 1:			
			get_by_id("wzw1_wan_static_ipaddr").value = (dat[0] !="0.0.0.0" && get_by_id("wan_static_ipaddr").value == "0.0.0.0") ? dat[0]: get_by_id("wan_static_ipaddr").value;
			get_by_id("wzw1_wan_static_netmask").value = (dat[1] !="0.0.0.0" && get_by_id("wan_static_netmask").value == "0.0.0.0") ? dat[0]: get_by_id("wan_static_netmask").value;
			get_by_id("wzw1_wan_static_gw").value = get_by_id("wan_static_gateway").value;
			get_by_id("wzw1_wan_primary_dns").value = get_by_id("wan_primary_dns").value;
			get_by_id("wzw1_wan_secondary_dns").value = get_by_id("wan_secondary_dns").value;
			break;
/*IFDEF CONFIG_POE*/
		case 2:
			get_by_id("wzw2_username").value = get_by_id("wan_pppoe_username_00").value;
			get_by_id("wzw2_pwd").value = pwd_value;
			get_by_id("wzw2_pwd_v").value = pwd_value;
			break;
		case 3:
			get_by_id("wzw3_username").value = get_by_id("wan_pppoe_username_00").value;
			get_by_id("wzw3_pwd").value = pwd_value;
			get_by_id("wzw3_pwd_v").value = pwd_value;
			get_by_id("wzw3_ipaddr").value = get_by_id("wan_pppoe_ipaddr_00").value;
			break;
/*ENDIF CONFIG_POE*/
/*IFDEF CONFIG_PPTP*/
		case 4:
			set_checked(get_by_id("wan_pptp_dynamic").value, get_by_name("wzw4_dynamic"));
			get_by_id("wzw4_username").value = get_by_id("wan_pptp_username").value;
			get_by_id("wzw4_pwd").value = pwd_value;
			get_by_id("wzw4_pwd_v").value = pwd_value;
			get_by_id("wzw4_ipaddr").value = (dat[0] !="0.0.0.0" && get_by_id("wan_pptp_ipaddr").value == "0.0.0.0") ? dat[0]: get_by_id("wan_pptp_ipaddr").value;
			get_by_id("wzw4_netmask").value = (dat[1] !="0.0.0.0" && get_by_id("wan_pptp_netmask").value == "0.0.0.0") ? dat[0]: get_by_id("wan_pptp_netmask").value;
			get_by_id("wzw4_gw").value = get_by_id("wan_pptp_gateway").value;
			get_by_id("wzw4_server").value = get_by_id("wan_pptp_server_ip").value;
			disable_dhcp_static_address(get_by_name("wzw4_dynamic"), get_by_id("wzw4_ipaddr"), get_by_id("wzw4_netmask"), get_by_id("wzw4_gw"));
			break;
/*ENDIF CONFIG_PPTP*/
/*IFDEF CONFIG_L2TP*/
		case 5:
			set_checked(get_by_id("wan_l2tp_dynamic").value, get_by_name("wzw5_dynamic"));
			get_by_id("wzw5_username").value = get_by_id("wan_l2tp_username").value;
			get_by_id("wzw5_pwd").value = pwd_value;
			get_by_id("wzw5_pwd_v").value = pwd_value;
			get_by_id("wzw5_ipaddr").value = (dat[0] !="0.0.0.0" && get_by_id("wan_l2tp_ipaddr").value == "0.0.0.0") ? dat[0]: get_by_id("wan_l2tp_ipaddr").value;
			get_by_id("wzw5_netmask").value = (dat[1] !="0.0.0.0" && get_by_id("wan_l2tp_netmask").value == "0.0.0.0") ? dat[0]: get_by_id("wan_l2tp_netmask").value;
			get_by_id("wzw5_gw").value = get_by_id("wan_l2tp_gateway").value;
			get_by_id("wzw5_server").value = get_by_id("wan_l2tp_server_ip").value;
			disable_dhcp_static_address(get_by_name("wzw5_dynamic"), get_by_id("wzw5_ipaddr"), get_by_id("wzw5_netmask"), get_by_id("wzw5_gw"));
			break;
/*ENDIF CONFIG_L2TP*/
/*IFDEF CONFIG_BIGPOND*/
		case 6:
			get_by_id("wzw6_username").value = get_by_id("wan_bigpond_username").value;
			get_by_id("wzw6_pwd").value = pwd_value;
			get_by_id("wzw6_pwd_v").value = pwd_value;
			set_selectIndex(get_by_id("wan_bigpond_auth").value,get_by_id("wzw6_auth"));
			get_by_id("wzw6_auth").value = get_by_id("wan_bigpond_auth").value;
			get_by_id("wzw6_server").value = get_by_id("wan_bigpond_server").value;
			break;
/*ENDIF CONFIG_BIGPOND*/
/*IFDEF CONFIG_RUSPOE*/
		case 7:
			set_checked(get_by_id("wan_pppoe_dynamic_00").value, get_by_name("wzw7_dynamic"));
			get_by_id("wzw7_username").value = get_by_id("wan_pppoe_username_00").value;
			get_by_id("wzw7_pwd").value = pwd_value;
			get_by_id("wzw7_pwd_v").value = pwd_value;
			get_by_id("wzw7_ipaddr").value = get_by_id("wan_pppoe_ipaddr_00").value;
			get_by_id("wzw7_ipaddr").disabled=(get_checked_value(get_by_name("wzw7_dynamic")))?true:false;
			break;
/*ENDIF CONFIG_RUSPOE*/
/*IFDEF CONFIG_RUSPPTP*/
		case 8:
			set_checked(get_by_id("wan_pptp_dynamic").value, get_by_name("wzw8_dynamic"));
			get_by_id("wzw8_username").value = get_by_id("wan_pptp_username").value;
			get_by_id("wzw8_pwd").value = pwd_value;
			get_by_id("wzw8_pwd_v").value = pwd_value;
			get_by_id("wzw8_ipaddr").value = (dat[0] !="0.0.0.0" && get_by_id("wan_pptp_ipaddr").value == "0.0.0.0") ? dat[0]: get_by_id("wan_pptp_ipaddr").value;
			get_by_id("wzw8_netmask").value = (dat[1] !="0.0.0.0" && get_by_id("wan_pptp_netmask").value == "0.0.0.0") ? dat[0]: get_by_id("wan_pptp_netmask").value;
			get_by_id("wzw8_gw").value = get_by_id("wan_pptp_gateway").value;
			get_by_id("wzw8_server").value = get_by_id("wan_pptp_server_ip").value;
			disable_dhcp_static_address(get_by_name("wzw8_dynamic"), get_by_id("wzw8_ipaddr"), get_by_id("wzw8_netmask"), get_by_id("wzw8_gw"));
			break;
/*ENDIF CONFIG_RUSPPTP*/
	}	
}
	
function restore_nvram(page){	
	switch(parseInt(page)){
		case 1:
			get_by_id("wz1_pwd").value = pwd_value;
			get_by_id("wz1_pwd_v").value = pwd_value;
			break;
		case 2:
			get_by_id("wz2_time_zone").selectedIndex = get_by_id("time_zone_area").value;
			break;
		case 3:
			get_by_id("wz3_lan_ipaddr").value =	get_by_id("lan_ipaddr").value;
			get_by_id("wz3_lan_netmask").value =	get_by_id("lan_netmask").value;
			set_checked(get_by_id("dhcpd_enable").value, get_by_name("wz3_dhcpd_enable"));
			disable_dhcp(get_by_name("wz3_dhcpd_enable")[1].checked, get_by_id("wz3_dhcpd_start"), get_by_id("wz3_dhcpd_end"));
			get_by_id("wz3_dhcpd_start").value =	get_by_id("dhcpd_start").value;
			get_by_id("wz3_dhcpd_end").value =	get_by_id("dhcpd_end").value;			
			break;
		case wz_pg_wan_setup:
			restore_wan_type();
			break;
		case wz_pg_wan_setup+1:			
			restore_nvram_wan(get_checked_value(get_by_name("wz4_ConnType")));
			break;	
		case 6:
			set_checked(get_by_id("wlan0_enable").value, get_by_name("wz6_enable"));
			get_by_id("wz6_ssid").value = ReplaceRecover(hex_to_a(get_by_id("wlan0_ssid").value));
			set_channel(wlan0_channel_list,get_by_id("wlan0_channel").value, get_by_id("wz6_channel"));
			disable_wz6(get_checked_value(get_by_name("wz6_enable")));
			break;
	
	}	
}	

function disable_wz6(enable){	
	get_by_id("wz6_ssid").disabled = (enable==0) ? true: false;
	get_by_id("wz6_channel").disabled = (enable==0) ? true: false;
}
	
function wz_showhide(){	
	get_by_id("st_wz").style.display = wz_pg_cur==wz_pg_min ? "block" : "none";
	get_by_id("wz_prev_b").style.display = wz_pg_cur==wz_pg_min ? "none" : "";
	get_by_id("wz_next_b").style.display = (wz_pg_cur==wz_hd.length-1) ? "none" : "";
	get_by_id("wz_save_b").style.display = (wz_pg_cur==wz_hd.length-1) ? "" : "none";
	
	get_by_id("wz_hd").innerHTML = wz_hd[wz_pg_cur];
	for (var i = 0; i < wz_hd.length; i++) {		
			get_by_id("wz_pg_" + i).style.display = wz_pg_cur == i ? "block" : "none";
	}
	resizeInnerTo(getLeft(get_by_id("wz_size"))+get_by_id("wz_size").width, getTop(get_by_id("wz_size"))+get_by_id("wz_size").offsetHeight);
}

function wz_wan_showhide(ConnType){	
	for (var i = 0; i < wz_wan_hd.length; i++) {
		try{
		get_by_id("wz_wan_" + i).style.display = ConnType == i ? "block" : "none";
		} catch(error){
			/*ignore error while wan type not Compiled*/
		}
	}
}
	
function wz_next(){
	/*Verify and save values of current page to nvram*/
	if(!is_verify_wz_pg(wz_pg_cur))	
		return false;
	save_nvram(wz_pg_cur);	
	
	wz_pg_prev = wz_pg_cur;
	wz_pg_cur++;
	//load setting to page
	restore_nvram(wz_pg_cur);
	/*Re-display layout*/
	if((wz_pg_cur-1) == wz_pg_wan_setup){
		wz_hd[wz_pg_cur] = wz_wan_hd[get_checked_value(get_by_name("wz4_ConnType"))];
		wz_wan_showhide(get_checked_value(get_by_name("wz4_ConnType")));
	}
	wz_showhide();
}

function wz_prev(){	
	/* restore settings of current page.*/
	restore_nvram(wz_pg_cur);
	wz_pg_prev = wz_pg_cur;
	wz_pg_cur--;
	wz_showhide();
}		

function wz_exit(){    
    var error_msg = "Quit setup wizard and discard settings?";
    if (confirm(error_msg)){
        window.close();
    }
}

function OnPageLoad(){			
	set_checked(get_by_id("blank_status").value, get_by_name("start_wizard"));
	wz_showhide();	
}

function append_wireless(aform){
	if(parseInt(get_by_id("wlan0_enable").value)==1){
		get_by_id(aform).appendChild(get_by_id("wlan0_ssid"));
		get_by_id(aform).appendChild(get_by_id("wlan0_channel"));
	}	
}	
function append_wan(aform){
	var wan_type=get_checked_value(get_by_name("wz4_ConnType"));
	switch(parseInt(wan_type)){
		case 0:
			get_by_id(aform).appendChild(get_by_id("hostname"));
			get_by_id(aform).appendChild(get_by_id("wan_mac"));
			break;
		case 1:
			get_by_id(aform).appendChild(get_by_id("wan_static_ipaddr"));
			get_by_id(aform).appendChild(get_by_id("wan_static_netmask"));
			get_by_id(aform).appendChild(get_by_id("wan_static_gateway"));
			get_by_id(aform).appendChild(get_by_id("wan_specify_dns"));
			get_by_id(aform).appendChild(get_by_id("wan_primary_dns"));
			get_by_id(aform).appendChild(get_by_id("wan_secondary_dns"));
			break;
/*IFDEF	CONFIG_POE*/
		case 2:						
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_dynamic_00"));
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_username_00"));
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_password_00"));					
			break;
		case 3:		
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_dynamic_00"));
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_username_00"));
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_password_00"));
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_ipaddr_00"));
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_netmask_00"));
			break;
/*ENDIF	CONFIG_POE*/	
/*IFDEF	CONFIG_PPTP*/			
		case 4:		
			get_by_id(aform).appendChild(get_by_id("wan_pptp_dynamic"));
			get_by_id(aform).appendChild(get_by_id("wan_pptp_username"));
			get_by_id(aform).appendChild(get_by_id("wan_pptp_password"));
			get_by_id(aform).appendChild(get_by_id("wan_pptp_server_ip"));
			if(get_by_id("wan_pptp_dynamic").value =="0"){
				get_by_id(aform).appendChild(get_by_id("wan_pptp_ipaddr"));
				get_by_id(aform).appendChild(get_by_id("wan_pptp_netmask"));
				get_by_id(aform).appendChild(get_by_id("wan_pptp_gateway"));
			}			
			break;
/*ENDIF	CONFIG_PPTP*/	
/*IFDEF	CONFIG_L2TP*/			
		case 5:
			get_by_id(aform).appendChild(get_by_id("wan_l2tp_dynamic"));
			get_by_id(aform).appendChild(get_by_id("wan_l2tp_username"));
			get_by_id(aform).appendChild(get_by_id("wan_l2tp_password"));
			get_by_id(aform).appendChild(get_by_id("wan_l2tp_server_ip"));
			if(get_by_id("wan_l2tp_dynamic").value =="0"){
				get_by_id(aform).appendChild(get_by_id("wan_l2tp_ipaddr"));
				get_by_id(aform).appendChild(get_by_id("wan_l2tp_netmask"));
				get_by_id(aform).appendChild(get_by_id("wan_l2tp_gateway"));
			}			
			break;
/*ENDIF	CONFIG_L2TP*/	
/*IFDEF	CONFIG_BIGPOND*/
		case 6:
			get_by_id(aform).appendChild(get_by_id("wan_bigpond_username"));
			get_by_id(aform).appendChild(get_by_id("wan_bigpond_password"));
			get_by_id(aform).appendChild(get_by_id("wan_bigpond_auth"));
			get_by_id(aform).appendChild(get_by_id("wan_bigpond_server"));			
			break;
/*ENDIF	CONFIG_BIGPOND*/			
/*IFDEF	CONFIG_RUSPOE*/			
		case 7:
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_dynamic_00"));
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_username_00"));
			get_by_id(aform).appendChild(get_by_id("wan_pppoe_password_00"));
			if(get_by_id("wan_pppoe_dynamic_00")==1){
				get_by_id(aform).appendChild(get_by_id("wan_pppoe_ipaddr_00"));
				get_by_id(aform).appendChild(get_by_id("wan_pppoe_netmask_00"));
			}
			break;
/*ENDIF	CONFIG_RUSPOE*/
/*IFDEF	CONFIG_RUSPPTP*/
		case 8:
			get_by_id(aform).appendChild(get_by_id("wan_pptp_dynamic"));
			get_by_id(aform).appendChild(get_by_id("wan_pptp_username"));
			get_by_id(aform).appendChild(get_by_id("wan_pptp_password"));
			get_by_id(aform).appendChild(get_by_id("wan_pptp_server_ip"));
			if(get_by_id("wan_pptp_dynamic").value =="0"){
				get_by_id(aform).appendChild(get_by_id("wan_pptp_ipaddr"));
				get_by_id(aform).appendChild(get_by_id("wan_pptp_netmask"));
				get_by_id(aform).appendChild(get_by_id("wan_pptp_gateway"));
			}			
			break;
/*ENDIF	CONFIG_RUSPPTP*/			
	}	
}	
function send_request(sform){
	var html_response_return_page =window.opener.location.href;	
	html_response_return_page = html_response_return_page.substring(html_response_return_page.lastIndexOf("\/")+1);
	get_by_id("html_response_return_page").value = html_response_return_page;
	append_wan(sform);
	append_wireless(sform);
	send_submit(sform);
	window.opener.location.href="back_wizard_reboot.asp";
	window.close();
}

function send_st_wz(sform){
	get_by_id("blank_status").value	= get_checked_value(get_by_name("start_wizard"));
	send_submit(sform);
	if("<% CmoGetStatus("get_current_user"); %>" == "user"){
		window.opener.location.href="user_page.asp";	
		window.close();
	}	
}	
</script>
</head>
<body onLoad="OnPageLoad();">	
<table width="450" border="0" cellpadding="0" cellspacing="0">
  <tr>
    <td width="21"><img src="c1_tl.gif" width="21" height="21"></td>
    <td width="708" background="bg1_t.gif"><img src="top_1.gif" width="450" height="21"></td>
    <td width="21"><img src="c1_tr.gif" width="21" height="21"></td>
  </tr>
  
  <tr>
    <td valign="top" background="bg1_l.gif"><img src="top_2.gif" width="21" height="69"></td>
    <td valign="top" id="content_container" bgcolor="#000000">    
<DIV class="headerwizard" id="wz_hd" width="98%"></DIV><!-- show header-->

<table id="wz_pg_0" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr><td><b>Step 1. </b><span>Set your new password </span></td></tr>
    <tr><td><b>Step 2. </b><span>Choose your time zone </span></td></tr>
    <tr><td><b>Step 3. </b><span>Set LAN connection and DHCP Server </span></td></tr>
    <tr><td><b>Step 4. </b><span>Set Internet connection</span></td></tr>
    <tr><td><b>Step 5. </b><span>Set wireless LAN connection</span></td></tr>
    <tr><td><b>Step 6. </b><span>Restart</span></td></tr>
</table><!-- End of wz_pg_0-->	    	

<table id="wz_pg_1" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
    <tr><td width="144"  class="wizleft"><b>Password</b></td>
        <td width="235" class="wizright">
           <input type="password" id="wz1_pwd" size="20" maxlength="15" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
    </td></tr>
    <tr><td width="144" class="wizleft"><b>Verify Password</b></td>
        <td width="235" class="wizright">
    	  <input type="password" id="wz1_pwd_v" size="20" maxlength="15" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
    </td></tr>
</table><!-- End of wz_pg_1 -->

<table id="wz_pg_2" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
    <tr><td>
        <select id="wz2_time_zone" name="wz2_time_zone">
        <option value="-192">(GMT-12:00) Eniwetok, Kwajalein</option>
                            <option value="-176">(GMT-11:00) Midway Island, Samoa</option>
                            <option value="-160">(GMT-10:00) Hawaii</option>
                            <option value="-144">(GMT-09:00) Alaska</option>
                            <option value="-128">(GMT-08:00) Pacific Time (US/Canada), Tijuana</option>
                            <option value="-112">(GMT-07:00) Arizona</option>
                            <option value="-112">(GMT-07:00) Mountain Time (US/Canada)</option>
                            <option value="-96">(GMT-06:00) Central America</option>
                            <option value="-96">(GMT-06:00) Central Time (US/Canada)</option>
                            <option value="-96">(GMT-06:00) Mexico City</option>
                            <option value="-96">(GMT-06:00) Saskatchewan</option>
                            <option value="-80">(GMT-05:00) Bogota, Lima, Quito</option>
                            <option value="-80">(GMT-05:00) Eastern Time (US/Canada)</option>
                            <option value="-80">(GMT-05:00) Indiana (East)</option>
                            <option value="-64">(GMT-04:00) Atlantic Time (Canada)</option>
                            <option value="-64">(GMT-04:00) Caracas, La Paz</option>
                            <option value="-64">(GMT-04:00) Santiago</option>
                            <option value="-48">(GMT-03:30) Newfoundland</option>
                            <option value="-48">(GMT-03:00) Brazilia</option>
                            <option value="-48">(GMT-03:00) Buenos Aires, Georgetown</option>
                            <option value="-48">(GMT-03:00) Greenland</option>
                            <option value="-32">(GMT-02:00) Mid-Atlantic</option>
                            <option value="-16">(GMT-01:00) Azores</option>
                            <option value="-16">(GMT-01:00) Cape Verde Is.</option>
                            <option value="0">(GMT) Casablanca, Monrovia</option>
                            <option value="0">(GMT) Greenwich Time: Dublin, Edinburgh, Lisbon, London</option>
                            <option value="16">(GMT+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm</option>
                            <option value="16">(GMT+01:00) Belgrade, Brastislava, Ljubljana</option>
                            <option value="16">(GMT+01:00) Brussels, Copenhagen, Madrid, Paris</option>
                            <option value="16">(GMT+01:00) Sarajevo, Skopje, Sofija, Vilnus, Zagreb</option>
                            <option value="16">(GMT+01:00) Budapest, Vienna, Prague, Warsaw</option>
                            <option value="16">(GMT+01:00) West Central Africa</option>
                            <option value="32">(GMT+02:00) Athens, Istanbul, Minsk</option>
                            <option value="32">(GMT+02:00) Bucharest</option>
                            <option value="32">(GMT+02:00) Cairo</option>
                            <option value="32">(GMT+02:00) Harare, Pretoria</option>
                            <option value="32">(GMT+02:00) Helsinki, Riga, Tallinn</option>
                            <option value="32">(GMT+02:00) Jerusalem</option>
                            <option value="48">(GMT+03:00) Baghdad</option>
                            <option value="48">(GMT+03:00) Kuwait, Riyadh</option>
                            <option value="48">(GMT+03:00) Moscow, St. Petersburg, Volgograd</option>
                            <option value="48">(GMT+03:00) Nairobi</option>
                            <option value="48">(GMT+03:00) Tehran</option>
                            <option value="64">(GMT+04:00) Abu Dhabi, Muscat</option>
                            <option value="64">(GMT+04:00) Baku, Tbilisi, Yerevan</option>
                            <option value="72">(GMT+04:30) Kabul</option>
                            <option value="80">(GMT+05:00) Ekaterinburg</option>
                            <option value="80">(GMT+05:00) Islamabad, Karachi, Tashkent</option>
                            <option value="88">(GMT+05:30) Calcutta, Chennai, Mumbai, New Delhi</option>
                            <option value="92">(GMT+05:45) Kathmandu</option>
                            <option value="96">(GMT+06:00) Almaty, Novosibirsk</option>
                            <option value="96">(GMT+06:00) Astana, Dhaka</option>
                            <option value="96">(GMT+06:00) Sri Jayawardenepura</option>
							<option value="104">(GMT+06:30) Rangoon</option>
                            <option value="112">(GMT+07:00) Bangkok, Hanoi, Jakarta</option>
                            <option value="112">(GMT+07:00) Krasnoyarsk</option>
                            <option value="128">(GMT+08:00) Beijing, Chongqing, Hong Kong, Urumqi</option>
                            <option value="128">(GMT+08:00) Irkutsk, Ulaan Bataar</option>
                            <option value="128">(GMT+08:00) Kuala Lumpur, Singapore</option>
                            <option value="128">(GMT+08:00) Perth</option>
                            <option value="128">(GMT+08:00) Taipei</option>
                            <option value="144">(GMT+09:00) Osaka, Sapporo, Tokyo</option>
                            <option value="144">(GMT+09:00) Seoul</option>
                            <option value="144">(GMT+09:00) Yakutsk</option>
                            <option value="152">(GMT+09:30) Adelaide</option>
                            <option value="152">(GMT+09:30) Darwin</option>
                            <option value="160">(GMT+10:00) Brisbane</option>
                            <option value="160">(GMT+10:00) Canberra, Melbourne, Sydney</option>
                            <option value="160">(GMT+10:00) Guam, Port Moresby</option>
                            <option value="160">(GMT+10:00) Hobart</option>
                            <option value="160">(GMT+10:00) Vladivostok</option>
                            <option value="176">(GMT+11:00) Magadan, Solomon Is., New Caledonia</option>
                            <option value="192">(GMT+12:00) Auckland, Wellington</option>
                            <option value="192">(GMT+12:00) Fiji, Kamchatka, Marshall Is.</option>
                            <option value="208">(GMT+13:00) Nuku'alofa, Tonga</option>
		</select>
   </td></tr>	
</table><!--End of wz_pg_2-->

<table id="wz_pg_3" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr>
      <td width="144" class="wizleft" >LAN IP Address</td>
      <td width="235" class="wizright"><font face="Arial" color="#000000">
        <input type="text" id="wz3_lan_ipaddr" name="wz3_lan_ipaddr" size="16" maxlength="15" value="">
      </font></td>
    </tr>
    <tr>
      <td class="wizleft" >LAN Subnet Mask</td>
      <td class="wizright"><font face="Arial" color="#000000">
        <input type="text" id="wz3_lan_netmask" name="wz3_lan_netmask" size="16" maxlength="15" value="">
      </font></td>
    </tr>
    <tr>
      <td class="wizleft" >DHCP Server</td>
      <td class="wizright"><font face="Arial" color="#000000">
        <input type="radio" name="wz3_dhcpd_enable" value="1" onClick='disable_dhcp(get_by_name("wz3_dhcpd_enable")[1].checked, get_by_id("wz3_dhcpd_start"), get_by_id("wz3_dhcpd_end"));'>
        Enable
        <input type="radio" name="wz3_dhcpd_enable" value="0" onClick='disable_dhcp(get_by_name("wz3_dhcpd_enable")[1].checked, get_by_id("wz3_dhcpd_start"), get_by_id("wz3_dhcpd_end"));'>
        Disable</font></td>
    </tr>
    <tr>
      <td class="wizleft" >Range Start</td>
      <td class="wizright"><font face="Arial" color="#000000">
        <input type="text" id="wz3_dhcpd_start" name="wz3_dhcpd_start" size="16" maxlength="15" value="">
      </font></td>
    </tr>
    <tr>
      <td class="wizleft" >Range End</td>
      <td class="wizright"><font face="Arial" color="#000000">
        <input type="text" id="wz3_dhcpd_end" name="wz3_dhcpd_end" size="16" maxlength="15" value="">
      </font></td>
    </tr>	
</table><!--End of wz_pg_3-->	

<table id="wz_pg_4" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr><td><b><font><input type="radio" name="wz4_ConnType" value="0">Obtain IP automatically (DHCP client)</font></b></td></tr>
    <tr><td><b><font><input type="radio" name="wz4_ConnType" value="1">Fixed IP address</font></b></td></tr>
<!--DEF	CONFIG_POE-->    <tr><td><b><font><input type="radio" name="wz4_ConnType" value="2">PPPoE to obtain IP automatically</font></b></td></tr>
<!--DEF	CONFIG_POE-->    <tr><td><b><font><input type="radio" name="wz4_ConnType" value="3">PPPoE with a fixed IP address</font></b></td></tr>
<!--DEF	CONFIG_PPTP-->    <tr><td><b><font><input type="radio" name="wz4_ConnType" value="4">PPTP</font></b></td></tr>
<!--DEF	CONFIG_L2TP-->    <tr><td><b><font><input type="radio" name="wz4_ConnType" value="5">L2TP</font></b></td></tr>
<!--DEF	CONFIG_BIGPOND-->    <tr><td><b><font><input type="radio" name="wz4_ConnType" value="6">BigPond Cable</font></b></td></tr>
<!--DEF	CONFIG_RUSPOE-->    <tr><td><b><font><input type="radio" name="wz4_ConnType" value="7">Russia PPPoE</font></b></td></tr>
<!--DEF	CONFIG_RUSPPTP-->    <tr><td><b><font><input type="radio" name="wz4_ConnType" value="8">Russia PPTP</font></b></td></tr>
</table><!--End of wz_pg_4-->

<DIV id="wz_pg_5" style="DISPLAY:none">	
<table id="wz_wan_0" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr>
      <td width=76 height=19 valign="top"  nowrap class="wizleft">Host Name</td>
      <td width=303 height=19 class="wizright"><input type="text" id="wzw0_hostname" name="wzw0_hostname" size="40" maxlength="39" value=""><br>
      	(optional)</td>
    </tr>
    <tr>
      <input type="hidden" id="wzw0_mac" name="wzw0_mac" value="00:11:22:33:44:55">	
      <td height=29  valign=top class="wizleft">MAC</td>
      <td width=303 height=29 class="wizright"><font face=Arial size=2>
        <input type=text id="mac1" name="mac1" size="2" maxlength="2">
        -
        <input type=text id="mac2" name="mac2" size="2" maxlength="2">
        -
        <input type=text id="mac3" name="mac3" size="2" maxlength="2">
        -
        <input type=text id="mac4" name="mac4" size="2" maxlength="2">
        -
        <input type=text id="mac5" name="mac5" size="2" maxlength="2">
        -
        <input type=text id="mac6" name="mac6" size="2" maxlength="2">
        (optional)</font><font face="Arial, Helvetica, sans-serif" size=2><br>
          </font>
		<input type="button" value="Clone MAC Address" name="wzw0_clone" onClick=set_mac(mac_clone_addr,":");>          
      </td>
    </tr>	
</table><!--End of wz_wan_0-->

<table id="wz_wan_1" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">	
	
	<tr>
      <td nowrap class="wizleft" >WAN IP Address</td>
      <td class="wizright"><input type="text" id="wzw1_wan_static_ipaddr" name="wzw1_wan_static_ipaddr" size="16" maxlength="15" value=""></td>
    </tr>
    <tr>
      <td class="wizleft" >WAN Subnet Mask</td>
      <td class="wizright"><input type="text" id="wzw1_wan_static_netmask" name="wzw1_wan_static_netmask" size="16" maxlength="15" value=""></td>
    </tr>
    <tr>
      <td  nowrap class="wizleft">WAN Gateway Address</td>
      <td class="wizright"><input type="text" id="wzw1_wan_static_gw" name="wzw1_static_wan_gw" size="16" maxlength="15" value=""></td>
    </tr>
    <tr>
      <td class="wizleft" >DNS Server Address 1 </td>
      <td class="wizright"><input type="text" id="wzw1_wan_primary_dns" name="wzw1_wan_primary_dns" size="16" maxlength="15" value="">                              </td>
    </tr>
    <tr>
      <td class="wizleft" >DNS Server Address 2 </td>
      <td class="wizright"><input type="text" id="wzw1_wan_secondary_dns" name="wzw1_wan_secondary_dns" size="16" maxlength="15" value="">                              </td>
    </tr>	
</table><!--End of wz_wan_1-->
<!--IFDEF	CONFIG_POE-->
<table id="wz_wan_2" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr>
      <td width="140"   class="wizleft"><font face="Arial">User Name</font></td>
      <td width="231"  class="wizright"><font face="Arial" color="#000000">
        <input type="text" id="wzw2_username" name="wzw2_username" size="30" maxlength="63" value="">
      </font></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Password</font></td>
      <td  class="wizright"><font face="Arial" color="#000000">
        <input type="password" id="wzw2_pwd" name="wzw2_pwd" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
      </font></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Verify Password</font></td>
      <td  class="wizright"><font face="Arial" color="#000000">
        <input type="password" id="wzw2_pwd_v" name="wzw2_pwd_v" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
      </font></td>
    </tr>
</table><!--End of wz_wan_2-->
<!--ENDIF	CONFIG_POE-->
<!--IFDEF	CONFIG_POE-->
<table id="wz_wan_3" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr>
      <td width="140"   class="wizleft"><font face="Arial">User Name</font></td>
      <td width="231" class="wizright"><font face="Arial">
        <input type="text" id="wzw3_username" name="wzw3_username" size="30" maxlength="63" value="">
      </font></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Passward</font></td>
      <td class="wizright"><font face="Arial">
        <input type="password" id="wzw3_pwd" name="wzw3_pwd" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
      </font></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Verify Password</font></td>
      <td class="wizright"><font face="Arial">
        <input type="password" id="wzw3_pwd_v" name="wzw3_pwd_v" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
      </font></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">IP Address</font></td>
      <td class="wizright"><input type="text" id="wzw3_ipaddr" name="wzw3_ipaddr" size="16" maxlength="15" value=""></td>
    </tr>
</table><!--End of wz_wan_3-->
<!--ENDIF	CONFIG_POE-->
<!--IFDEF	CONFIG_PPTP-->
<table id="wz_wan_4" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr>
      <td   class="wizleft">&nbsp;</td>
      <td class="wizright"><font face="Arial">
        <input type="radio" name="wzw4_dynamic" value="1" onClick='disable_dhcp_static_address(get_by_name("wzw4_dynamic"), get_by_id("wzw4_ipaddr"), get_by_id("wzw4_netmask"), get_by_id("wzw4_gw"))'>
        </font>Dynamic IP&nbsp;<font face="Arial">
        <input type="radio" name="wzw4_dynamic" value="0" onClick='disable_dhcp_static_address(get_by_name("wzw4_dynamic"), get_by_id("wzw4_ipaddr"), get_by_id("wzw4_netmask"), get_by_id("wzw4_gw"))'>
      </font>Static IP</td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">My IP</font></td>
      <td width="235" class="wizright"><input type="text" id="wzw4_ipaddr" name="wzw4_ipaddr" size=16 maxlength=15 ></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Subnet Mask</font></td>
      <td class="wizright"><input type="text" id="wzw4_netmask" name="wzw4_netmask" size=16 maxlength=15 ></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">GateWay</font></td>
      <td class="wizright"><input type="text" id="wzw4_gw" name="wzw4_gw" size="16" maxlength="15" ></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Server IP</font></td>
      <td class="wizright"><input type="text" id="wzw4_server" name="wzw4_server" size=30 maxlength=63 ></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">PPTP Account</font></td>
      <td class="wizright"><input type="text" id="wzw4_username" name="wzw4_username" size="30" maxlength="63" ></td>
    </tr>
    <tr>
      <td   class="wizleft">PPTP Password</td>
      <td class="wizright"><input type="password" id="wzw4_pwd" name="wzw4_pwd" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG"></td>
    </tr>
    <tr>
      <td   class="wizleft">Retype Password</td>
      <td class="wizright"><input type="password" id="wzw4_pwd_v" name="wzw4_pwd_v" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG"></td>
    </tr>
</table><!--End of wz_wan_4-->
<!--ENDIF	CONFIG_PPTP-->
<!--IFDEF	CONFIG_L2TP-->
<table id="wz_wan_5" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr class="formarea">
      <td align=right class="wizleft">&nbsp;</td>
      <td class="wizright"><font face="Arial">
        <input type="radio" name="wzw5_dynamic" value="1" onClick='disable_dhcp_static_address(get_by_name("wzw5_dynamic"), get_by_id("wzw5_ipaddr"), get_by_id("wzw5_netmask"), get_by_id("wzw5_gw"))'>
        </font>Dynamic IP&nbsp;<font face="Arial">
        <input type="radio" name="wzw5_dynamic" value="0" onClick='disable_dhcp_static_address(get_by_name("wzw5_dynamic"), get_by_id("wzw5_ipaddr"), get_by_id("wzw5_netmask"), get_by_id("wzw5_gw"))'>
      </font>Static IP</td>
    </tr>
    <tr class="formarea">
      <td align=right class="wizleft"><font face="Arial">My IP</font></td>
      <td class="wizright"><input name="wzw5_ipaddr" type=text id="wzw5_ipaddr" size="20" maxlength="15">
      </td>
    </tr>
    <tr class="formarea">
      <td align=right class="wizleft"> Subnet Mask</td>
      <td class="wizright"><input name="wzw5_netmask" type=text id="wzw5_netmask" size="20" maxlength="15">
      </td>
    </tr>
    <tr class="formarea">
      <td align=right class="wizleft">Gateway</td>
      <td class="wizright" ><input name="wzw5_gw" type=text id="wzw5_gw" size="20" maxlength="15">
      </td>
    </tr>
    <tr>
      <td  class="wizleft"><font face="Arial">Server IP</font></td>
      <td  class="wizright"><font>
        <input type="text" id="wzw5_server" name="wzw5_server" size=30 maxlength=63 >
      </font></td>
    </tr>
    <tr>
      <td  class="wizleft"><font face="Arial">L2TP Account</font></td>
      <td  class="wizright"><font>
        <input type="text" id="wzw5_username" name="wzw5_username" size=30 maxlength=63 >
      </font></td>
    </tr>
    <tr>
      <td  class="wizleft">L2TP Password</td>
      <td  class="wizright"><input type="password" id="wzw5_pwd" name="wzw5_pwd" size=30 maxlength=63 value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG"></td>
    </tr>
    <tr>
      <td  class="wizleft">Retype Password</td>
      <td  class="wizright"><input type="password" id="wzw5_pwd_v" name="wzw5_pwd_v" size=30 maxlength=63 value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG"></td>
    </tr>
</table><!--End of wz_wan_5-->
<!--ENDIF	CONFIG_L2TP-->
<!--IFDEF	CONFIG_BIGPOND-->
<table id="wz_wan_6" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr>
      <td colspan="2" >Please set your BigPond Cable data then press Next to continue.</td>
    </tr>
    <tr>
      <td width="144"   class="wizleft"><font face="Arial">User Name</font></td>
      <td width="235"  class="wizright"><input type="text" id="wzw6_username" name="wzw6_username" size="30" maxlength="63"></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Password</font></td>
      <td  class="wizright"><input type="password" id="wzw6_pwd" name="wzw6_pwd" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG"></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Verify Password</font></td>
      <td  class="wizright"><input type="password" id="wzw6_pwd_v" name="wzw6_pwd_v" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG"></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Auth Server</font></td>
      <td  class="wizright"><select id="wzw6_auth" name="wzw6_auth">
          <option value="sm-server">sm-server</option>
          <option value="dce-server">dce-server</option>
        </select>
      </td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Login Server IP</font></td>
      <td  class="wizright"><input type="text" id="wzw6_server" name="wzw6_server" size=30 maxlength=63>
        (optional)</td>
    </tr>
</table><!--End of wz_wan_6-->
<!--ENDIF	CONFIG_BIGPOND-->
<!--IFDEF	CONFIG_RUSPOE-->
<table id="wz_wan_7" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr>
      <td class="wizleft">&nbsp;</td>
      <td class="wizright"><span class="style3">
        <input name="wzw7_dynamic" type="radio" value="1" onClick='get_by_id("wzw7_ipaddr").disabled=true;'>
        <span class="style5"> Dynamic IP</span>&nbsp;&nbsp;
        <input name="wzw7_dynamic" type="radio" value="0" onClick='get_by_id("wzw7_ipaddr").disabled=false;'>
        <span class="style5"> Static IP </span></span></td>
    </tr>
    <tr>
      <td width="140" class="wizleft"><font face="Arial">User Name</font></td>
      <td width="231" class="wizright"><font face="Arial">
        <input type="text" id="wzw7_username" name="wzw7_username" size="30" maxlength="63">
      </font></td>
    </tr>
    <tr>
      <td class="wizleft"><font face="Arial">Passward</font></td>
      <td class="wizright"><font face="Arial">
        <input type="password" id="wzw7_pwd" name="wzw7_pwd" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
      </font></td>
    </tr>
    <tr>
      <td class="wizleft"><font face="Arial">Verify Password</font></td>
      <td class="wizright"><font face="Arial"> <font face="Arial">
        <input type="password" id="wzw7_pwd_v" name="wzw7_pwd_v" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
      </font> </font></td>
    </tr>
    <tr>
      <td class="wizleft"><font face="Arial">IP Address</font></td>
      <td class="wizright"><input type="text" id="wzw7_ipaddr" name="wzw7_ipaddr" size="16" maxlength="15" value=""></td>
    </tr>
</table><!--End of wz_wan_7-->
<!--ENDIF	CONFIG_RUSPOE-->
<!--IFDEF	CONFIG_RUSPPTP-->
<table id="wz_wan_8" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr>
      <td   class="wizleft">&nbsp;</td>
      <td class="wizright"><font face="Arial">
        <input type="radio" name="wzw8_dynamic" value="1" onClick='disable_dhcp_static_address(get_by_name("wzw8_dynamic"), get_by_id("wzw8_ipaddr"), get_by_id("wzw8_netmask"), get_by_id("wzw8_gw"))'>
        </font>Dynamic IP&nbsp;<font face="Arial">
        <input type="radio" name="wzw8_dynamic" value="0" onClick='disable_dhcp_static_address(get_by_name("wzw8_dynamic"), get_by_id("wzw8_ipaddr"), get_by_id("wzw8_netmask"), get_by_id("wzw8_gw"))'>
      </font>Static IP</td>
    </tr>
    <tr>
      <td width="144"   class="wizleft"><font face="Arial">My IP</font></td>
      <td width="235" class="wizright"><input type="text" id="wzw8_ipaddr" name="wzw8_ipaddr" size=16 maxlength=15 ></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Subnet Mask</font></td>
      <td class="wizright"><input type="text" id="wzw8_netmask" name="wzw8_netmask" size=16 maxlength=15 ></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">GateWay</font></td>
      <td class="wizright"><input type="text" id="wzw8_gw" name="wzw8_gw" size="16" maxlength="15" ></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">Server IP</font></td>
      <td class="wizright"><input type="text" id="wzw8_server" name="wzw8_server" size=30 maxlength=63 ></td>
    </tr>
    <tr>
      <td   class="wizleft"><font face="Arial">PPTP Account</font></td>
      <td class="wizright"><input type="text" id="wzw8_username" name="wzw8_username" size="30" maxlength="63" ></td>
    </tr>
    <tr>
      <td   class="wizleft">PPTP Password</td>
      <td class="wizright"><input type="password" id="wzw8_pwd" name="wzw8_pwd" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG"></td>
    </tr>
    <tr>
      <td   class="wizleft">Retype Password</td>
      <td class="wizright"><input type="password" id="wzw8_pwd_v" name="wzw8_pwd_v" size="30" maxlength="63" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG"></td>
    </tr>
</table><!--End of wz_wan_8-->
<!--ENDIF	CONFIG_RUSPPTP-->
</DIV><!--End of wz_pg_5 (wz_wan_type)-->

<table id="wz_pg_6" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr>
      <td width="144" nowrap   class="wizleft">Wireless LAN</td>
      <td width="235" class="wizright"><input type="radio" name="wz6_enable" value="1" onclick='disable_wz6(get_checked_value(get_by_name("wz6_enable")));'>Enable
        <input type="radio" name="wz6_enable" value="0" onclick='disable_wz6(get_checked_value(get_by_name("wz6_enable")));' >Disable</td>
    </tr>
    <tr>
      <td   class="wizleft">SSID</td>
      <td class="wizright"><input type="text" id="wz6_ssid" name="wz6_ssid" size="20" maxlength="32"></td>
    </tr>
    <tr>
      <td   class="wizleft">Channel </td>
      <td class="wizright"><select size="1" id="wz6_channel" name="wz6_channel"></select></td>
    </tr>
</table><!--End of wz_pg_6-->

<table id="wz_pg_7" style="DISPLAY:none" width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">
	<tr></tr>
	<tr>	
	  <td class="wizright">Click &quot;Restart&quot; button to save the settings and restart Wireless Router.</td>	
	</tr>
	<tr></tr>
</table><!--End of wz_pg_7-->

<!-- Button Area-->
<table width="98%" align="center" border="0" cellpadding="3" cellspacing="1" bgcolor="#DDDDDD">   
   <tr><td align="center">
   		<P>
         <INPUT class="ButtonSmall" id=wz_prev_b onclick=wz_prev(); type=button value="&lt; Back">
		 <INPUT class="ButtonSmall" id=wz_next_b onclick=wz_next(); type=button value="Next &gt;">
		 <INPUT class="ButtonSmall" id=wz_save_b onclick=send_request("form_wz"); type=button value="Restart">
         <INPUT class="ButtonSmall" id=wz_cancel_b onclick=wz_exit(); type=button value="Exit">         
        </P>
        <P id="st_wz" style="DISPLAY:none"><font face="Arial"><b>Display wizard next time?</b></font><font face="Arial" size="2pt">&nbsp;
            <input type="radio" name="start_wizard" value="0">&nbsp;Yes&nbsp;
            <input type="radio" name="start_wizard" value="1">&nbsp;No &nbsp;</font>
			<input name="update " type="button" class="ButtonSmall" value="update" onclick=send_st_wz("form_st_wz");>
        </P>
   </td></tr>
   <tr><td><br></td></tr>
</table>
	&nbsp;
    </td>    
    <td valign="top" background="bg1_r.gif"></td>
  </tr>
  
  <tr>
    <td width="21"><img src="c1_bl.gif" width="21" height="20"></td>
    <td height="20" background="bg1_b.gif"><img src="bg1_b.gif" width="390" height="20"></td>
    <td width="21"><img id="wz_size" src="c1_br.gif" width="21" height="20"></td>
  </tr>
</table>

<!--form id="form_wz" method="POST" action="apply.cgi"-->
<input type="hidden" id="wan_curr_ipaddr" name="wan_curr_ipaddr" value="<% CmoGetStatus("wan_current_ipaddr_00"); %>">
<form id="form_wz" method="POST" action="apply.cgi">
	<input type="hidden" id="reboot_type" name="reboot_type" value="reboot">
	<input type="hidden" id="html_response_page" name="html_response_page" value="back.asp">
	<input type="hidden" id="html_response_return_page" name="html_response_return_page" value="lan.asp">
	<input type="hidden" id="dhcpd_last_assign_ip" name="dhcpd_last_assign_ip">
	<input type="hidden" id="html_response_message" name="html_response_message" value=" Success, system rebooting. ">
	<input type="hidden" id="admin_password" name="admin_password" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
	<input type="hidden" id="time_zone_area" name="time_zone_area" value="<% CmoGetCfg("time_zone_area","none"); %>">
	<input type="hidden" id="lan_ipaddr" name="lan_ipaddr" value="<% CmoGetCfg("lan_ipaddr","none"); %>">
	<input type="hidden" id="lan_netmask" name="lan_netmask" value="<% CmoGetCfg("lan_netmask","none"); %>">
	<input type="hidden" id="dhcpd_enable" name="dhcpd_enable" value="<% CmoGetCfg("dhcpd_enable","none"); %>">
	<input type="hidden" id="dhcpd_start" name="dhcpd_start" value="<% CmoGetCfg("dhcpd_start","none"); %>">
	<input type="hidden" id="dhcpd_end" name="dhcpd_end" value="<% CmoGetCfg("dhcpd_end","none"); %>">
	<input type="hidden" id="wan_proto" name="wan_proto" value="<% CmoGetCfg("wan_proto","none"); %>">
	<input type="hidden" id="wlan0_enable" name="wlan0_enable" value="<% CmoGetCfg("wlan0_enable","none"); %>">	
<!--DEF CONFIG_RUSPOE-->	<input type="hidden" id="wan_pppoe_russia_enable" name="wan_pppoe_russia_enable" value="<% CmoGetCfg("wan_pppoe_russia_enable","none"); %>">
<!--DEF CONFIG_RUSPPTP-->	<input type="hidden" id="wan_pptp_russia_enable" name="wan_pptp_russia_enable" value="<% CmoGetCfg("wan_pptp_russia_enable","none"); %>">
</form>
<!-- Put to form while wlan0_enable=1 -->
	<input type="hidden" id="wlan0_ssid" name="wlan0_ssid" value="<% CmoGetCfg("wlan0_ssid","none"); %>">
	<input type="hidden" id="wlan0_channel" name="wlan0_channel" value="<% CmoGetCfg("wlan0_channel","none"); %>">		
<!-- Put wan type to form based on selected wz4_ConnType -->
	<input type="hidden" id="wan_pppoe_dynamic_00" name="wan_pppoe_dynamic_00" value="<% CmoGetCfg("wan_pppoe_dynamic_00","none"); %>">
<!--DEF COMMENT wz_wan_0-->
	<input type="hidden" id="wan_mac" name="wan_mac" value="<% CmoGetCfg("wan_mac","none"); %>">
	<input type="hidden" id="hostname" name="hostname" value="<% CmoGetCfg("hostname","none"); %>">
<!--DEF COMMENT wz_wan_1-->	
	<input type="hidden" id="wan_static_ipaddr" name="wan_static_ipaddr" value="<% CmoGetCfg("wan_static_ipaddr","none"); %>">
	<input type="hidden" id="wan_static_netmask" name="wan_static_netmask" value="<% CmoGetCfg("wan_static_netmask","none"); %>">
	<input type="hidden" id="wan_static_gateway" name="wan_static_gateway" value="<% CmoGetCfg("wan_static_gateway","none"); %>">
	<input type="hidden" id="wan_specify_dns" name="wan_specify_dns" value="<% CmoGetCfg("wan_specify_dns","none"); %>">
	<input type="hidden" id="wan_primary_dns" name="wan_primary_dns" value="<% CmoGetCfg("wan_primary_dns","none"); %>">
	<input type="hidden" id="wan_secondary_dns" name="wan_secondary_dns" value="<% CmoGetCfg("wan_secondary_dns","none"); %>">
<!--IFDEF CONFIG_POE-->		
<!--DEF COMMENT wz_wan_2, wz_wan_3, wz_wan_7-->
	<input type="hidden" id="wan_pppoe_username_00" name="wan_pppoe_username_00" value="<% CmoGetCfg("wan_pppoe_username_00","none"); %>">
	<input type="hidden" id="wan_pppoe_password_00" name="wan_pppoe_password_00" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
<!--DEF COMMENT wz_wan_3, wz_wan_7-->
	<input type="hidden" id="wan_pppoe_ipaddr_00" name="wan_pppoe_ipaddr_00" value="<% CmoGetCfg("wan_pppoe_ipaddr_00","none"); %>">
	<input type="hidden" id="wan_pppoe_netmask_00" name="wan_pppoe_netmask_00" value="<% CmoGetCfg("wan_pppoe_netmask_00","none"); %>">
<!--ENDIF CONFIG_POE-->
<!--DEF COMMENT wz_wan_4, wz_wan_8-->
<!--IFDEF CONFIG_PPTP-->
<input type="hidden" id="wan_pptp_dynamic" name="wan_pptp_dynamic" value="<% CmoGetCfg("wan_pptp_dynamic","none"); %>"> 
<input type="hidden" id="wan_pptp_username" name="wan_pptp_username" value="<% CmoGetCfg("wan_pptp_username","none"); %>">
<input type="hidden" id="wan_pptp_password" name="wan_pptp_password" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
<input type="hidden" id="wan_pptp_ipaddr" name="wan_pptp_ipaddr" value="<% CmoGetCfg("wan_pptp_ipaddr","none"); %>">
<input type="hidden" id="wan_pptp_netmask" name="wan_pptp_netmask" value="<% CmoGetCfg("wan_pptp_netmask","none"); %>">
<input type="hidden" id="wan_pptp_gateway" name="wan_pptp_gateway" value="<% CmoGetCfg("wan_pptp_gateway","none"); %>">
<input type="hidden" id="wan_pptp_server_ip" name="wan_pptp_server_ip" value="<% CmoGetCfg("wan_pptp_server_ip","none"); %>">
<!--ENDIF CONFIG_PPTP-->
<!--DEF COMMENT wz_wan_5-->
<!--IFDEF CONFIG_L2TP-->
<input type="hidden" id="wan_l2tp_dynamic" name="wan_l2tp_dynamic" value="<% CmoGetCfg("wan_l2tp_dynamic","none"); %>"> 
<input type="hidden" id="wan_l2tp_username" name="wan_l2tp_username" value="<% CmoGetCfg("wan_l2tp_username","none"); %>">
<input type="hidden" id="wan_l2tp_password" name="wan_l2tp_password" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
<input type="hidden" id="wan_l2tp_ipaddr" name="wan_l2tp_ipaddr" value="<% CmoGetCfg("wan_l2tp_ipaddr","none"); %>">
<input type="hidden" id="wan_l2tp_netmask" name="wan_l2tp_netmask" value="<% CmoGetCfg("wan_l2tp_netmask","none"); %>">
<input type="hidden" id="wan_l2tp_gateway" name="wan_l2tp_gateway" value="<% CmoGetCfg("wan_l2tp_gateway","none"); %>">
<input type="hidden" id="wan_l2tp_server_ip" name="wan_l2tp_server_ip" value="<% CmoGetCfg("wan_l2tp_server_ip","none"); %>">
<!--ENDIF CONFIG_L2TP-->
<!--DEF COMMENT wz_wan_6-->	
<!--IFDEF CONFIG_BIGPOND-->
<input type="hidden" id="wan_bigpond_username" name="wan_bigpond_username" value="<% CmoGetCfg("wan_bigpond_username","none"); %>">
<input type="hidden" id="wan_bigpond_password" name="wan_bigpond_password" value="WDB8WvbXdHtZyM8Ms2RENgHlacJghQyG">
<input type="hidden" id="wan_bigpond_auth" name="wan_bigpond_auth" value="<% CmoGetCfg("wan_bigpond_auth","none"); %>">
<input type="hidden" id="wan_bigpond_server" name="wan_bigpond_server" value="<% CmoGetCfg("wan_bigpond_server","none"); %>">
<!--ENDIF CONFIG_BIGPOND-->

<form id="form_st_wz" method="POST" action="apply.cgi">
<input type="hidden" id="html_response_page" name="html_response_page" value="wizard.asp">
<input type="hidden" id="reboot_type" name="reboot_type" value="none">
<input type="hidden" id="blank_status" name="blank_status" value="<% CmoGetCfg("blank_status","none"); %>">
</form>	
</body>
</html>
