<html>
<head>
<meta http-equiv="Content-Type" content="text/html;">
<title>TRENDNET | TEW-651BR | Access | Firewall Rule</title>
<link rel="stylesheet" href="style.css" type="text/css">
<script language="JavaScript" src="public_msg.js"></script>
<script language="JavaScript" src="public.js"></script>
<SCRIPT LANGUAGE="JavaScript">

	var rule_max_num = 20;
	var rule_list = new Array();
	var DataArray = new Array();
		
	var DEFINE_DO_NOTHING = 0;
	var DEFINE_AUTO_SEND = 1;
	var DEFINE_SEND_DIRECTLY = 2;
			
	function auto_apply_to_sys(type){
		if(type=="add" || type=="update" || type=="del"){
			return DEFINE_AUTO_SEND;
		}else if(type=="send"){
			return DEFINE_SEND_DIRECTLY;
		}
		return DEFINE_DO_NOTHING;
	}
	
			
	function check_icmp(){
		var is_disable = false;
		
		if (get_by_id("protocol").value == "ICMP"){
			is_disable = true;	
			get_by_id("port1").value = "";
			get_by_id("port2").value = "";
		}
		
		get_by_id("port1").disabled = is_disable;
		get_by_id("port2").disabled = is_disable;
	}
		
	function change_priority(off){
		var row = parseInt(get_by_id("edit_row").value);
		var obj = get_by_id("table1");
		var index = row + off;
		
		if (index < 0 || index >= rule_list.length){
			return;
		}
		
		var new_row = obj.rows[index+1];
		var self_row = obj.rows[row+1];
		var temp_rule_list = rule_list[row];
		
		
		/* switch rows */		
		for (var i = 1; i < new_row.cells.length; i++){
			var temp_data = new_row.cells[i].childNodes[0].data;		
			new_row.cells[i].childNodes[0].data = self_row.cells[i].childNodes[0].data;
			self_row.cells[i].childNodes[0].data = temp_data;
		}
		/* switch firewall data list */
		rule_list[row] = rule_list[index];
		rule_list[index] = temp_rule_list;
		
		if (temp_rule_list.Enable == "0"){
			get_by_id("e" + index).checked = false;
		}else{
			get_by_id("e" + index).checked = true;
		}
		if (rule_list[row].Enable == "0"){
			get_by_id("e" + row).checked = false;
		}else{
			get_by_id("e" + row).checked = true;
		}		
		edit_row_update(index);		
	}

	function del_row(row){
		var index = parseInt(get_by_id("edit_row").value,10);
		
		var tmp_enable;
        if(confirm(msg[MSG37])){
        	for(var i=index ; i<rule_list.length-1 ;i++){			//show on page
				rule_list[i].Name =  rule_list[i+1].Name;
				rule_list[i].Enable = rule_list[i+1].Enable;		
				rule_list[i].Action = rule_list[i+1].Action;
				rule_list[i].Src_iface = rule_list[i+1].Src_iface;
				rule_list[i].Src_ip1 = rule_list[i+1].Src_ip1;
				rule_list[i].Src_ip2 = rule_list[i+1].Src_ip2;
				rule_list[i].Dst_iface = rule_list[i+1].Dst_iface;
				rule_list[i].Dst_ip1 = rule_list[i+1].Dst_ip1;
				rule_list[i].Dst_ip2 = rule_list[i+1].Dst_ip2;		
				rule_list[i].Proto = rule_list[i+1].Proto;
				rule_list[i].Port1 = rule_list[i+1].Port1;
				rule_list[i].Port2 = rule_list[i+1].Port2;

				var enable_name = "e"+i;
				tmp_enable="<input type=\"checkbox\" id=\""+ enable_name +"\" name=\""+ enable_name +"\" value=\"1\">";
				get_by_id("rule_td1_"+i).innerHTML=tmp_enable;
				get_by_id("rule_td2_"+i).innerHTML=rule_list[i].Action;
				get_by_id("rule_td3_"+i).innerHTML=rule_list[i].Name;
				get_by_id("rule_td4_"+i).innerHTML=show_iface(rule_list[i].Src_iface) + ":"+show_range(rule_list[i].Src_ip1, rule_list[i].Src_ip2);
				get_by_id("rule_td5_"+i).innerHTML=rule_list[i].Dst_iface + ":"+show_range(rule_list[i].Dst_ip1, rule_list[i].Dst_ip2);
				get_by_id("rule_td6_"+i).innerHTML=show_protocol(rule_list[i].Proto)+","+show_range(rule_list[i].Port1,rule_list[i].Port2);
				check_box_enabled(i);
			}
			get_by_id("rule_table_"+(rule_list.length-1)).style.display="none";			
			--rule_list.length;
			clear_row();
			
			/* for auto send the request */						
			send_request("send");		
			return true;
        }
        return false;
    }
	 
	function set_interface(value){		
		if (value == "WAN"){
			return 1;
		}else if (value == "LAN"){
			return 0;
		}else{
			return 0;
		}
	}
	
	function set_rule_protocol(value){	   
	    if (value =="UDP"){
	   		return 1;
	    }else if (value =="TCP"){
	    	return 0;
	    }else if (value =="ICMP"){
	    	return 2;
	    }else{
	    	return 3;
	    }	
	}
	 
	function edit_row_update(row){	
    	var row_obj = get_by_id("table1").rows[row+1];        
        var enable = get_by_name("enable");
        var action = get_by_name("action");
       	
       	
	    if (row < rule_list.length){       
			get_by_id("serial").value = rule_list[row].Index;
			
		    if (rule_list[row].Enable == "1"){
		    	enable[0].checked = true;
		    }else{
		    	enable[1].checked = true;
		    }
		    
		    get_by_id("firewall_name").value = get_row_data(row_obj, 2);
		    
		    if (rule_list[row].Action == "Allow"){
				action[0].checked = true;
			}else{
				action[1].checked = true;
			}
		    
		  	get_by_id("src_iface").selectedIndex = set_interface(rule_list[row].Src_iface);				
			get_by_id("src_ip1").value = rule_list[row].Src_ip1;
			get_by_id("src_ip2").value = rule_list[row].Src_ip2;
			get_by_id("dst_iface").selectedIndex = set_interface(rule_list[row].Dst_iface);
			get_by_id("dst_ip1").value = rule_list[row].Dst_ip1;
			get_by_id("dst_ip2").value = rule_list[row].Dst_ip2;
			get_by_id("protocol").selectedIndex = set_rule_protocol(rule_list[row].Proto);
			
			if (rule_list[row].Proto != "ICMP"){
				get_by_id("port1").value = rule_list[row].Port1;
				get_by_id("port2").value = rule_list[row].Port2;
			}
		        	    	    	        
		    get_by_id("edit_row").value = row;
		    get_by_id("add").disabled = true;
		    get_by_id("update").disabled = false;
		    get_by_id("del").disabled = false;
		    if (row != 0){
		    	get_by_id("up").disabled = false;
		    }else{
		    	get_by_id("up").disabled = true;
		    }
		    
		    if (row != rule_list.length - 1){
		    	get_by_id("down").disabled = false;
		    }else{
		    	get_by_id("down").disabled = true;
		    }
		    
		    if (rule_list.length > 1){
		    	get_by_id("priority").disabled = false;
		    }else{
		    	get_by_id("priority").disabled = true;
		    }
		    check_icmp();
		    change_color("table1", row+1);	 
		    disable_iprange();
			var login_who="<% CmoGetStatus("get_current_user"); %>";
	    if(login_who == "user")
    	{
        	get_by_id("add").disabled  = "true";
        	get_by_id("del").disabled  = "true";
        	get_by_id("new").disabled  = "true";
        	get_by_id("update").disabled  = "true";
        	get_by_id("up").disabled  = "true";
        	get_by_id("down").disabled  = "true";
        	get_by_id("priority").disabled  = "true";
    	}
		}
	}
	
	function clear_row(){
        get_by_id("edit_row").value = "-1";
        change_color("table1", -1);

//	Clear input
		get_by_id("firewall_name").value="";
		get_by_id("src_ip1").value="";
		get_by_id("src_ip2").value="";
		get_by_id("dst_ip1").value="";
		get_by_id("dst_ip2").value="";
		get_by_id("port1").value="";
		get_by_id("port2").value="";
		get_by_id("port1").disabled=false;
		get_by_id("port2").disabled=false;
		get_by_id("src_iface").selectedIndex = 0;
		get_by_id("dst_iface").selectedIndex = 1;

		
		for(var i=0;i<get_by_name("enable").length;i++){
				get_by_name("enable")[i].checked = false;
		}
		for(i=0;i<get_by_name("action").length;i++){
				get_by_name("action")[i].checked = false;
		}		
		get_by_id("protocol").selectedIndex=0;


		//reset status of button
		
		get_by_id("priority").disabled=false;
		get_by_id("add").disabled=false;
		get_by_id("up").disabled=true;
		get_by_id("down").disabled=true;
		get_by_id("update").disabled=true;		
		get_by_id("del").disabled=true;	

    }
	 
	function send_request(type){		
		var firewall_name = get_by_id("firewall_name").value;
		var src_ip1 = get_by_id("src_ip1").value;
		var src_ip2 = get_by_id("src_ip2").value;
		var dst_ip1 = get_by_id("dst_ip1").value;
		var dst_ip2 = get_by_id("dst_ip2").value;
		var protocol = get_by_id("protocol").value;
		var port1 = get_by_id("port1").value;
		var port2 = get_by_id("port2").value;
		var temp_src_ip1 = new addr_obj(src_ip1.split("."), src_start_ip_msg, false, false);
		var temp_src_ip2 = new addr_obj(src_ip2.split("."), src_end_ip_msg, true, false);
		var temp_dst_ip1 = new addr_obj(dst_ip1.split("."), dst_start_ip_msg, false, false);
		var temp_dst_ip2 = new addr_obj(dst_ip2.split("."), dst_end_ip_msg, true, false);

		if(type!="send"){
			if (firewall_name == ""){
				alert(msg[MSG18]);
				return false;
			}
				
			if(!get_checked_value(get_by_name("action"))){
				alert(msg[MSG54]);
				return false;
			}
			
			if (src_ip1 != "*"){
				if (!check_address(temp_src_ip1)){
					return false;
				}
				if (src_ip2=="*"){
					src_ip2 = src_ip1;
					temp_src_ip2 = new addr_obj(src_ip2.split("."), src_end_ip_msg, true, false);					
				}	
			}else{	//src_ip1 == *
				src_ip2 = "*";
			}	
	
			if (src_ip2 != "" && src_ip2 != "*"){
				if (!check_address(temp_src_ip2)){
					return false;
				}
			}else {
					src_ip2=src_ip1;
			}
			
			// dst_iprange
			if (dst_ip1 != "*"){
 			    if (!check_address(temp_dst_ip1)){
					return false;
				}	
				if (dst_ip2=="*"){
					dst_ip2 = dst_ip1;
					temp_dst_ip2 = new addr_obj(dst_ip2.split("."), dst_end_ip_msg, true, false);					
				}	
			}else{		//dst_ip1 == *					
				dst_ip2 = "*";
				if(get_select_value(get_by_id("dst_iface"))=="LAN" && get_checked_value(get_by_name("action")) == "Allow"){
					alert(msg[MSG60]);
					return false;
				}
			}	
			
			if((get_select_value(get_by_id("dst_iface"))=="LAN" || (get_select_value(get_by_id("src_iface"))=="WAN" && get_select_value(get_by_id("dst_iface"))=="source")) && get_checked_value(get_by_name("action"))=="Allow"){
				dst_ip2=dst_ip1;
				temp_dst_ip2 = new addr_obj(dst_ip2.split("."), dst_end_ip_msg, true, false);			
			}			
						
			if (dst_ip2 != "" && dst_ip2 != "*"){
				if (!check_address(temp_dst_ip2)){
					return false;
				}
			}else {
					dst_ip2=dst_ip1;
			}
	
			// check range
			if (!check_ip_order(temp_src_ip1, temp_src_ip2)){
				alert(temp_src_ip2.e_msg[10]);
				return false;
			}
			
			if (!check_ip_order(temp_dst_ip1, temp_dst_ip2)){
				alert(temp_dst_ip2.e_msg[10]);
				return false;
			}

	
/*			if((get_select_value(get_by_id("dst_iface"))=="LAN" || (get_select_value(get_by_id("src_iface"))=="WAN" && get_select_value(get_by_id("dst_iface"))=="source")) && get_checked_value(get_by_name("action"))=="Allow"){
						dst_ip2=dst_ip1;
			}else{
				if (!check_address(temp_dst_ip2)){
					return false;
				}
			}			
*/		
			if (protocol != "ICMP"){
				if (port1 != "*"){
					if (!check_port(port1)){
		        		alert(msg[MSG52]);
						return false;
					}					
		    	} else {
				 	port2="*";
				}
	    
			    if (port2 != "" && port2 != "*"){
				    if (!check_port(port2)){
			    	    alert(msg[MSG53]);
			        	return false;
				    }
				}
				else {
					port2=port1;
				}
				
				if(port1 != "*" && port2 != "*"){
					if(parseInt(port1,10) > parseInt(port2,10)){
						alert("The end port number must be greater than the start port number");
			        	return false;
				    }
				}
			}else{
				port1="0";
				port2="0";				
			}
		}
		
		var index = parseInt(get_by_id("edit_row").value,10);
		//duplicate check
		var wan_port_ping = "<% CmoGetCfg("wan_port_ping_response_enable","none"); %>";
		if(wan_port_ping == "1")
		{	
			if(get_by_id("firewall_name").value == "Allow to Ping WAN port")
			{
				alert(addstr(msg[MSG41],"Firewall name"));
                return false;
			}
		}

		if(get_by_id("firewall_name").value == "Default")
		{
			alert(addstr(msg[MSG41],"Firewall name"));
            return false;
		}

		for(i=0;i<rule_list.length;i++){
			if(index != i)
			{
				if(rule_list[i].Name==get_by_id("firewall_name").value)
				{
					if(rule_list[i].Name != "" && index==(rule_list[i].OnList))
					{
						continue;
					}
					else
					{ // Duplicate value
						alert(addstr(msg[MSG41],"Firewall name"));
						return false;
					}			
				}
			}
		}

		if(type=="add"){
			if(rule_list.length<rule_max_num){
				rule_list[rule_list.length++] = new Data(rule_list.length-1,firewall_name, get_checked_value(get_by_name("enable")), get_checked_value(get_by_name("action")),get_select_value(get_by_id("src_iface")),src_ip1,src_ip2,get_select_value(get_by_id("dst_iface")),dst_ip1,dst_ip2,protocol,port1,port2);
				//show  poe_rule_list
				var enable_name="e"+(rule_list.length-1);
				get_by_id("rule_table_"+(rule_list.length-1)).style.display="";
				get_by_id("rule_td2_"+(rule_list.length-1)).innerHTML=rule_list[rule_list.length-1].Action;
				get_by_id("rule_td3_"+(rule_list.length-1)).innerHTML=rule_list[rule_list.length-1].Name;
				get_by_id("rule_td4_"+(rule_list.length-1)).innerHTML=show_iface(rule_list[rule_list.length-1].Src_iface) + ":"+show_range(rule_list[rule_list.length-1].Src_ip1, rule_list[rule_list.length-1].Src_ip2);
				get_by_id("rule_td5_"+(rule_list.length-1)).innerHTML=show_iface(rule_list[rule_list.length-1].Dst_iface) + ":"+show_range(rule_list[rule_list.length-1].Dst_ip1, rule_list[rule_list.length-1].Dst_ip2);
				get_by_id("rule_td6_"+(rule_list.length-1)).innerHTML=show_protocol(rule_list[rule_list.length-1].Proto)+","+show_range(rule_list[rule_list.length-1].Port1,rule_list[rule_list.length-1].Port2);
				check_box_enabled((rule_list.length-1));
				
			}else{
				alert("Exceeding the maximum number of firewall rule. (" + rule_max_num + ")");
				return false;
			}
		}else if(type=="update"){			// save: edit
			rule_list[index].Enable=get_checked_value(get_by_name("enable"));
			rule_list[index].Name=firewall_name;
			rule_list[index].Src_iface=get_select_value(get_by_id("src_iface"));
			rule_list[index].Proto=protocol;
			rule_list[index].Src_ip1=src_ip1;
			rule_list[index].Src_ip2=src_ip2;
			rule_list[index].Dst_iface=get_select_value(get_by_id("dst_iface"));
			rule_list[index].Dst_ip1=dst_ip1;
			rule_list[index].Dst_ip2=dst_ip2;
			rule_list[index].Port1=port1;	
			rule_list[index].Port2=port2;
			rule_list[index].Action=get_checked_value(get_by_name("action"));				
			
			var enable_name="e"+(index);
			var tmp_enable="<input type=\"checkbox\" id=\""+ enable_name +"\" name=\""+ enable_name +"\" value=\"1\">";
			get_by_id("rule_td1_"+(index)).innerHTML=tmp_enable;
			get_by_id("rule_td2_"+(index)).innerHTML=rule_list[index].Action;
			get_by_id("rule_td3_"+(index)).innerHTML=rule_list[index].Name;
			get_by_id("rule_td4_"+(index)).innerHTML=show_iface(rule_list[index].Src_iface) + ":"+show_range(rule_list[index].Src_ip1,rule_list[index].Src_ip2);
			get_by_id("rule_td5_"+(index)).innerHTML=show_iface(rule_list[index].Dst_iface) + ":"+show_range(rule_list[index].Dst_ip1,rule_list[index].Dst_ip2);
			get_by_id("rule_td6_"+(index)).innerHTML=show_protocol(rule_list[index].Proto)+","+show_range(rule_list[index].Port1,rule_list[index].Port2);
			check_box_enabled((index));
		}					
		save_to_cfg();		
		clear_row();
		
		/* for auto send the request */
		var apply_type = auto_apply_to_sys(type);
		if(apply_type == DEFINE_AUTO_SEND){		
			send_request("send");
		}else if(apply_type == DEFINE_SEND_DIRECTLY){
			send_submit("form1");
		}
		
    	return true;
	}
	
	function save_to_cfg(){
		var temp_fr = "";
		var tmp_port1;
		var tmp_port2;
		for(k=0; k<rule_max_num; k++){
			var now_num = k;
			if(parseInt(k,10)<10){
				now_num = "0"+k;
			}			
			temp_fr = "";
			if(k<rule_list.length){
				tmp_port1=save_port(rule_list[k].Port1);
				tmp_port2=save_port(rule_list[k].Port2)	;
				temp_fr = rule_list[k].Enable+"/"+ rule_list[k].Name+"/"+rule_list[k].Src_iface+"/"+ rule_list[k].Proto+"/"+
				rule_list[k].Src_ip1+"/"+rule_list[k].Src_ip2+"/"+rule_list[k].Dst_iface+"/"+rule_list[k].Dst_ip1+"/"+
				rule_list[k].Dst_ip2+"/"+tmp_port1+"/"+tmp_port2+"/Always/"+rule_list[k].Action;
			}
			get_by_id("firewall_rule_"+now_num).value = temp_fr;				
		}
	}
	
	function Data(index, name, enable, action, src_iface, src_ip1, src_ip2, dst_iface, dst_ip1, dst_ip2, proto, port1,port2) 
	{
		this.Index = index;
		this.Name = name;
		this.Enable = enable;		
		this.Action = action;
		this.Src_iface = src_iface;
		this.Src_ip1 = src_ip1;
		this.Src_ip2 = src_ip2;
		this.Dst_iface = dst_iface;
		this.Dst_ip1 = dst_ip1;
		this.Dst_ip2 = dst_ip2;		
		this.Proto = proto;
		this.Port1 = port1;
		this.Port2 = port2;						
	}

	function set_rule_data(){ 	   		
		var index = 0;
		var tmp_fr;
		
		for (var i = 0; i < rule_max_num; i++){				
			var k=i;
			if(i<10){
				k="0"+i;
			}				
			
			tmp_fr = (get_by_id("firewall_rule_" + k).value).split("/");							
			if(tmp_fr.length>1){
				
				if(tmp_fr[1]!=""){												
					rule_list[rule_list.length++] = new Data(index,tmp_fr[1], tmp_fr[0], tmp_fr[12],tmp_fr[2],tmp_fr[4],tmp_fr[5],tmp_fr[6],tmp_fr[7],tmp_fr[8],tmp_fr[3],tmp_fr[9],tmp_fr[10]);						
					index++;
				}
			}
		}			
	}

	function show_firewall_rule(){		
		set_rule_data();
		var tmp_action;		
		for (var i=0; i<rule_list.length;i++){
			var enable_name = "e"+i;			
			var tmp_enable="<input type=\"checkbox\" id=\""+ enable_name +"\" name=\""+ enable_name +"\" value=\"1\">";			
			document.write("<tr id=\"rule_table_"+i+"\" bgcolor=\"#F0F0F0\" onClick=\"edit_row_update("+ i +")\">");
			document.write("<td id=\"rule_td1_"+ i +"\">"+tmp_enable+"</td>");			
			document.write("<td id=\"rule_td2_"+ i +"\">"+ rule_list[i].Action +"</td>");			
			document.write("<td id=\"rule_td3_"+ i +"\">"+ rule_list[i].Name +"</td>");
			document.write("<td id=\"rule_td4_"+ i +"\">"+ show_iface(rule_list[i].Src_iface) + ": "+show_range(rule_list[i].Src_ip1, rule_list[i].Src_ip2)+"</td>");
			document.write("<td id=\"rule_td5_"+ i +"\">"+ show_iface(rule_list[i].Dst_iface) + ": "+show_range(rule_list[i].Dst_ip1, rule_list[i].Dst_ip2)+"</td>");			
			document.write("<td id=\"rule_td6_"+ i +"\">"+ show_protocol(rule_list[i].Proto) +","+show_range(rule_list[i].Port1,rule_list[i].Port2)+"</td>");
			document.write("</tr>\n");
			check_box_enabled(i);			
		}
		for (var i=rule_list.length; i<rule_max_num;i++){
			var enable_name = "e"+i;
			var tmp_enable="<input type=\"checkbox\" id=\""+ enable_name +"\" name=\""+ enable_name +"\" value=\"1\">";
			document.write("<tr id=\"rule_table_"+i+"\" bgcolor=\"#99CCFF\" onClick=\"edit_row_update("+ i +")\" style=\"display:none\">");;
			document.write("<td id=\"rule_td1_"+ i +"\">"+ tmp_enable +"</td>");
			document.write("<td id=\"rule_td2_"+ i +"\"></td>");
			document.write("<td id=\"rule_td3_"+ i +"\"></td>");
			document.write("<td id=\"rule_td4_"+ i +"\"></td>");
			document.write("<td id=\"rule_td5_"+ i +"\"></td>");			
			document.write("<td id=\"rule_td6_"+ i +"\"></td>");
			document.write("</tr>\n");			
		}
		var wan_port_ping_response_enable = get_by_id("wan_port_ping_response_enable").value;		
		if(wan_port_ping_response_enable == 1)
			document.write("<tr bgcolor=\"#F0F0F0\"><td><input type=\"checkbox\" id=\"e0\" value=\"1\" disabled checked></td><td>Allow</td><td>Allow to Ping WAN port</td><td>WAN,*</td><td>WAN,*</td><td>ICMP,</td></tr>");		
		document.write("<tr bgcolor=\"#F0F0F0\"><td><input type=\"checkbox\" id=\"e1\" value=\"1\" disabled checked></td><td>Deny</td><td>Default</td><td>WAN,*</td><td>LAN,*</td><td>*,*</td></tr>");		
		document.write("<tr bgcolor=\"#F0F0F0\"><td><input type=\"checkbox\" id=\"e2\" value=\"1\" disabled checked></td><td>Allow</td><td>Default</td><td>LAN,*</td><td>WAN,*</td><td>*,*</td></tr>");
	}
	
		function check_box_enabled(num){
		var array_num = num;
		get_by_id("e"+num).checked = false;
		get_by_id("e"+num).disabled = true;
		if(parseInt(rule_list[array_num].Enable,10)==1){
			get_by_id("e"+num).checked = true;
		}
	}
	
		function show_protocol(protocol){
		if(protocol=="Any")
			return "*";
		return protocol;	
	}

		function show_iface(iface){
		if(iface=="source")
			return "*";
		return iface;	
	}

	function save_port(port){
		if(port=="")
			return "0";
		else
			return port;
	}

	function show_range(ip1,ip2){
		if(ip1=="*")
			return ip1;
		else if(ip1==ip2)
			return ip1;
		else if(ip2=="")
			return ip1;
		else	
			return ip1+" - "+ip2;		
	}		
	
	function disable_iface(){	
		var src_iface=get_select_value(get_by_id("src_iface"));
		for(i=0;i<get_by_id("dst_iface").length;i++){	 	 	
			if(get_by_id("dst_iface").options[i].value==src_iface){
			 get_by_id("dst_iface").options[i].disabled=true;
			 if(get_by_id("dst_iface").selectedIndex==i)
			 	 get_by_id("dst_iface").selectedIndex=((i+1)%2);
			}
			else 
				get_by_id("dst_iface").options[i].disabled=false;
		}	
		disable_iprange();
	}	
	
	function disable_iprange(){
	 	var action=get_checked_value(get_by_name("action"));
	 	var src_iface=get_select_value(get_by_id("src_iface"));
	 	var dst_iface=get_select_value(get_by_id("dst_iface"));
     	
	 	if(src_iface == dst_iface){
	 		alert("'Lan to Lan' or 'Wan to Wan' is not a valid setting");	 	
	 		clear_row();	 	
	 		get_by_id("src_iface").selectedIndex = 0;			 		
	 		get_by_id("dst_iface").selectedIndex = 1;
	 		return;
	 	}
     	
	 	if((dst_iface=="LAN" || (src_iface=="WAN" && dst_iface==source)) && action=="Allow"){			
 			get_by_id("dst_ip2").value=get_by_id("dst_ip1").value;
	 	 	get_by_id("dst_ip2").disabled=true;
 	 	} else{
  			get_by_id("dst_ip2").disabled=false;
	 	}	
	 	if(get_by_id("dst_iface").selectedIndex==get_by_id("src_iface").selectedIndex)
			get_by_id("dst_iface").value=((get_by_id("dst_iface").selectedIndex+1)%3);
	}
	
	function loadSettings(){		
		get_by_id("edit_row").value = "-1";
		disable_iface();
		disable_iprange();
	}
	
</SCRIPT>
</head>

<body onLoad="MM_preloadImages('but_wizard_1.gif','but_status_1.gif','but_tools_1.gif','but_main_1.gif','but_wireless_1.gif','but_routing_1.gif','but_access_1.gif','but_management_1.gif');loadSettings();">
<table width="750" border="0" cellpadding="0" cellspacing="0">
  <tr>
    <td width="21"><img src="c1_tl.gif" width="21" height="21" /></td>
    <td width="708" background="bg1_t.gif"><img src="top_1.gif" width="390" height="21" /></td>
    <td width="21"><img src="c1_tr.gif" width="21" height="21" /></td>
  </tr>
  <tr>
    <td valign="top" background="bg1_l.gif"><img src="top_2.gif" width="21" height="69" /></td>
    <td background="bg.gif"><table width="100%" border="0" cellpadding="0" cellspacing="0">
      <tr>
        <td width="13%"><img src="logo.gif" width="270" height="69" /></td>
        <td width="87%" align="right"><img src="description.gif" /></td>
      </tr>
    </table>
        <table width="100%" border="0" cellpadding="0" cellspacing="0">
          <tr>
            <td width="20%" height="429" valign="top"><table width="56%" border="0" cellpadding="0" cellspacing="0">
              <tr>
                <td><a href="lan.asp"><img src="but_main_0.gif" name="Image91" border="0" id="Image91" onMouseOver="MM_swapImage('Image91','','but_main_1.gif',1)" onMouseOut="MM_swapImgRestore()"></a></td>
              </tr>
              <tr>
                <td><img src="spacer.gif" width="8" height="8"></td>
              </tr>
              <tr>
                <td><a href="wireless_basic.asp"><img src="but_wireless_0.gif" name="Image101" border="0" id="Image101" onMouseOver="MM_swapImage('Image101','','but_wireless_1.gif',1)" onMouseOut="MM_swapImgRestore()"></a><a href="w_basic.asp"></a></td>
              </tr>
              <tr>
                <td><img src="spacer.gif" width="8" height="8"></td>
              </tr>
              <tr>
                <td><a href="status.asp"><img src="but_status_0.gif" name="Image111" border="0" id="Image111" onMouseOver="MM_swapImage('Image111','','but_status_1.gif',1)" onMouseOut="MM_swapImgRestore()"></a></td>
              </tr>
              <tr>
                <td><img src="spacer.gif" width="8" height="8"></td>
              </tr>
              <tr>
                <td><a href="static_routing.asp"><img src="but_routing_0.gif" name="Image121" border="0" id="Image121" onMouseOver="MM_swapImage('Image121','','but_routing_1.gif',1)" onMouseOut="MM_swapImgRestore()"></a></td>
              </tr>
              <tr>
                <td><img src="spacer.gif" width="8" height="8"></td>
              </tr>
              <tr>
                <td><a href="filters.asp"><img src="but_access_1.gif" name="Image131" border="0" id="Image131" onMouseOver="MM_swapImage('Image131','','but_access_1.gif',1)" onMouseOut="MM_swapImgRestore()"></a></td>
              </tr>
              <tr>
                <td><table width="100%" border="0" cellpadding="2" class="submenubg">
                    <tr>
                      <td width="13%" align="right"><font color="#FFFFFF">&bull;</font></td>
                      <td width="87%"><a href="filters.asp" class="submenus"><b>Filter </b></a></td>
                    </tr>
                    <!--<tr>
                  <td align="right"><font color="#FFFFFF">&bull;</font></td>
                  <td><a href="inbound_filter.asp" class="submenus"><b>Inbound Filter </b></a></td>
                </tr>-->
                    <tr>
                      <td align="right"><font color="#FFFFFF">&bull;</font></td>
                      <td><a href="virtual_server.asp" class="submenus"><b>Virtual Server </b></a></td>
                    </tr>
                    <tr>
                      <td align="right"><font color="#FFFFFF">&bull;</font></td>
                      <td><a href="special_ap.asp" class="submenus"><b>Special AP </b></a></td>
                    </tr>
                    <tr>
                      <td align="right"><font color="#FFFFFF">&bull;</font></td>
                      <td><a href="dmz.asp" class="submenus"><b>DMZ</b></a></td>
                    </tr>
                    <tr>
                      <td align="right"><font color="#FFFFFF">&bull;</font></td>
                      <td><a href="firewall_setting.asp" class="submenus"><b><u>Firewall Rule</u></b></a></td>
                    </tr>
                </table></td>
              </tr>
              <tr>
                <td><img src="spacer.gif" width="8" height="8"></td>
              </tr>
              <tr>
                <td><a href="remote_management.asp"><img src="but_management_0.gif" border="0" id="Image14" onMouseOver="MM_swapImage('Image6','','but_management_1.gif',1)" onMouseOut="MM_swapImgRestore()"></a></td>
              </tr>
              <tr>
                <td><img src="spacer.gif" width="8" height="8"></td>
              </tr>
              <tr>
                <td><a href="restart.asp"><img src="but_tools_0.gif" border="0" id="Image15" onMouseOver="MM_swapImage('Image7','','but_tools_1.gif',1)" onMouseOut="MM_swapImgRestore()"></a></td>
              </tr>
              <tr>
                <td><img src="spacer.gif" width="8" height="8"></td>
              </tr>
              <tr>
                <td><a href="#" onClick="show_wizard('wizard.asp','<% CmoGetStatus("get_current_user"); %>')"><img src="but_wizard_0.gif" name="Image161" border="0" id="Image161" onMouseOver="MM_swapImage('Image161','','but_wizard_1.gif',1)" onMouseOut="MM_swapImgRestore()"></a></td>
              </tr>
              <tr>
                <td><img src="spacer.gif" width="15" height="15"></td>
              </tr>
            </table>
            <p>&nbsp;</p>
              <p>&nbsp;</p></td>
            <td width="2%"><img src="spacer.gif" width="15" height="15" /></td>
            <td width="78%" valign="top"><table width="98%" border="0" cellpadding="0" cellspacing="0" class="tabBigTitle">
                <tr>
                  <td class="headerbg2"><table width="100%" border="0" cellpadding="0" cellspacing="0" style="padding: 10px 0 10px 0">
                    <tr>
                      <td width="79%"><font color="#FFFFFF" class="textheader" style="margin-left:0; padding-left:0">Firewall Rule </font></td>
                      <td width="21%"><input name="button" type="button" class="ButtonHelp" onclick="MM_openBrWindow('help_access.asp#access_DMZ','','scrollbars=yes,resizable=yes,width=800,height=550')" value=" Help " />
                      </td>
                    </tr>
                  </table>                    </td>
                </tr>
                <tr>
                  <td valign="top"><form id="form1" name="form1" method="post" action="apply.cgi">
                    <input type="hidden" id="html_response_page" name="html_response_page" value="back.asp">
                    <input type="hidden" id="html_response_message" name="html_response_message" value="Settings Saved.">
                    <input type="hidden" id="html_response_return_page" name="html_response_return_page" value="firewall_setting.asp">
                    <input type="hidden" id="reboot_type" name="reboot_type" value="filter">
                    <input type="hidden" id="wan_port_ping_response_enable" name="wan_port_ping_response_enable" value="<% CmoGetCfg("wan_port_ping_response_enable","none"); %>">
                    <input type="hidden" id="serial" name="serial">
                    <input type="hidden" id="edit_row" name="edit_row" value="-1">
                    <input type="hidden" id="firewall_rule_00" name="firewall_rule_00" value="<% CmoGetCfg("firewall_rule_00","none"); %>">
	                 <input type="hidden" id="firewall_rule_01" name="firewall_rule_01" value="<% CmoGetCfg("firewall_rule_01","none"); %>">
	                 <input type="hidden" id="firewall_rule_02" name="firewall_rule_02" value="<% CmoGetCfg("firewall_rule_02","none"); %>">
	                 <input type="hidden" id="firewall_rule_03" name="firewall_rule_03" value="<% CmoGetCfg("firewall_rule_03","none"); %>">
	                 <input type="hidden" id="firewall_rule_04" name="firewall_rule_04" value="<% CmoGetCfg("firewall_rule_04","none"); %>">
							<input type="hidden" id="firewall_rule_05" name="firewall_rule_05" value="<% CmoGetCfg("firewall_rule_05","none"); %>">
							<input type="hidden" id="firewall_rule_06" name="firewall_rule_06" value="<% CmoGetCfg("firewall_rule_06","none"); %>">
							<input type="hidden" id="firewall_rule_07" name="firewall_rule_07" value="<% CmoGetCfg("firewall_rule_07","none"); %>">
							<input type="hidden" id="firewall_rule_08" name="firewall_rule_08" value="<% CmoGetCfg("firewall_rule_08","none"); %>">
							<input type="hidden" id="firewall_rule_09" name="firewall_rule_09" value="<% CmoGetCfg("firewall_rule_09","none"); %>">
							<input type="hidden" id="firewall_rule_10" name="firewall_rule_10" value="<% CmoGetCfg("firewall_rule_10","none"); %>">
							<input type="hidden" id="firewall_rule_11" name="firewall_rule_11" value="<% CmoGetCfg("firewall_rule_11","none"); %>">
							<input type="hidden" id="firewall_rule_12" name="firewall_rule_12" value="<% CmoGetCfg("firewall_rule_12","none"); %>">
							<input type="hidden" id="firewall_rule_13" name="firewall_rule_13" value="<% CmoGetCfg("firewall_rule_13","none"); %>">
							<input type="hidden" id="firewall_rule_14" name="firewall_rule_14" value="<% CmoGetCfg("firewall_rule_14","none"); %>">
							<input type="hidden" id="firewall_rule_15" name="firewall_rule_15" value="<% CmoGetCfg("firewall_rule_15","none"); %>">
							<input type="hidden" id="firewall_rule_16" name="firewall_rule_16" value="<% CmoGetCfg("firewall_rule_16","none"); %>">
							<input type="hidden" id="firewall_rule_17" name="firewall_rule_17" value="<% CmoGetCfg("firewall_rule_17","none"); %>">
							<input type="hidden" id="firewall_rule_18" name="firewall_rule_18" value="<% CmoGetCfg("firewall_rule_18","none"); %>">
							<input type="hidden" id="firewall_rule_19" name="firewall_rule_19" value="<% CmoGetCfg("firewall_rule_19","none"); %>">
                    <table width="98%" border="0" align="center" cellpadding="3" cellspacing="1" bgcolor="#333333">
                      <tr>
						<td width="150" align="right" class="bgblue">Enable</td>
						<td colspan="4" bgcolor="#FFFFFF" class="bggrey">
							<input type="radio" name="enable" value="1">Enable
							<input type="radio" name="enable" value="0">Disabled
						</td>
					  </tr>
					  
					  <tr>
						<td align="right" class="bgblue">Name</td>
						<td colspan="4" bgcolor="#FFFFFF" class="bggrey"><input type="text" id="firewall_name" name="firewall_name" size="20" maxlength="27" value=""></td>
					  </tr>
					  
                      <tr>
						<td align="right" class="bgblue">Action</td>
						<td colspan="4" bgcolor="#FFFFFF" class="bggrey">
							<input type="radio" name="action" value="Allow">Allow
							<input type="radio" name="action" value="Deny">Deny</td>
					 </tr> 
					 
					 <tr bgcolor="#339900">
						<td align="right" class="bgblue"><font color="#FFFFFF"></font></td>
						<td width="67" bgcolor="#CCCCCC"><b><font color="#666666" size="2">Interface</font></b></td>
						<td width="106" bgcolor="#CCCCCC"><b><font color="#666666" size="2">IP Range Start</font></b></td>
						<td width="96" bgcolor="#CCCCCC"><b><font color="#666666" size="2">IP Range End</font></b></td>
						<td width="128" bgcolor="#CCCCCC"><b><font color="#666666" size="2">Protocol</font></b></td>
					</tr> 
					
					<tr>
						<td align="right" class="bgblue">Source</td>
						<td width="67" bgcolor="#FFFFFF" class="bggrey">
						<select size="1" id="src_iface" name="src_iface" onChange="disable_iface();">																			
							<option value="LAN">LAN</option>
							<option value="WAN">WAN</option>
						</select></td>
						<td width="106" bgcolor="#FFFFFF" class="bggrey"><input type="text" id="src_ip1" name="src_ip1" size="16" maxlength="15" value=""></td>
						<td width="96" bgcolor="#FFFFFF" class="bggrey"><input type="text" id="src_ip2" name="src_ip2" size="16" maxlength="15" value=""></td>
						<td bgcolor="#FFFFFF" class="bggrey">&nbsp;</td>
					</tr>
					
					<tr>
						<td align="right" class="bgblue">Destination</td>
						<td width="67" bgcolor="#FFFFFF" class="bggrey">
						<select size="1" id="dst_iface" name="dst_iface" onChange="disable_iprange();">					
							<option value="LAN">LAN</option>
							<option value="WAN">WAN</option>
						</select></td>
						<td width="106" bgcolor="#FFFFFF" class="bggrey"><input type="text" id="dst_ip1" name="dst_ip1" size="16" maxlength="15" value=""></td>
						<td width="96" bgcolor="#FFFFFF" class="bggrey"><input type="text" id="dst_ip2" name="dst_ip2" size="16" maxlength="15" value=""></td>
						<td bgcolor="#FFFFFF" class="bggrey"><table width="100%" border="0" cellpadding="3" cellspacing="1">
						<tr>
							<td>
								<select size="1" id="protocol" name="protocol" onChange="check_icmp()">
									<option value="TCP">TCP</option>
									<option value="UDP">UDP</option>
									<option value="ICMP">ICMP</option>
									<option value="Any">*</option>
								</select>
							</td>
						</tr>
						<tr>
							<td>
								<input type="text" id="port1" name="port1" size="6" maxlength="5" value=""> -
								<input type="text" id="port2" name="port2" size="6" maxlength="5" value="">
							</td>
						</tr>
							</table></td>
					</tr>
					
					<tr>
						<td colspan="5" align="left" class="bggrey2">
							<input type="button" value="Add" id="add" name="add" onClick="return send_request('add')">	
							<input type="button" value="Update" id="update" name="update" onClick="return send_request('update')" disabled>
							<input type="button" value="Delete" id="del" name="del" onClick="return del_row()" disabled>
							<input type="button" value="New" id="new" name="cancel" onClick="clear_row()">
							<input type="button" value="Priority Up" id="up" name="up" onClick="change_priority(-1)" disabled>
							<input type="button" value="Priority Down" id="down" name="down" onClick="change_priority(1)" disabled>
							<input type="submit" value="Update Priority" id="priority" name="priority" onClick="return send_request('send')" disabled>
						</td>	
					</tr>
					        
                    
                    </table>
					
					<table width="98%" border="0" align="center" cellpadding="3" cellspacing="1" bgcolor="#333333" id="table1">
 					<tr align="center" bgcolor="#C5CEDA">
						<td align="center" bgcolor="#CCCCCC"><font face="Arial" color="#FFFFFF"></font></td>
						<td align="center" bgcolor="#CCCCCC"><b>Action</b></td>
						<td align="center" bgcolor="#CCCCCC"><b>Name</b></td>
						<td align="center" bgcolor="#CCCCCC"><b>Source</b></td>
						<td align="center" bgcolor="#CCCCCC"><b>Destination</b></td>
						<td align="center" bgcolor="#CCCCCC"><b>Protocol</b></td>
					</tr>
						<script>
						<!-- repeat name=show_firewall_rule -->
						show_firewall_rule();
						</script>
 					</table>
 					
 										
                  </form>
                    <br>
                  </td>
                </tr>
            </table></td>
          </tr>
      </table></td>
    <td background="bg1_r.gif">&nbsp;</td>
  </tr>
  <tr>
    <td><img src="c1_bl.gif" width="21" height="20" /></td>
    <td align="right" background="bg1_b.gif"><img src="copyright.gif" width="264" height="20" /></td>
    <td><img src="c1_br.gif" width="21" height="20" /></td>
  </tr>
</table>
<script>
    var login_who="<% CmoGetStatus("get_current_user"); %>";
    if(login_who == "user")
    {
        get_by_id("add").disabled  = "true";
        get_by_id("del").disabled  = "true";
        get_by_id("new").disabled  = "true";
        get_by_id("update").disabled  = "true";
		get_by_id("up").disabled  = "true";
		get_by_id("down").disabled  = "true";
		get_by_id("priority").disabled  = "true";
    }
</script>

</body>
</html>
