#!/bin/sh
PROJECTS_PATH=$1
FS_PATH=$PROJECTS_PATH/rootfs/target
PROJECTS_IMAGE_PATH=$PROJECTS_PATH/image
BS=$(($2-64))
ROOTFS_SIZE=$(($BS*1024))
echo " Using mksquashfs :"
echo " $PLATFORM"
	$PROJECTS_PATH/rootfs/setup_rootdir
	rm -r -f /$PROJECTS_IMAGE_PATH/squash.bin
	rm -r -f /$PROJECTS_IMAGE_PATH/squash
	$PROJECTS_PATH/tools/mksquashfs-lzma $FS_PATH $PROJECTS_IMAGE_PATH/squash -be -always-use-fragments
	chmod 644 $PROJECTS_IMAGE_PATH/squash
	$PROJECTS_PATH/tools/cvimg root $PROJECTS_IMAGE_PATH/squash $PROJECTS_IMAGE_PATH/squash.bz F0000 F0000
        IMGSIZE=`du -s $PROJECTS_IMAGE_PATH/squash |  cut -f1`
	ROOTSIZE=`du -s $FS_PATH | cut -f1`
	echo "=============================================="
	echo "Summary:"
	echo "==>Squashfs disk size  = $ROOTSIZE        KBytes"
	echo "==>Squashfs image size = $IMGSIZE KBytes"
	chmod 644 $PROJECTS_IMAGE_PATH/squash.bz
	dd if=$PROJECTS_IMAGE_PATH/squash.bz of=$PROJECTS_IMAGE_PATH/squash.bin bs=$ROOTFS_SIZE count=1 conv=sync
