#include <asm/asm.h>
#include <asm/regdef.h>
#include <asm/mipsregs.h>
#include "start.h"
#include "../autoconf.h"


		.text
		.set noreorder
		.globl __start
__start:
		j 	load_boot
		nop              
//--------------------------------------------------------------------------------              
 load_boot:   
 		move 	t0, zero
		mtc0 	t0, $12
		nop
//-------------------------------------------------------------------------------- 
#ifdef RTL8196B
		li     t0, 0x00FFFFD6 
 		li     t1, 0xb8000010
 	      	sw     t0, 0(t1)
 	        nop
	################  2nd BIST-R  ######################
	
	        // 2nd BIST-R for fully SWITCH reset
	        li     t0,  0x4  # mem timing configuration Reg1 init
 	        li     t1, 0xbb804204
 	        sw     t0, 0(t1)  
 	        nop
 	        nop

	################2nd BIST-R end######################
#endif
#define ROMSIZE_1Mbyte (2 <<29)
#define ROMSIZE_2Mbyte (3 <<29)
#define ROMSIZE_4Mbyte (4 <<29)
#define ROMSIZE_8Mbyte (5 <<29)

#define RAMSIZE_4Mbyte  (1 <<26)
#define RAMSIZE_8Mbyte  (2 <<26)
#define RAMSIZE_16Mbyte (3 <<26)
#define RAMSIZE_32Mbyte (4 <<26)

#define LATENCY_2 (0<<25)
#define LATENCY_3 (1<<25)

#define BANKWIDTH_16bit (1<<23 + 1<<21)
#define BANKWIDTH_32bit (2<<23 + 2<<21)

#define RAMWIDTH_16bit (0<<20)
#define RAMWIDTH_32bit (1<<20)

#define REFRESH_1024T (4<<15)

#ifndef RTL8196B
//#ifdef MEMORY_32_BIT_MODE
#ifdef CONFIG_F2_D16_32          
        li		t0,  ROMSIZE_2Mbyte + RAMSIZE_8Mbyte + LATENCY_3 + BANKWIDTH_16bit + RAMWIDTH_32bit + REFRESH_1024T  // 2M flash, 8M SDRAM 32bit
#elif defined(CONFIG_F4_D32_32)
        li		t0,  ROMSIZE_4Mbyte + RAMSIZE_16Mbyte + LATENCY_3 + BANKWIDTH_16bit + RAMWIDTH_32bit + REFRESH_1024T  // 4M flash, 16M SDRAM 32bit
#elif defined(CONFIG_F8_D32_32)
        //li		t0,  ROMSIZE_8Mbyte + RAMSIZE_32Mbyte + LATENCY_3 + BANKWIDTH_16bit + RAMWIDTH_32bit + REFRESH_1024T  // 8M flash, 32M SDRAM 32bit
#elif defined(CONFIG_F4_D64_32)
        li		t0,  ROMSIZE_4Mbyte + RAMSIZE_32Mbyte + LATENCY_3 + BANKWIDTH_16bit + RAMWIDTH_32bit + REFRESH_1024T  // 4M flash, 32M SDRAM 32bit
//#else               
        //li		t0,  ROMSIZE_2Mbyte + RAMSIZE_8Mbyte + LATENCY_3 + BANKWIDTH_16bit + RAMWIDTH_16bit + REFRESH_1024T  // 2M flash, 8M SDRAM 16b
#elif defined(CONFIG_F4_D16_16)        
        li		t0,  ROMSIZE_4Mbyte + RAMSIZE_16Mbyte + LATENCY_3 + BANKWIDTH_16bit + RAMWIDTH_16bit + REFRESH_1024T  // 4M flash, 16M SDRAM 16b
        //li		t0,  ROMSIZE_8Mbyte + RAMSIZE_32Mbyte + LATENCY_3 + BANKWIDTH_16bit + RAMWIDTH_16bit + REFRESH_1024T  // 8M flash, 32M SDRAM 16b
#elif defined(CONFIG_F4_D32_16)        
       li		t0,  ROMSIZE_4Mbyte + RAMSIZE_32Mbyte + LATENCY_3 + BANKWIDTH_16bit + RAMWIDTH_16bit + REFRESH_1024T  // 4M flash, 32M SDRAM 16b 
#elif defined(CONFIG_F2_D32_16)
        li		t0,  ROMSIZE_2Mbyte + RAMSIZE_32Mbyte + LATENCY_3 + BANKWIDTH_16bit + RAMWIDTH_16bit + REFRESH_1024T  // 2M flash, 32M SDRAM 16b
#elif defined(CONFIG_F2_D16_16)       
        li		t0,  ROMSIZE_2Mbyte + RAMSIZE_16Mbyte + LATENCY_3 + BANKWIDTH_16bit + RAMWIDTH_16bit + REFRESH_1024T  // 2M flash, 16M SDRAM 16bit
#endif        

		//li     t0, 0x6ab20000
		li     t1, 0xb8001000
		sw     t0, 0(t1)        //  *(0xb8001000)=0x92a28000    ,memory control register
					//				1001 0010 1010 0010 | 1000 0000 0000 0000   
					//				(31-29) 100: ROM=4M  
					//				(28-26) 100: RAM=4M  
					//				(25)    1  : Latency=3  
					//				(24-23) 01 : 16bit bank0
					//				(22-21) 01:  16bit bank1
					//				(20)     0: 16bit SDRAM
					//				(19)   reserverd : 0
					//				(18)  SyncMode: 0 Async
					//				(17-15)  ARIT: 101 512T
					//				(14)   MemLEndian: 0
					//
#endif //RTL8196B            

#ifdef RTL8196B
            // ew 0xb8001004 = 0x54880000 // DCR ,SDR=64MB-Micron
            //ew 0xb8001004 = 0x54480000 // DCR ,SDR=32MB
            //ew 0xb8001004 = 0x52480000 // DCR ,SDR=16MB
            //ew 0xb8001004 = 0x52080000 // DCR ,SDR=8MB
//#if defined(CONFIG_D8_16)
//          	li     t0, 0x52080000
//#elif defined(CONFIG_D16_16)
		li     t0, 0x52480000
//#elif defined(CONFIG_D32_16)
		/* SDR 32MB */
        //  	li     t0, 0x54480000 # mem timing configuration Reg0 init
//#elif defined(CONFIG_D64_16)
//          	li     t0, 0x54880000
//#endif
#else
          	li     t0, 0x1b1b0000
#endif
        	li     t1, 0xb8001004 #(DCR)
           	sw     t0, 0(t1)	//  *(0xb8001004)=0xffffff00	,Memory Timing Configuration Register 0
           				//				(31-28)
           				//				(27-24)
           				//				(23-20)
           				//				(19-16)
           				//				(15-0)Reserved: 0
            
#ifdef RTL8196B
         	li     t0, 0x6CEA0A80 #0xffff05c0 # mem timing configuration Reg1 init
#else
         	li     t0, 0xd0b
#endif
 			li     t1, 0xb8001008
 	      	sw     t0, 0(t1)	//  *(0xb8001008)=0xfeb		,Memory Timing Configuration Register 1   
 	      				//				(12-10)   111
 	      				//				(9-5)   11111
 	      				//				(4-0)   11111                            
		li     t0, 0x00FFFFCB 
 		li     t1, 0xb8000010
 	      	sw     t0, 0(t1)
 		nop
 		nop
#ifdef RTL8196B
		li	t0, 0x20000000 #enable prefetch
		li	t1, 0xb8001000
		sw	t0, 0(t1)
#endif
//--------------------------------------------------------------------------------
// flush all cache
		mtc0	zero, $20	//cache control register:  *(20)=0x00
		nop
		nop
		li		t0, 0x3
		mtc0	t0, $20		//cache control register:  *(20)=0x03
		nop
		nop
		mtc0	zero, $20	//cache control register:  *(20)=0x00

//--------------------------------------------------------------------------------		
// Load to 80100000 for compress
// Load to 80000000 for non-compress

//#define __boot_start 0xbfc00000
//#define __boot_end   0xbfcd0000 
//#define BOOT_ADDR    0x80100000

		la		k0, __boot_start
		la		k1, (__boot_end + 4)
		la		t1, BOOT_ADDR
1:
		lw		t0, 0(k0)
		nop

		sw		t0, 0(t1)	//*(t1)=*(t0)   t1+=4;  t0+=4;   t1=BOOT_ADDR, t0=__boot_start, run loop
		nop

		addu	t1, 4
		
		addu	k0, 4
		
		bne		k1, k0, 1b
		nop
		nop

//--------------------------------------------------------------------------------				
//		Jump to booting	


	li sp,0x80300000
	/*
	jal uart_init
	li a0,'A'
	jal print_char
	li a0,'B'
	jal print_char

	li a0,'C'
	jal print_char
#include "uart.s"	
	
*/


		li		k0, BOOT_ADDR
		jr		k0
		nop

                            
//--------------------------------------------------------------------------------





