/*
 * Copyright c                Realtek Semiconductor Corporation, 2003
 * All rights reserved.                                                    
 * 
 * $Header: /cvsroot/WWW/TEW-651BR/kernel_patch/linux-2.6.x/drivers/net/re865x/rtl_nic.c,v 1.1 2009/08/26 09:07:44 jackey Exp $
 *
 * $Author: jackey $
 *
 * Abstract: Pure L2 NIC driver, without RTL865X's advanced L3/4 features.
 *
 *   re865x_nic.c: NIC driver for the RealTek 865* 
 *
 */

#define DRV_RELDATE		"Mar 25, 2004"
#include <linux/config.h>
#include <linux/autoconf.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/compiler.h>
#include <linux/netdevice.h>
#include <linux/inetdevice.h>
#include <linux/etherdevice.h>
#include <linux/init.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <linux/ethtool.h>
#include <linux/mii.h>
#include <linux/if_vlan.h>
#include <linux/crc32.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <asm/rtl865x/interrupt.h>
#include <asm/rtl865x/re865x.h>
#include <linux/slab.h>
#include <linux/signal.h>
#include <linux/proc_fs.h>
#include <linux/time.h>
#include <linux/rtc.h>
#include "version.h"

#include "rtl_nic.h"

#include "common/rtl_types.h"
#include "common/mbuf.h"
#include "common/rtl_glue.h"
#include "common/rtl8651_aclLocal.h"
#include "common/rtl_errno.h"
#include "common/rtl8651_tblDrvProto.h"

#include "swNic2.h"
#include "assert.h"
#include "rtl865xc_swNic.h"

#include "AsicDriver/asicRegs.h"
#include "AsicDriver/rtl8651_tblAsicDrv.h"


/*common*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#include "common/rtl865x_vlan.h"
#include "common/rtl865x_netif.h"
#include "common/rtl865x_netif_local.h"
#include "l2Driver/rtl865x_fdb.h"
#else
#include "common/rtl865x_common.h"
#include "common/rtl865x_common_local.h"
#endif

/*l2*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#include "l2Driver/rtl865x_fdb.h"
#else
#include "l2Driver/rtl865x_layer2.h"
#include "l2Driver/rtl865x_layer2_local.h"
#endif

/*l3*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#include "l3Driver/rtl865x_ip.h"
#include "l3Driver/rtl865x_nexthop.h"
#include "l3Driver/rtl865x_ppp.h"
#include "l3Driver/rtl865x_route.h"
#include "l3Driver/rtl865x_arp.h"
#include "l4Driver/rtl865x_nat.h"

#else
#include "l3Driver/rtl865x_layer3.h"
#include "l3Driver/rtl865x_layer3_local.h"
#include "l4Driver/rtl865x_layer4.h"
#include "l4Driver/rtl865x_layer4_local.h"
#endif

/*l4*/


#undef CONFIG_RTL865X_ROMEPERF
#ifdef	CONFIG_RTL865X_ROMEPERF
#include "romeperf.h"
#endif

#ifdef RTL865X_DRIVER_DEBUG_FLAG
#include "common/rtl865x_proc_debug.h"
#endif

#if defined(CONFIG_PROC_FS) && defined(CONFIG_NET_QOS) && defined(CONFIG_RTL865X_LAYERED_DRIVER)
#if defined(CONFIG_RTL865X_HW_QOS_SUPPORT)
#include <l2Driver/rtl865x_outputQueue.h>
#endif
#endif

#ifdef CONFIG_RTL865X_HW_PPTPL2TP
#include <linux/netfilter_ipv4/ip_conntrack.h>
#include <linux/netfilter_ipv4/ip_conntrack_pptp.h>
#endif


#ifdef CONFIG_RTL_STP
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#include "l2Driver/rtl865x_fdb.h"
#else
#include "l2Driver/rtl865x_layer2.h"
#endif
#endif

#ifdef CONFIG_RTL865X_IGMP_SNOOPING
#include "igmpsnooping/rtl865x_igmpsnooping.h"
#include "linux/ip.h"
static uint32 nicIgmpModuleIndex=0xFFFFFFFF;
#endif

#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
#include "l3Driver/rtl865x_multicast.h"
#endif

#ifdef CONFIG_RTL8186_GR
static int oldStatus = 0;
#endif

#if 0
#define DEBUG_ERR printk
#else
#define DEBUG_ERR(format, args...)
#endif

#ifdef CONFIG_RTL865X_LAYERED_DRIVER

#else
extern struct lr_cpu_stats 					lr_stats;
extern struct vlan_table					vlan_tbl;
extern struct acl_table						acl_tbl;
extern struct if_table						if_tbl;

extern struct natip_table					natip_tbl;
extern struct rt_table						rt_tbl;
extern struct arp_table						arpt_tbl;
extern struct pppoe_table					pppoe_tbl;

extern struct fdb_table						fdb_tbl;
extern struct port_attribute					port_attr;

#endif

extern struct nat_table						nat_tbl;


static int32 __865X_Config;
//#define RX_TASKLET
#define TX_TASKLET
#if defined(CONFIG_NET_WIRELESS_AGN) || (CONFIG_RTL8192SE)
#if	defined(CONFIG_RTL865X_EXTPORT)
#undef BR_SHORTCUT
#else
#define BR_SHORTCUT
#endif

#endif

#define RTK_QUE

#define BIT(x)	(1<<(x))

#ifdef BR_SHORTCUT
static int eth_flag=4; // 0 dynamic tasklet, 1 - disable tasklet, 2 - always tasklet , bit2 - bridge shortcut enabled
static int pkt_cnt=0, enable_brsc=0;
__DRAM_FWD  unsigned char cached_eth_addr[6];
__DRAM_FWD  struct net_device *cached_dev;
#endif

#if defined(DYNAMIC_ADJUST_TASKLET) || defined(CONFIG_RTL8186_TR) || defined(BR_SHORTCUT)
static void one_sec_timer(unsigned long task_priv);
#endif

#if 0
#define MAX_PRE_ALLOC_RX_SKB		256
#define NUM_RX_PKTHDR_DESC		512
#define NUM_TX_PKTHDR_DESC		1024
#else
	#ifdef DELAY_REFILL_ETH_RX_BUF
	#define MAX_PRE_ALLOC_RX_SKB	64
	#else
	#define MAX_PRE_ALLOC_RX_SKB	160
	#endif
#define NUM_RX_PKTHDR_DESC		256
#define NUM_TX_PKTHDR_DESC		512
#endif

#ifdef CONFIG_RTL865X_ETH_PRIV_SKB
static struct sk_buff *dev_alloc_skb_priv_eth(unsigned int size);
static void init_priv_eth_skb_buf(void);
#endif

struct ring_que {
	int qlen;
	int qmax;	
	int head;
	int tail;
	struct sk_buff **ring;
};
__DRAM_FWD static struct ring_que rx_skb_queue;
int skb_num=0;

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	int32 rtl865x_init(void);
	int32 rtl865x_config(struct rtl865x_vlanConfig vlanconfig[]);
#else
enum RTL_RESULT rtl865x_init(void);
enum RTL_RESULT rtl865x_config(struct rtl865x_vlanConfig vlanconfig[]);
#endif

/* These identify the driver base version and may not be removed. */
MODULE_DESCRIPTION("RealTek RTL-8650 series 10/100 Ethernet driver");
MODULE_LICENSE("GPL");

#ifdef CONFIG_DEFAULTS_KERNEL_2_6
static char* multicast_filter_limit = "maximum number of filtered multicast addresses";
module_param (multicast_filter_limit,charp, S_IRUGO);
#else
/* Maximum number of multicast addresses to filter (vs. Rx-all-multicast).
   The RTL chips use a 64 element hash table based on the Ethernet CRC.  */
MODULE_PARM (multicast_filter_limit, "i");
MODULE_PARM_DESC (multicast_filter_limit, "maximum number of filtered multicast addresses");
#endif

#define DRV_NAME		"re865x_nic"
#define PFX			DRV_NAME ": "
#define DRV_VERSION		"0.1"
#define TX_TIMEOUT		(10*HZ)
#define BDINFO_ADDR 0xbe3fc000

spinlock_t *rtl865xSpinlock;
struct tasklet_struct	*rtl8651RxTasklet;


#define NEXT_DEV(cp)			(cp->dev_next ? cp->dev_next : cp->dev_prev)
#define NEXT_CP(cp)			((struct dev_priv *)NEXT_DEV(cp)->priv)
#define IS_FIRST_DEV(cp)	(NEXT_CP(cp)->opened ? 0 : 1)
#define GET_IRQ_OWNER(cp) (cp->irq_owner ? cp->dev : NEXT_DEV(cp))

#define MAX_PORT_NUM 9

static unsigned int rxRingSize[RTL865X_SWNIC_RXRING_MAX_PKTDESC] = {NUM_RX_PKTHDR_DESC, 0, 0, 0, 0, 0};
static unsigned int txRingSize[RTL865X_SWNIC_TXRING_MAX_PKTDESC] = {NUM_TX_PKTHDR_DESC, 0};

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
static struct rtl865x_vlanConfig vlanconfig[] = {
/*      	ifName  W/L      If type		VID	 FID	   Member Port	UntagSet		mtu		MAC Addr	is_slave								*/
/*		=====  ===   =======	===	 ===   =========   =======	====	====================================	*/

#ifdef CONFIG_BRIDGE
	{ 	"br0",	 0,   IF_ETHER, 	RTL_LANVLANID, 	   0, 		RTL_LANPORT_MASK, 		RTL_LANPORT_MASK,		1500, 	{ { 0x00, 0x12, 0x34, 0x56, 0x78, 0x90 } }, 0	},
	{	"eth1",	 1,   IF_ETHER,		RTL_WANVLANID,	   0,		RTL_WANPORT_MASK,		RTL_WANPORT_MASK,		1500,	{ { 0x00, 0x12, 0x34, 0x56, 0x78, 0x91 } }, 0	},
	//{ 	"eth0",	 0,   IF_NONE, 	RTL_LANVLANID, 	   0, 		RTL_LANPORT_MASK, 		RTL_LANPORT_MASK,		1500, 	{ { 0x00, 0x12, 0x34, 0x56, 0x78, 0x90 } }, 1	},
#else
	{ 	"eth0",	 0,   IF_ETHER, 	RTL_LANVLANID, 	   0, 		RTL_LANPORT_MASK, 		RTL_LANPORT_MASK,		1500, 	{ { 0x00, 0x12, 0x34, 0x56, 0x78, 0x90 } }, 0	},
	{	"eth1",	 1,   IF_ETHER,		RTL_WANVLANID,	   0,		RTL_WANPORT_MASK,		RTL_WANPORT_MASK,		1500,	{ { 0x00, 0x12, 0x34, 0x56, 0x78, 0x91 } }, 0	},
#endif
	{	"ppp0", 1,   IF_PPPOE,    		RTL_WANVLANID,    0,    		RTL_WANPORT_MASK,         	RTL_WANPORT_MASK,     1500, { { 0x00, 0x12, 0x34, 0x56, 0x78, 0x91 } }, 1 },
	RTL865X_CONFIG_END,
};

#else

static struct rtl865x_vlanConfig vlanconfig[] = {
/*      	ifName  W/L      If type		VID	 FID	   Member Port	UntagSet		mtu		MAC Addr									*/
/*		=====  ===   =======	===	 ===   =========   =======	====	====================================	*/

#ifdef CONFIG_BRIDGE
	{ 	"br0",	 0,   IF_ETHER, 	RTL_LANVLANID, 	   0, 		RTL_LANPORT_MASK, 		RTL_LANPORT_MASK,		1500, 	{ { 0x00, 0x12, 0x34, 0x56, 0x78, 0x90 } }	},
	{	"eth1",	 1,   IF_ETHER,		RTL_WANVLANID,	   0,		RTL_WANPORT_MASK,		RTL_WANPORT_MASK,		1500,	{ { 0x00, 0x12, 0x34, 0x56, 0x78, 0x91 } }	},
#else
	{ 	"eth0",	 0,   IF_ETHER, 	RTL_LANVLANID, 	   0, 		RTL_LANPORT_MASK, 		RTL_LANPORT_MASK,		1500, 	{ { 0x00, 0x12, 0x34, 0x56, 0x78, 0x90 } }	},
	{	"eth1",	 1,   IF_ETHER,		RTL_WANVLANID,	   0,		RTL_WANPORT_MASK,		RTL_WANPORT_MASK,		1500,	{ { 0x00, 0x12, 0x34, 0x56, 0x78, 0x91 } }	},
#endif
	{	"ppp0", 1,   IF_PPPOE,    		RTL_WANVLANID,    0,    RTL_WANPORT_MASK,         RTL_WANPORT_MASK,     1500, { { 0x00, 0x12, 0x34, 0x56, 0x78, 0x91 } } },
	LRCONFIG_END,
};

#endif

#if defined(CONFIG_PROC_FS) && defined(CONFIG_NET_QOS) && defined(CONFIG_RTL865X_LAYERED_DRIVER)
static uint8	netIfName[NETIF_NUMBER][IFNAMSIZ] = {{0}};
#endif

#ifdef CONFIG_RTL865X_ETH_PRIV_SKB
	#ifdef CONFIG_RTL8196B
		#ifdef DELAY_REFILL_ETH_RX_BUF
		#define MAX_ETH_SKB_NUM	(NUM_RX_PKTHDR_DESC + MAX_PRE_ALLOC_RX_SKB + 400)
		#else
		#define MAX_ETH_SKB_NUM	(NUM_RX_PKTHDR_DESC + MAX_PRE_ALLOC_RX_SKB + 400)
		#endif

	#else
	#define MAX_ETH_SKB_NUM	(NUM_RX_PKTHDR_DESC + MAX_PRE_ALLOC_RX_SKB + 256)
	#endif

#define ETH_SKB_BUF_SIZE	(CROSS_LAN_MBUF_LEN+sizeof(struct skb_shared_info)+160)
//#define ETH_SKB_BUF_SIZE	2048
#define ETH_MAGIC_CODE		"865x"

struct priv_skb_buf2 {
	unsigned char magic[4];
	struct list_head	list;	
	unsigned char buf[ETH_SKB_BUF_SIZE];
};

static struct priv_skb_buf2 eth_skb_buf[MAX_ETH_SKB_NUM+1];
static struct list_head eth_skbbuf_list;

int eth_skb_free_num=MAX_ETH_SKB_NUM;
extern struct sk_buff *dev_alloc_8190_skb(unsigned char *data, int size);
#endif

#if	defined(CONFIG_RTL865X_EXTPORT)
struct net_device *cachedWlanDev = NULL;
#endif

int rtl865x_curOpMode=GATEWAY_MODE;

 struct re865x_priv
{
	u16			ready;
	u16			addIF;
	u16			devnum;
	u32			sec_count;
	u32			sec;
	struct	net_device	*dev[RTL8651_VLAN_NUMBER];
#ifdef CONFIG_RTL_STP
	struct	net_device	*stp_port[MAX_RE865X_STP_PORT];
#endif
	spinlock_t		lock;
	void			*regs;
	struct tasklet_struct	rx_tasklet;
	struct timer_list timer;	/* Media monitoring timer. */
	unsigned long		linkchg;	
};

__DRAM_FWD static  struct re865x_priv _rtl86xx_dev; 

struct dev_priv {
	u32			id;            /* VLAN id, not vlan index */
	u32			portmask;     /* member port mask */
	u32			portnum;     	/* number of member ports */
	u32			netinit;
	struct net_device	*dev;
	struct net_device   *dev_prev;
	struct net_device   *dev_next;
#ifdef RX_TASKLET
	struct tasklet_struct   rx_dsr_tasklet;
#endif

#ifdef TX_TASKLET
	struct tasklet_struct   tx_dsr_tasklet;
#endif
	//struct re865x_priv	*priv;
#ifdef CP_VLAN_TAG_USED
	struct vlan_group	*vlgrp;
#endif
	spinlock_t			lock;
	u32			msg_enable;
	u32 			opened;
	u32			irq_owner; //record which dev request IRQ
	struct net_device_stats net_stats;
#if defined(DYNAMIC_ADJUST_TASKLET) || defined(CONFIG_RTL8186_TR) || defined(BR_SHORTCUT)
    struct timer_list expire_timer; 
#endif

#if 0
	int			ip;
	int			mask;
	int			dns;
	int			pppoe_status;
	int			gateway;
	int			setup;
//	struct mii_if_info	mii_if;
#endif
};

#ifdef CONFIG_RTL_STP
static unsigned char STPmac[] = { 1, 0x80, 0xc2, 0,0,0};
int8 STP_PortDev_Mapping[MAX_RE865X_STP_PORT] ={NO_MAPPING, NO_MAPPING, NO_MAPPING, NO_MAPPING, NO_MAPPING, WLAN_PSEUDO_IF_INDEX};
static int re865x_stp_get_pseudodevno(uint32 port_num);
#endif

static int re865x_ioctl (struct net_device *dev, struct ifreq *rq, int cmd);

/* Set or clear the multicast filter for this adaptor.
 * This routine is not state sensitive and need not be SMP locked.
 */
static void re865x_set_rx_mode (struct net_device *dev){
	unsigned long flags;
	spin_lock_irqsave (&_rtl86xx_dev.lock, flags);
	//Not yet implemented.
	spin_unlock_irqrestore (&_rtl86xx_dev.lock, flags);
}

static struct net_device_stats *re865x_get_stats(struct net_device *dev){
	struct dev_priv  *dp = dev->priv;
	return &dp->net_stats;
}

static void rtl865x_disableDevPortForward(struct net_device *dev, struct dev_priv *cp)
{
	int port;
	for(port=0;port<RTL8651_AGGREGATOR_NUMBER;port++)
	{
		if((1<<port) & cp->portmask)
		{
#if 1
//			WRITE_MEM32(PCRP0+(port<<2), ((READ_MEM32(PCRP0+(port<<2)))&(~EnablePHYIf))
			REG32(PCRP0+(port<<2))= ((REG32(PCRP0+(port<<2)))&(~EnablePHYIf));
#else
			rtl865xC_setAsicEthernetForceModeRegs(port, TRUE, FALSE, 1, TRUE);
#endif
		}
	}
	
}

static void rtl865x_enableDevPortForward(struct net_device *dev, struct dev_priv *cp)
{
	int port;
	for(port=0;port<RTL8651_AGGREGATOR_NUMBER;port++)
	{
		if((1<<port) & cp->portmask)
		{
#if 1
			REG32(PCRP0+(port<<2))= ((REG32(PCRP0+(port<<2)))|(EnablePHYIf));
#else
			rtl865xC_setAsicEthernetForceModeRegs(port, FALSE, TRUE, 1, TRUE);
			rtl8651_restartAsicEthernetPHYNway(port);
#endif
		}
	}
	
}

static void rtl865x_disableInterrupt(void)
{
	REG32(CPUICR) = 0; 
	REG32(CPUIIMR) = 0;      
}

static void rtk_queue_init(struct ring_que *que)
{
	memset(que, 0, sizeof(struct ring_que));
	que->ring = (struct sk_buff **)kmalloc(
		(sizeof(struct skb_buff*)*(rtl865x_maxPreAllocRxSkb+1))
		,GFP_KERNEL);
	memset(que->ring, 0, (sizeof(struct sk_buff *))*(rtl865x_maxPreAllocRxSkb+1));
	que->qmax = rtl865x_maxPreAllocRxSkb;	
}

static int rtk_queue_tail(struct ring_que *que, struct sk_buff *skb)
{
	int next;
	uint32 flags;

	local_irq_save(flags);

	if (que->head == que->qmax)
		next = 0;
	else
		next = que->head + 1;
	
	if (que->qlen >= que->qmax || next == que->tail) {
		local_irq_restore(flags);							
		return 0;
	}	
	
	que->ring[que->head] = skb;
	que->head = next;
	que->qlen++;

	local_irq_restore(flags);					
	
	return 1;
}

static struct sk_buff *rtk_dequeue(struct ring_que *que)
{
	struct sk_buff *skb;
	uint32 flags;

	local_irq_save(flags);

	if (que->qlen <= 0 || que->tail == que->head) {
		local_irq_restore(flags);							
		return NULL;
	}

	skb = que->ring[que->tail];
		
	if (que->tail == que->qmax)
		que->tail  = 0;
	else
		que->tail++;

	que->qlen--;	

	local_irq_restore(flags);					
	
	return (struct sk_buff *)skb;
}

static void refill_rx_skb(void)
{
	struct sk_buff *skb;

	while (rx_skb_queue.qlen < rtl865x_maxPreAllocRxSkb) {
#ifdef CONFIG_RTL865X_ETH_PRIV_SKB
		skb = dev_alloc_skb_priv_eth(CROSS_LAN_MBUF_LEN);
#else
		skb = dev_alloc_skb(CROSS_LAN_MBUF_LEN);
#endif

		if (skb == NULL) { 
			DEBUG_ERR("EthDrv: dev_alloc_skb() failed!\n");		
			return;
		}
		skb_reserve(skb, RX_OFFSET);	
#ifdef RTK_QUE
		rtk_queue_tail(&rx_skb_queue, skb);
#else		
		__skb_queue_tail(&rx_skb_queue, skb);
#endif
	}
}

//---------------------------------------------------------------------------
static void free_rx_skb(void)
{
	struct sk_buff *skb;

	swNic_freeRxBuf();

	while  (rx_skb_queue.qlen > 0) {
#ifdef RTK_QUE
		skb = rtk_dequeue(&rx_skb_queue);
#else
		skb = __skb_dequeue(&rx_skb_queue);
#endif
		dev_kfree_skb_any(skb);
	}
}

//---------------------------------------------------------------------------
void *UNCACHED_MALLOC(int size) 
{
	return ((void *)(((uint32)kmalloc(size, GFP_KERNEL)) | UNCACHE_MASK));	
}

//---------------------------------------------------------------------------
unsigned char *alloc_rx_buf(void **skb, int buflen)
{
	struct sk_buff *new_skb;

	if (rx_skb_queue.qlen == 0) {
#ifdef CONFIG_RTL865X_ETH_PRIV_SKB
		new_skb = dev_alloc_skb_priv_eth(CROSS_LAN_MBUF_LEN);
#else        
		new_skb = dev_alloc_skb(CROSS_LAN_MBUF_LEN);
#endif
		if (new_skb == NULL) { 
			DEBUG_ERR("EthDrv: dev_alloc_skb() failed!\n");		
		}
		else 
			skb_reserve(new_skb, RX_OFFSET);	
	}
	else {
#ifdef RTK_QUE
		new_skb = rtk_dequeue(&rx_skb_queue);
#else
		new_skb = __skb_dequeue(&rx_skb_queue);
#endif
	}
	
	if (new_skb == NULL) 
		return NULL;	
	*skb = new_skb;

	#ifdef RTL865X_RX_RUNOUT_BUG
	/* store the skb pointer in a DW in front of  new_skb->data, it will be used in swNic_receive() */
	*(uint32 *)(new_skb->data-6) = (uint32)(new_skb);
	#endif

	return new_skb->data;		
}

//---------------------------------------------------------------------------
void free_rx_buf(void *skb)
{
	dev_kfree_skb_any((struct sk_buff *)skb);
}

//---------------------------------------------------------------------------
void tx_done_callback(void *skb)
{
//	dev_kfree_skb_irq((struct sk_buff *)skb);	
	dev_kfree_skb_any((struct sk_buff *)skb);
}

#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
//__IRAM_FWD
static void re865x_rxProcessUnknownMCast(struct sk_buff *skb, unsigned int vid, unsigned int pid)
{
	char *ptr=skb->data;
	int ret;
	struct rtl_multicastDataInfo multicastDataInfo;
	uint32 mcastFwdPortMask;
	rtl_nicTx_info	nicTx;
 	struct sk_buff *skb2;

	/*when ip multicast table is enable, unknown multicast data will be trapped to cpu directly*/
	/*1.igmp packet can't be broadcasted
	   2.send multicast data according to igmp snooping result
	   3.broadcast unknown multicast*/

	/*it's not multicast data*/   
	if((ptr[0]!=0x01) 
	|| (ptr[1]!=0x00)
	|| (ptr[2]!=0x5e))
	{
		return;
	}

	/*it's not the source vlan id */
	if(vid == PKTHDR_EXTPORT_MAGIC)
	{
		return;
	}

	/**/
	ptr=ptr+12;
	if(*(int16 *)(ptr)==(int16)htons(0x8100))
	{
		ptr=ptr+4;
	}

	/*it's not ipv4 packet*/
	if(*(int16 *)(ptr)!=(int16)htons(0x0800))
	{
		return;
	}
	
	ptr=ptr+2;
	
	/*igmp protocol packet can't be flooded, for igmp snooping*/
	if(ptr[9]==0x02)
	{
		return;
	}
	
	/*try igmp snooping forwarding,only process tcp/udp protocol packet*/
	#if 0
	if((ptr[9]==0x06) || (ptr[9]==0x11))
	{
		multicastDataInfo.ipVersion=4;
		multicastDataInfo.sourceIp[0]= *(unsigned int*)(ptr[12]);
		multicastDataInfo.groupAddr[0]= *(unsigned int*)(ptr[16]);
		ret= rtl_getMulticastDataFwdPortMask(nicIgmpModuleIndex, &multicastDataInfo, &mcastFwdPortMask);
		
		if(ret==SUCCESS)
		{
			/*filter source port and extension port*/
			mcastFwdPortMask=mcastFwdPortMask & (~(1<<pid)) & ((1<<RTL8651_MAC_NUMBER)-1);
		}
		else
		{
			/*record not found, broadcast within vlan,filter source port and extension port*/
			mcastFwdPortMask=rtl865x_getVlanPortMask(vid)& (~(1<<pid)) & ((1<<RTL8651_MAC_NUMBER)-1);
		}
	}
	else
	{
		/*flood this packet within vlan,filter source port and extension port*/
		mcastFwdPortMask=rtl865x_getVlanPortMask(vid)& (~(1<<pid)) & ((1<<RTL8651_MAC_NUMBER)-1);
	}
	#else
	mcastFwdPortMask=rtl865x_getVlanPortMask(vid)& (~(1<<pid)) & ((1<<RTL8651_MAC_NUMBER)-1);
	#endif
	/*clone this packet,multicast/flood the new skbuff*/
	skb2= skb_clone(skb, GFP_ATOMIC);
       if(skb2!=NULL)
       {
		nicTx.vid = vid; 
		nicTx.portlist = mcastFwdPortMask;
		nicTx.srcExtPort = 0;
		nicTx.flags = (PKTHDR_USED|PKT_OUTGOING);
		if (swNic_send((void *)skb2, skb2->data, skb2->len, &nicTx) < 0) 
		{
			dev_kfree_skb_any(skb2);			
		}
	
	}
	return;	
}
					
#endif

__IRAM_FWD
static void interrupt_dsr_rx(unsigned long task_priv)
{
	struct dev_priv *cp = (struct dev_priv *)task_priv;
	struct dev_priv *cp_next;
	struct dev_priv *cp_this;
	struct sk_buff *skb;
 	int len;
 	unsigned int vid,pid;
#ifdef CONFIG_RTK_VOIP
 	unsigned long start_time = jiffies;
#endif
 	unsigned rx_work = rtl865x_rxSkbPktHdrDescNum;
#ifdef BR_SHORTCUT
	extern struct net_device *get_shortcut_dev(unsigned char *da);
	struct net_device *dev = NULL;
#endif	
#ifdef CONFIG_RTL_STP
	int32 dev_no;
#endif
	cp_next = NEXT_CP(cp);
	while (rx_work--) {
		if (swNic_receive((void **)&skb, &len, &vid, &pid) !=  0)			
	        	break;
		#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
		if(vid!=PKTHDR_EXTPORT_MAGIC)
		{
			skb->srcPort=(uint16)pid;
			skb->srcVlanId=(uint16)vid;	
			//printk("%s:%d,skb->srcPort  is %d,vid is %d,skb->srcVlanId is %d\n",__FUNCTION__,__LINE__,skb->srcPort,vid,skb->srcVlanId);                         
		}
		else
		{
			skb->srcPort=0xFFFF;
			skb->srcVlanId=0;
		}
		#endif
		DEBUG_ERR("RX from port 0x%x, vid 0x%x.\n", pid, vid);
		DEBUG_ERR("%x:%x:%x:%x:%x:%x ==> %x:%x:%x:%x:%x:%x \n", 
			skb->data[6], skb->data[7], skb->data[8],
			skb->data[9], skb->data[10], skb->data[11], 
			skb->data[0], skb->data[1], skb->data[2], 
			skb->data[3], skb->data[4], skb->data[5]);
		DEBUG_ERR("EtherType: 0x%x\n", *((uint16*)&skb->data[12]));
		DEBUG_ERR("open1 %d, portmask 0x%x.\n", cp->opened, cp->portmask);
		DEBUG_ERR("open2 %d, portmask 0x%x.\n", cp_next->opened, cp_next->portmask);

		skb_put(skb, len);
		
		{
			/*	extension port process	*/
#if	defined(CONFIG_RTL865X_EXTPORT)		
			if (pid==PKTHDR_EXTPORT_P1)
			{
				if (vid == PKTHDR_EXTPORT_MAGIC)
				{
					skb->dev = cachedWlanDev;
					cachedWlanDev->hard_start_xmit(skb, cachedWlanDev);
					continue;
				}
				else
				{
					cachedWlanDev->last_rx = jiffies;
					skb->dev = cachedWlanDev;
				}
			}
			else
#endif
#ifdef CONFIG_RTL865X_HW_PPTPL2TP
			if (pid==PKTHDR_EXTPORT_P2)
			{
				if(vid == PKTHDR_EXTPORT_MAGIC)
				{
					memset(skb->cb, 'P', 3);
				}
				skb->dev = pptpAccInfo.pppDev;
			} 
			else if (vid==RTL_PPTPL2TP_VLANID&&((1<<pid)&vlanconfig[1].memPort))
			{
				memset(skb->cb, 'N', 3);
//				skb->cb[0] = 'N';
//				skb->cb[1] = 'A';
//				skb->cb[2] = 'T';
				skb->dev = pptpAccInfo.wanDev;
			}
			else
#endif
			{
				/*	multicast snooping process	*/
				/*	If a pkt was decided by hw to extension port, 
				  *	it can NOT be multicast pkt.
				  *	So we put the multicast process after
				  *	extention port process
				  *	20081020	-	ZhaoBo
				  */
#ifdef CONFIG_RTL865X_IGMP_SNOOPING
				if(skb->data[0]&0x01)
				{
					uint32 fwdPortMask;

					rtl_igmpMldProcess(nicIgmpModuleIndex, skb->data, pid, &fwdPortMask);
	#ifdef CONFIG_RTL_STP
					if ( !memcmp(&(skb->data[0]), STPmac, 5) && !(skb->data[5] & 0xF0))
					{
						/* It's a BPDU */
						dev_no = re865x_stp_get_pseudodevno(pid);
						if (dev_no != NO_MAPPING)
						{
							skb->dev = _rtl86xx_dev.stp_port[dev_no];
							goto RxToPs;
			/*				printk("receieved BPDU packet in nic form %s\n", skb->dev->name);	*/
						}
						else
						{
							dev_kfree_skb_any(skb);
							continue;
						}
					}
	#endif
	
	#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
					re865x_rxProcessUnknownMCast(skb,vid, pid);		
	#endif
				}
#else
	#ifdef CONFIG_RTL_STP
				if ( !memcmp(&(skb->data[0]), STPmac, 5) && !(skb->data[5] & 0xF0))
				{
					/* It's a BPDU */
					dev_no = re865x_stp_get_pseudodevno(pid);
					if (dev_no != NO_MAPPING)
					{
						skb->dev = _rtl86xx_dev.stp_port[dev_no];
		/*				printk("receieved BPDU packet in nic form %s\n", skb->dev->name);	*/
					}
					else
					{
						dev_kfree_skb_any(skb);
					}
				}
				else
	#endif
#endif
				{
					pid = 1<<pid;

#ifdef CONFIG_RTL865X_HARDWARE_NAT
					/* for the issue: WAN port PC can not ping br0 (192.168.1.254) in Bridge mode */
					if (cp->opened && (cp->portmask & pid))
			    		{
			       	 		cp_this = cp;
			    		}
					else if (cp_next->opened && (cp_next->portmask & pid))
					{
						cp_this = cp_next;
					}
					#ifdef CONFIG_RTL865X_HW_PPTPL2TP
					else if (pid & BIT(7))
					{
						cp_this = cp;
					}
					#endif
				    	else
					{
						dev_kfree_skb_any(skb);
						continue;
			    		}
#else
			    		if (cp->opened && cp->id==vid)				
			       	 		cp_this = cp;
					else if (cp_next->opened && cp_next->id==vid)
						cp_this = cp_next;
				    	else {    
							dev_kfree_skb_any(skb);
						continue;
			    		}
#endif

					skb->dev = cp_this->dev;
					cp_this->net_stats.rx_packets++;	
					cp_this->net_stats.rx_bytes += skb->len;	
					cp_this->dev->last_rx = jiffies;

#ifdef BR_SHORTCUT
					if (enable_brsc && !(skb->data[0] & 0x01) &&
							(eth_flag & BIT(2))  &&
							(cp_this->dev->br_port) &&
							((dev = get_shortcut_dev(skb->data)) != NULL))
					{
						memcpy(cached_eth_addr, &skb->data[6], 6);
						cached_dev = cp_this->dev;				
						dev->hard_start_xmit(skb, dev);
						continue;
					}
#endif
				}
			}
#if defined(CONFIG_RTL865X_IGMP_SNOOPING) && defined(CONFIG_RTL_STP)
RxToPs:
#endif
			{
				DEBUG_ERR("skb->dev(%s).\n", skb->dev->name);
				skb->protocol = eth_type_trans(skb, skb->dev);
				skb->ip_summed = CHECKSUM_UNNECESSARY;
				netif_rx(skb);			
			}
	    	}
	}

#ifdef RX_TASKLET
    	REG32(CPUIIMR) |= RX_DONE_IE_ALL;
#endif
}

//---------------------------------------------------------------------------
static void interrupt_dsr_tx(unsigned long task_priv)
{
    struct dev_priv *cp = (struct dev_priv*)task_priv;
	int free_desc_num;
	unsigned long flags;

	local_irq_save(flags);

	refill_rx_skb();

	free_desc_num = swNic_txDone(); 

    if (free_desc_num >= (txRingSize[0]/4)) {
		if (cp->opened && netif_queue_stopped(cp->dev)) 			
			netif_wake_queue(cp->dev);
		
		if (NEXT_CP(cp)->opened && netif_queue_stopped(NEXT_DEV(cp)))
			netif_wake_queue(NEXT_DEV(cp));			
   	}
		
#ifdef TX_TASKLET		
    REG32(CPUIIMR) |= TX_ALL_DONE_IE_ALL;		
#endif

	local_irq_restore(flags);

}

__IRAM_FWD static int interrupt_isr(int irq, void *dev_instance)
{
    struct net_device *dev = dev_instance;
    struct dev_priv *cp = dev->priv;
	unsigned int status;

	status =*(volatile unsigned int*)(CPUIISR); 
    *(volatile unsigned int *)(CPUIISR) = status; 

    if (!status || (status == 0xFFFF)) {
		spin_unlock(&cp->lock);			
		return IRQ_HANDLED;
	}
#if 0
    if (status & PKTHDR_DESC_RUNOUT_IP_ALL) {
		DEBUG_ERR("EthDrv: packet RUNOUT error!\n");
		*(volatile unsigned int *)(CPUIIMR)|=PKTHDR_DESC_RUNOUT_IE_ALL;
		*(volatile unsigned int *)(CPUIISR)=PKTHDR_DESC_RUNOUT_IP_ALL;   
    }
#endif

	if (status & (RX_DONE_IP_ALL |PKTHDR_DESC_RUNOUT_IP_ALL)) {
#ifdef RX_TASKLET	
#if 0
		*(volatile unsigned int *)(CPUIIMR) &= ~RX_DONE_IE_ALL;			
#else
		*(volatile unsigned int *)(CPUIIMR) &= ~TX_ALL_DONE_IP_ALL; // JoeyLin_test
#endif
			tasklet_hi_schedule(&cp->rx_dsr_tasklet);			
#else	
		interrupt_dsr_rx((unsigned long)cp);	
#endif
	}		

	if (status &TX_ALL_DONE_IP_ALL) {
#ifdef TX_TASKLET		
		*(volatile unsigned int *)(CPUIIMR) &= ~TX_DONE_IE_ALL;
		tasklet_schedule(&cp->tx_dsr_tasklet);						
#else
		interrupt_dsr_tx((unsigned long)cp);
#endif			
	}

	return IRQ_HANDLED;
}


static int rtl865x_init_hw(void)
{
	unsigned int mbufRingSize = rtl865x_rxSkbPktHdrDescNum;

	/* Initialize NIC module */
	if (swNic_init(rxRingSize, mbufRingSize, txRingSize, MBUF_LEN))
	{
		printk("865x-nic: swNic_init failed!\n");            
		return FAILED;
	}
			
	return SUCCESS;	
}

#ifdef CONFIG_RTL865X_HARDWARE_NAT		
static void reset_hw_mib_counter(struct net_device *dev)
{
	int i, port;
	int32 totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;

	for(i=0;i<totalVlans;i++)
	{
		if (IF_ETHER!=vlanconfig[i].if_type)
		{
			continue;
		}
		if (!memcmp(vlanconfig[i].mac.octet, dev->dev_addr, 6))
		{
			for (port=0; port<RTL8651_AGGREGATOR_NUMBER; port++)
			{
				if (vlanconfig[i].memPort & (1<<port))
				   WRITE_MEM32(MIB_CONTROL, (1<<port*2) | (1<<(port*2+1)));
				return;
			}
		}
	}
}
#endif


static int re865x_open (struct net_device *dev)
{
	struct dev_priv *cp = dev->priv;
	uint32 flags;
	int rc;

	if (cp->opened)
		return SUCCESS;

	printk("Dev %s open\n", dev->name);
	if (!NEXT_CP(cp)->opened)
	{
		/* this is the first open dev */
		rtk_queue_init(&rx_skb_queue);  
		spin_lock_irqsave (&cp->lock, flags);
		rc = rtl865x_init_hw();
		spin_unlock_irqrestore(&cp->lock, flags);
		if (rc) {
			printk("rtl865x_init_hw() failed!\n");
			return FAILED;
		}

#ifdef RX_TASKLET
		tasklet_init(&cp->rx_dsr_tasklet, interrupt_dsr_rx, (unsigned long)cp);
#endif

#ifdef TX_TASKLET
		tasklet_init(&cp->tx_dsr_tasklet, interrupt_dsr_tx, (unsigned long)cp);
#endif

		rc = request_irq(dev->irq, interrupt_isr, SA_INTERRUPT, dev->name, dev);
		if (rc)
		{
			printk("request_irq() error!\n");
			goto err_out_hw;
		}
		cp->irq_owner =1;
		rtl865x_start();	
	}

	cp->opened = 1;

#ifdef CONFIG_RTL865X_HARDWARE_NAT	
	reset_hw_mib_counter(dev);
#endif

	netif_start_queue(dev);
	
#if defined(DYNAMIC_ADJUST_TASKLET) || defined(BR_SHORTCUT)
#ifndef CONFIG_RTL8186_TR
	if (dev->name[3] == '0') 
#endif		
	{	
		init_timer(&cp->expire_timer);
		cp->expire_timer.expires = jiffies + 100;
		cp->expire_timer.data = (unsigned long)dev;
		cp->expire_timer.function = one_sec_timer;
		mod_timer(&cp->expire_timer, jiffies + 100);		
#ifdef DYNAMIC_ADJUST_TASKLET			
		rx_cnt = 0;
#endif
#ifdef BR_SHORTCUT
		pkt_cnt = 0;
#endif
	}
#endif


#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#ifdef CONFIG_RTL865X_LAYERED_DRIVER_L3
	/*FIXME_hyking: should add default route to cpu....*/
	if(rtl865x_curOpMode == GATEWAY_MODE)
		rtl865x_addRoute(0,0,0,"eth1");
#else
	{
		rtl865x_tblAsicDrv_routingParam_t rth;
		memset(&rth, 0, sizeof(rtl865x_tblAsicDrv_routingParam_t));
		rth.process = 0x4; /* CPU */
		rth.ipAddr	= 0;
		rth.ipMask	= 0;
		rth.vidx			= _rtl865x_getNetifIdxByVid(8);
		rth.internal            = 0;
		rtl8651_setAsicRouting(7, &rth);
	}
#endif

#endif

	rtl865x_enableDevPortForward( dev, cp);

	return SUCCESS;
	
err_out_hw:
    rtl865x_down();
    return rc;
}

static int re865x_close (struct net_device *dev)
{
	struct dev_priv *cp = dev->priv;

	if (!cp->opened)
		return SUCCESS;

	printk("Dev %s close\n", dev->name);
	rtl865x_disableDevPortForward(dev, cp);
	
	netif_stop_queue(dev);

	if (!NEXT_CP(cp)->opened)
	{
		/*	warning:
			1.if we don't reboot,we shouldn't hold switch core from rx/tx, otherwise there will be some problem during change operation mode
			2.only when two devices go down,can we shut down nic interrupt
			3.the interrupt will be re_enable by rtl865x_start()
		*/
		rtl865x_disableInterrupt();
		
		free_irq(dev->irq, GET_IRQ_OWNER(cp));
		((struct dev_priv *)GET_IRQ_OWNER(cp)->priv)->irq_owner = 0;

#ifdef RX_TASKLET
		tasklet_kill(&cp->rx_dsr_tasklet);	
#endif

#ifdef TX_TASKLET
		tasklet_kill(&cp->tx_dsr_tasklet);
#endif

		free_rx_skb();
	}

	memset(&cp->net_stats, '\0', sizeof(struct net_device_stats));
	cp->opened = 0;

#if defined(DYNAMIC_ADJUST_TASKLET) || defined(CONFIG_RTL8186_TR) || defined(BR_SHORTCUT)
    if (timer_pending(&cp->expire_timer))
        del_timer_sync(&cp->expire_timer);
#endif

#ifdef BR_SHORTCUT
	if (dev == cached_dev)
		cached_dev=NULL;
#endif

#ifdef CONFIG_RTL865X_HARDWARE_NAT	
	reset_hw_mib_counter(dev);
#endif

	return SUCCESS;
}

#ifdef CONFIG_RTL_STP
static int re865x_stp_open (struct net_device *dev)
{
	struct dev_priv *cp = dev->priv;

	if (cp->opened)
		return SUCCESS;
	
	cp->opened = 1;	
	netif_start_queue(dev);
	return SUCCESS;
}


static int re865x_stp_close (struct net_device *dev)
{
	struct dev_priv *cp = dev->priv;

	if (!cp->opened)
		return SUCCESS;

	netif_stop_queue(dev);

	memset(&cp->net_stats, '\0', sizeof(struct net_device_stats));
	cp->opened = 0;

#ifdef BR_SHORTCUT
	if (dev == cached_dev)
		cached_dev=NULL;
#endif
	return SUCCESS;
}

static int re865x_stp_mapping_init(void)
{
	int i, j, k, totalVlans;
	totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;
	
	for (i = 0; i < MAX_RE865X_STP_PORT; i++)
	{
		STP_PortDev_Mapping[i] = NO_MAPPING; 
	}

	STP_PortDev_Mapping[MAX_RE865X_STP_PORT -1] = WLAN_PSEUDO_IF_INDEX;
	printk("=======stp port dev mapping init=======\n");
	j = 0;
	for(k=0;k<totalVlans;k++)
	{
		if (vlanconfig[k].isWan == FALSE)
		{
			for(i=0; i< MAX_RE865X_STP_PORT-1 ; i++)
			{
				if ( (1<<i) & vlanconfig[k].memPort ) 
				{
					STP_PortDev_Mapping[j] = i;
					printk("mapping: lan phycisal [port%d] <====>pseudo [port%d]\n", i, j);
					j++;
				}
			}
			
			break;
		}
	}
	
		printk("mapping table is ");
	for(i=0; i< MAX_RE865X_STP_PORT-1 ; i++)
	{
		printk(" %d ", STP_PortDev_Mapping[i]);
	}
		printk("\n\n");
	return SUCCESS;
}

static int re865x_stp_mapping_reinit(void)
{
	int i, j, k, totalVlans;
	totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;
	
	for (i = 0; i < MAX_RE865X_STP_PORT; i++)
	{
		STP_PortDev_Mapping[i] = NO_MAPPING; 
	}

	STP_PortDev_Mapping[MAX_RE865X_STP_PORT -1] = WLAN_PSEUDO_IF_INDEX;

	printk("=======stp port dev mapping reinit=======\n");
	j = 0;
	for(k=0;k<totalVlans;k++)
	{
		if (vlanconfig[k].isWan == FALSE)
		{
			for(i=0; i< MAX_RE865X_STP_PORT-1 ; i++)
			{
				if ( (1<<i) & vlanconfig[k].memPort ) 
				{
					STP_PortDev_Mapping[j] = i;
					printk("mapping: lan phycisal [port%d] <====>pseudo [port%d]\n", i, j);
					j++;
				}
			}
			
			break;
		}
	}
	
		printk("mapping table is ");
	for(i=0; i< MAX_RE865X_STP_PORT-1 ; i++)
	{
		printk(" %d ", STP_PortDev_Mapping[i]);
	}
		printk("\n\n");
	return SUCCESS;
}

static int re865x_stp_get_pseudodevno(uint32 port_num)
{
	int i, dev_no;
	for(i=0; i< MAX_RE865X_STP_PORT-1 ; i++)
	{
		if( STP_PortDev_Mapping[i] == port_num)
		{
			dev_no = i;
			return dev_no;
		}		
	}
	return NO_MAPPING;

}

#endif
#ifdef CONFIG_RTL865X_HW_PPTPL2TP
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
int rtl865x_set_pptp(struct pptp_acc_info* info)
{
	int     i;

	rtl865x_addPpp(info->pppDev->name, (ether_addr_t*)info->peerMac, info->peerCallID, IF_PPTP);
	
	rtl865x_addVlan(RTL_PPTPL2TP_VLANID);
	rtl865x_addVlanPortMember(RTL_PPTPL2TP_VLANID, rtl865x_wanPortMask|(1<<PKTHDR_EXTPORT_P2));

	for(i=0; i<6; i++)
	{
		if ( (1<<i)&rtl865x_wanPortMask)
			rtl8651_setAsicPvid(i, RTL_PPTPL2TP_VLANID);
	}
	rtl8651_setAsicPvid(PKTHDR_EXTPORT_P2, RTL_PPTPL2TP_VLANID);

	rtl865x_setNetifVid("eth1", RTL_PPTPL2TP_VLANID);
	rtl865x_delVlan(RTL_WANVLANID);
	
	rtl865x_setNetifVid("ppp0", RTL_PPTPL2TP_VLANID);

	rtl865x_setNetifType("ppp0", IF_PPTP);

	rtl865x_addFilterDatabaseEntry(0, (ether_addr_t*)info->peerMac, 1<<PKTHDR_EXTPORT_P2, FDB_TYPE_FWD);
	return SUCCESS;
}

int rtl865x_clr_pptp(struct pptp_acc_info* info)
{
	int	i, j;
	int	pvid;

	rtl865x_addVlan(RTL_WANVLANID);
	rtl865x_addVlanPortMember(RTL_WANVLANID, rtl865x_wanPortMask);

	for(i=0; i<RTL8651_PORT_NUMBER + 3; i++) 
	{ 
		/* Set each port's PVID */
		for(j=0,pvid=0; vlanconfig[j].vid != 0; j++)
		{
			if ( (1<<i) & vlanconfig[j].memPort ) 
			{
				pvid = vlanconfig[j].vid;
				break;
			}
		}
		
		if (pvid!=0)	
		{
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
			CONFIG_CHECK(rtl8651_setAsicPvid(i,pvid));
#else
			LR_CONFIG_CHECK(port_attr.pvid_asic_set(i, pvid));
#endif
		}
	}

	rtl865x_setNetifVid("eth1", RTL_WANVLANID);
	rtl865x_setNetifVid("ppp0", RTL_WANVLANID);

	rtl865x_delVlan(RTL_PPTPL2TP_VLANID);
		
	rtl865x_setNetifType("ppp0", IF_PPPOE);
	rtl865x_delFilterDatabaseEntry(RTL865x_L2_TYPEII, 0, (ether_addr_t*)info->peerMac);

	rtl865x_delPpp(info->peerCallID);
	return SUCCESS;
}
#else
int rtl865x_pptp_set_hwaddr(unsigned char *addr)
{

	memcpy(vlanconfig[2].mac.octet, addr, ETHER_ADDR_LEN);

	if(vlanconfig[2].vid!=0)
	{
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	{
		rtl865x_netif_t netif;
		netif.macAddr = vlanconfig[2].mac;
		memcpy(netif.name,vlanconfig[2].ifname,MAX_IFNAMESIZE);
		rtl865x_setNetifMac(&netif);
	}		
#else
		INIT_CHECK(TBLFIELD(vlan_tbl, vlan_set_mac)(&vlanconfig[2]));
#endif
	}

	return SUCCESS;
}
#endif		/* CONFIG_RTL865X_LAYERED_DRIVER */

#endif		/* CONFIG_RTL865X_HW_PPTPL2TP */

__IRAM_TX static int re865x_start_xmit(struct sk_buff *skb, struct net_device *dev)
{
//	unsigned long flags;
 	struct dev_priv *cp = dev->priv;
	rtl_nicTx_info	nicTx;

	nicTx.vid = cp->id;
//	spin_lock_irqsave (&cp->lock, flags);
    	dev->trans_start = jiffies;

#ifdef CONFIG_RTL865X_IGMP_SNOOPING
	if((skb->data[0]&0x01)==0)
	{
		/*unicast process*/
		if (nicTx.vid == RTL_LANVLANID)
		{
			/* the pkt must be tx to lan vlan */
			nicTx.portlist = RTL8651_CPU_PORT;		/* must be set 0x7 */
			nicTx.srcExtPort = PKTHDR_EXTPORT_LIST_CPU;
			nicTx.flags = (PKTHDR_USED|PKTHDR_HWLOOKUP|PKTHDR_BRIDGING|PKT_OUTGOING);
		}
		else
		{
			nicTx.portlist = cp->portmask;
			nicTx.srcExtPort = 0;
			nicTx.flags = (PKTHDR_USED|PKT_OUTGOING);
		}
	}
	else
	{
		nicTx.srcExtPort = 0;
		nicTx.flags = (PKTHDR_USED|PKT_OUTGOING);
		//printk("XMIT to portlist 0x%x vid %d\n", cp->portmask, cp->id);
		nicTx.portlist=cp->portmask;
		/*multicast process*/
		if((skb->data[0]==0x01) && (skb->data[1]==0x00) && (skb->data[2]==0x5e))
		{
			int32 retVal;
			struct iphdr *iph;
			struct rtl_multicastDataInfo multicastDataInfo;
			uint32 mcportlist;
			
			iph = skb->nh.iph;
			
			if((iph->protocol==0x06) || (iph->protocol==0x11))
			{
				/*only process tcp/udp in igmp snooping data plane*/
				multicastDataInfo.ipVersion=4;
				multicastDataInfo.sourceIp[0]=  (uint32)(iph->saddr);
				multicastDataInfo.groupAddr[0]=  (uint32)(iph->daddr);
				//printk("multicastDataInfo.groupAddr[0]= 0x%x\n",multicastDataInfo.groupAddr[0]);//added for test
				retVal= rtl_getMulticastDataFwdPortMask(nicIgmpModuleIndex, &multicastDataInfo, (uint32*)&mcportlist);
			
				/*record not found, broadcast within device vlan*/
				if(retVal==SUCCESS)
				{
					//printk("MCAST: 0x%x&0x%x\n", mcportlist, cp->portmask);
					nicTx.portlist = mcportlist&cp->portmask;
				}
			}
					
		}
#ifdef CONFIG_RTL8186_GR
		else if (oldStatus)
		{
			if (((oldStatus&IP6_PASSTHRU_MASK)&&(*((uint16*)&skb->data[12])==0x86dd)) ||
				((oldStatus&PPPOE_PASSTHRU_MASK)&&((*((uint16*)&skb->data[12])==0x8864)||(*((uint16*)&skb->data[12])==0x8863))) )
			{
				nicTx.portlist = RTL8651_CPU_PORT;		/* must be set 0x7 */
				nicTx.srcExtPort = PKTHDR_EXTPORT_LIST_CPU;
				nicTx.flags = (PKTHDR_USED|PKTHDR_HWLOOKUP|PKT_OUTGOING);
			}
		}
#endif
#ifdef CONFIG_RTL_STP
		if(!dev->irq){
			//virtual interfaces have no IRQ assigned. We use this to identify STP port interfaces.
			uint8 stpPortNum= dev->name[strlen(dev->name)-1]-'0';
/*			printk("send bpdu packet in nic, port num is %d\n", STP_PortDev_Mapping[stpPortNum]);	*/
			if (STP_PortDev_Mapping[stpPortNum] != NO_MAPPING)
			{
				nicTx.portlist = STP_PortDev_Mapping[stpPortNum];
			}
			else
			{
				dev_kfree_skb_any(skb);
			}
		}
#endif
	}

	if(nicTx.portlist==0)
	{
		dev_kfree_skb_any(skb);
		return 0;
	}
	
	if (swNic_send((void *)skb, skb->data, skb->len, &nicTx) < 0) {	// tx queue full
		DEBUG_ERR("%s: tx failed!\n", dev->name);

		netif_stop_queue(dev);
#ifdef CONFIG_RTK_VOIP
		// avoid packet lost!
		struct Qdisc *q=dev->qdisc;
		q->ops->requeue(skb, q);
		netif_schedule(dev);		
		return 0;
#else		
		cp->net_stats.tx_dropped++;
//		dev_kfree_skb_irq(skb);
		dev_kfree_skb_any(skb);		
//		spin_unlock_irqrestore(&cp->lock, flags);		

		/* tx queue full and drop this packet, return 0 to indicate the caller that the packet is done.
		 * return 1 the caller will resend it again and cause core dump in __kfree_skb().
		 */
		return 0;
#endif		
    }
#else
	nicTx.portlist = cp->portmask;
	nicTx.srcExtPort = 0;
	nicTx.flags = (PKTHDR_USED|PKT_OUTGOING);

	if(nicTx.portlist==0)
	{
		dev_kfree_skb_any(skb);
		return 0;
	}
	
    if (swNic_send((void *)skb, skb->data, skb->len, &nicTx) < 0) {	// tx queue full
		DEBUG_ERR("%s: tx failed!\n", dev->name);
			
		netif_stop_queue(dev);
#ifdef CONFIG_RTK_VOIP
		// avoid packet lost!
		struct Qdisc *q=dev->qdisc;
		q->ops->requeue(skb, q);
		netif_schedule(dev);		
		return 0;
#else		
		cp->net_stats.tx_dropped++;
		dev_kfree_skb_any(skb);		

		/* tx queue full and drop this packet, return 0 to indicate the caller that the packet is done.
		 * return 1 the caller will resend it again and cause core dump in __kfree_skb().
		 */
		return 0;
#endif		
    }
#endif	
	cp->net_stats.tx_packets++;		
	cp->net_stats.tx_bytes += skb->len;

#ifdef BR_SHORTCUT
	pkt_cnt++;
#endif

//	spin_unlock_irqrestore(&cp->lock, flags);   
    return 0;
}

#if 0
__IRAM_FWD int re865x_start_xmit (struct sk_buff *skb, struct net_device *dev)
{
	struct dev_priv		*dp = dev->priv;
	struct rtl_pktHdr 	*pktHdr;	
	struct rtl_mBuf		*Mblk;
	uint32	len = skb->len;//orlando

#ifdef CONFIG_HARDWARE_NAT_DEBUG
/*2007-12-19*/
	rtlglue_printf("%s:%d:TX to vlan[%d] port[x%x] dev[%s].\n", __FUNCTION__,__LINE__,dp->id, dp->portmask, dev->name);
#endif
	if(!dp->portnum){
		dp->net_stats.tx_dropped++;
		rtlglue_printf("Tx: No port num!\n");
		return -1;
	}

	Mblk=mBuf_attachHeader((void*)UNCACHE(skb->data),(uint32)(skb),PKT_BUF_SZ, len,0);
	if(!Mblk){
		dp->net_stats.tx_dropped++;
		rtlglue_printf("Tx: Can't attach mbuf!\n");
		return -1;
	}

	pktHdr=Mblk->m_pkthdr;

#if 0
	rtlglue_printf("%s:%d:TX to vlan[%d] port[x%x] dev[%s].\n", __FUNCTION__,__LINE__,dp->id, dp->portmask, dev->name);
	rtlglue_printf("%s:%d:portlist [0x%x], vlanid[0x%x], l2[0x%x].\n",  __FUNCTION__,__LINE__,pktHdr->ph_portlist, dp->id, rtl8651_asicL2DAlookup(skb->data));
#endif


#ifdef CONFIG_HARDWARE_NAT_DEBUG
/*2007-12-19*/
	rtlglue_printf("%s:%d:portlist [0x%x], vlanid[0x%x], l2[0x%x].\n",  __FUNCTION__,__LINE__,pktHdr->ph_portlist, dp->id, rtl8651_asicL2DAlookup(skb->data));
#endif
	pktHdr->ph_len = len;
	pktHdr->ph_flags = 0x8800;
	pktHdr->ph_proto = PKTHDR_ETHERNET;
	pktHdr->ph_vlanId= (dp->id);

#ifdef CONFIG_RTL865X_IGMP_SNOOPING
	if((Mblk->m_data[0]&0x01)==0)
	{
		/*unicast process*/
		pktHdr->ph_portlist = dp->portmask & rtl8651_asicL2DAlookup(skb->data);
	}
	else
	{
		/*multicast process*/
		if((Mblk->m_data[0]==0x01) && (Mblk->m_data[1]==0x00) && (Mblk->m_data[2]==0x5e))
		{
			uint32 fwdPortMask;
			int32 retVal;
			struct iphdr *iph;
			struct rtl_multicastDataInfo multicastDataInfo;
			
			iph = skb->nh.iph;
			multicastDataInfo.ipVersion=4;
			multicastDataInfo.sourceIp[0]=  (uint32)(iph->saddr);
			multicastDataInfo.groupAddr[0]=  (uint32)(iph->daddr);
			retVal= rtl_getMulticastDataFwdPortMask(nicIgmpModuleIndex, &multicastDataInfo, &fwdPortMask);
			//printk("source ip is 0x%x, dest ip is 0x%x\n",multicastDataInfo.sourceIp[0],multicastDataInfo.groupAddr[0]);
			//printk("%s:%d,fwdPortMask is 0x%x\n",__FUNCTION__,__LINE__,fwdPortMask);
			if(retVal==SUCCESS)
			{
				pktHdr->ph_portlist=(uint8)fwdPortMask;
			
			}
			else
			{
				/*unknown multicast*/
				pktHdr->ph_portlist =dp->portmask &  0xFFFFFFFF;
			}
			
		
		}
		else
		{
			/*broadcast/unknown multicast process*/
			pktHdr->ph_portlist =dp->portmask &  0xFFFFFFFF;
		}
	}
#else
	pktHdr->ph_portlist = dp->portmask & rtl8651_asicL2DAlookup(skb->data);
#endif

#if 1
	pktHdr->ph_portlist = dp->portmask & rtl8651_asicL2DAlookup(skb->data);
	pktHdr->ph_portlist&= ~0x40; //clear CPU port.
	//if portmask contains MII port. MII port must be configured before we can send pkt to it.
	if(pktHdr->ph_portlist & RTL8651_MII_PORTMASK && miiPhyAddress<0)
		pktHdr->ph_portlist&=~RTL8651_MII_PORTMASK;
#else
	if (dp->id==8)
	{
		/* to wan */
		pktHdr->ph_portlist = dp->portmask & vlanconfig[1].memPort;
		pktHdr->ph_portlist&= ~0x40; //clear CPU port.
		//if portmask contains MII port. MII port must be configured before we can send pkt to it.
		if(pktHdr->ph_portlist & RTL8651_MII_PORTMASK && miiPhyAddress<0)
			pktHdr->ph_portlist&=~RTL8651_MII_PORTMASK;
	}
	else
	{
		/* to lan or to virtual port */
		if (dp->id==9)
		{
			pktHdr->ph_portlist = dp->portmask & vlanconfig[0].memPort;
			pktHdr->ph_portlist&= ~0x40; //clear CPU port.
			//if portmask contains MII port. MII port must be configured before we can send pkt to it.
			if(pktHdr->ph_portlist & RTL8651_MII_PORTMASK && miiPhyAddress<0)
				pktHdr->ph_portlist&=~RTL8651_MII_PORTMASK;

			pktHdr->ph_flags = 0xc000;
			{
				pktHdr->ph_flags |= (PKTHDR_HWLOOKUP|PKTHDR_BRIDGING);
				pktHdr->ph_srcExtPortNum = 1;
				pktHdr->ph_extPortList = 0x08;
			}
		}
		else
		{
			pktHdr->ph_portlist = dp->portmask & rtl8651_asicL2DAlookup(skb->data);
			pktHdr->ph_portlist&= ~0x40; //clear CPU port.
			//if portmask contains MII port. MII port must be configured before we can send pkt to it.
			if(pktHdr->ph_portlist & RTL8651_MII_PORTMASK && miiPhyAddress<0)
				pktHdr->ph_portlist&=~RTL8651_MII_PORTMASK;
		}
	}
#endif

	rtlglue_drvSend((void*)pktHdr);
	dev->trans_start = jiffies;
	dp->net_stats.tx_packets++;		
	dp->net_stats.tx_bytes += skb->len;
	return 0;				
}
#endif

static void re865x_tx_timeout (struct net_device *dev)
{
	rtlglue_printf("Tx Timeout!!! Can't send packet\n");
}


int re865x_ioctl (struct net_device *dev, struct ifreq *rq, int cmd)
{
	int32 rc = 0;
	unsigned long *data;
	int32 args[4];
	int32  * pRet;
#if defined(CONFIG_RTL8186_KB)||defined(CONFIG_RTL8186_GR)
	uint32	*pU32;
#endif

	if (cmd != SIOCDEVPRIVATE)
	{
		goto normal;
	}

	data = (unsigned long *)rq->ifr_data;

	if (copy_from_user(args, data, 4*sizeof(unsigned long)))
	{
		return -EFAULT;
	}

	switch (args[0])
	{
		case RTL8651_IOCTL_GETWANLINKSTATUS:
			{
				int i;
				int wanPortMask;
				int32 totalVlans;

				pRet = (int32 *)args[3];
				*pRet = FAILED;
				rc = SUCCESS;

				wanPortMask = 0;
				totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;
				for(i=0;i<totalVlans;i++)
				{
					if(vlanconfig[i].isWan==TRUE)
						wanPortMask = vlanconfig[i].memPort;
				}

				if (wanPortMask==0)
				{
					/* no wan port exist */					
					break;
				}

				for(i=0;i<RTL8651_AGGREGATOR_NUMBER;i++)
				{
					if( (1<<i)&wanPortMask )
					{
						if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkUp)!=0)
						{
							//rtlglue_printf("Wan port i=%d\n",i);//Added for test
							*pRet = SUCCESS;
						}
						break;
					}
				}
				
				break;
			}
		case RTL8651_IOCTL_GETWANLINKSPEED:
			{
				int i;
				int wanPortMask;
				int32 totalVlans;
					
				pRet = (int32 *)args[3];
				*pRet = FAILED;
				rc = FAILED;

				wanPortMask = 0;
				totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;
				for(i=0;i<totalVlans;i++)
				{
					if(vlanconfig[i].isWan==TRUE)
						wanPortMask = vlanconfig[i].memPort;
				}

				if (wanPortMask==0)
				{
					/* no wan port exist */
					//rtlglue_printf("%s(%d)Wan port: no wan port exist\n",__FUNCTION__,__LINE__);//Added for test
					break;
				}

				for(i=0;i<RTL8651_AGGREGATOR_NUMBER;i++)
				{
					if( (1<<i)&wanPortMask )
					{
						//if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkUp)!=0)
						//{
							//rtlglue_printf("%s(%d)Wan port i=%d\n",__FUNCTION__,__LINE__,i);//Added for test
							//*pRet = SUCCESS;
						//}
						break;
					}
				}
				
				switch(READ_MEM32(PSRP0 + (i<<2)) & PortStatusLinkSpeed_MASK)
				{
					case PortStatusLinkSpeed10M:
						*pRet = PortStatusLinkSpeed10M;
						rc = SUCCESS;
						//rtlglue_printf("%s(%d)Wan port: 10M\n",__FUNCTION__,__LINE__);//Added for test
						break;
					case PortStatusLinkSpeed100M:
						*pRet = PortStatusLinkSpeed100M;
						rc = SUCCESS;
						//rtlglue_printf("%s(%d)Wan port: 100M\n",__FUNCTION__,__LINE__);//Added for test
						break;
					case  PortStatusLinkSpeed1000M:
						*pRet = PortStatusLinkSpeed1000M;
						rc = SUCCESS;
						//rtlglue_printf("%s(%d)Wan port: 1000M\n",__FUNCTION__,__LINE__);//Added for test
						break;
					default:
						//rtlglue_printf("%s(%d)Wan port: no match\n",__FUNCTION__,__LINE__);//Added for test
						break;
				}
				break;
			}
#if defined(CONFIG_RTL8186_KB)|| defined(CONFIG_RTL8186_GR)
		case RTL8651_IOCTL_GETLANLINKSTATUS:
			{
				int i;
				int lanPortMask;
				int32 totalVlans;

				pRet = (int32 *)args[3];
				*pRet = FAILED;
				rc = SUCCESS;

				lanPortMask = 0;
				totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;
				for(i=0;i<totalVlans;i++)
				{
					if(vlanconfig[i].isWan==FALSE)
					{
						lanPortMask = vlanconfig[i].memPort;
						if (lanPortMask==0)
						{
							/* no wan port exist */					
							continue;
						}

						for(i=0;i<=RTL8651_PHY_NUMBER;i++)
						{
							if( (1<<i)&lanPortMask )
							{
								if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkUp)!=0)
								{
									//rtlglue_printf("Lan port i=%d\n",i);//Added for test
									*pRet = SUCCESS;
									return rc;
								}
							}
						}
					}
				}

				break;
			}
#if defined(CONFIG_RTL8186_KB)
		case RTL8651_IOCTL_GETWANTHROUGHPUT:
			{
				static unsigned long last_jiffies = 0;
				static unsigned long last_rxtx = 0;
				int i;
				int32 totalVlans;
				struct dev_priv *cp;
				int32 *throughputLevel;
				unsigned long	diff_jiffies;
				pRet = (int32 *)args[3];

				diff_jiffies = (jiffies-last_jiffies);
				if (diff_jiffies>HZ)
				{
					pU32 = (uint32*)args[1];
					throughputLevel = (uint32*)pU32[0];
					rc = SUCCESS;

					cp = NULL;
					totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;
					for(i=0;i<totalVlans;i++)
					{
						if(vlanconfig[i].isWan==TRUE)
						{
							cp = _rtl86xx_dev.dev[i]->priv;
							break;
						}
					}

					if (cp==NULL)
					{
						/* no wan port exist */					
						rc = FAILED;
					}

					for(i=1;i<20;i++)
					{
						if (diff_jiffies < (HZ<<i))
							break;
					}
					/* get the throughput level */
					*throughputLevel = (((cp->net_stats.rx_bytes + cp->net_stats.tx_bytes)-last_rxtx)>>(17+i));

					last_jiffies = jiffies;
					last_rxtx = (cp->net_stats.rx_bytes + cp->net_stats.tx_bytes);
					*pRet = SUCCESS;
				}
				else
				{
					*pRet = FAILED;
				}
			}
#endif
#endif
#if defined(CONFIG_RTL8186_GR)
		case RTL8651_IOCTL_GETLANPORTLINKSTATUS:
			{
				int i;
                            int lanPortMask;
                            int32 totalVlans;
				int32 *lanportnum;
				int32 lanPortTypeMask;
 
                            pRet = (int32 *)args[3];
                            *pRet = FAILED;
                            rc = SUCCESS;

				pU32 = (uint32*)args[1];
				lanportnum = (uint32*)pU32[0];
 
                                lanPortMask = 0;
                                totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;
                                for(i=0;i<totalVlans;i++)
                                {
                                        if(vlanconfig[i].isWan==FALSE)
                                        {
                                                lanPortMask = vlanconfig[i].memPort;
                                                if (lanPortMask==0)
                                                {
                                                        /* no wan port exist */
                                                        continue;
                                                }
 
                                                for(i=0;i<=RTL8651_PHY_NUMBER;i++)
                                                {
                                                        if( (1<<i)&lanPortMask )
                                                        {
                                                                if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkUp)!=0)
                                                                {
										if(i==(*lanportnum))
										{
											//rtlglue_printf("Lan port i=%d\n",i);//Added for test
                                                                        	*pRet = SUCCESS;
																			
											if((READ_MEM32(PSRP0+(i<<2))&PortStatusDuplex)!=0)
											{
												lanPortTypeMask=1;
												*pRet |= lanPortTypeMask;
												//rtlglue_printf("Duplex port!\n");//Added for test
											}
											if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkSpeed10M)!=0)
											{
												lanPortTypeMask=2;
												*pRet |= lanPortTypeMask;
												//rtlglue_printf("10M port!\n");//Added for test
											}
											if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkSpeed100M)!=0)
											{
												lanPortTypeMask=4;
												*pRet |= lanPortTypeMask;
												//rtlglue_printf("100M port!\n");//Added for test
											}
											if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkSpeed1000M)!=0)
											{
												lanPortTypeMask=8;
												*pRet |= lanPortTypeMask;
												//rtlglue_printf("1000M port!\n");//Added for test
											}
											
                                                                        	return rc;
										}
                                                                }
                                                        }
                                                }
                                        }
                                }
 
                                break;
			}

		case RTL8651_IOCTL_GETWANPORTLINKSTATUS:
			{
				int i;
				int wanPortMask;
				int32 totalVlans;
				int32 wanPortTypeMask;

				pRet = (int32 *)args[3];
				*pRet = FAILED;
				rc = SUCCESS;

				wanPortMask = 0;
				totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;
				for(i=0;i<totalVlans;i++)
				{
					if(vlanconfig[i].isWan==TRUE)
						wanPortMask = vlanconfig[i].memPort;
				}

				if (wanPortMask==0)
				{
					/* no wan port exist */					
					break;
				}

				for(i=0;i<RTL8651_AGGREGATOR_NUMBER;i++)
				{
					if( (1<<i)&wanPortMask )
					{
						if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkUp)!=0)
						{
							//rtlglue_printf("Wan port i=%d\n",i);//Added for test
							*pRet = SUCCESS;

							if((READ_MEM32(PSRP0+(i<<2))&PortStatusDuplex)!=0)
							{
												wanPortTypeMask=1;
												*pRet |= wanPortTypeMask;
												//rtlglue_printf("WAN: Duplex port!\n");//Added for test
							}
							if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkSpeed10M)!=0)
							{
												wanPortTypeMask=2;
												*pRet |= wanPortTypeMask;
												//rtlglue_printf("WAN: 10M port!\n");//Added for test
							}
							if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkSpeed100M)!=0)
							{
												wanPortTypeMask=4;
												*pRet |= wanPortTypeMask;
												//rtlglue_printf("WAN: 100M port!\n");//Added for test
							}
							if((READ_MEM32(PSRP0+(i<<2))&PortStatusLinkSpeed1000M)!=0)
							{
												wanPortTypeMask=8;
												*pRet |= wanPortTypeMask;
												//rtlglue_printf("WAN: 1000M port!\n");//Added for test
							}
						}
						break;
					}
				}
				
				break;
			}
#endif
		default:
			rc = SUCCESS;
			break;
	}
	
	return rc;
			
normal:	
	if (!netif_running(dev))
		return -EINVAL;
	switch (cmd)
        {
	    default:
		rc = -EOPNOTSUPP;
		break;
	}
	return rc;
}

#if defined(DYNAMIC_ADJUST_TASKLET) || defined(CONFIG_RTL8186_TR) || defined(BR_SHORTCUT)
static void one_sec_timer(unsigned long task_priv)
{
	uint32 flags;
	
    struct dev_priv *cp = ((struct net_device *)task_priv)->priv;

	spin_lock_irqsave (&cp->lock, flags);

#ifdef DYNAMIC_ADJUST_TASKLET
    if (((struct net_device *)task_priv)->name[3] == '0' && rx_pkt_thres > 0 && 
									((eth_flag&TASKLET_MASK) == 0))  { 
        if (rx_cnt > rx_pkt_thres) {
			if (!rx_tasklet_enabled) {
				rx_tasklet_enabled = 1;
            }							
        }               
        else {
			if (rx_tasklet_enabled) { // tasklet enabled
				rx_tasklet_enabled = 0;
			}						
        }       
        rx_cnt = 0;     
    }   
#endif

#ifdef CONFIG_RTL8186_TR
    cp->tx_avarage = (cp->tx_avarage/10)*7 + (cp->tx_byte_cnt/10)*3;
    if (cp->tx_avarage > cp->tx_peak)
        cp->tx_peak = cp->tx_avarage;
    cp->tx_byte_cnt = 0;
    
    cp->rx_avarage = (cp->rx_avarage/10)*7 + (cp->rx_byte_cnt/10)*3;
    if (cp->rx_avarage > cp->rx_peak)
        cp->rx_peak = cp->rx_avarage;
    cp->rx_byte_cnt = 0;    
#endif

#ifdef BR_SHORTCUT
	if (pkt_cnt > 100)
		enable_brsc=1;
	else
		enable_brsc=0;
#endif

    mod_timer(&cp->expire_timer, jiffies + 100);

	spin_unlock_irqrestore(&cp->lock, flags);   
}
#endif


static int rtl865x_set_hwaddr(struct net_device *dev, void *addr)
{
	unsigned long flags;
	int i;
	unsigned char *p;

	p = ((struct sockaddr *)addr)->sa_data;
 	local_irq_save(flags);
	for (i = 0; i<ETHER_ADDR_LEN; ++i) {
		dev->dev_addr[i] = p[i];
	}

	if (!strcmp(dev->name, "eth0"))
		i = 0;
	else
		i = 1;	

	memcpy(vlanconfig[i].mac.octet, dev->dev_addr, ETHER_ADDR_LEN);

#ifdef CONFIG_HARDWARE_NAT_DEBUG
/*2007-12-19*/
	rtlglue_printf("%s:%d:dev->name is %s,__lrconfig[%d].mac is 0x%x:%x:%x:%x:%x:%x\n",__FUNCTION__,__LINE__,dev->name, i, 
	vlanconfig[i].mac.octet[0],vlanconfig[i].mac.octet[1],vlanconfig[i].mac.octet[2],vlanconfig[i].mac.octet[3],vlanconfig[i].mac.octet[4],vlanconfig[i].mac.octet[5]);

	rtlglue_printf("%s:%d:__lrconfig[%d].vid is %d\n",__FUNCTION__,__LINE__,i,vlanconfig[i].vid);
#endif


#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	if(vlanconfig[i].vid != 0)
	{
		rtl865x_netif_t netif;
		netif.macAddr = vlanconfig[i].mac;
		memcpy(netif.name,vlanconfig[i].ifname,MAX_IFNAMESIZE);
		rtl865x_setNetifMac(&netif);
	}
	
#else

	if(vlanconfig[i].vid!=0)
	{	
		INIT_CHECK(TBLFIELD(vlan_tbl, vlan_set_mac)(&vlanconfig[i]));
	}	
#endif

	local_irq_restore(flags);
	return SUCCESS;
}

static int rtl865x_set_mtu(struct net_device *dev, int new_mtu)
{
	unsigned long flags;
	int i;

 	local_irq_save(flags);

	if (!strcmp(dev->name, "eth0"))
		i = 0;
	else
		i = 1;	

	dev->mtu = new_mtu;
	
	vlanconfig[i].mtu=(uint32)new_mtu;
	if(vlanconfig[i].vid!=0)
	{
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	{
		rtl865x_netif_t netif;
		netif.mtu = vlanconfig[i].mtu;
		memcpy(netif.name,vlanconfig[i].ifname,MAX_IFNAMESIZE);

		rtl865x_setNetifMtu(&netif);
	}
#else
		INIT_CHECK(TBLFIELD(vlan_tbl, vlan_set_mtu)(&vlanconfig[i]));
#endif
	}
	#ifdef CONFIG_HARDWARE_NAT_DEBUG
	/*2007-12-19*/
		rtlglue_printf("%s:%d:new_mtu is %d\n",__FUNCTION__,__LINE__,new_mtu);
	#endif

	local_irq_restore(flags);

	return SUCCESS;
}

int  __init re865x_probe (void)
{
/*2007-12-19*/
	int32 i, j;
	int32 totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;
#ifdef CONFIG_RTL865X_IGMP_SNOOPING
	int32 retVal;
	struct rtl_mCastSnoopingGlobalConfig mCastSnoopingGlobalConfig;
	#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
	rtl865x_mCastConfig_t mCastConfig;
	#endif
#endif	
	rtlglue_printf("Probing RTL8186 10/100 NIC...\n");
    	REG32(CPUIIMR) = 0x00;
    	REG32(CPUICR) &= ~(TXCMD | RXCMD);
	extern	uint32* rxMbufRing;
	rxMbufRing=NULL;
	/*Initial ASIC table*/

	{
		rtl8651_tblAsic_InitPara_t para;

		memset(&para, 0, sizeof(rtl8651_tblAsic_InitPara_t));

		/*
			For DEMO board layout, RTL865x platform define corresponding PHY setting and PHYID.
		*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
		INIT_CHECK(rtl8651_initAsic(&para));
#else
		DRV_INIT_CHECK(rtl8651_initAsic(&para));
#endif
		/*
			Re-define the wan port according the wan port detection result.
			NOTE:
				There are a very strong assumption that if port5 was giga port, 
				then wan port was port 5.
		*/
		if (RTL865X_PORTMASK_UNASIGNED==rtl865x_wanPortMask)
		{
			/* keep the original mask */
			assert(RTL865X_PORTMASK_UNASIGNED==rtl865x_lanPortMask);
			rtl865x_wanPortMask = RTL_WANPORT_MASK;
			rtl865x_lanPortMask = RTL_LANPORT_MASK;
		}
		else
		{
			/* redefine wan port mask */
			assert(RTL865X_PORTMASK_UNASIGNED!=rtl865x_lanPortMask);
			for(i=0;i<totalVlans;i++)
			{
				if (TRUE==vlanconfig[i].isWan)
				{
					vlanconfig[i].memPort = vlanconfig[i].untagSet = rtl865x_wanPortMask;
				}
				else
				{
					vlanconfig[i].memPort = vlanconfig[i].untagSet = rtl865x_lanPortMask;
				}
			}
		}
#if 1		/*	10/100 & giga use the same pre-allocated skb number */
		/*
			Re-define the pre-allocated skb number according the wan 
			port detection result.
			NOTE:
				There are a very strong assumption that if port1~port4 were
				all giga port, then the sdram was 32M.
		*/
		{
			if (RTL865X_PREALLOC_SKB_UNASIGNED==rtl865x_maxPreAllocRxSkb)
			{
				assert(rtl865x_rxSkbPktHdrDescNum==
					rtl865x_txSkbPktHdrDescNum==
					RTL865X_PREALLOC_SKB_UNASIGNED);

				rtl865x_maxPreAllocRxSkb = MAX_PRE_ALLOC_RX_SKB;
				rtl865x_rxSkbPktHdrDescNum = NUM_RX_PKTHDR_DESC;
				rtl865x_txSkbPktHdrDescNum = NUM_TX_PKTHDR_DESC;
			}
			else
			{
				assert(rtl865x_rxSkbPktHdrDescNum!=RTL865X_PREALLOC_SKB_UNASIGNED);
				assert(rtl865x_txSkbPktHdrDescNum!=RTL865X_PREALLOC_SKB_UNASIGNED);
				/* Assigned value in function of rtl8651_initAsic() */
				rxRingSize[0] = rtl865x_rxSkbPktHdrDescNum;
				txRingSize[0] = rtl865x_txSkbPktHdrDescNum;
			}
		}
#else
		{
			rtl865x_maxPreAllocRxSkb = MAX_PRE_ALLOC_RX_SKB;
			rtl865x_rxSkbPktHdrDescNum = NUM_RX_PKTHDR_DESC;
			rtl865x_txSkbPktHdrDescNum = NUM_TX_PKTHDR_DESC;
		}
#endif

	}

#ifdef BR_SHORTCUT
	cached_dev=NULL;
#endif
	/*init PHY LED style*/
#if defined(CONFIG_RTL865X_BICOLOR_LED)
		#ifdef BICOLOR_LED_VENDOR_BXXX
			REG32(LEDCR) |= (1 << 19); // 5 ledmode set to 1 for bi-color LED
			REG32(PABCNR) &= ~0x001f0000; /* set port port b-4/3/2/1/0 to gpio */
			REG32(PABDIR) |=  0x001f0000; /* set port port b-4/3/2/1/0 gpio direction-output */
		#else
			//8650B demo board default: Bi-color 5 LED
			WRITE_MEM32(LEDCR, READ_MEM32(LEDCR) | 0x01180000 ); // bi-color LED
		#endif
		/* config LED mode */
		WRITE_MEM32(SWTAA, PORT5_PHY_CONTROL);
		WRITE_MEM32(TCR0, 0x000002C2); //8651 demo board default: 15 LED boards
		WRITE_MEM32(SWTACR, CMD_FORCE | ACTION_START); // force add
#else /* CONFIG_RTL865X_BICOLOR_LED */

		/* config LED mode */
		WRITE_MEM32(LEDCR, 0x00000000 ); // 15 LED
		WRITE_MEM32(SWTAA, PORT5_PHY_CONTROL);
		WRITE_MEM32(TCR0, 0x000002C7); //8651 demo board default: 15 LED boards
		WRITE_MEM32(SWTACR, CMD_FORCE | ACTION_START); // force add
#endif /* CONFIG_RTL865X_BICOLOR_LED */

/*2007-12-19*/
	INIT_CHECK(rtl865x_init());
	INIT_CHECK(rtl865x_config(vlanconfig));

	/* create all default VLANs */
//	rtlglue_printf("	creating eth0~eth%d...\n",totalVlans-1 );

	for(i=0;i<totalVlans;i++)
	{
		struct net_device *dev;
		struct dev_priv	  *dp;
		int rc;

		if (IF_ETHER!=vlanconfig[i].if_type)
		{
			continue;
		}	
		dev = alloc_etherdev(sizeof(struct dev_priv));
		if (!dev){
			rtlglue_printf("failed to allocate dev %d", i);
			return -1;
		}
		SET_MODULE_OWNER(dev);
		dp = dev->priv;
		memset(dp,0,sizeof(*dp));
		dp->dev = dev;
		dp->id = vlanconfig[i].vid;
		dp->portmask =  vlanconfig[i].memPort;
		dp->portnum  = 0;
		for(j=0;j<RTL8651_AGGREGATOR_NUMBER;j++){
			if(dp->portmask & (1<<j))
				dp->portnum++;
		}
		
		memcpy((char*)dev->dev_addr,(char*)(&(vlanconfig[i].mac)),ETHER_ADDR_LEN);
		dev->open = re865x_open;
		dev->stop = re865x_close;
		dev->set_multicast_list = re865x_set_rx_mode;
		dev->hard_start_xmit = re865x_start_xmit;
		dev->get_stats = re865x_get_stats;
		dev->do_ioctl = re865x_ioctl;
		dev->tx_timeout = re865x_tx_timeout;
		dev->set_mac_address = rtl865x_set_hwaddr;
		dev->change_mtu = rtl865x_set_mtu;
		dev->watchdog_timeo = TX_TIMEOUT;
#if 0 
		dev->features |= NETIF_F_SG | NETIF_F_IP_CSUM;
#endif
#ifdef CP_VLAN_TAG_USED
		dev->features |= NETIF_F_HW_VLAN_TX | NETIF_F_HW_VLAN_RX;
		dev->vlan_rx_register = cp_vlan_rx_register;
		dev->vlan_rx_kill_vid = cp_vlan_rx_kill_vid;
#endif
		dev->irq = ICU_NIC;
		rc = register_netdev(dev);
		if(!rc){
			_rtl86xx_dev.dev[i]=dev;
/*2007-12-19*/
			rtlglue_printf("eth%d added. vid=%d Member port 0x%x...\n", i,vlanconfig[i].vid ,vlanconfig[i].memPort );
		}else
			rtlglue_printf("Failed to allocate eth%d\n", i);

	}

#ifdef CONFIG_RTL865X_IGMP_SNOOPING
	mCastSnoopingGlobalConfig.maxGroupNum=30;
	mCastSnoopingGlobalConfig.maxSourceNum=300;
	mCastSnoopingGlobalConfig.hashTableSize=32;
	
	mCastSnoopingGlobalConfig.groupMemberAgingTime=260;
       mCastSnoopingGlobalConfig.lastMemberAgingTime=2;
	mCastSnoopingGlobalConfig.querierPresentInterval=260;  
	
       mCastSnoopingGlobalConfig.dvmrpRouterAgingTime=120;
	mCastSnoopingGlobalConfig.mospfRouterAgingTime=120;
	mCastSnoopingGlobalConfig.pimRouterAgingTime=120;
	
	retVal=rtl_initMulticastSnooping(mCastSnoopingGlobalConfig);
	if(retVal==SUCCESS)
	{
		
	
		retVal=rtl_registerIgmpSnoopingModule(&nicIgmpModuleIndex);
		#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
		if(retVal==SUCCESS)
		{
			rtl_multicastDeviceInfo_t devInfo;
			strcpy(devInfo.devName, "eth0");
			devInfo.vlanId=RTL_LANVLANID;
			vlanconfig[i].memPort=0; 
			for(i=0;i<totalVlans;i++)
			{
				if(vlanconfig[i].isWan!=TRUE)
				{
					devInfo.portMask|=vlanconfig[i].memPort ;
				}
			}
			devInfo.swPortMask=devInfo.portMask & (~ ((1<<RTL8651_MAC_NUMBER)-1));
			rtl_setIgmpSnoopingModuleDevInfo(nicIgmpModuleIndex, &devInfo);
		}
		#endif
	}
	
	#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
	memset(&mCastConfig, 0, sizeof(rtl865x_mCastConfig_t));
	for(i=0;i<totalVlans;i++)
	{
		if (TRUE==vlanconfig[i].isWan)
		{
			mCastConfig.externalPortMask |=vlanconfig[i].memPort;
		}
	}
	rtl865x_initMulticast(&mCastConfig);
	#endif
#endif


#ifdef CONFIG_RTL_STP
	printk("Configuration LINUX to process port 0 ~ port %d for Spanning tree process\n", MAX_RE865X_STP_PORT-2);
	rtl8651_setAsicSpanningEnable(TRUE);
	for ( i = 0 ; i < MAX_RE865X_STP_PORT-1 ; i ++ )
	{
		struct net_device *dev;
		struct dev_priv *dp;
		int rc;
		struct re865x_priv *rp;
		
		rp = &_rtl86xx_dev;
		dev = alloc_etherdev(sizeof(struct dev_priv));
		if (!dev){
			rtlglue_printf("failed to allocate dev %d", i);
			return -1;
		}
		strcpy(dev->name, "port%d");	
		memcpy((char*)dev->dev_addr,(char*)(&(vlanconfig[0].mac)),ETHER_ADDR_LEN);
		dp = dev->priv;
		memset(dp,0,sizeof(*dp));
		dp->dev = dev;
		dev->open = re865x_stp_open;
		dev->stop = re865x_stp_close;
		dev->set_multicast_list = NULL;
		dev->hard_start_xmit = re865x_start_xmit;
		dev->get_stats = re865x_get_stats;
		dev->do_ioctl = re865x_ioctl;
		dev->tx_timeout = NULL;
		dev->watchdog_timeo = TX_TIMEOUT;
		dev->irq = 0;				/* virtual interfaces has no IRQ allocated */
		rc = register_netdev(dev);
		if (rc == 0)
		{
			_rtl86xx_dev.stp_port[i] = dev;
			printk("=> [stp pseudo port%d] done\n", i);
		} else
		{
			printk("=> Failed to register [stp pseudo port%d]", i);
			return -1;
		}
	}

	re865x_stp_mapping_init();

#endif
	((struct dev_priv*)(_rtl86xx_dev.dev[0]->priv))->dev_next = _rtl86xx_dev.dev[1];
	((struct dev_priv*)(_rtl86xx_dev.dev[1]->priv))->dev_prev = _rtl86xx_dev.dev[0];

#ifdef CONFIG_RTL865X_ETH_PRIV_SKB
	init_priv_eth_skb_buf();



#endif	
#ifdef CONFIG_RTL8186_GR
	//cary
	rtl8651_customPassthru_init();
#endif

#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
	rtl8651_setAsicMulticastEnable(TRUE);
#else
	rtl8651_setAsicMulticastEnable(FALSE);
#endif
	return 0;
}

#ifdef CONFIG_RTL865X_ETH_PRIV_SKB

//---------------------------------------------------------------------------
static void init_priv_eth_skb_buf(void)
{
	int i;

	DEBUG_ERR("Init priv skb.\n");
	memset(eth_skb_buf, '\0', sizeof(struct priv_skb_buf2)*MAX_ETH_SKB_NUM);
	INIT_LIST_HEAD(&eth_skbbuf_list);

	for (i=0; i<MAX_ETH_SKB_NUM; i++)  {
		memcpy(eth_skb_buf[i].magic, ETH_MAGIC_CODE, 4);	
		INIT_LIST_HEAD(&eth_skb_buf[i].list);
		list_add_tail(&eth_skb_buf[i].list, &eth_skbbuf_list);	
        
	}
}

//---------------------------------------------------------------------------
static __inline__ unsigned char *get_buf_from_poll(struct list_head *phead, unsigned int *count)
{
	unsigned long flags;
	unsigned char *buf;
	struct list_head *plist;

	local_irq_save(flags);

	if (list_empty(phead)) {
		local_irq_restore(flags);
		DEBUG_ERR("eth_drv: phead=%X buf is empty now!\n", (unsigned int)phead);
		DEBUG_ERR("free count %d\n", *count);
		return NULL;
	}

	if (*count == 1) {
		local_irq_restore(flags);
		DEBUG_ERR("eth_drv: phead=%X under-run!\n", (unsigned int)phead);
		return NULL;
	}

	*count = *count - 1;
	plist = phead->next;
	list_del_init(plist);
	buf = (unsigned char *)((unsigned int)plist + sizeof (struct list_head));
	local_irq_restore(flags);
	return buf;
}

//---------------------------------------------------------------------------
static __inline__ void release_buf_to_poll(unsigned char *pbuf, struct list_head	*phead, unsigned int *count)
{
	unsigned long flags;
	struct list_head *plist;

	local_irq_save(flags);

	*count = *count + 1;
	plist = (struct list_head *)((unsigned int)pbuf - sizeof(struct list_head));
	list_add_tail(plist, phead);
	local_irq_restore(flags);
}

//---------------------------------------------------------------------------
__IRAM_GEN void free_rtl865x_eth_priv_buf(unsigned char *head)
{
	#ifdef DELAY_REFILL_ETH_RX_BUF
	extern int return_to_rx_pkthdr_ring(unsigned char *head);
	if (!return_to_rx_pkthdr_ring(head)) 
	#endif
		release_buf_to_poll(head, &eth_skbbuf_list, (unsigned int *)&eth_skb_free_num);	
}

//---------------------------------------------------------------------------
static struct sk_buff *dev_alloc_skb_priv_eth(unsigned int size)
{
	struct sk_buff *skb;

	/* first argument is not used */
	unsigned char *data = get_buf_from_poll(&eth_skbbuf_list, (unsigned int *)&eth_skb_free_num);
	if (data == NULL) {
		DEBUG_ERR("eth_drv: priv skb buffer empty!\n");
		return NULL;
	}
	skb = dev_alloc_8190_skb(data, size);
	if (skb == NULL) {
		free_rtl865x_eth_priv_buf(data);
		return NULL;
	}
    
	return skb;
}

//---------------------------------------------------------------------------
int is_rtl865x_eth_priv_buf(unsigned char *head)
{
	unsigned long offset = (unsigned long)(&((struct priv_skb_buf2 *)0)->buf);
	struct priv_skb_buf2 *priv_buf = (struct priv_skb_buf2 *)(((unsigned long)head) - offset);

	if (!memcmp(priv_buf->magic, ETH_MAGIC_CODE, 4)) {
		return 1;	
	}
	else {
		return 0;
	}
}
//---------------------------------------------------------------------------
#if defined(CONFIG_NET_WIRELESS_AGN) || defined(CONFIG_NET_WIRELESS_AG)
#include <net/dst.h>

 //---------------------------------------------------------------------------
 struct sk_buff *priv_skb_copy(struct sk_buff *skb)
 {
         struct sk_buff *n;
 
         if (rx_skb_queue.qlen == 0) {
 #ifdef CONFIG_RTL865X_ETH_PRIV_SKB
                 n = dev_alloc_skb_priv_eth(CROSS_LAN_MBUF_LEN);
 #else
                 n  = dev_alloc_skb(CROSS_LAN_MBUF_LEN);
 #endif
         }
         else {
 #ifdef RTK_QUE
                 n = rtk_dequeue(&rx_skb_queue);
 #else
                 n = __skb_dequeue(&rx_skb_queue);
 #endif
         }
 
         if (n == NULL)
                 return NULL;
 
         /* Set the tail pointer and length */
         skb_put(n, skb->len);
         n->csum = skb->csum;
         n->ip_summed = skb->ip_summed;
         memcpy(n->data, skb->data, skb->len);
 
         copy_skb_header(n, skb);
         return n;
 }
 #endif // defined(CONFIG_NET_WIRELESS_AGN) || defined(CONFIG_NET_WIRELESS_AG)
#endif // CONFIG_RTL865X_ETH_PRIV_SKB

static void __exit re865x_exit (void)
{

#ifdef RTL865X_DRIVER_DEBUG_FLAG
	rtl865x_proc_debug_cleanup();
#endif

#if defined(CONFIG_PROC_FS) && defined(CONFIG_NET_QOS) && defined(CONFIG_RTL865X_LAYERED_DRIVER)
#ifdef CONFIG_RTL865X_HW_QOS_SUPPORT
	rtl865x_exitOutputQueue();
#endif
#endif
	
#ifdef CONFIG_RTL865X_IGMP_SNOOPING
	rtl_exitMulticastSnooping();
#endif

	return;
}

module_init(re865x_probe);
module_exit(re865x_exit);

/*
@func enum RTL_RESULT | rtl865x_init | Initialize light rome driver and RTL865x ASIC.
@rvalue RTL_SUCCESS | Initial success. 
@comm
	Its important to call this API before using the driver. Note taht you can not call this API twice !
*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
int32 rtl865x_init(void)
#else
enum RTL_RESULT rtl865x_init(void)
#endif

{
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	int32 retval = 0;
#endif

	__865X_Config = 0;
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#else
	memset(&lr_stats, 0, sizeof(struct lr_cpu_stats));
#endif

/*common*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	retval = rtl865x_initNetifTable();
	retval = rtl865x_initVlanTable();
#ifdef CONFIG_RTL865X_LAYERED_DRIVER_ACL
	retval = rtl865x_init_acl();
#endif
	retval = rtl865x_initEventMgr(NULL);	
	//printk("%s(%d),retval(%d)\n",__FUNCTION__,__LINE__,retval);
	
#else
	LR_INIT_CHECK( TBLFIELD(vlan_tbl, vlan_init)() );
	LR_INIT_CHECK( TBLFIELD(acl_tbl, acl_init)() );	
#endif

/*l2*/
 #ifdef CONFIG_RTL865X_LAYERED_DRIVER
 #ifdef CONFIG_RTL865X_LAYERED_DRIVER_L2
	retval = rtl865x_layer2_init();
 #endif
 #else
 	LR_INIT_CHECK( TBLFIELD(fdb_tbl, fdb_init)() );
 #endif
 
/*layer3*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#ifdef CONFIG_RTL865X_LAYERED_DRIVER_L3
	retval = rtl865x_initIpTable();
	retval = rtl865x_initPppTable();
	retval = rtl865x_initRouteTable();
	retval = rtl865x_initNxtHopTable();
	retval = rtl865x_arp_init();
#endif
#else
	LR_INIT_CHECK( TBLFIELD(if_tbl, if_init)() );	
	LR_INIT_CHECK( TBLFIELD(natip_tbl, natip_init)() );	
	LR_INIT_CHECK( TBLFIELD(rt_tbl, route_init)() );	
	LR_INIT_CHECK( TBLFIELD(arpt_tbl, arp_init)() );	
#endif

/*layer4*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#ifdef CONFIG_RTL865X_LAYERED_DRIVER_L4
	//nat_tbl.nat_init();
	rtl865x_nat_init();
#endif
#else
	LR_INIT_CHECK( TBLFIELD(nat_tbl, nat_init)() );	
#endif

 
	/*LR_INIT_CHECK( TBLFIELD(pppoe_tbl, pppoe_init)() );*/
 #ifdef CONFIG_RTL865X_LAYERED_DRIVER
 	//INIT_CHECK( rtl8651_regLinkChangeCallBackFun(port_attr.link_change) );
 #else
	LR_INIT_CHECK( rtl8651_regLinkChangeCallBackFun(port_attr.link_change) );
 #endif

#ifdef RTL865X_DRIVER_DEBUG_FLAG
	rtl865x_proc_debug_init();
#endif

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	return SUCCESS;
#else
	return RTL_SUCCESS;
#endif
}



/*
@func enum RTL_RESULT | rtl865x_config | Configure light rome driver. Create VLAN and Network interface.
@parm struct rtl865x_vlanConfig * | vlanconfig | 
@rvlaue RTL_SUCCESS | Sucessful configuration.
@rvalue RTL_INVVID | Invalid VID.
@comm
	struct rtl865x_vlanConfig is defined as follows:
	
			ifname:		Layer 3 Network Interface name, eg: eth0, eth1, ppp0...etc,. If it is specified, both layer 2 vlan and layer 3
						netwrok interface are created and bound together. It also can be a NULL value. In this case, only a layer 2 VLAN 
						is created.
			isWan:		1 for WAN interface and 0 for LAN interface in a layer 4 mode.
			if_type:		IF_ETHER sets a network interface to be ETHER type. Instead, IF_PPPOE sets a netwrok to be PPPoE type.
						This field is meaningful only when the ifname is specified.
			vid:			VLAN ID to create a vlan.
			memPort:		VLAN member port.
			untagSet:	VLAN untag Set.
			mtu:			MTU.
			mac:		MAC address of the VLAN or network interface.	
	eg1:

	struct rtl865x_vlanConfig vlanconfig[] = {
		{ 	"eth0",	 1,   IF_ETHER, 	8, 	   1, 	0x01, 		0x01,		1500, 	{ { 0x00, 0x00, 0xda, 0xcc, 0xcc, 0x08 } }	},
		{	"eth1",	 0,   IF_ETHER,	9,	   1,		0x1e,		0x1e,		1500,	{ { 0x00, 0x00, 0xda, 0xcc, 0xcc, 0x09 } }	},

		LRCONFIG_END,
	}
*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
int32 rtl865x_config(struct rtl865x_vlanConfig vlanconfig[])
#else
enum RTL_RESULT rtl865x_config(struct rtl865x_vlanConfig vlanconfig[])
#endif

{

#ifdef CONFIG_RTL865X_LAYERED_DRIVER	
#else
	enum RTL_RESULT rc;
#endif

	uint16 pvid;
	int32 i, j;
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	int32 retval = 0;
#endif

	if (!vlanconfig[0].vid)
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
		return RTL_EINVALIDVLANID;
#else
		return RTL_INVVID;
#endif

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	INIT_CHECK(rtl8651_setAsicOperationLayer(2));
#else
	LR_INIT_CHECK(rtl8651_setAsicOperationLayer(2));
#endif
	
	//for(i=0; i<vlanconfig[i].vid != 0; i++) {
	for(i=0; vlanconfig[i].vid != 0; i++)
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	{
		rtl865x_netif_t netif;
		
		/*add vlan*/
		retval = rtl865x_addVlan(vlanconfig[i].vid);

		if(retval == SUCCESS)
		{
			rtl865x_addVlanPortMember(vlanconfig[i].vid,vlanconfig[i].memPort);
			rtl865x_setVlanFilterDatabase(vlanconfig[i].vid,vlanconfig[i].fid);			
		
		}
		/*add network interface*/
		memset(&netif, 0, sizeof(rtl865x_netif_t));
		memcpy(netif.name,vlanconfig[i].ifname,MAX_IFNAMESIZE);
		netif.macAddr = vlanconfig[i].mac;
		netif.mtu = vlanconfig[i].mtu;
		netif.if_type = vlanconfig[i].if_type;
		netif.vid = vlanconfig[i].vid;
		netif.is_wan = vlanconfig[i].isWan;
		netif.is_slave = vlanconfig[i].is_slave;
		retval = rtl865x_addNetif(&netif);

		if(netif.is_slave == 1)
			rtl865x_attachMasterNetif(netif.name, "eth1");
#if defined(CONFIG_PROC_FS) && defined(CONFIG_NET_QOS) && defined(CONFIG_RTL865X_LAYERED_DRIVER)
		memcpy(&netIfName[i][0], vlanconfig[i].ifname, sizeof(vlanconfig[i].ifname));
#endif

		
		if(retval != SUCCESS && retval != RTL_EVLANALREADYEXISTS)
			return retval;
		
	}
#else
	{
		if (vlanconfig[i].ifname[0] != '\0')
		{
			rc = (TBLFIELD(if_tbl, if_attach)(&vlanconfig[i]));
			if (rc != RTL_SUCCESS)
				return rc;
		}
		
		rc = TBLFIELD(vlan_tbl, vlan_create)(&vlanconfig[i]);
		if (rc != RTL_SUCCESS && rc != RTL_DUPENTRY)
			return rc;
	}
#endif

	/*this is a one-shot config*/
	if ((++__865X_Config) == 1)
	{
		for(i=0; i<RTL8651_PORT_NUMBER + 3; i++) 
		{ 
			/* Set each port's PVID */
			for(j=0,pvid=0; vlanconfig[j].vid != 0; j++)
			{
				if ( (1<<i) & vlanconfig[j].memPort ) 
				{
					pvid = vlanconfig[j].vid;
					break;
				}
			}
			
			if (pvid!=0)	
			{
	#ifdef CONFIG_HARDWARE_NAT_DEBUG
	/*2007-12-19*/
			rtlglue_printf("%s:%d:lrconfig[j].vid is %d,pvid is %d, j is %d,i is %d\n",__FUNCTION__,__LINE__,vlanconfig[j].vid,pvid,j, i);
	#endif
	
	#ifdef CONFIG_RTL865X_LAYERED_DRIVER	
			CONFIG_CHECK(rtl8651_setAsicPvid(i, pvid));
	#else
			LR_CONFIG_CHECK(port_attr.pvid_asic_set(i, pvid));
	#endif
			}
		}
	}

#if defined(CONFIG_PROC_FS) && defined(CONFIG_NET_QOS) && defined(CONFIG_RTL865X_LAYERED_DRIVER)
#if defined (CONFIG_RTL865X_HW_QOS_SUPPORT)
	rtl865x_initOutputQueue((uint8 **)netIfName);
#endif
#endif

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	return SUCCESS;
#else
	return RTL_SUCCESS;	
#endif
}


#ifdef CONFIG_RTL865X_LAYERED_DRIVER
int32 rtl865x_changeOpMode(int mode)
#else
enum RTL_RESULT rtl865x_changeOpMode(int mode)
#endif

{
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	int32 retval = 0;
#else
	enum RTL_RESULT rc;
#endif

	uint16 pvid;
	int32 i, j;
	struct net_device *dev;
	struct dev_priv	  *dp;	

	int32 totalVlans=((sizeof(vlanconfig))/(sizeof(struct rtl865x_vlanConfig)))-1;

	if(mode==rtl865x_curOpMode)
	{
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
		return SUCCESS;
#else
		return RTL_SUCCESS;
#endif
	}

	for(i=0; i<totalVlans; i++)
	{
		if (IF_ETHER!=vlanconfig[i].if_type)
		{
			continue;
		}
		
		dev=_rtl86xx_dev.dev[i];
		dp = dev->priv;
		
		if(vlanconfig[i].isWan==0)/*lan config*/
		{
			if(mode==GATEWAY_MODE)
			{
				vlanconfig[i].memPort=rtl865x_lanPortMask;
				vlanconfig[i].untagSet=rtl865x_lanPortMask;
			}
			else if(mode==BRIDGE_MODE)
			{
				vlanconfig[i].memPort=0x1ff;
				vlanconfig[i].untagSet=0x1ff;
			}
			else if(mode==WISP_MODE)
			{
				vlanconfig[i].memPort=0x1ff;
				vlanconfig[i].untagSet=0x1ff;
			}
			#ifdef CONFIG_RTL865X_LAYERED_DRIVER
			else if(mode==MULTIPLE_VLAN_BRIDGE_MODE)
			{
				vlanconfig[i].memPort=rtl865x_lanPortMask;
				vlanconfig[i].untagSet=rtl865x_lanPortMask;
			}
			else if(mode==MULTIPLE_VLAN_WISP_MODE)
			{
				vlanconfig[i].memPort=rtl865x_lanPortMask;
				vlanconfig[i].untagSet=rtl865x_lanPortMask;
			}
			#endif
			
		}
		else/*wan config*/
		{	
			if(mode==GATEWAY_MODE)
			{
				vlanconfig[i].vid=8;
				vlanconfig[i].memPort=rtl865x_wanPortMask;
				vlanconfig[i].untagSet=rtl865x_wanPortMask;

				/*there are two vlan in gateway mode*/
				dp->id=8;
			}
			else if(mode==BRIDGE_MODE)
			{
				vlanconfig[i].vid=0;
				vlanconfig[i].memPort=0x0;
				vlanconfig[i].untagSet=0x0;

				/*only one vlan in bridge mode*/
				dp->id=9;
			}
			else if(mode==WISP_MODE)
			{
				vlanconfig[i].vid=0;
				vlanconfig[i].memPort=0x0;
				vlanconfig[i].untagSet=0x0;

				/*only one vlan in bridge mode*/
				dp->id=9;
			}
			#ifdef CONFIG_RTL865X_LAYERED_DRIVER
			else if(mode==MULTIPLE_VLAN_BRIDGE_MODE)
			{
				vlanconfig[i].vid=8;
				vlanconfig[i].memPort=rtl865x_wanPortMask;
				vlanconfig[i].untagSet=rtl865x_wanPortMask;
				dp->id=8;
			}
			else if(mode==MULTIPLE_VLAN_WISP_MODE)
			{
				vlanconfig[i].vid=8;
				vlanconfig[i].memPort=rtl865x_wanPortMask;
				vlanconfig[i].untagSet=rtl865x_wanPortMask;
				dp->id=8;
			}
			#endif
		}

		/*update port mask and port number*/
		dp->portmask =  vlanconfig[i].memPort;
		dp->portnum  = 0;
		for(j=0;j<RTL8651_AGGREGATOR_NUMBER;j++)
		{
			if(dp->portmask & (1<<j))
				dp->portnum++;
		}	
		
	}
	
	#ifdef CONFIG_RTL865X_HARDWARE_MULTICAST
	rtl865x_setMulticastExternalPortMask(0);
	for(i=0;i<totalVlans;i++)
	{
		if (TRUE==vlanconfig[i].isWan)
		{
#ifdef CONFIG_RTL865X_LAYERED_DRIVER_L3
			rtl865x_addMulticastExternalPortMask(vlanconfig[i].memPort);
#else
			rtl865x_addMulticastExternalPortMask(0);
#endif
		}
		
	}
	#endif

	if (!vlanconfig[0].vid && !vlanconfig[1].vid )
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
		return RTL_EINVALIDVLANID;
#else
		return RTL_INVVID;
#endif	

/*l4*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#ifdef CONFIG_RTL865X_LAYERED_DRIVER_L4
	//nat_tbl.nat_init();
	rtl865x_nat_init();
#endif
#else
	LR_INIT_CHECK( TBLFIELD(nat_tbl, nat_init)() );
	
#endif	

/*l3*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#ifdef CONFIG_RTL865X_LAYERED_DRIVER_L3
	rtl865x_reinitRouteTable();
	rtl865x_reinitNxtHopTable();
	rtl865x_reinitIpTable();	
	rtl865x_reinitPppTable();	
	rtl865x_arp_reinit();
#endif
#else
	LR_INIT_CHECK( TBLFIELD(if_tbl, if_init)() );	
	LR_INIT_CHECK( TBLFIELD(natip_tbl, natip_init)() );	
	LR_INIT_CHECK( TBLFIELD(rt_tbl, route_init)() );	
	LR_INIT_CHECK( TBLFIELD(arpt_tbl, arp_init)() );
#endif

/*l2*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
#ifdef CONFIG_RTL865X_LAYERED_DRIVER_L2
	rtl865x_layer2_reinit();
#endif
#else
	LR_INIT_CHECK( TBLFIELD(fdb_tbl, fdb_init)() );
#endif

	/*common*/
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	rtl865x_reInitEventMgr();
	rtl865x_reinitNetifTable();	
	rtl865x_reinitVlantable();
#ifdef CONFIG_RTL865X_LAYERED_DRIVER_ACL
	rtl865x_reinit_acl();	
#endif
#else	
	LR_INIT_CHECK( TBLFIELD(vlan_tbl, vlan_init)() );
	LR_INIT_CHECK( TBLFIELD(acl_tbl, acl_init)() );	

	rtl8651_clearAsicAllTable();
#endif
	
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	INIT_CHECK(rtl8651_setAsicOperationLayer(2));
#else
	LR_INIT_CHECK(rtl8651_setAsicOperationLayer(2));
#endif

	for(i=0; vlanconfig[i].vid != 0; i++)
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	{
		rtl865x_netif_t netif;
		
		/*add vlan*/
		retval = rtl865x_addVlan(vlanconfig[i].vid);

		if(retval == SUCCESS)
		{
			rtl865x_addVlanPortMember(vlanconfig[i].vid,vlanconfig[i].memPort);
			rtl865x_setVlanFilterDatabase(vlanconfig[i].vid,vlanconfig[i].fid);
			
		}

		/*add network interface*/
		memset(&netif, 0, sizeof(rtl865x_netif_t));
		memcpy(netif.name,vlanconfig[i].ifname,MAX_IFNAMESIZE);
		netif.macAddr = vlanconfig[i].mac;
		netif.mtu = vlanconfig[i].mtu;
		netif.if_type = vlanconfig[i].if_type;
		netif.vid = vlanconfig[i].vid;
		netif.is_wan = vlanconfig[i].isWan;
		netif.is_slave = vlanconfig[i].is_slave;

		retval = rtl865x_addNetif(&netif);
		
		if(retval != SUCCESS && retval != RTL_EVLANALREADYEXISTS)
			return retval;
		
		
	}
#else
	{
		if (vlanconfig[i].ifname[0] != '\0')
		{
			rc = (TBLFIELD(if_tbl, if_attach)(&vlanconfig[i]));
			if (rc != RTL_SUCCESS)
				return rc;
		}
		
		rc = TBLFIELD(vlan_tbl, vlan_create)(&vlanconfig[i]);
		if (rc != RTL_SUCCESS && rc != RTL_DUPENTRY)
			return rc;
	}
#endif

#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	if((mode==MULTIPLE_VLAN_BRIDGE_MODE) || (mode==MULTIPLE_VLAN_WISP_MODE))
	{
		for(i=0; vlanconfig[i].vid != 0; i++)
		{
			if(vlanconfig[i].isWan==0)
			{
				rtl865x_setVlanFilterDatabase(vlanconfig[i].vid, 0);
			}
			else
			{
				rtl865x_setVlanFilterDatabase(vlanconfig[i].vid,1);
			}
		}
	}
#endif

	for(i=0; i<RTL8651_PORT_NUMBER + 3; i++) 
	{ 
		/* Set each port's PVID */
		for(j=0,pvid=0; vlanconfig[j].vid != 0; j++)
		{
			if ( (1<<i) & vlanconfig[j].memPort ) 
			{
				pvid = vlanconfig[j].vid;
				break;
			}
		}
		
		if (pvid!=0)	
		{
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
			CONFIG_CHECK(rtl8651_setAsicPvid(i,pvid));
#else
			LR_CONFIG_CHECK(port_attr.pvid_asic_set(i, pvid));
#endif
		}
	}
#ifdef CONFIG_RTL_STP
	re865x_stp_mapping_reinit();
#endif

	/*update current operation mode*/
	rtl865x_curOpMode=mode;
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
	return SUCCESS;
#else
	return RTL_SUCCESS;	
#endif
}

#ifdef CONFIG_RTL8186_GR

static int isCreated;
static struct proc_dir_entry *res=NULL;
static char passThru_flag[1];

static unsigned long atoi_dec(char *s)
{
	unsigned long k = 0;

	k = 0;
	while (*s != '\0' && *s >= '0' && *s <= '9') {
		k = 10 * k + (*s - '0');
		s++;
	}
	return k;
}

static int custom_Passthru_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data)
{
	int len;	
	len = sprintf(page, "%s\n", passThru_flag);
	if (len <= off+count) 
		*eof = 1;

	*start = page + off;
	len -= off;

	if (len>count) 
		len = count;

	if (len<0) len = 0;

	return len;
}

static int custom_Passthru_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data)
{
	int flag,i;

#if	!defined(CONFIG_RTL865X_LAYERED_DRIVER)
	struct rtl865x_vlanConfig  passThruVlanConf = {"passThru",0,IF_ETHER,PASSTHRU_VLAN_ID,0,
		rtl865x_lanPortMask|rtl865x_wanPortMask,
		rtl865x_lanPortMask|rtl865x_wanPortMask,
		1500,{ { 0x00, 0x12, 0x34, 0x56, 0x78, 0x90 } } };
#endif
//	printk("old status=%d\n",oldStatus);	
	if (buffer && !copy_from_user(&passThru_flag, buffer, count))
	{			
		flag=(int)atoi_dec(passThru_flag);		
		//printk("rtl865x_wanPortMask=%d	",rtl865x_wanPortMask);
		if(flag ^ oldStatus)
		{
			
			//IPv6 PassThru
			if((flag & IP6_PASSTHRU_MASK) ^ (oldStatus & IP6_PASSTHRU_MASK)) 
			{			
				if(flag & IP6_PASSTHRU_MASK)
				{//add				
					for(i=0; i<RTL865XC_PORT_NUMBER; i++)
					{
						rtl8651_setProtocolBasedVLAN(IP6_PASSTHRU_RULEID, i, TRUE, PASSTHRU_VLAN_ID);
					}				
				}
				else
				{//delete
					for(i=0; i<RTL865XC_PORT_NUMBER; i++)
					{
						rtl8651_setProtocolBasedVLAN(IP6_PASSTHRU_RULEID, i, FALSE, PASSTHRU_VLAN_ID);
					}
				}
			}

			//PPPoE PassThru
			if((flag & PPPOE_PASSTHRU_MASK) ^ (oldStatus & PPPOE_PASSTHRU_MASK)) 
			{			
				if(flag & PPPOE_PASSTHRU_MASK)
				{//add				
					for(i=0; i<RTL865XC_PORT_NUMBER; i++)
					{
						rtl8651_setProtocolBasedVLAN(RTL8651_PBV_RULE_PPPOE_CONTROL, i, TRUE, PASSTHRU_VLAN_ID);
						rtl8651_setProtocolBasedVLAN(RTL8651_PBV_RULE_PPPOE_SESSION, i, TRUE, PASSTHRU_VLAN_ID);
					}				
				}
				else
				{//delete
					for(i=0; i<RTL865XC_PORT_NUMBER; i++)
					{
						rtl8651_setProtocolBasedVLAN(RTL8651_PBV_RULE_PPPOE_CONTROL, i, FALSE, PASSTHRU_VLAN_ID);
						rtl8651_setProtocolBasedVLAN(RTL8651_PBV_RULE_PPPOE_SESSION, i, TRUE, PASSTHRU_VLAN_ID);
					}
				}
			}
			
			//vlan
			#if 0
			if(!oldStatus)
			{
				TBLFIELD(vlan_tbl, vlan_create)(&passThruVlanConf);
			}
			
			if(!flag)
			{
				TBLFIELD(vlan_tbl, vlan_remove)(PASSTHRU_VLAN_ID);
			}
			#else
			if(!isCreated)
                        {
#ifdef CONFIG_RTL865X_LAYERED_DRIVER
				rtl865x_addVlan(PASSTHRU_VLAN_ID);
				rtl865x_addVlanPortMember(PASSTHRU_VLAN_ID, rtl865x_lanPortMask|rtl865x_wanPortMask);
#else
                                TBLFIELD(vlan_tbl, vlan_create)(&passThruVlanConf);
#endif
				isCreated=1;
                        }
			#endif			
		}
		oldStatus=flag;
		return count;
	}
	return -EFAULT;
}
int32 rtl8651_customPassthru_init(void)
{
	oldStatus=0;
	isCreated=0;
	res = create_proc_entry("custom_Passthru", 0, NULL);	
	if(res)
	{
		res->read_proc = custom_Passthru_read_proc;
		res->write_proc = custom_Passthru_write_proc;
	}
	rtl8651_defineProtocolBasedVLAN( IP6_PASSTHRU_RULEID, 0x0, 0x86DD );
	return 0;
}

void __exit rtl8651_customPassthru_exit(void)
{
	if (res) {
		remove_proc_entry("custom_Passthru", res);				
		res = NULL;
	}
}
#endif


	
