#ifndef _PROJECT_H
#define _PROJECT_H
//Platform Define Setting
#define SYS_KERNEL_MTDBLK               "/dev/mtdblock1"
#define SYS_KERNEL_MTD                  "/dev/mtd1"
#define IMG_LOWER_BOUND                 2 * 1024 * 1024
#define IMG_UPPER_BOUND                 3 * 1024 * 1024
#define LOADER_LOWER_BOUND				64 * 1024
#define LOADER_UPPER_BOUND				128 * 1024
#define FW_KERNEL_BUF_SIZE              0xe0000
#define SYS_ROOTFS_MTDBLK               "/dev/mtdblock2"
#define SYS_ROOTFS_MTD                  "/dev/mtd2"
#define FW_ROOTFS_BUF_SIZE              0x200000
#define FW_BUF_SIZE                     FW_KERNEL_BUF_SIZE + FW_ROOTFS_BUF_SIZE
#define SYS_MAC_MTDBLK                  "/dev/mtdblock4"
#define SYS_MAC_MTD                     "/dev/mtd4"
#define MAC_BUF_SIZE                	64 * 1024
#define SYS_CAL_MTDBLK          		"/dev/mtdblock5"
#define SYS_CAL_MTD                     "/dev/mtd5"
#define FW_CAL_BUF_SIZE                 0x20000
#define SYS_BOOT_MTDBLK                 "/dev/mtdblock0"
#define SYS_BOOT_MTD                    "/dev/mtd0"
#define BOOT_BUF_SIZE                   0x20000
/*temp sol: fake define for passing sutil compile, but we don't need it*/
#define SYS_KERNEL_START_ADDR			0xb05000

/* Wireless Domain and Channel Setting, */
/*Domain*/
#define MAX_24G_GROUP           2
#define WIRELESS_BAND_24G		0
#define WIRELESS_BAND_50G		1
#define COUNTRY_NAME			0
#define DOMAIN_NAME				1
/* region domain */
#define DEBUG_REG_DMN   0x0000
#define NULL1           0xffff
#define NOT_FOUND       0xffff
/* for 2.4G */
#define APLD            0x0001
#define ETSIA           0x0002
#define ETSIB           0x0003
#define ETSIC           0x0004
#define FCCA            0x0005
#define MKKA            0x0006
#define MKKC            0x0007
#define WORLD           0x0008
/* for 5G */
#define APL1            0x1001
#define APL2            0x1002
#define APL3            0x1003
#define APL4            0x1004
#define APL5            0x1005
#define APL6            0x1006
#define ETSI1           0x1007
#define ETSI2           0x1008
#define ETSI3           0x1009
#define ETSI4           0x100A
#define ETSI5           0x100B
#define ETSI6           0x100C
#define FCC1            0x100D
#define FCC2            0x100E
#define FCC3            0x100F
#define MKK1            0x1010
#define MKK2            0x1011
#define APL9            0x1012
#define FCC6            0x1013

/* Realtek wlan client */
#define STA_INFO_FLAG_ASOC		0x04
#define SIOCGIWNAME				0x8B01
#define SIOCGIWRTLSTAINFO		0x8B30
#define SIOCGIWRTLGETBSSINFO	0x8B37
#define BAND_11A				4
#define BAND_11N				8
#define BAND_11G				2
#define BAND_11B				1

struct channel_list_s {
	unsigned short low_channel;   // Low Channel center in MHz
	unsigned short high_channel;  // High Channel center in MHz
};

struct freq_table_s {
	int regdomain_mode;
	int no_group;
	struct channel_list_s group[MAX_24G_GROUP];
};

static struct freq_table_s wireless2_table[] = {
	{APLD, 2,	{
				{-19, -1},
				{1, 13}}},
	{ETSIA, 1,	{
				{10, 13},	
				{0, 0}}}, 
	{ETSIB, 1,	{
				{5, 13},	
				{0, 0}}},
	{ETSIC, 1,	{
				{1, 13},	
				{0, 0}}},
	{FCCA, 1,	{
				{1, 11},	
				{0, 0}}},
	{MKKA, 2,	{
				{1, 13},	
				{14, 14}}},	
	{MKKC, 1,	{
				{1, 13},
				{0, 0}}},		
	{WORLD, 1,	{
				{1, 13},
				{0, 0}}},	
					
	{NULL1, 1,	{
				{1, 13},
				{0, 0}}},	
					 
};


struct domain_name_s {
	int  number;
	char name[20];
	int  wireless2_freq_table;
	int  wireless5_freq_table;
};

static struct domain_name_s  domain_name[] = {
	{0x00,     "NO_ENUMRD",     NULL1,  NULL1  },
	{0x03,     "NULL1_WORLD",   WORLD,  NULL1},         /* For 11b-only countries (no 11a allowed) */
	{0x07,     "NULL1_ETSIB",   ETSIB,  NULL1},         /* Israel */
	{0x08,     "NULL1_ETSIC",   ETSIC,  NULL1},
	{0x10,     "FCC1_FCCA",     FCCA,   FCC1},          // USA
	{0x11,     "FCC1_WORLD",    WORLD,  FCC1},          // Hong Kong 
	{0x14,	   "FCC6_FCCA",		FCCA,	FCC6},	//CTRY_CANADA2                                                          
	{0x20,     "FCC2_FCCA",     FCCA,   FCC2},          // Canada                                                             
	{0x21,     "FCC2_WORLD",    WORLD,  FCC2},          // Australia                                                          
	{0x22,     "FCC2_ETSIC",    ETSIC,  FCC2},   
	{0x23,     "FCC6_WORLD",    WORLD,  FCC6},	//CTRY_AUSTRALIA2                                                                       
	{0x31,     "FRANCE_RES",    WORLD,  ETSI3},         // Legacy France for OEM                                              
	{0x3A,     "FCC3_FCCA",		FCCA,	FCC3},          // USA & Canada w/5470 band, 11h, DFS enabled  //CTRY_UNITED_STATES                       
	{0x37,     "ETSI1_WORLD",   WORLD,  ETSI1},          //CTRY_GERMANY                                                               
	{0x32,     "ETSI3_ETSIA",   WORLD,  ETSI3},         // France (optional)                                                  
	{0x35,     "ETSI2_WORLD",   WORLD,  ETSI2},         // Hungary & others                                                   
	{0x36,     "ETSI3_WORLD",   WORLD,  ETSI3},         // France & others                                                    
	{0x30,     "ETSI4_WORLD",   WORLD,  ETSI4},                                                                         
	{0x38,     "ETSI4_ETSIC",   ETSIC,  ETSI4},                                                                         
	{0x39,     "ETSI5_WORLD",   WORLD,  ETSI5},                                                                         
	{0x34,     "ETSI6_WORLD",   WORLD,  ETSI6},         // Bulgaria                                                           
	{0x33,     "ETSI_RESERVED", NULL1,  NULL1},         // Reserved (Do not used)                                             
	{0x40,     "MKK1_MKKA",     MKKA,   MKK1},          // Japan (JP1)                                                        
	{0x41,     "MKK1_MKKB",     MKKA,   MKK1},          // Japan (JP0)                                                        
	{0x42,     "APL4_WORLD",    WORLD,  APL4},          // Jordon                                                             
	{0x43,     "MKK2_MKKA",     MKKA,   MKK2},          // Japan with 4.9G channels                                           
	{0x44,     "APL_RESERVED",  NULL1,  NULL1},         // Reserved (Do not used)                                             
	{0x45,     "APL2_WORLD",    WORLD,  APL2},          // Korea                                                              
	{0x46,     "APL2_APLC",     NULL1,  APL2},                                                                           
	{0x47,     "APL3_WORLD",    WORLD,  APL3},                                                                          
	{0x48,     "MKK1_FCCA",     FCCA,   MKK1},          // Japan (JP1-1)                                                      
	{0x49,     "APL2_APLD",     APLD,   APL2},          // Korea with 2.3G channels  
	{0x50,     "APL3_FCCA",		FCCA,	APL3},	//CTRY_TAIWAN  
	{0x51,     "APL2_FCCA",		FCCA,	APL2},	//CTRY_CHILE 
	{0x5E,     "APL9_WORLD",    WORLD,  APL9},	//CTRY_KOREA_NORTH                                         
	{0x4A,     "MKK1_MKKA1",    MKKA,   MKK1},          // Japan (JE1)                                                        
	{0x4B,     "MKK1_MKKA2",    MKKA,   MKK1},          // Japan (JE2)                                                        
	{0x4C,     "MKK1_MKKC",     MKKC,   MKK1},          // Japan (MKK1_MKKA,except Ch14)                                      
	{0x52,     "APL1_WORLD",    WORLD,  APL1},          // Latin America //CTRY_CHINA                                                     
	{0x53,     "APL1_FCCA",     FCCA,   APL1},                                                                           
	{0x54,     "APL1_APLA",     NULL1,  APL1},                                                                           
	{0x55,     "APL1_ETSIC",    ETSIC,  APL1},                                                                          
	{0x56,     "APL2_ETSIC",    ETSIC,  APL2},          // Venezuala                                                          
	{0x58,     "APL5_WORLD",    WORLD,  APL5},          // Chile                                                              
	{0x5B,     "APL6_WORLD",    WORLD,  APL6},          // Singapore  //CTRY_INDIA                                                        
	{0xffff,   "unknow",        NULL1,  NULL1}
};

/*  Date: 2009-2-17
*   Name: Ken Chiang
*   Reason: added to change wireless region from show Domain name to Country name for version.txt.
*   Notice :
*/
struct country_name_s {
	int  number;
	char name[10];	
};

static struct country_name_s  country_name[] = {
	{0x10,     "US/NA"},//FCC1_FCCA
	{0x14,	   "CA"},	        //FCC6_FCCA
	{0x20,	   "CA"},	//FCC2_FCCA   
	{0x23,     "AU"},			//FCC6_WORLD                                             
	{0x30,     "EU"},	//ETSI4_WORLD
	{0x31,     "SP"},   //FRANCE_RES        
	{0x32,     "FR"},	//ETSI3_ETSIA 
	{0x37,     "EU"},	        //ETSI1_WORLD  
	{0x3A,     "US/NA"},	    //FCC3_FCCA                                                              
	{0x40,     "JP"},	//MKK1_MKKA 
	{0x41,     "JP"},	//MKK1_MKKB    
	{0x50,     "TW"},	        //APL3_FCCA  
    {0x51,     "LA"},	        //APL2_FCCA                                                               
	{0x52,     "CN"},	        //APL1_WORLD                                                                                                             
	{0x5B,     "SG"},	        //APL6_WORLD (INDIA) 
	{0x5E,     "KR"},			//APL9_WORLD                                                           
	{0xffff,   "unknow"}
};

struct region_s{
	char *name;
	int number;
};

static struct region_s region[] = {
	{"Africa",				0x37},
	{"Asia",					0x52},
	{"Australia",			0x21},
	{"Canada",				0x20},
	{"Europe",				0xffff},   //can't find
	{"France",				0x36},
	{"Israel",				0x07},
	{"Japan",					0x40},
	{"Maxico",				0x10},
	{"South America",	0xffff},   //can't find
	{"United States",	0x10}
};
#endif //#ifndef _PROJECT_H
