#include "project.h"
//////////////////////////////////////////////////////////////////
// Common Define Setting 
#define AP_RT_INFO              	"/var/tmp/ap_rt_info"
#define CHAP_REMOTE_NAME            "CAMEO"
#define WPASUP_CONFIG               "/var/etc/wpa.conf"
#ifdef UUID
#define UUID_FILE                                       "/var/tmp/uuid_file"
#endif
#define RC_PID                      "/var/run/rc.pid"
#define UDHCPD_PID					"/var/run/udhcpd.pid"
#define HOSTAPD_PID                 "/var/run/hostapd.pid"
#define NVRAM_UPGRADE_PID       	"/var/run/nvram_upgrade.pid"
#define TRACEGW_PID                 "/var/run/tracegw.pid"
#define GPIO_PID                    "/var/run/gpio.pid"
#define HTTPD_PID                   "/var/run/httpd.pid"
#define TIMER_PID                   "/var/run/timer.pid"
#define WANTIMER_PID				"/var/run/wan_timer.pid"
#define WAN_MONITOR_PID				"/var/run/monitor.pid"
#define IGMPPROXY_PID				"/var/run/igmpproxy.pid"
#define PPTP_PID					"/var/run/ppp-pptp.pid"
#define L2TP_PID					"/var/run/l2tp.pid"
#define PPP0_PID					"/var/run/ppp0.pid"

#define LOG_FILE     				"/var/log/FW_log"
#define LOG_FILE_HTTP 				"/var/log/messages"
#define LOG_FILE_FULL   			"/var/log/messages_full"
#define LOG_FILE_BAK 				"/var/log/messages_bak"
#define STATUS_OF_EMAIL_LOG			"/var/tmp/status_of_email_log"
#define STATUS_OF_TIMEOUT_EMAIL_LOG	"/var/tmp/status_log_email_time_out_display"
#define EMAIL_LOG_STATUS_INIT		2
#define EMAIL_LOG_SUCCESS			1
#define EMAIL_LOG_FAIL				0
#define EMAIL_LOG_TIMEOUT_DISABLE	0
#define EMAIL_LOG_TIMEOUT_ENABLE	1
#define EMAIL_LOG_RETRY_MAX_COUNT	4

#define DHCPD_CONF              	"/var/etc/udhcpd.conf"
#define HTML_LEASES_FILE        	"/var/misc/html.leases"
#define LEASES_FILE             	"/var/misc/udhcpd.leases"
#define RC_FLAG_FILE            	"/var/etc/rc_flag.conf"

#define NVRAM_UPGRADE_TMP       	"/var/tmp/nvram.tmp"
#define NVRAM_CONFIG_TMP            "/var/tmp/nvram.bin"
#define GPIO_DRIVER_PATH			"/lib/modules/2.6.15/net/gpio_mod.ko"
#define WPS_LED_GPIO_DRIVER_PATH	"/lib/modules/2.6.15/net/ar531xgpio.o"
#define DHCPC_DNS_SCRIPT            "/usr/share/udhcpc/default.bound-dns"
#define DHCPC_NODNS_SCRIPT          "/usr/share/udhcpc/default.bound-nodns"
#define IGMPPROXY                   "/var/etc/igmpproxy.conf"
#define HOSTAPD_TMP_CONFIG_0		"/tmp/hostapd.conf.0.0"
#define HOSTAPD_TMP_CONFIG_1		"/tmp/hostapd.conf.0.1"
#define HOSTAPD_TMP_CONFIG_2		"/tmp/hostapd.conf.0.2"
#define HOSTAPD_TMP_CONFIG_3		"/tmp/hostapd.conf.0.3"
#define HOSTAPD_DUMP_FILE_0			"/tmp/hostapd.dump.0.0"
#define HOSTAPD_DUMP_FILE_1			"/tmp/hostapd.dump.0.1"
#define HOSTAPD_DUMP_FILE_2			"/tmp/hostapd.dump.0.2"
#define HOSTAPD_DUMP_FILE_3			"/tmp/hostapd.dump.0.3"
#define RESOLVFILE					"/var/etc/resolv.conf"
#define L2TP_CONF					"/var/etc/l2tp.conf"
#define CHAP_SECRETS				"/var/etc/chap-secrets"
#define PAP_SECRETS					"/var/etc/pap-secrets"
#define LAN_BRIDGE_INFO				"/var/tmp/lanbrinfo"
#define FW_FILTER					"/var/tmp/fw_filter"
#define FW_NAT						"/var/tmp/fw_nat"
#define FW_MANGLE					"/var/tmp/fw_mangle"
#define HTTP_PORT					80	/* TCP */
#define IDENT_PORT					113	/* TCP */
#define ISAKMP_PORT					500	/* UDP */
#define L2TP_PORT					1701	/* UDP */
#define PPTP_PORT					1723	/* TCP */
#define IP_MULTICAST				"224.0.0.0/4"
#define IP_FORWARD					"/proc/sys/net/ipv4/ip_forward"
#define ROUTING_INFO				"/var/etc/routing.txt"
#define DOMAIN_RECORDS				"/var/tmp/domain_records"
#define SNMPV3_CONF_FILE        	"/var/etc/snmpd.conf"
#define SNMPV3_AUTH_FILE        	"/var/net-snmp/snmpd.conf"
#define UPNP_CONF_FILE				"/tmp/etc/miniupnpd.conf"

#define DHCPD_REVOKE_FILE			"/var/tmp/dhcp_revoke"
#define AVERAGE_BYTES               "/var/tmp/average_bytes"
#define IGMP_GROUP_FILE				"/var/tmp/igmp_group.conf"

#define CLIENT_LIST_FILE        	"/var/tmp/local_lan_ip"
#define PPP_OPTIONS					"/var/etc/options"
#define DNS_QUERY_RESULT			"/var/tmp/dns_quesy_result"
#define FW_UPGRADE_FILE				"/var/firm/image.bin"
#define WPS_PBC  					0
#define WPS_PIN  					1
#define IDENT_PORT					113      /* TCP */
#define HTTP_PORT					80		 /* TCP */


/* status value */
/* need to change for different solution(here is realtek:8196B) */
#define WPS_SUCCESS_STATUS			"3"
#define WPS_RESPONSE_FILE			"/var/wscd_status"
#define WPS_UPDATE_SETTTING_FILE	"/var/flash_param"
#define WPS_TMP_FILE				"/var/flash_param_tmp"
#define WSC_SSID_STR				"WSC_SSID="
#define WSC_PSK_STR					"WSC_PSK="
#define WSC_AUTH_STR				"WSC_AUTH="
#define WSC_CIPHER_STR				"WSC_ENC="
#define WIRELESS_IN_CONFIG_MODE		"5"
#define WIRELESS_IN_UNCONFIG_MODE	"1"
#define WIRELESS_CLIENT_LIST		"/var/tmp/rtk_wlan_client_list.txt"

/* pptp redial check (here is realtek:8196B) */
#define RTK_PPTP_DAEMON_EXIST		"/var/tmp/pppd_rtk_daemon.txt"
#define RTK_PPTP_IPCP_STATUS		"/var/tmp/ipcp_rtk_status.txt"
#define RTK_PPTP_START				"pppd-rtk call rpptp"
#define RTK_PPTP_STOP				"killall -9 pppd-rtk"
#define RTK_PPTP_IPCP_BUSY			0
#define RTK_PPTP_IPCP_IDLE			1
#define RTK_PPTP_NOT_EXIST			2

/* url filter setting (realtek fast path enable)*/
#define RTL_MAX_URL_FILTER_LIST		1024
#define RTL_DEFAULT_URL_FILTER_RULE	"\" \""
#define RTL_ALLOW_ALL_URL			"\"00-00-00-00-00-00/00-00-00-00-00-00/always/allday/0/0/1/0,1;\""
#define RTL_DENY_ALL_URL			"\"00-00-00-00-00-00/00-00-00-00-00-00/always/allday/0/0/0/0,1;\""
#define RTL_MAC_URL_FILTER_PROC		"/proc/mac_url_filter"
#define RTL_URL_FILTER_PROC			"/proc/url_filter"

/* FQDN */
#define FQDN_HOST_IP_LIST			"/var/tmp/fqdn_host_ip.txt"
#define FQDN_HOST_IP_LIST_SWAP		FQDN_HOST_IP_LIST ".swap"

//////////////////////////////////////////////////////////////////
// IPv6 Define Setting 
#define RESOLVFILE_IPV6             "/var/etc/resolv_ipv6.conf"
#define RESOLVFILE_DUAL             "/var/etc/resolv_dual.conf"
#define IPV6_CLIENT_LIST       		"/var/tmp/ipv6_client_list"
#define IPV6_CLIENT_INFO        	"/var/tmp/ipv6_client_info"
#define IPV6_CLIENT_RESULT      	"/var/tmp/ipv6_client_result"
#define RADVD_CONF_FILE         	"/var/etc/radvd.conf"
#define LINK_LOCAL_INFO         	"/var/etc/link_local_info"

#ifdef DHCPv6
#define DHCPD6_CONF_FILE        	"/var/etc/dhcpd6.conf"
#define DHCPD6_LEASE_FILE       	"/var/misc/dhcpd6.lease"
#define DHCPD6_PID_FILE         	"/var/run/dhcpd6.pid"
#define DHCLIENT6_SCRIPT        	"/etc/dhc6.script"
#define DHCLIENT6_NODNS_SCRIPT  	"/etc/dhc6nodns.script"
#define DHCLIENT6_LEASE_FILE    	"/var/misc/dhc6.lease"
#endif
#define MAX_DHCPD_RESERVATION_NUMBER    CONFIG_DHCPD_RESERVATION_NUMBER
// Protocol Define Setting 
#define MAX_PPPOE_CONNECTION    		1
#define LOG_MAX_SIZE				20 /*KB*/
#define SMTP_CONF                       	"/var/etc/smtp.conf"
#ifdef CONFIG_QOS_NUMBER
#define MAX_QOS_NUMBER                          CONFIG_QOS_NUMBER
#else
#define MAX_QOS_NUMBER                          20
#endif

#ifdef CONFIG_RC_DYNAMIC_ROUTE
#define ZEBRA_CONF		"/var/etc/zebra.conf"
#define RIPD_CONF		"/var/etc/ripd.conf"
#endif

#ifdef CONFIG_STATIC_ROUTE_NUMBER
#define MAX_STATIC_ROUTING_NUMBER               CONFIG_STATIC_ROUTE_NUMBER
#else
#define MAX_STATIC_ROUTING_NUMBER               20
#endif

#ifdef CONFIG_SRC_MACHINE_NUMBER
#define MAX_SRC_MACHINE_NUMBER                  CONFIG_SRC_MACHINE_NUMBER
#else
#define MAX_SRC_MACHINE_NUMBER                  8
#endif

#ifdef CONFIG_ACCESS_CONTROL_NUMBER
#define MAX_ACCESS_CONTROL_NUMBER               CONFIG_ACCESS_CONTROL_NUMBER
#else
#define MAX_ACCESS_CONTROL_NUMBER               15
#endif

#ifdef CONFIG_SCHEDULE_NUMBER
#define MAX_SCHEDULE_NUMBER                     CONFIG_SCHEDULE_NUMBER
#else
#define MAX_SCHEDULE_NUMBER                     10
#endif

#ifdef CONFIG_MAC_FILTER_NUMBER
#define MAX_MAC_FILTER_NUMBER                   CONFIG_MAC_FILTER_NUMBER
#else
#define MAX_MAC_FILTER_NUMBER                   20
#endif

#ifdef CONFIG_UPGRADE_TIME
#define UPGRADE_COUNT_DOWN                      core_itoa(CONFIG_UPGRADE_TIME)
#else
#define UPGRADE_COUNT_DOWN                      "140"
#endif

#ifdef CONFIG_UPLOAD_TIME
#define UPLOAD_COUNT_DOWN                       core_itoa(CONFIG_UPLOAD_TIME)
#else
#define UPLOAD_COUNT_DOWN                       "120"
#endif

#ifdef CONFIG_RESET_TIME
#define RESET_COUNT_DOWN                        core_itoa(CONFIG_RESET_TIME)
#else
#define RESET_COUNT_DOWN                        "3"
#endif

#ifdef CONFIG_REBOOT_TIME
#define REBOOT_COUNT_DOWN                       core_itoa(CONFIG_REBOOT_TIME)
#else
#define REBOOT_COUNT_DOWN                       "60"
#endif

#ifdef CONFIG_RESTORE_TIME
#define RESTORE_COUNT_DOWN                      core_itoa(CONFIG_RESTORE_TIME)
#else
#define RESTORE_COUNT_DOWN                      "70"
#endif

#ifdef CONFIG_RESTORE_WIRELESS_TIME
#define RESTORE_WIRELESS_COUNT_DOWN             core_itoa(CONFIG_RESTORE_WIRELESS_TIME)
#else
#define RESTORE_WIRELESS_COUNT_DOWN             "30"
#endif
#define RC_RESTART_COUNT_DOWN             "20"