#include "prj_define.h"
struct nvram_t {
	char name[40];
	char value[192];
};

extern int nvram_show(void);
extern int nvram_upgrade(void);
extern char *nvram_get(const char *name);
extern char *nvram_safe_get(const char *name);
extern int nvram_set(const char *name, const char *value);
extern int nvram_unset(const char *name);
extern int nvram_del(const char *name);
extern int nvram_count(const char *name);
extern int nvram_match(const char *name, const char *value);
extern int nvram_commit(void);
extern int nvram_restore_default(void);
extern int nvram_config2file(void);
extern int nvram_file_save(const char *name, const char *file);
extern int nvram_file_restore(const char *name, const char *file);
extern int nvram_replace(const char *name, const char *value);
extern void nvram_flag_set(void);
extern void nvram_flag_reset(void);

#define CONF_BUF 30*1024
  
#define CONFIG_NVRAM_BLK "/dev/mtdblock3"
#define SYS_CONF_MTDBLK CONFIG_NVRAM_BLK

#define NVRAM_FILE "/var/etc/nvram.conf"
#define NVRAM_SIZE_COUNT "/var/etc/nvram_count.txt"
