/*
* ----------------------------------------------------------------
* Copyright c                  Realtek Semiconductor Corporation, 2002  
* All rights reserved.
* 
* $Header: /cvsroot/Realtek/RTL8196B/loader/bootcode/boot/rtl865x/swCore.c,v 1.1.1.1 2009/02/17 09:45:01 anderson Exp $
*
* Abstract: Switch core driver source code.
*
* $Author: anderson $
*
* $Log: swCore.c,v $
* Revision 1.1.1.1  2009/02/17 09:45:01  anderson
* RTL8196B source code
*
* Revision 1.1.1.1  2009/02/11 06:37:02  anderson
* RTL8196B source code
*
* Revision 1.2  2007/08/23 12:29:04  davidhsu
* Read GPIO setting to determine Ethernet s/w LED
*
* Revision 1.1.1.1  2007/08/06 10:05:02  root
* Initial import source to CVS
*
* Revision 1.35  2007/03/20 07:31:59  yumc
* Add runtime determined patch for 865xC Cut-A revision.
*
* Revision 1.34  2007/03/15 09:03:53  hf_shi
* default enable flow control.if enalbe flow control in image will
* cause link down-up.
*
* Revision 1.33  2007/02/08 08:30:40  ghhuang
* *: Remove Cut-A Patch
*
* Revision 1.32  2006/11/15 13:19:28  ghhuang
* *: Phy Patch for RTL8652 IC Bug
*
* Revision 1.31  2006/09/15 03:53:39  ghhuang
* +: Add TFTP download support for RTL8652 FPGA
*
* Revision 1.30  2006/05/19 05:18:38  chenyl
* *: modify the header file "board.h" to "loader.h" to prevent from naming redundancy.
*
* Revision 1.29  2005/10/13 12:27:22  yjlou
* +: set PHY Amplitude
*
* Revision 1.28  2005/09/22 05:22:31  bo_zhao
* *** empty log message ***
*
* Revision 1.1.1.1  2005/09/05 12:38:25  alva
* initial import for add TFTP server
*
* Revision 1.27  2005/04/24 03:49:59  yjlou
* *: do not touch other fields, except SYS_CLK_MASK, of MACMR
*
* Revision 1.26  2005/01/28 02:03:48  yjlou
* *: loader version migrates to "00.00.19".
* +: support Hub mode
* +: Ping mode support input IP address
* *: clear WDTIND always.
*
* Revision 1.25  2004/12/28 12:28:53  yjlou
* *: version migrates to 00.00.17
* *: VLAN MTU changes to 1500 (not 1522).
* *: support I28F320J3A flash
*
* Revision 1.24  2004/10/01 01:39:30  yjlou
* -: remove Mii port from VLAN member port
*
* Revision 1.23  2004/08/02 01:12:28  yjlou
* *: fixed the compile error
*
* Revision 1.22  2004/07/30 10:51:22  yjlou
* *: To get the correct link status, register PORT0_PHY_STATUS must be read twice.
*
* Revision 1.21  2004/07/26 08:12:52  yjlou
* +: add code to check BIST Queue Memory and Packet Buffer
*
* Revision 1.20  2004/07/13 02:59:42  yjlou
* +: enable Mii at swCore_init()
*
* Revision 1.19  2004/07/12 11:57:47  yjlou
* +: support BICOLOR_LED
*
* Revision 1.18  2004/06/11 07:12:11  yjlou
* *: change compile flag from 'CONFIG_RTL865X_BICOLOR_LED' to 'BICOLOR_LED_VENDOR_BXXX'
*
* Revision 1.17  2004/05/21 11:43:17  yjlou
* +: support hub mode (still buggy) and erase flash function.
*
* Revision 1.16  2004/05/14 09:39:42  orlando
* check in CONFIG_RTL865X_BICOLOR_LED/DIAG_LED/INIT_BUTTON related code
*
* Revision 1.15  2004/05/06 11:32:41  yjlou
* +: add PORT6_PHY_CONTROL series register
*
* Revision 1.14  2004/05/06 03:52:50  yjlou
* +: code for Buffalo bi-color LED (defualt marked)
*
* Revision 1.13  2004/05/04 06:24:27  yjlou
* *: fixed the FCRTH value (Flow Control Threshold Register)
*
* Revision 1.12  2004/04/23 04:33:08  yjlou
* *: fixed the bug of TEATCR L2 Aging field.
*
* Revision 1.11  2004/04/13 02:11:32  yjlou
* *: clear FULL_RST and SEMI_RST bit to 0 after reset.
*
* Revision 1.10  2004/04/05 09:32:46  yjlou
* *: fixed the bug of TRXRDY always high when reseting.
*
* Revision 1.9  2004/04/01 12:41:26  yjlou
* *: fixed FullAndSemiReset() to be compatible with 8651
*
* Revision 1.8  2004/04/01 12:17:45  yjlou
* *: Patched the bug of Switch Core Full Reset: add FullAndSemiReset()
*
* Revision 1.7  2004/03/31 01:49:20  yjlou
* *: all text files are converted to UNIX format.
*
* Revision 1.6  2004/03/30 11:34:38  yjlou
* *: commit for 80B IC back
*   +: system clock rate definitions have changed.
*   *: fixed the bug of BIST_READY_PATTERN
*   +: clean all ASIC table when init ASIC.
* -: define _L2_MODE_ to support L2 switch mode.
*
* Revision 1.5  2004/03/29 03:42:25  yjlou
* +: Initializing for 8650 backward compatible mode.
*
* Revision 1.4  2004/03/26 09:20:28  yjlou
* +: add code for Buffalo bi-color LED (but commented)
*
* Revision 1.3  2004/03/25 08:59:58  yjlou
* -: remove 'int_Register(SW_ILEV, SWIE, SWIRS_OFFSET, swCore_intHandler);' in swCore_init()
*
* Revision 1.2  2004/03/22 05:54:55  yjlou
* +: support two flash chips.
*
* Revision 1.1  2004/03/16 06:36:13  yjlou
* *** empty log message ***
*
* Revision 1.4  2004/03/16 06:04:04  yjlou
* +: support pure L2 switch mode (for hardware testing)
*
* Revision 1.3  2004/03/09 00:45:01  danwu
* remove unused code to shrink loader image size under 0xc000 and only flash block 0 & 3 occupied
*
* Revision 1.2  2004/01/27 08:37:05  tony
* small change
*
* Revision 1.1.1.1  2003/09/25 08:16:55  tony
*  initial loader tree 
*
* Revision 1.1.1.1  2003/05/07 08:16:06  danwu
* no message
*
* ---------------------------------------------------------------
*/

#include <rtl_types.h>
#include <rtl_errno.h>
#include <rtl8650/loader.h>  //wei edit
#include <rtl8650/asicregs.h>
#include <rtl8650/swCore.h>
#include <rtl8650/phy.h>
#include <linux/autoconf.h>

#define BICOLOR_LED 1

#define WRITE_MEM32(addr, val)   (*(volatile unsigned int *) (addr)) = (val)
#define WRITE_MEM16(addr, val)   (*(volatile unsigned short *) (addr)) = (val)
#define READ_MEM32(addr)         (*(volatile unsigned int *) (addr))

#define RTL8651_ETHER_AUTO_100FULL	0x00
#define RTL8651_ETHER_AUTO_100HALF	0x01
#define RTL8651_ETHER_AUTO_10FULL		0x02
#define RTL8651_ETHER_AUTO_10HALF	0x03
#define RTL8651_ETHER_AUTO_1000FULL	0x08
#define RTL8651_ETHER_AUTO_1000HALF	0x09
#define GIGA_PHY_ID	0x16
#ifdef RTL_8652_5PORT
#define GIGA_P1_PHYID	0x12
#define GIGA_P2_PHYID	0x13
#define GIGA_P3_PHYID	0x14
#define GIGA_P4_PHYID	0x15 
#define GIGA_P5_PHYID	0x16 
#endif
#define tick_Delay10ms(x) { int i=x; while(i--) __delay(5000); }
static int32 miiPhyAddress;

#if CONFIG_RTL865XC
/*#define rtl8651_asicTableAccessAddrBase(type) (RTL8651_ASICTABLE_BASE_OF_ALL_TABLES + 0x10000 * (type)) */
#define		RTL8651_ASICTABLE_BASE_OF_ALL_TABLES		0xBB000000
#define		rtl8651_asicTableAccessAddrBase(type) (RTL8651_ASICTABLE_BASE_OF_ALL_TABLES + ((type)<<16) )
#define 		RTL865X_FAST_ASIC_ACCESS
#define		RTL865XC_ASIC_WRITE_PROTECTION				/* Enable/Disable ASIC write protection */
#define		RTL8651_ASICTABLE_ENTRY_LENGTH (8 * sizeof(uint32))
#define		RTL865X_TLU_BUG_FIXED		1

#ifdef RTL865X_FAST_ASIC_ACCESS
static uint32 _rtl8651_asicTableSize[] =
{
	2 /*TYPE_L2_SWITCH_TABLE*/,
	1 /*TYPE_ARP_TABLE*/,
    2 /*TYPE_L3_ROUTING_TABLE*/,
	3 /*TYPE_MULTICAST_TABLE*/,
	1 /*TYPE_PROTOCOL_TRAP_TABLE*/,
	5 /*TYPE_VLAN_TABLE*/,
	3 /*TYPE_EXT_INT_IP_TABLE*/,
    1 /*TYPE_ALG_TABLE*/,
    4 /*TYPE_SERVER_PORT_TABLE*/,
    3 /*TYPE_L4_TCP_UDP_TABLE*/,
    3 /*TYPE_L4_ICMP_TABLE*/,
    1 /*TYPE_PPPOE_TABLE*/,
    8 /*TYPE_ACL_RULE_TABLE*/,
    1 /*TYPE_NEXT_HOP_TABLE*/,
    3 /*TYPE_RATE_LIMIT_TABLE*/,
};
#endif

static uint8 fidHashTable[]={0x00,0x0f,0xf0,0xff};

static void _rtl8651_asicTableAccessForward(uint32 tableType, uint32 eidx, void *entryContent_P) {
	ASSERT_CSP(entryContent_P);


	while ( (READ_MEM32(SWTACR) & ACTION_MASK) != ACTION_DONE );//Wait for command done

#ifdef RTL865X_FAST_ASIC_ACCESS

	{
		register uint32 index;

		for( index = 0; index < _rtl8651_asicTableSize[tableType]; index++ )
		{
			WRITE_MEM32(TCR0+(index<<2), *((uint32 *)entryContent_P + index));
		}

	}
#else
	WRITE_MEM32(TCR0, *((uint32 *)entryContent_P + 0));
	WRITE_MEM32(TCR1, *((uint32 *)entryContent_P + 1));
	WRITE_MEM32(TCR2, *((uint32 *)entryContent_P + 2));
	WRITE_MEM32(TCR3, *((uint32 *)entryContent_P + 3));
	WRITE_MEM32(TCR4, *((uint32 *)entryContent_P + 4));
	WRITE_MEM32(TCR5, *((uint32 *)entryContent_P + 5));
	WRITE_MEM32(TCR6, *((uint32 *)entryContent_P + 6));
	WRITE_MEM32(TCR7, *((uint32 *)entryContent_P + 7));
#endif	
	WRITE_MEM32(SWTAA, ((uint32) rtl8651_asicTableAccessAddrBase(tableType) + eidx * RTL8651_ASICTABLE_ENTRY_LENGTH));//Fill address
}

static int32 _rtl8651_forceAddAsicEntry(uint32 tableType, uint32 eidx, void *entryContent_P) {

	#ifdef RTL865XC_ASIC_WRITE_PROTECTION
	if (RTL865X_TLU_BUG_FIXED)	/* No need to stop HW table lookup process */
	{	/* No need to stop HW table lookup process */
		WRITE_MEM32(SWTCR0,EN_STOP_TLU|READ_MEM32(SWTCR0));
		while ( (READ_MEM32(SWTCR0) & STOP_TLU_READY)==0);
	}
	#endif

	_rtl8651_asicTableAccessForward(tableType, eidx, entryContent_P);

 	WRITE_MEM32(SWTACR, ACTION_START | CMD_FORCE);//Activate add command
	while ( (READ_MEM32(SWTACR) & ACTION_MASK) != ACTION_DONE );//Wait for command done

	#ifdef RTL865XC_ASIC_WRITE_PROTECTION
	if (RTL865X_TLU_BUG_FIXED)	/* No need to stop HW table lookup process */
	{
		WRITE_MEM32(SWTCR0,~EN_STOP_TLU&READ_MEM32(SWTCR0));
	}
	#endif

	return SUCCESS;
}

uint32 rtl8651_filterDbIndex(ether_addr_t * macAddr,uint16 fid) {
    return ( macAddr->octet[0] ^ macAddr->octet[1] ^
                    macAddr->octet[2] ^ macAddr->octet[3] ^
                    macAddr->octet[4] ^ macAddr->octet[5] ^fidHashTable[fid]) & 0xFF;
}

static int32 rtl8651_setAsicL2Table(ether_addr_t	*mac, uint32 column)
{
	rtl865xc_tblAsic_l2Table_t entry;
	uint32	row;

	row = rtl8651_filterDbIndex(mac, 0);
	if((row >= RTL8651_L2TBL_ROW) || (column >= RTL8651_L2TBL_COLUMN))
		return FAILED;
	if(mac->octet[5] != ((row^(fidHashTable[0])^ mac->octet[0] ^ mac->octet[1] ^ mac->octet[2] ^ mac->octet[3] ^ mac->octet[4] ) & 0xff))
		return FAILED;

	memset(&entry, 0,sizeof(entry));
	entry.mac47_40 = mac->octet[0];
	entry.mac39_24 = (mac->octet[1] << 8) | mac->octet[2];
	entry.mac23_8 = (mac->octet[3] << 8) | mac->octet[4];

//	entry.extMemberPort = 0;   
	entry.memberPort = 7;
	entry.toCPU = 1;
	entry.isStatic = 1;
//	entry.nxtHostFlag = 1;

	/* RTL865xC: modification of age from ( 2 -> 3 -> 1 -> 0 ) to ( 3 -> 2 -> 1 -> 0 ). modification of granularity 100 sec to 150 sec. */
	entry.agingTime = 0x03;
	
//	entry.srcBlock = 0;
	entry.fid=0;
	entry.auth=1;

	return _rtl8651_forceAddAsicEntry(TYPE_L2_SWITCH_TABLE, row<<2 | column, &entry);
}
#endif

//------------------------------------------------------------------------
static void _rtl8651_clearSpecifiedAsicTable(uint32 type, uint32 count) 
{
	struct { uint32 _content[8]; } entry;
	uint32 idx;
	
	bzero(&entry, sizeof(entry));
	for (idx=0; idx<count; idx++)// Write into hardware
		swTable_addEntry(type, idx, &entry);
}

void FullAndSemiReset( void )
{
#if CONFIG_RTL865XC

/* FIXME: Currently workable for FPGA, may need further modification for real chip */

#if 1
    /* Perform full-reset for sw-core. */ 
    REG32(SIRR) |= FULL_RST;

	tick_Delay10ms(50);

	/* Enable TRXRDY */
	REG32(SIRR) |= TRXRDY;
#endif

#endif /* CONFIG_RTL865XC */
}

int32 rtl865xC_setAsicEthernetMIIMode(uint32 port, uint32 mode)
{
	if ( port != 0 && port != RTL8651_MII_PORTNUMBER )
		return FAILED;
	if ( mode != LINK_RGMII && mode != LINK_MII_MAC && mode != LINK_MII_PHY )
		return FAILED;

	if ( port == 0 )
	{
		/* MII port MAC interface mode configuration */
		WRITE_MEM32( P0GMIICR, ( READ_MEM32( P0GMIICR ) & ~CFG_GMAC_MASK ) | ( mode << LINKMODE_OFFSET ) );
	}
	else
	{
		/* MII port MAC interface mode configuration */
		WRITE_MEM32( P5GMIICR, ( READ_MEM32( P5GMIICR ) & ~CFG_GMAC_MASK ) | ( mode << LINKMODE_OFFSET ) );
	}
	return SUCCESS;

}

int32 rtl865xC_setAsicEthernetRGMIITiming(uint32 port, uint32 Tcomp, uint32 Rcomp)
{
	if ( port != 0 && port != RTL8651_MII_PORTNUMBER )
		return FAILED;
	if ( Tcomp < RGMII_TCOMP_0NS || Tcomp > RGMII_TCOMP_7NS || Rcomp < RGMII_RCOMP_0NS || Rcomp > RGMII_RCOMP_2DOT5NS )
		return FAILED;
	
	if ( port == 0 )
	{
		WRITE_MEM32(P0GMIICR, ( ( ( READ_MEM32(P0GMIICR) & ~RGMII_TCOMP_MASK ) | Tcomp ) & ~RGMII_RCOMP_MASK ) | Rcomp );
	}
	else
	{
		WRITE_MEM32(P5GMIICR, ( ( ( READ_MEM32(P5GMIICR) & ~RGMII_TCOMP_MASK ) | Tcomp ) & ~RGMII_RCOMP_MASK ) | Rcomp );
	}

	return SUCCESS;
}

int32 rtl8651_setAsicEthernetMII(uint32 phyAddress, int32 mode, int32 enabled)
{
	/* Input validation */
	if ( phyAddress < 0 || phyAddress > 31 )
		return FAILED;
	if ( mode != P5_LINK_RGMII && mode != P5_LINK_MII_MAC && mode != P5_LINK_MII_PHY )
		return FAILED;
	
	/* Configure driver level information about mii port 5 */
	if ( enabled )
	{
		if ( miiPhyAddress >= 0 && miiPhyAddress != phyAddress )
			return FAILED;

		miiPhyAddress = phyAddress;
	}
	else
	{
		miiPhyAddress = -1;
	}

	/* MII port MAC interface mode configuration */
	WRITE_MEM32( P5GMIICR, ( READ_MEM32( P5GMIICR ) & ~CFG_GMAC_MASK ) | ( mode << P5_LINK_OFFSET ) );

	return SUCCESS;
}


int32 rtl8651_getAsicEthernetPHYReg(uint32 phyId, uint32 regId, uint32 *rData)
{
	uint32 status;
	
	WRITE_MEM32( MDCIOCR, COMMAND_READ | ( phyId << PHYADD_OFFSET ) | ( regId << REGADD_OFFSET ) );

#ifdef RTL865X_TEST
	status = READ_MEM32( MDCIOSR );
#else
	do { status = READ_MEM32( MDCIOSR ); } while ( ( status & STATUS ) != 0 );
#endif

	status &= 0xffff;
	*rData = status;

	return SUCCESS;
}

int32 rtl8651_setAsicEthernetPHYReg(uint32 phyId, uint32 regId, uint32 wData)
{
	WRITE_MEM32( MDCIOCR, COMMAND_WRITE | ( phyId << PHYADD_OFFSET ) | ( regId << REGADD_OFFSET ) | wData );

#ifdef RTL865X_TEST
#else
	while( ( READ_MEM32( MDCIOSR ) & STATUS ) != 0 );		/* wait until command complete */
#endif

	return SUCCESS;
}

int32 rtl8651_restartAsicEthernetPHYNway(uint32 port, uint32 phyid)
{
	uint32 statCtrlReg0;

	/* read current PHY reg 0 */
	rtl8651_getAsicEthernetPHYReg( phyid, 0, &statCtrlReg0 );

	/* enable 'restart Nway' bit */
	statCtrlReg0 |= RESTART_AUTONEGO;

	/* write PHY reg 0 */
	rtl8651_setAsicEthernetPHYReg( phyid, 0, statCtrlReg0 );

	return SUCCESS;
}

int32 rtl8651_setAsicEthernetPHY(uint32 port, int8 autoNegotiation, uint32 advCapability, uint32 speed, int8 fullDuplex, 
	uint32 phyId, uint32 isGPHY) 
{
	uint32 statCtrlReg0, statCtrlReg4, statCtrlReg9;

	/* ====================
		Arrange PHY reg 0
	   ==================== */

	/* Read PHY reg 0 (control register) first */
	rtl8651_getAsicEthernetPHYReg(phyId, 0, &statCtrlReg0);

	if ( autoNegotiation == TRUE )	
	{
		statCtrlReg0 |= ENABLE_AUTONEGO;
	}
	else
	{
		statCtrlReg0 &= ~ENABLE_AUTONEGO;

		/* Clear speed & duplex setting */
		if ( isGPHY )
			statCtrlReg0 &= ~SPEED_SELECT_1000M;
		statCtrlReg0 &= ~SPEED_SELECT_100M;
		statCtrlReg0 &= ~SELECT_FULL_DUPLEX;

		if ( speed == 1 )	/* 100Mbps, assume 10Mbps by default */
			statCtrlReg0 |= SPEED_SELECT_100M;

		if ( fullDuplex == TRUE )
			statCtrlReg0 |= SELECT_FULL_DUPLEX;
	}

	/* =============================================================
		Arrange PHY reg 4, if GPHY, also need to arrange PHY reg 9.
	   ============================================================= */
	rtl8651_getAsicEthernetPHYReg( phyId, 4, &statCtrlReg4 );

	/* Clear all capability */
	statCtrlReg4 &= ~CAP_100BASE_MASK;

	if ( isGPHY )
	{
		rtl8651_getAsicEthernetPHYReg( phyId, 9, &statCtrlReg9 );

		/* Clear all 1000BASE capability */
		statCtrlReg9 &= ~ADVCAP_1000BASE_MASK;
	}
	else
	{
		statCtrlReg9 = 0;
	}
	
	if ( advCapability == RTL8651_ETHER_AUTO_1000FULL )
	{
		statCtrlReg9 = statCtrlReg9 | CAPABLE_1000BASE_TX_FD | CAPABLE_1000BASE_TX_HD;
		statCtrlReg4 = statCtrlReg4 | CAPABLE_100BASE_TX_FD | CAPABLE_100BASE_TX_HD | CAPABLE_10BASE_TX_FD | CAPABLE_10BASE_TX_HD;
	}
	else if ( advCapability == RTL8651_ETHER_AUTO_1000HALF )
	{
		statCtrlReg9 = statCtrlReg9 | CAPABLE_1000BASE_TX_HD;
		statCtrlReg4 = statCtrlReg4 | CAPABLE_100BASE_TX_FD | CAPABLE_100BASE_TX_HD | CAPABLE_10BASE_TX_FD | CAPABLE_10BASE_TX_HD;
	}
	else if ( advCapability == RTL8651_ETHER_AUTO_100FULL )
	{
		statCtrlReg4 = statCtrlReg4 | CAPABLE_100BASE_TX_FD | CAPABLE_100BASE_TX_HD | CAPABLE_10BASE_TX_FD | CAPABLE_10BASE_TX_HD;
	}
	else if ( advCapability == RTL8651_ETHER_AUTO_100HALF )
	{
		statCtrlReg4 = statCtrlReg4 | CAPABLE_100BASE_TX_HD | CAPABLE_10BASE_TX_FD | CAPABLE_10BASE_TX_HD;
	}
	else if ( advCapability == RTL8651_ETHER_AUTO_10FULL )
	{
		statCtrlReg4 = statCtrlReg4 | CAPABLE_10BASE_TX_FD | CAPABLE_10BASE_TX_HD;
	}
	else if ( advCapability == RTL8651_ETHER_AUTO_10HALF )
	{
		statCtrlReg4 = statCtrlReg4 | CAPABLE_10BASE_TX_HD;
	}
	else
	{
//		RTL_WARN(RTL_MSG_GENERIC, "Invalid advertisement capability!");
		return FAILED;
	}

	/* ===============================
		Set PHY reg 4.
		Set PHY reg 9 if necessary.
	   =============================== */
	rtl8651_setAsicEthernetPHYReg( phyId, 4, statCtrlReg4 );

	if ( isGPHY )
	{
		rtl8651_setAsicEthernetPHYReg( phyId, 9, statCtrlReg9 );
	}

	/* =================
		Set PHY reg 0.
	   ================= */
	rtl8651_setAsicEthernetPHYReg( phyId, 0, statCtrlReg0 );

	/* =======================================================
		Restart Nway.
		If 'Nway enable' is FALSE, ASIC won't execute Nway.
	   ======================================================= */
	rtl8651_restartAsicEthernetPHYNway(port, phyId);

	return SUCCESS;
}


int32 rtl8651_setAsicFlowControlRegister(uint32 port, uint32 enable, uint32 phyid)
{
	uint32 statCtrlReg4;

	/* Read */
	rtl8651_getAsicEthernetPHYReg( phyid, 4, &statCtrlReg4 );

	if ( enable && ( statCtrlReg4 & CAPABLE_PAUSE ) == 0 )
	{
		statCtrlReg4 |= CAPABLE_PAUSE;		
	}
	else if ( enable == 0 && ( statCtrlReg4 & CAPABLE_PAUSE ) )
	{
		statCtrlReg4 &= ~CAPABLE_PAUSE;
	}
	else
		return SUCCESS;	/* The configuration does not change. Do nothing. */

	rtl8651_setAsicEthernetPHYReg( phyid, 4, statCtrlReg4 );
	
	/* restart N-way. */
	rtl8651_restartAsicEthernetPHYNway(port, phyid);

	return SUCCESS;
}
static unsigned int ExtP5GigaPhyMode=0;
#ifdef RTL_8652_5PORT
static unsigned int fixdata[]={
				
/*
				// for auto mdi bug to fix
				0,31,0x0002,				0,3,0x0360,				0,31,0x0008,
				1,31,0x0002,				1,3,0x0360,				1,31,0x0008,
				2,31,0x0002,				2,3,0x0360,				2,31,0x0008,
				3,31,0x0002,				3,3,0x0360,				3,31,0x0008,
*/

///*				
				//#     Enable Auto MDI/MDIX
				0,31,0x0000,		0,16,0x0140,
				0,31,0x0008,		1,31,0x0000,
				1,16,0x0140,		1,31,0x0008,
				2,31,0x0000,		2,16,0x0140,
				2,31,0x0008,		3,31,0x0000,
				3,16,0x0140,		3,31,0x0008,
//*/				
				

				0,31,0x0008,  	0,19,0xFE1F,	0,31,0x0008,	
				0,31,0x0000,	0,23,0x2104,	0,31,0x0008,	
				1,31,0x0000,	1,23,0x2104,	1,31,0x0008,	
				2,31,0x0000,	2,23,0x2104,	2,31,0x0008,	
				3,31,0x0000,	3,23,0x2104,	3,31,0x0008,	
				0,31,0x0001,	0,27,0xB414,	0,31,0x0008,	
				1,31,0x0001,	1,27,0xB414,	1,31,0x0008,	
				2,31,0x0001,	2,27,0xB414,	2,31,0x0008,	
				3,31,0x0001,	3,27,0xB414,	3,31,0x0008,	
				0,31,0x0002,	0,10,0xA084,	0,31,0x0008,	
				1,31,0x0002,	1,10,0xA084,	1,31,0x0008,	
				2,31,0x0002,	2,10,0xA084,	2,31,0x0008,	
				3,31,0x0002,	3,10,0xA084,	3,31,0x0008,	
				0,31,0x0000,	0,22,0xFF00,	0,31,0x0008,	
				1,31,0x0000,	1,22,0xFF00,	1,31,0x0008,	
				2,31,0x0000,	2,22,0xFF00,	2,31,0x0008,	
				3,31,0x0000,	3,22,0xFF00,	3,31,0x0008,	
				0,31,0x0001,	0,12,0xDC00,	0,31,0x0008,	
				1,31,0x0001,	1,12,0xDC00,	1,31,0x0008,	
				2,31,0x0001,	2,12,0xDC00,	2,31,0x0008,	
				3,31,0x0001,	3,12,0xDC00,	3,31,0x0008,	
				0,31,0x0008,	0, 0,0x1340,	0,31,0x0008,	
				1,31,0x0008,	1, 0,0x1340,	1,31,0x0008,	
				2,31,0x0008,	2, 0,0x1340,	2,31,0x0008,	
				3,31,0x0008,	3, 0,0x1340,	3,31,0x0008,	
				0,31,0x0008,	1,31,0x0008,	2,31,0x0008,	3,31,0x0008,
				//serdes rst
				0,31,0x0009,	0,16,0x8A19,	0,31,0x0008,	
				0,31,0x0009,	0,16,0x8A19,	0,16,0x8A11,	
				0,16,0x8A19,	0,31,0x0008,	1,31,0x0009,	
				1,16,0x8A18,	1,16,0x8A10,	1,16,0x8A18,	
				1,31,0x0008,	
				0,31,0x0009,	
				0,16,0x8A19,	0,16,0x8A1D,	0,16,0x8A19,	0,31,0x0008,	
				1,31,0x0009,	1,16,0x8A18,	1,16,0x8A1C,	
				1,16,0x8A18,	1,31,0x0008,	
				0,31,0x0009,	0,16,0x8A18,	0,31,0x0008,

				//date:1/5 add
				//Calibration one time then Close
				0,31,0x0000,		0,26,0x0040,		0,31,0x0008,
				1,31,0x0000,		1,26,0x0040,		1,31,0x0008,
				2,31,0x0000,		2,26,0x0040,		2,31,0x0008,
				3,31,0x0000,		3,26,0x0040,		3,31,0x0008,
				
				0,31,0x0009,		0,21,0xc54e,		0,31,0x0008,
				1,31,0x0009,		1,21,0xc54e,		1,31,0x0008,



				
};  //phyid, reg, val, total 114 counts


static unsigned int SerdesRst[]={
				0,31,0x0009,	0,16,0x8A19,	0,31,0x0008,	
				0,31,0x0009,	0,16,0x8A19,	0,16,0x8A11,	
				0,16,0x8A19,	0,31,0x0008,	1,31,0x0009,	
				1,16,0x8A18,	1,16,0x8A10,	1,16,0x8A18,	
				1,31,0x0008,	
				0,31,0x0009,	
				0,16,0x8A19,	0,16,0x8A1D,	0,16,0x8A19,	0,31,0x0008,	
				1,31,0x0009,	1,16,0x8A18,	1,16,0x8A1C,	
				1,16,0x8A18,	1,31,0x0008,	
				0,31,0x0009,	0,16,0x8A18,	0,31,0x0008
				};  //phyid, reg, val, 



void FixPHYChip()
{

	unsigned int i,j;
	for(i=0; i<sizeof(fixdata)/sizeof(unsigned int); i+=3 )
	{
		//dprintf("i=%04d, %02d %02d %04x\r\n",i/3, GIGA_P1_PHYID+fixdata[i+0], fixdata[i+1], fixdata[i+2]);
		rtl8651_setAsicEthernetPHYReg(GIGA_P1_PHYID+fixdata[i+0], fixdata[i+1], fixdata[i+2] );		
		delay_ms(10);
	}
}

void Fix8652Serdes()
{
		//do 8652 sedes bug fix
		REG32(0xbb802004)=0x00001fe2;
		REG32(0xbb80200c)=0x00001fe2;
		REG32(0xbb802000)=0x8eaa2416;
		REG32(0xbb802008)=0x8eaa2416;

}

void RstGigaPhy()
{
	unsigned int r,rstcount=5,tmp,needrst=0;
	unsigned int i=0,j;	

	FixPHYChip();

	for(r=0; r<rstcount; r++)
	{
		delay_ms(200);	
		//do serdes rst
		for(i=0; i<sizeof(SerdesRst)/sizeof(unsigned int); i+=3 )
			rtl8651_setAsicEthernetPHYReg(GIGA_P1_PHYID+SerdesRst[i+0], SerdesRst[i+1], SerdesRst[i+2] );	
		
		needrst=1;		
		for(i=0;i<5;i++)
		{	rtl8651_getAsicEthernetPHYReg(GIGA_P1_PHYID+0, 27, &tmp);
			delay_ms(200);
			//dprintf("reg 27=0x%x\r\n",tmp);
			if( (tmp&0x1b) ==0x1b )	//if have one time is not 0x1b, need reset
			{	needrst=0;
				break;			
			}
		}
		if(needrst ==0)
		{	//dprintf("RTL8214 Init OK!\n");
			break;
		}	
		else
			dprintf("Serdes not init OK, need Reset again\r\n");
	}



}


static unsigned int ExtP1P4GigaPhyMode=0;

//unsigned int ProbeP1toP4GigaPHYChip()
void ProbeP1toP4GigaPHYChip()
{
	unsigned int uid,tmp;
	unsigned int i;

	//FixPHYChip();

	/* Read */
	for(i=0; i<4; i++)  //probe p1-p4
	{
		rtl8651_getAsicEthernetPHYReg( GIGA_P1_PHYID+i, 2, &tmp );
		uid=tmp<<16;
		rtl8651_getAsicEthernetPHYReg( GIGA_P1_PHYID+i, 3, &tmp );
		uid=uid | tmp;

		if( uid==0x001cC912 )  //0x001cc912 is 8212 two giga port , 0x001cc940 is 8214 four giga port
		{	//dprintf("PHYID=%x Find PHY Chip! UID=%08x\r\n", GIGA_P1_PHYID+i, uid);
			dprintf("Find Port1-4 have 8212 PHY Chip! \r\n");
			Fix8652Serdes();
			ExtP1P4GigaPhyMode=1;
			//return 1;
			return;
		}
		else if(uid==0x001cC940)
		{
			dprintf("Find Port1-4 have 8214 PHY Chip!\r\n");
//			dprintf("Do fix phy chip...\r\n");
			//FixPHYChip();
			Fix8652Serdes();
			//RstGigaPhy();
			ExtP1P4GigaPhyMode=1;
			//return 1;
			return;
		}
	}
	//return 0;
}

//unsigned int ProbeP5GigaPHYChip()
void ProbeP5GigaPHYChip()	
{
	unsigned int uid,tmp;
	unsigned int i;

	/* Read */
	rtl8651_getAsicEthernetPHYReg( GIGA_P5_PHYID, 0, &tmp );
	rtl8651_setAsicEthernetPHYReg(GIGA_P5_PHYID,0x10,0x01FE);
	
	rtl8651_getAsicEthernetPHYReg( GIGA_P5_PHYID, 2, &tmp );
	uid=tmp<<16;
	rtl8651_getAsicEthernetPHYReg( GIGA_P5_PHYID, 3, &tmp );
	uid=uid | tmp;

	if( uid==0x001CC912 )  //0x001cc912 is 8212 two giga port , 0x001cc940 is 8214 four giga port
	{	dprintf("Find Port5   have 8211 PHY Chip! \r\n");
		ExtP5GigaPhyMode=1;
		//return 1;
	}	

	//return 0;
}
#endif
int32 swCore_init()
{
#if CONFIG_RTL865XC

/* FIXME: Currently workable for FPGA, may need further modification for real chip */

	int c;
        uint32 rev;
	int port;
	
	/* Full reset and semreset */
	FullAndSemiReset();

	#if 1  /* May not be needed */
	/* rtl8651_clearAsicAllTable */
	_rtl8651_clearSpecifiedAsicTable(TYPE_L2_SWITCH_TABLE, RTL8651_L2TBL_ROW*RTL8651_L2TBL_COLUMN);
	_rtl8651_clearSpecifiedAsicTable(TYPE_ARP_TABLE, RTL8651_ARPTBL_SIZE);
	_rtl8651_clearSpecifiedAsicTable(TYPE_L3_ROUTING_TABLE, RTL8651_ROUTINGTBL_SIZE);
	_rtl8651_clearSpecifiedAsicTable(TYPE_MULTICAST_TABLE, RTL8651_IPMULTICASTTBL_SIZE);
	_rtl8651_clearSpecifiedAsicTable(TYPE_NETINTERFACE_TABLE, RTL865XC_NETINTERFACE_NUMBER);
	_rtl8651_clearSpecifiedAsicTable(TYPE_VLAN_TABLE, RTL865XC_VLAN_NUMBER);
	_rtl8651_clearSpecifiedAsicTable(TYPE_EXT_INT_IP_TABLE, RTL8651_IPTABLE_SIZE);
	_rtl8651_clearSpecifiedAsicTable(TYPE_ALG_TABLE, RTL8651_ALGTBL_SIZE);
	_rtl8651_clearSpecifiedAsicTable(TYPE_SERVER_PORT_TABLE, RTL8651_SERVERPORTTBL_SIZE);
	_rtl8651_clearSpecifiedAsicTable(TYPE_L4_TCP_UDP_TABLE, RTL8651_TCPUDPTBL_SIZE);
	_rtl8651_clearSpecifiedAsicTable(TYPE_L4_ICMP_TABLE, RTL8651_ICMPTBL_SIZE);
	_rtl8651_clearSpecifiedAsicTable(TYPE_PPPOE_TABLE, RTL8651_PPPOE_NUMBER);
	_rtl8651_clearSpecifiedAsicTable(TYPE_ACL_RULE_TABLE, RTL8651_ACLTBL_SIZE);
	_rtl8651_clearSpecifiedAsicTable(TYPE_NEXT_HOP_TABLE, RTL8651_NEXTHOPTBL_SIZE);
	_rtl8651_clearSpecifiedAsicTable(TYPE_RATE_LIMIT_TABLE, RTL8651_RATELIMITTBL_SIZE);
	#endif

#if defined(BICOLOR_LED_VENDOR_BXXX)
    /* Install interrupt handler */
   // int_Register(SW_ILEV, SWIE, SWIRS_OFFSET, swCore_intHandler);
#endif /* BICOLOR_LED_VENDOR_BXXX */
#ifdef RTL_8652_5PORT
	if(ExtP1P4GigaPhyMode)
	{
		//dprintf("Setting PIT register\r\n");
		//P5 P4 P3 P2 P1 P0, offset: 10,8,6,4,2,0  
		//REG32(PITCR)=(0<<10) | (0x01 <<8) | (0x01<<6) | (0x01<<4) | (0x01 <<2)  | (0x03<<0 ); //set P0:reserver,  P1-P4:serdes, P5:RGMII
		REG32(PITCR)=(0<<10) | (0x01 <<8) | (0x01<<6) | (0x01<<4) | (0x01 <<2)  | (0x00<<0 ); //for anson test port0
		//REG32(PCRP0) = (GIGA_P0_PHYID<< ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
		REG32(PCRP1) = (GIGA_P1_PHYID << ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
		REG32(PCRP2) = (GIGA_P2_PHYID << ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
		REG32(PCRP3) = (GIGA_P3_PHYID << ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
		REG32(PCRP4) = (GIGA_P4_PHYID << ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
	}
	else
#else
	{

	REG32(PCRP0) = (0 << ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
	REG32(PCRP1) = (1 << ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
	REG32(PCRP2) = (2 << ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
	REG32(PCRP3) = (3 << ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
	REG32(PCRP4) = (4 << ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
	}
#endif	

#if !defined(RTL8196B)
    rev = ((READ_MEM32(CRMR)) >> 12) & 0x0f ;/*Runtime determined patch for A cut revison. RLRevID_OFFSET = 12, RLRevID_MASK = 0x0f */
    if (rev < 0x01) {
		rev = READ_MEM32((SYSTEM_BASE+0x3400+0x08));
		if(rev == 0x00)/*A Cut patch RTL865X_CHIP_REV_A = 0x00*/{
			REG32(PCRP6) = (6 << ExtPHYID_OFFSET) | AcptMaxLen_16K | EnablePHYIf;
        }
    }   
#endif

#ifdef RTL_8652_5PORT
	if(ExtP1P4GigaPhyMode)
		rtl865xC_setAsicEthernetMIIMode(0, LINK_RGMII); //wei add for 8652 demo board
#endif
	if(ExtP5GigaPhyMode)
	rtl865xC_setAsicEthernetMIIMode(RTL8651_MII_PORTNUMBER, LINK_RGMII);

	/*
		# According to Hardware SD: David & Maxod,			
		Set Port5_GMII Configuration Register.
		- RGMII Output Timing compensation control : 0 ns
		- RGMII Input Timing compensation control : 0 ns
	*/
#ifdef RTL_8652_5PORT
	if(ExtP1P4GigaPhyMode)	
		rtl865xC_setAsicEthernetRGMIITiming(0, RGMII_TCOMP_0NS, RGMII_RCOMP_0NS); //wei add, for 8652 demo board	
#endif	
	if(ExtP5GigaPhyMode)
	{
	rtl865xC_setAsicEthernetRGMIITiming(RTL8651_MII_PORTNUMBER, RGMII_TCOMP_0NS, RGMII_RCOMP_0NS);
	rtl8651_setAsicEthernetMII(GIGA_PHY_ID, P5_LINK_RGMII, TRUE);		
	WRITE_MEM32(PCRP5, (GIGA_PHY_ID<<ExtPHYID_OFFSET)|AcptMaxLen_16K|EnablePHYIf);		
	}
    /* Set forwarding status */
    REG32(PCRP0) = (REG32(PCRP0) & ~STP_PortST_MASK) | STP_PortST_FORWARDING;
    REG32(PCRP1) = (REG32(PCRP1) & ~STP_PortST_MASK) | STP_PortST_FORWARDING;
    REG32(PCRP2) = (REG32(PCRP2) & ~STP_PortST_MASK) | STP_PortST_FORWARDING;
    REG32(PCRP3) = (REG32(PCRP3) & ~STP_PortST_MASK) | STP_PortST_FORWARDING;
    REG32(PCRP4) = (REG32(PCRP4) & ~STP_PortST_MASK) | STP_PortST_FORWARDING;
#if !defined(RTL8196B)
    REG32(PCRP5) = (REG32(PCRP5) & ~STP_PortST_MASK) | STP_PortST_FORWARDING;
#endif

    /* Set PVID of all ports to 8 */
    REG32(PVCR0) = (0x8 << 16) | 0x8;
    REG32(PVCR1) = (0x8 << 16) | 0x8;
    REG32(PVCR2) = (0x8 << 16) | 0x8;
    REG32(PVCR3) = (0x8 << 16) | 0x8;

	
    /* Enable L2 lookup engine and spanning tree functionality */
//    REG32(MSCR) = EN_L2 | EN_L3 | EN_L4 | EN_IN_ACL;
  REG32(MSCR) = EN_L2;
	REG32(QNUMCR) = P0QNum_1 | P1QNum_1 | P2QNum_1 | P3QNum_1 | P4QNum_1;

    /* Start normal TX and RX */
    REG32(SIRR) |= TRXRDY;

	
    /* Enable interrupt */
/*
    if ( SW_ILEV < getIlev() )
  	    setIlev(SW_ILEV);
*/
	/* Init PHY LED style */
#ifdef BICOLOR_LED
	extern unsigned int read_gpio_hw_setting();

//	REG32(LEDCR) = 0x01180000; // for bi-color LED
	unsigned int hw_val = read_gpio_hw_setting();
#ifdef RTL8196B //jason 0829
	REG32(0xB8000030)= 0x00000000;
#endif
#ifdef RTL_8652_5PORT
	if(hw_val & 0x02)
#else
	if (hw_val == 0x2 || hw_val == 0x3 || hw_val == 0x6 || hw_val == 0x7)  // LED in matrix mode
#endif
	  	REG32(LEDCR)  = 0x155500;
		
	REG32(TCR0) = 0x000002c2;
	REG32(SWTAA) = PORT5_PHY_CONTROL;
	REG32(SWTACR) = ACTION_START | CMD_FORCE;
	while ( (REG32(SWTACR) & ACTION_MASK) != ACTION_DONE ); /* Wait for command done */
#else
	#if defined(BICOLOR_LED_VENDOR_BXXX)
		REG32(LEDCR) |= 0x00080000;

		REG32(PABCNR) &= ~0xc01f0000; /* set port a-7/6 & port b-4/3/2/1/0 to gpio */
		REG32(PABDIR) |=  0x401f0000; /* set port a-6 & port b-4/3/2/1/0 gpio direction-output */
		REG32(PABDIR) &= ~0x80000000; /* set port a-7 gpio direction-input */
	#else /* BICOLOR_LED_VENDOR_BXXX */
		REG32(LEDCR) = 0x00000000;
		REG32(TCR0) = 0x000002c7;
		REG32(SWTAA) = PORT5_PHY_CONTROL;
		REG32(SWTACR) = ACTION_START | CMD_FORCE;
		while ( (REG32(SWTACR) & ACTION_MASK) != ACTION_DONE ); /* Wait for command done */
	#endif /* BICOLOR_LED_VENDOR_BXXX */
#endif

	

      /*PHY FlowControl. Default enable*/
		for(port=0;port<MAX_PORT_NUMBER;port++)
	{
		/* Set Flow Control capability. */
#ifdef RTL_8652_5PORT
		if(ExtP1P4GigaPhyMode && (port>=1) && (port <=4) )
			rtl8651_setAsicFlowControlRegister(port+1, TRUE, GIGA_P1_PHYID+port);				
		else if ((port == MAX_PORT_NUMBER-1 ) && ExtP5GigaPhyMode)
			rtl8651_setAsicFlowControlRegister(RTL8651_MII_PORTNUMBER, TRUE, GIGA_PHY_ID);
		else				
			rtl8651_restartAsicEthernetPHYNway(port+1, port);	
#else
		#if defined(RTL8196B)
		rtl8651_restartAsicEthernetPHYNway(port+1, port);	
		#else
		if (port == MAX_PORT_NUMBER-1)
			rtl8651_setAsicFlowControlRegister(RTL8651_MII_PORTNUMBER, TRUE, GIGA_PHY_ID);
		else				
			rtl8651_restartAsicEthernetPHYNway(port+1, port);	
		#endif			
#endif			
	}

	#if defined(CONFIG_RTL865X_DIAG_LED)
	/* diagnosis led (gpio-porta-6) on */
	REG32(PABDAT) |=  0x40000000; /* pull high by set portA-0(bit 30) as gpio-output-1, meaning: diag led OFF */
	#endif /* CONFIG_RTL865X_DIAG_LED */
	
#ifdef RTL_8652_5PORT
	if(ExtP1P4GigaPhyMode) //fix 8241 bug
	{	//RstGigaPhy();
		REG32(0xBB804908)=0x00000400; //OѨMGigabit test with random length  Lk wire speed D. change from 0x99 to 0x400


		
	}
#endif

	{		
		extern char eth0_mac[6];
		extern char eth0_mac_httpd[6];
		extern char abc;
		rtl8651_setAsicL2Table((ether_addr_t*)(&eth0_mac), 0);
		rtl8651_setAsicL2Table((ether_addr_t*)(&eth0_mac_httpd), 1);
	}
	REG32(FFCR) = EN_UNUNICAST_TOCPU | EN_UNMCAST_TOCPU; // rx broadcast and unicast packet
	return 0;
#endif /* CONFIG_RTL865XC */
}


#ifdef _L2_MODE_
void DumpAsicRegisters()
{
	uint32 count;
	uint32* adr;
	uint32 len;
	
    /* Display registers */
    
    count = 0;
    adr = (uint32*) 0xbc802000;
    len = 64;
    printf( "\nAddr: %p -----------------------------------", adr );
    while (len--)
    {
        if (count == 0)
            printf("\n0x%p: ", adr);
        if ( ++count == 4 )
            count = 0;
            
        printf("%08x ", *(adr++));
    }
    
    count = 0;
    adr = (uint32*) 0xbc805000;
    len = 65;
    printf( "\nAddr: %p -----------------------------------", adr );
    while (len--)
    {
        if (count == 0)
            printf("\n0x%p: ", adr);
        if ( ++count == 4 )
            count = 0;
            
        printf("%08x ", *(adr++));
    }
    
    count = 0;
    adr = (uint32*) 0xbc803000;
    len = 64;
    printf( "\nAddr: %p -----------------------------------", adr );
    while (len--)
    {
        if (count == 0)
            printf("\n0x%p: ", adr);
        if ( ++count == 4 )
            count = 0;
            
        printf("%08x ", *(adr++));
    }
    
    count = 0;
    adr = (uint32*) 0xbc050000;
    len = 64;
    printf( "\nAddr: %p -----------------------------------", adr );
    while (len--)
    {
        if (count == 0)
            printf("\n0x%p: ", adr);
        if ( ++count == 4 )
            count = 0;
            
        printf("%08x ", *(adr++));
    }
}

/*
 *	Configuration for L2 Switch Mode
 *
 *	From david's letter.
 *
 *  for_RTL8650A = 1 -- 8650A
 *               = 0 -- 8650B
 */
int32 L2_swCore_config( uint8* gmac, uint32 for_RTL8650A )
{
	uint32 sysCLKRate;
	uint32 SCLK;
	uint32 DIV;
	uint32 SCR;
	uint32 initUART1 = 1;    // Is UART1 existed ?

	printf("\n\n");
	if ( for_RTL8650A )
		printf( "For 8650A\n");
	else
		printf( "For 8650B\n");
        
	// Read High-speed Lexra bus
	uint32 scr = (REG32(SCLKCR) & 0xF0000000) >> 28;
	uint32 mcr = (REG32(SCLKCR) & 0x0F000000) >> 24;

	printf( "System Clock Rate: " );
	switch( scr )
	{
		case 0: printf( "200MHz" ); break;
		case 1: printf( "180MHz" ); break;
		case 2: printf( "170MHz" ); break;
		case 3: printf( "190MHz" ); break;
		case 4: printf( "160MHz" ); break;
		case 5: printf( "150MHz" ); break;
		case 6: printf( "140MHz" ); break;
		case 7: printf( "100MHz" ); break;
		default:printf( "unknown" ); break;
	}

	printf( ", Memory Clock Rate: " );
	switch( mcr )
	{
		case 0: printf( " 50MHz" ); break;
		case 1: printf( "100MHz" ); break;
		case 2: printf( "110MHz" ); break;
		case 3: printf( "120MHz" ); break;
		case 4: printf( "130MHz" ); break;
		case 5: printf( "140MHz" ); break;
		case 6: printf( "150MHz" ); break;
		case 7: printf( "160MHz" ); break;
		default:printf( "unknown" ); break;
	}
	printf( " %08x\n",REG32(SCLKCR));

	// dv "\n [Set](3) : Swith Core MAC, PCI 33 Mhz, all others =0 (0xbc803000):\n"
	// dv "##### to Configure PCI clock (33Mhz) clock divide factor \n "
	// ew 0xBC803004 = 0x0     ;//Write 0 before read to update the current clock value of this register. 
	// dw 0xBC803004
	// ew $sysCLKRate = (@0xBC803004 & 0x00070000) >> 0x10 ; //Read system clock rate and set PCI clock setting factor.
	printf( " [Set](3) : Swith Core MAC, PCI 33 Mhz, all others =0 (0xbc803000):\n" );
	printf( "##### to Configure PCI clock (33Mhz) clock divide factor \n " );
    REG32(MACMR) = REG32(MACMR) & ~SYS_CLK_MASK;
	sysCLKRate = ( REG32(MACMR) & 0x00070000 ) >> 0x10;

	switch( sysCLKRate )
	{
		case 0x0: printf( " --> low system clock = 100MHZ \n" ); SCLK= 0x64; break;
		case 0x1: printf( " --> low system clock =  90MHZ \n" ); SCLK= 0x5A; break;
		case 0x2: printf( " --> low system clock =  85MHZ \n" ); SCLK= 0x55; break;
		case 0x3: printf( " --> low system clock =  96MHZ \n" ); SCLK= 0x60; break;
		case 0x4: printf( " --> low system clock =  80MHZ \n" ); SCLK= 0x50; break;
		case 0x5: printf( " --> low system clock =  75MHZ \n" ); SCLK= 0x4B; break;
		case 0x6: printf( " --> low system clock =  70MHZ \n" ); SCLK= 0x46; break;
		case 0x7: printf( " --> low system clock =  50MHZ \n" ); SCLK= 0x32; break;
		default:  printf( " --> low system clock = unknown\n" ); SCLK= 0xFF; break;
	}

	// if ( @$for_RTL8650A == 0x1) {ew $DIV = (@$SCLK+0x10)/0x21 -1 ; dv "RTL8650A mode\n"} {ew $DIV = 2*@$SCLK/0x21 -1 ; dv "RTL8650B mode\n" }
	if ( for_RTL8650A ) 
	{
		DIV = ( SCLK + 0x10 ) / 0x21 - 1;
		printf( "RTL8650A mode\n" );
	} 
	else
	{
		DIV = 2 * SCLK / 0x21 - 1;
		printf( "RTL8650B mode\n" );
	}

	// ew 0xBC803000 = (@0xBC803000 & 0xffff8fff)|(@$DIV << 0xC) ;
	// dv " Now, sysCLK=@$SCLK Mhz ;DIV = %d \n", @$DIV  
	REG32(MACCR) = ( REG32(MACCR) & 0xffff8fff ) | ( DIV << 0xC );
	printf( " Now, sysCLK=%d Mhz ;DIV = %d \n", SCLK, DIV );

	// dv "\n [Set](1) : LED display Mode (0xbc8020a0):\n" (for 15 LED, single color, Link/SPD/DUP)
	// ew 0xbc8020a0 = 0x000002C7 
	printf( " [Set](1) : LED display Mode (0xbc8020a0):\n" );
	REG32(SWTAA) = PORT5_PHY_CONTROL;
	REG32(TCR0) = 0x000002C7;
	REG32(SWTACR) = CMD_FORCE | ACTION_START; // force add
	while ( (REG32(SWTACR) & ACTION_MASK) != ACTION_DONE ); /* Wait for command done */

	/* added for david's reguest */
	REG32(SWTAA) = PORT6_PHY_CONTROL;
	REG32(TCR0) = 0x00000056;
	REG32(SWTACR) = CMD_FORCE | ACTION_START; // force add
	while ( (REG32(SWTACR) & ACTION_MASK) != ACTION_DONE ); /* Wait for command done */

	// dv "\n [Set](2) : MIB counter (0xbc801070,78,7C):\n"
	// ew 0xbc801070 = 0xff000000 
	// ew 0xbc801078 = 0xff000000 
	// ew 0xbc80107C = 0xff000000 
	// Note : RTL8650A = 0xff000000
	printf( " [Set](2) : MIB counter (0xbc801070,78,7C):\n" );
	REG32(MIB_CONTROL) = 0xff000000;
	if ( for_RTL8650A )
	{
		// SCCR1 and SCCR2 is not available.
	}
	else
	{
		REG32(SCCR1) = 0xff000000;
		REG32(SCCR2) = 0xff000000;
	}

	// dv "\n [Set](4) : init MDC/MDIO (0xbc803018) \n" 
	// ew 0xbc803018 = 0x4ff005f2 
	// RTL8650A = 0x4ff00000 
	printf( " [Set](4) : init MDC/MDIO (0xbc803018) \n" );
	if ( for_RTL8650A )
		REG32(MISCCR) = 0x4ff00000;
	else
		REG32(MISCCR) = 0x4ff005f2;

	// dv "\n [Set](5) : Init SwitchCore MISC, enable L3/L4 Re-calculation, L2 CRC Err allow (0xbc805010)\n"
	// ew 0xbc805010 =  0x00000000 
	// RTL8650A = 0x00000000
	printf( " [Set](5) : Init SwitchCore MISC, enable L3/L4 Re-calculation, L2 CRC Err allow (0xbc805010)\n" );
	if ( for_RTL8650A )
		REG32(CSCR) = 0x00000000;
	else
		REG32(CSCR) = 0x00000000;

	// dv "\n [Set] (6): # Disable flow control, descriptor run out threshold = 496 (0xbc805014)\n"
	// ew 0xbc805014 =  0xfffc05e0 
	// RTL8650A = 0xfffc05e0
	printf( " [Set] (6): # Disable flow control, descriptor run out threshold = 496 (0xbc805014)\n" );
	if ( for_RTL8650A )
		REG32(FCREN) = 0xfffc05e0;
	else
		REG32(FCREN) = 0xfffc05e0;

	// dv "\n [Set] (7): # set flow control per-port reserved threshold FC_On =32, FC_Off =16(0xbc805018)\n"
	// ew 0xbc805018 =  0x20102010 
	printf( " [Set] (7): # set flow control per-port reserved threshold FC_On =32, FC_Off =16(0xbc805018)\n" );
	REG32(FCRTH) = 0x10201020;

	// dv "\n [Set] (8): # set flow control shared threshold = 54 (0xbc805028)\n"
	// ew 0xbc805028 =  0x00360036 
	// RTL8650A = 0x00400040 
	printf( " [Set] (8): # set flow control shared threshold = 54 (0xbc805028)\n" );
	if ( for_RTL8650A )
		REG32(FCPTR) = 0x00400040;
	else
		REG32(FCPTR) = 0x00360036;

	// dv "\n [Set] (9): # enable TTL-1 (0xbc80502c) \n"
	// ew 0xbc80502c =  0x80000000
	printf( " [Set] (9): # enable TTL-1 (0xbc80502c) \n" );
	REG32(TTLCR) = 0x80000000;

	// dv "\n [Set] (10):# enable L2, disable Egress/Ingress ACL ;  disable L3/L4, Spanning tree (0xbc805030) \n"
	// ew 0xbc805030 =  0x00000001
	// RTL8650A =0x0000009F 
	printf( " [Set] (10):# enable L2, disable Egress/Ingress ACL ;  disable L3/L4, Spanning tree (0xbc805030) \n" );
	if ( for_RTL8650A )
		REG32(MSCR) = 0x0000009F;
	else
		REG32(MSCR) = 0x00000001;

	// dv "\n [Set] (10.2):# disable broadcast storm control (0xbc805038) \n"
	// ew 0xbc805038 =  0x00000000
	printf( " [Set] (10.2):# disable broadcast storm control (0xbc805038) \n" );
	REG32(BSCR) = 0x00000000;

	// dv "\n [Set] (11):# enable L2/L4 Aging (0xbc80503c) \n"
	// ew 0xbc80503c =  0xffffffff 
	printf( " [Set] (11):# enable L2/L4 Aging (0xbc80503c) \n" );
	REG32(TEATCR) = 0xfffffffc;
	
	// dv "\n [Set] (12): # enable L4 offset control \n"
	// ew 0xbc805080 =  0x03f00000 
	//printf( "\n [Set] (12): # enable L4 offset control \n" );
	//REG32(OCR) = 0x03f00000;

	// dv "\n [Set] (13): # Init SDRAM timing \n" 
	// ew 0xbd013008 =  0x00000463 
	//printf( " [Set] (13): # Init SDRAM timing \n" );
	//REG32(MTCR1) = 0x00000463;

	// dv "\n [Set] (14): # Init lexra bus timeout \n"
	// ew 0xbd012064 =  0xf0000000 
	printf( " [Set] (14): # Init lexra bus timeout \n" );
	REG32(LTOC) = 0xf0000000;

	// dv "\n [Set] (14): # Init peripheral lexra timing (0xbd012060) \n"
	// ew 0xbd012060 =  0x00000000 
	printf( " [Set] (14): # Init peripheral lexra timing (0xbd012060) \n" );
	REG32(PLTCR) = 0x00000000;

	// dv "\n [Set] (15): # Init TRXRDY \n"
	// ew 0xbc805004 =  0x318f0002 
	printf( " [Set] (15): # Init TRXRDY \n" ); /* BIST ??? */
	REG32(BISTCR) = 0x318f0002;

	// dv "\n [Set] (16):# set Port_based VLAN ID , all PVID=0 (0xbc805078) \n"
	// ew 0xbc805078 =  0x00000000 
	printf( " [Set] (16):# set Port_based VLAN ID , all PVID=0 (0xbc805078) \n" );
	REG32(PVCR) = 0x00000000;

	//dv "\n [set] (17): # Set UART 38400 bps, N,8,1  \n"
	// 1. Cehck system clock value (that is low speed Lexra BUS clock) 
	printf( " [set] (17): # Set UART 38400 bps, N,8,1  \n" );
	switch( ( REG32(MACMR) & 0x00070000 ) >> 0x10 )
	{
		case 0: SCR = 0x5F5E100; printf( " --> system clock = 100MHZ \n" ); break;
		case 1: SCR = 0x55D4A80; printf( " --> system clock =  90MHZ \n" ); break;
		case 2: SCR = 0x510FF40; printf( " --> system clock =  85MHZ \n" ); break;
		case 3: SCR = 0x5B8D800; printf( " --> system clock =  96MHZ \n" ); break;
		case 4: SCR = 0x4C4B400; printf( " --> system clock =  80MHZ \n" ); break;
		case 5: SCR = 0x47868C0; printf( " --> system clock =  75MHZ \n" ); break;
		case 6: SCR = 0x42C1D80; printf( " --> system clock =  70MHZ \n" ); break;
		case 7: SCR = 0x2FAF080; printf( " --> system clock =  50MHZ \n" ); break;
		default:SCR = 0xFFFFFFF; printf( " --> system clock = unknown\n" ); break;
	}
	
	// 2. set Line Control Register : 
	// eb 0xbd01110c = 0x03 ; dv " --> Line Control Parameter = [N,8,1]\n" ; 
	// eb 0xbd01100c = 0x03 ; dv " --> Line Control Parameter = [N,8,1]\n" ; 
	// ew $BR =0x9600  ; // --> Baud Rate = 38400 bps\n  
	// ew $divisor = (@$SCR/(@$BR*0x10))-1 ;// calculate the Divisor Latch value 
	REG8(UART0_BASE+0x0c) = 0x03;
	//printf( " --> Line Control Parameter = [N,8,1]\n" );
	if ( initUART1 )
	{
		REG8(UART1_BASE+0x0c) = 0x03;
		//printf( " --> Line Control Parameter = [N,8,1]\n" );
	}
	uint32 BR = 0x9600; /* 38400 bps */
	uint32 divisor = ( SCR / (BR*0x10) ) - 1;

	// to configure DLL and DLM   
	// ew 0xbd01110c = @0xbd01110c | 0x80000000 ;;  // set DLAB bit =1 
	// ew 0xbd01100c = @0xbd01100c | 0x80000000 ;;  // set DLAB bit =1 
	// eb 0xbd011100 = @$divisor ; 
	// eb 0xbd011000 = @$divisor ; 
	REG32(UART0_BASE+0x0c) |= 0x80000000; // set DLAB bit = 1
	REG8(UART0_BASE+0x00) = divisor;
	if ( initUART1 )
	{
		REG32(UART1_BASE+0x0c) |= 0x80000000; // set DLAB bit = 1
		REG8(UART1_BASE+0x00) = divisor;
	}

	// eb 0xbd011104 = @$divisor >> 8;  
	// eb 0xbd011004 = @$divisor >> 8;  
	// ew 0xbd01110c = @0xbd01110c & 0x7fffffff ;;  // set DLAB =0
	// ew 0xbd01100c = @0xbd01100c & 0x7fffffff ;;  // set DLAB =0
	REG8(UART0_BASE+0x04) = divisor >> 8;
	REG32(UART0_BASE+0x0c) &= 0x7FFFFFFF; // set DLAB bit = 1
	if ( initUART1 )
	{
		REG8(UART1_BASE+0x04) = divisor >> 8;
		REG32(UART1_BASE+0x0c) |= 0x7FFFFFFF; // set DLAB bit = 1
	}

	// ----------------------------------
	// VLAN table Setup :
	// ----------------------------------
	// dv "\n // Write to VLAN table entry 0 : (VLAN 0: without tagging) \n"
	// ew (0xbc800000 + 0x8)   = 0xbc050000 + 0*0x20 ;;   //Note : each entry = 8 Word = 32 byte.
	// ew (0xbc800000 + 0x20)  = 0x11223344 ;; // W0  ,
	// ew (0xbc800000 + 0x24)  = 0x003F0000 ;; // W1  ,MBR= W1:22:17, VID=W1:31:23
	// ew (0xbc800000 + 0x28)  = 0x00000000 ;; // W2
	// ew (0xbc800000 + 0x2C)  = 0xffff3ffd ;; // W3  ,VLANUntag= W3:21:16
	// ew (0xbc800000 + 0x30)  = 0x00000005 ;; // W4
	// ew (0xbc800000 + 0x34)  = 0x00000000 ;; // W5
	// ew (0xbc800000 + 0x38)  = 0x00000000 ;; // W6
	// ew (0xbc800000 + 0x3C)  = 0x00000000 ;; // W7
	// ew (0xbc800000 + 0x0)   = 0x9 ;;    
	printf( " // Write to VLAN table entry 0 : (VLAN 0: without tagging) \n" );
	REG32(SWTAA) = 0xbc050000 + 0*0x20 ;;   //Note : each entry = 8 Word = 32 byte.
	REG32(TCR0)  = 0x11223344 ;; // W0  ,
	REG32(TCR1)  = 0x003F0000 ;; // W1  ,MBR= W1:22:17, VID=W1:31:23
	REG32(TCR2)  = 0x00000000 ;; // W2
	REG32(TCR3)  = 0xffff3ffd ;; // W3  ,VLANUntag= W3:21:16
	REG32(TCR4)  = 0x00000005 ;; // W4
	REG32(TCR5)  = 0x00000000 ;; // W5
	REG32(TCR6)  = 0x00000000 ;; // W6
	REG32(TCR7)  = 0x00000000 ;; // W7
	REG32(SWTACR)= 0x9 ;;        // 
	
	// dv "\n // Write to VLAN table entry 1 : (VLAN 1: with tagging) \n"
	// ew (0xbc800000 + 0x8)   = 0xbc050000 + 1*0x20 ;;   //Note : each entry = 8 Word = 32 byte.
	// ew (0xbc800000 + 0x20)  = 0x11223344 ;; // W0
	// ew (0xbc800000 + 0x24)  = 0x007f0000 ;; // W1  ,MBR= W1:22:17, VID=W1:31:23
	// ew (0xbc800000 + 0x28)  = 0x00000000 ;; // W2
	// ew (0xbc800000 + 0x2C)  = 0xffc03ffd ;; // W3  ,VLANUntag= W3:21:16
	// ew (0xbc800000 + 0x30)  = 0x00000005 ;; // W4
	// ew (0xbc800000 + 0x34)  = 0x00000000 ;; // W5
	// ew (0xbc800000 + 0x38)  = 0x00000000 ;; // W6
	// ew (0xbc800000 + 0x3C)  = 0x00000000 ;; // W7
	// ew (0xbc800000 + 0x0)   = 0x9 ;;        // 
	printf( " // Write to VLAN table entry 1 : (VLAN 1: with tagging) \n" );
	REG32(SWTAA) = 0xbc050000 + 1*0x20 ;;   //Note : each entry = 8 Word = 32 byte.
	REG32(TCR0)  = 0x11223344 ;; // W0  ,
	REG32(TCR1)  = 0x007f0000 ;; // W1  ,MBR= W1:22:17, VID=W1:31:23
	REG32(TCR2)  = 0x00000000 ;; // W2
	REG32(TCR3)  = 0xffc03ffd ;; // W3  ,VLANUntag= W3:21:16
	REG32(TCR4)  = 0x00000005 ;; // W4
	REG32(TCR5)  = 0x00000000 ;; // W5
	REG32(TCR6)  = 0x00000000 ;; // W6
	REG32(TCR7)  = 0x00000000 ;; // W7
	REG32(SWTACR)= 0x9 ;;        // 

	// DumpAsicRegisters();

/*****************************************************************/


	return 0;
}
#endif //_L2_MODE_


#ifdef _HUB_MODE_

uint32 getLinkStatus( void )
{
	uint32 link = 0;
	uint32 i, dummy;

	for( i = 0; i < 5; i++ )
	{
		dummy = REG32(PHY_BASE+(i<<5) + 0x4); /* To get the correct link status, this register must be read twice. */
		if(REG32(PHY_BASE+(i<<5) + 0x4) & 0x4)
		{
			//link is up
			link |= (1<<i);
		}
	}

	return link;
}

/*
 *  HubMode() --
 *
 *  Ocuppy all L2 table entries to force broadcast.
 *
 */
void HubMode()
{

}
#endif //_HUB_MODE_

