#ifndef __RTK_H__
#define __RTK_H__

// david ----------------------------------------------------------------
#ifdef BK
	#define FW_SIGNATURE			((char *)"BKLN")	// fw signature
	#define FW_SIGNATURE_WITH_ROOT		((char *)"csro")	// fw signature with root fs
	#define ROOT_SIGNATURE          	((char *)"BKRT")	
#elif defined(GR)		//cary add 
	#define FW_SIGNATURE			((char *)"grln")	// fw signature
	#define FW_SIGNATURE_WITH_ROOT		((char *)"csro")	// fw signature with root fs
	#define ROOT_SIGNATURE          	((char *)"grrt")	
#elif defined(TR)
	#define FW_SIGNATURE			((char *)"trln")	// fw signature
	#define FW_SIGNATURE_WITH_ROOT		((char *)"csro")	// fw signature with root fs
	#define ROOT_SIGNATURE          	((char *)"trrt")	
#elif defined(CONFIG_RTL865X_SC)
	#define FW_SIGNATURE			((char *)"SCLN")	// fw signature
	#define FW_SIGNATURE_WITH_ROOT		((char *)"SCRO")	// fw signature with root fs
	#define ROOT_SIGNATURE			((char *)"SCRT")
#elif defined(RTL8196B)
	#define FW_SIGNATURE			((char *)"cs6b")	// fw signature
	#define FW_SIGNATURE_WITH_ROOT		((char *)"cr6b")	// fw signature with root fs
	#define ROOT_SIGNATURE          	((char *)"r6br")
#else
#define FW_SIGNATURE			((char *)"csys")	// fw signature
#define FW_SIGNATURE_WITH_ROOT	((char *)"csro")	// fw signature with root fs
#define ROOT_SIGNATURE		((char *)"root")
#endif

#define SQSH_SIGNATURE		((char *)"sqsh")

#ifdef RTL8196B
#define WEB_SIGNATURE         	((char *)"w6bg")
#else
#define WEB_SIGNATURE		((char *)"webp")
#endif
#define BOOT_SIGNATURE		((char *)"boot")
#define ALL1_SIGNATURE		((char *)"allp")
#define ALL2_SIGNATURE		((char *)"all2")

#define HW_SETTING_OFFSET		0x6000

// Cyrus ----------------------------------------------------------------
#define HW_SIGNATURE		((char *)"HS")	// hw signature
#define SW_SIGNATURE_D		((char *)"DS")	// sw_default signature
#define SW_SIGNATURE_C		((char *)"CS")	// sw_current signature
#define SIG_LEN			4

/* Firmware image header */
typedef struct _header_ {
	unsigned char signature[SIG_LEN];
	unsigned long startAddr;
	unsigned long burnAddr;
	unsigned long len;
} IMG_HEADER_T, *IMG_HEADER_Tp;

typedef struct _signature__ {
	unsigned char *signature;
	unsigned char *comment ;
	int sig_len;
	int skip ;
	int maxSize;
	int reboot;
} SIGN_T ;

#endif

