/*
 *  linux/init/main.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *
 *  GK 2/5/95  -  Changed to support mounting root fs via NFS
 *  Added initrd & change_root: Werner Almesberger & Hans Lermen, Feb '96
 *  Moan early if gcc is old, avoiding bogus kernels - Paul Gortmaker, May '96
 *  Simplified starting of init:  Michael A. Griffith <grif@acm.org>
 */

#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/random.h>
#include <linux/string.h>

#include <asm/bitops.h>
#include <asm/bootinfo.h>
#include <asm/irq.h>
#include <asm/mipsregs.h>
#include <asm/system.h>
#include <linux/circ_buf.h>

#ifdef RTL8186
#include <asm/rtl8181.h>
#endif

#if defined(RTL865X) || defined(RTL8196B)
#include <asm/rtl865x.h>
#endif

#include <asm/io.h>

#include "etherboot.h"
#include "./banner/mk_time"
#include "./rtk.h"
#include "./ver.h"
#define __KERNEL_SYSCALLS__

#define SYS_STACK_SIZE		(4096 * 2)
#define SERIAL_XMIT_SIZE	4096

#ifdef CONFIG_RTL865X_SC
#define VERSION				"1.0"
#else
#define VERSION				"1.4"
#endif

#define HS_IMAGE_OFFSET		(24*1024)	//0x6000
#define DS_IMAGE_OFFSET		(25*1024)	//0x6400
#define CS_IMAGE_OFFSET		(32*1024)	//0x8000

#define CODE_IMAGE_OFFSET	(64*1024)	//0x10000
#define CODE_IMAGE_OFFSET2	(128*1024)	//0x20000
#define CODE_IMAGE_OFFSET3	(192*1024)	//0x30000
#define CODE_IMAGE_OFFSET4	(0x8000)
#ifdef TR
#define ROOT_FS_OFFSET		(0xC0000)
#elif defined(CONFIG_RTL865X_SC)
#define ROOT_FS_OFFSET		(0xC0000)
#else
#define ROOT_FS_OFFSET		(0xE0000)
#define ROOT_FS_OFFSET_OP1		(0x10000)
#ifdef BK
#define ROOT_FS_OFFSET_OP2		(0x50000)
#else
#define ROOT_FS_OFFSET_OP2		(0x40000)
#endif
#endif
#define IS_32BIT			(rtl_inl(0x1000)&0x100000)

/*Cyrus Tsai*/
Int16  DSversion;
Int16  CSversion;
/*Cyrus Tsai*/


/*Cyrus Tsai*/
/*mips_io_port_base + FLASH_BASE =0xbfc0 0000   */
/*mips_io_port_base = 0xbd01 0000               */
/*Replace the 0xbfc0 0000 with 0xbe00 0000      */
/*so FLASH_BASE should be changed to 0x00ff 0000*/
/*if support large size FLASH                   */
/*Cyrus Tsai*/

//#define CPU_CLOCK			(22*1000*1000) //8186
#define CPU_CLOCK			(200*1000*1000)
#define WAIT_TIME_USER_INTERRUPT	(3*CPU_CLOCK)

#ifdef RTL8186
			//set LED0 On
#define Set_GPIO_LED_ON()	rtl_outl(0x124, (1<<2)); // pin2 as ouput  \
				rtl_outl(0x120, (rtl_inl(0x120)&(~(1<<2))))


#define Set_GPIO_LED_OFF()	rtl_outl(0x124, (1<<2)); //pin2 as ouput \
				rtl_outl(0x120, (rtl_inl(0x120)|(1<<2)))

#endif

#ifdef RTL865X
#if defined(BK)
#define RTL_R32(addr)		(*(volatile unsigned long *)(addr))
#define RTL_W32(addr, l)	((*(volatile unsigned long*)(addr)) = (l))
#define Set_GPIO_LED_ON() do {\
	RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)&(~(0xff<<16)))); \
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)&(~(0x40<<8)))); \
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)&(~(0xf<<16)))); \
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)&(~(0x2<<24)))); \
	RTL_W32(LEDCR1, (RTL_R32(LEDCR1) | (0x3))); \
	RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x3)))); \
	RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)&(~(0x1f0<< 16)))));\
} while(0);

#define Set_GPIO_LED_OFF()	do { \
	RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|(0xff<< 16))); \
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|(0x40<< 8))); \
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|(0xf<< 16))); \
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|(0x2<< 24))); \
	RTL_W32(LEDCR1, (RTL_R32(LEDCR1) & (~0x3))); \
	RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x3)))); \
	RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)|((0x1f0<< 16)))));\
} while(0);

#else
#define Set_GPIO_LED_ON()	(REG32(PABCDDAT_REG) =  REG32(PABCDDAT_REG)  & (~(1<<13)) )
#define Set_GPIO_LED_OFF()	(REG32(PABCDDAT_REG) =  REG32(PABCDDAT_REG)  | (1<<13))
#endif
#endif

#ifdef RTL865X
#if defined(BK)
	#define Get_GPIO_SW_IN()		0
#else
	#define Get_GPIO_SW_IN() (!(REG32(PEFGHDAT_REG) & (1<<15)) )  //return 0 if non-press
#endif
#endif

#if defined(RTL8196B)
extern eth_backup_mode;
#endif 

//return 1: data ready, 0 not yet ready
#ifdef RTL8186	
	#define  Check_UART_DataReady() (rtl_inb(UART_LSR) & 0x1)
	#define 	Get_UART_Data()  (rtl_inb(UART_RBR) & 0xff)	
#endif
#ifdef RTL865X
	#define  Check_UART_DataReady() (rtl_inl(UART_LSR) & (1<<24))
	#define 	Get_UART_Data() ((rtl_inl(UART_RBR) & 0xff000000)>>24)
#endif

/* Setting image header */
typedef struct _setting_header_ {
	Int8  Tag[2];
	Int8  Version[2];
	Int16 len;
} SETTING_HEADER_T, *SETTING_HEADER_Tp;

//-----------------------------------------------------------
static int check_system_image(unsigned long addr, IMG_HEADER_Tp pHeader,SETTING_HEADER_Tp sHeader);
int user_interrupt(unsigned long time);

/*in flash.c*/
extern int flashread (unsigned long dst, unsigned int src, unsigned long length);
extern int flashinit();


unsigned char init_task_union[SYS_STACK_SIZE];

/*Cyrus Tsai*/
unsigned long kernelsp;

#if defined(RTL865X) || defined(RTL8196B)
	#define GICR_BASE	0xB8003000
	#define SCCR				(0x200 + GICR_BASE)     /* System Clock Control Register */
	#define DPLCR0			(0x204 + GICR_BASE)     /* DPLL Clock Control Register 0 */
	#define DPLCR1			(0x208 + GICR_BASE)     /* DPLL Clock Control Register 1 */
	#define PCCR				(0x20C + GICR_BASE)     /* Peripheral Clock Control Register */
	#define tick_Delay10ms(x) { int i=x; while(i--) __delay(5000); }

	#define _SYSTEM_HEAP_SIZE	1024*64	//wei add
	char dl_heap[_SYSTEM_HEAP_SIZE];	//wei add
#endif
//------------------------------------------------------------------------------------------
extern void __init exception_init(void);
/*in trap.c*/
extern void flush_cache(void);
extern void flush_dcache(UINT32 start, UINT32 end);

/*in irq.c*/
extern void init_IRQ(void);
extern void eth_startup(int etherport);
extern void eth_listening(void);
/*in eth_tftpd.c*/
extern void tftpd_entry(void);
unsigned long self_test(void);

/*in monitor.c*/
extern int check_cpu_speed(void);
extern volatile int get_timer_jiffies(void);

//------------------------------------------------------------------------------------------
#if 0
void set_bridge_clock(int bus_clk)
{
	int reg_value = 0;
	unsigned int version = 0;

	version = *(volatile unsigned int *)(0xbd01010c);
	version &= 0xf0000000;

	if(bus_clk >= 100) {
		if(!version || (version == 0x80000000))
			reg_value = 0x9D;	// Bridge1 clock/4 for 'B' or 'C'
		else
			reg_value = 0x99;     // Bridge0,1 clock/2 for other

		if(bus_clk >= 120)
			reg_value |= 0x800 | 0x500; // PCI, divided by 6
		else
			reg_value |= 0x800 | 0x300; // PCI, divided by 4
	}
	else
		reg_value = 0x88 | 0x800 | 0x300;   // not divided
	*(volatile unsigned int *)(0xbd010100) = reg_value;
}
#endif

//------------------------------------------------------------------------------------------
#if defined(RTL865X) || defined(RTL8196B)
//#define SYS_CLK_RATE	  	(0x00f42400)      //16MHz
//#define SYS_CLK_RATE	  	(0x01312d00)      //20MHz
//#define SYS_CLK_RATE	  	(25000000)      //25MHz
//#define SYS_CLK_RATE	  	(0x01ab3f00)      //28MHz
//#define SYS_CLK_RATE	  	(0x02625a00)      //40MHz
#define SYS_CLK_RATE	  	(200000000)      //200MHz

#define BAUD_RATE	  	(38400)  
void console_init(void)
{

	int i;
	unsigned long dl;
	unsigned long dll;     
	unsigned long dlm;       
           
  	rtl_outl( UART_LCR,0x03000000);		//Line Control Register  8,n,1
  		
  	rtl_outl( UART_FCR,0xc7000000);		//FIFO Ccontrol Register
  	rtl_outl( UART_IER,0x00000000);
  	dl = (SYS_CLK_RATE /16)/BAUD_RATE-1;
  	*(volatile unsigned long *)(0xa1000000) = dl ; 
  	dll = dl & 0xff;
  	dlm = dl / 0x100;
  	rtl_outl( UART_LCR,0x83000000);		//Divisor latch access bit=1
  	rtl_outl( UART_DLL,dll*0x1000000);
   	rtl_outl( UART_DLM,dlm*0x1000000); 
   	rtl_outl( UART_LCR,0x83000000& 0x7fffffff);	//Divisor latch access bit=0
   	//rtl_outl( UART_THR,0x41000000);	
#if defined(RTL8196B)	
  	REG32( 0xb8003000)=REG32( 0xb8003000) | 0x1000;
#endif  	
//	dprintf("\nUART1 output test ok\n");
 	//prom_printf("\ntest value = %x \n", dl);
}
#endif

//------------------------------------------------------------------------------------------
int RTL_TIMEOUT()
{
	//return 1 is timeout, 0 is not yet timeout 
#ifdef RTL8186
	return (!rtl_inl(TC2CNT));	
#endif

#if defined(RTL865X) || defined(RTL8196B)
	return (!(rtl_inl(TC1CNT)>>8));
#endif
}

//-----------------------------------------------------------
void Init_GPIO()
{
#if defined(RTL865X) || defined(RTL8196B)
	REG32(PABCDCNR_REG) = REG32(PABCDCNR_REG)& (~(1<<13) ); //0 is gpio
	REG32(PABCDDIR_REG) = REG32(PABCDDIR_REG) |  (1<<13);  //0 input, 1 output, set  output
	REG32(PEFGHCNR_REG) = REG32(PEFGHCNR_REG)& (~(1<<15) ); //set byte F GPIO7 = gpio
	REG32(PEFGHDIR_REG) = REG32(PEFGHDIR_REG) & (~(1<<15) );  //0 input, 1 output, set F bit 7 input
	REG32(PEFGHCNR_REG) = REG32(PEFGHCNR_REG) & (~(1<<11) );  //set byte F GPIO3 = gpio	
#endif
#ifdef BK
	/*	B6	*/
	RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR)&(~(0x40 << 8))));
	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (0x40 << 8)));
	/*	C0~C7	*/
	RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR)&(~(0xff << 16))));
	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (0xff << 16)));
	/*	D0~D1	*/
	RTL_W32(PABCD_CNR,(RTL_R32(PABCD_CNR)&(~(0x3 << 24))));
	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | (0x3 << 24)));
	/*	G0~G7	*/
	RTL_W32(PEFGH_CNR,(RTL_R32(PEFGH_CNR)&(~(0xff << 16))));
	RTL_W32(PEFGH_DIR, (RTL_R32(PEFGH_DIR) | (0xff << 16)));
	/*	H3~H7	*/
	RTL_W32(PEFGH_CNR,(RTL_R32(PEFGH_CNR)&(~(0xf8 << 24))));
	RTL_W32(PEFGH_DIR, (RTL_R32(PEFGH_DIR) | (0xf8 << 24)));

	/* usb */
	RTL_W32(LEDCREG,(RTL_R32(LEDCREG)&(~(0x5f))));
	RTL_W32(LEDCREG, (RTL_R32(LEDCREG) | (0x47)));

	RTL_W32(PEFGH_DAT,(RTL_R32(PEFGH_DAT)|(0xff<< 16)));
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|(0x40<< 8)));
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|(0xf<< 16)));
	RTL_W32(PABCD_DAT,(RTL_R32(PABCD_DAT)|(0x2<< 24)));
	RTL_W32(LEDCR1, (RTL_R32(LEDCR1) & (~0x3)));
	RTL_W32(LEDBCR, (RTL_R32(LEDBCR)&(~(0x3))));
	
	RTL_W32(PABCD_DAT,((RTL_R32(PABCD_DAT)|((0x1f0<< 16)))));
#endif
#if defined(RTL8196B)
#define RTL_GPIO_MUX 0xB8000030
#define RTL_GPIO_MUX_DATA 0x0FC00380//for WIFI ON/OFF and GPIO\
	REG32(RTL_GPIO_MUX)=RTL_GPIO_MUX_DATA;
	REG32(PABCDCNR_REG) = REG32(PABCDCNR_REG)& (~(1<<0) ); //set byte F GPIO7 = gpio
	REG32(PABCDDIR_REG) = REG32(PABCDDIR_REG) & (~(1<<0) );  //0 input, 1 output, set F bit 7 input
#endif
}

#if 0
unsigned int read_gpio_hw_setting()
{
	unsigned int tmp;
	int b1,b2,b3,b4;

	REG32(PEFGHCNR_REG) = REG32(PEFGHCNR_REG)  &(~(0x03<<24)) & (~(0x48<<8) ); //set (GP4 GP3 GP2 GP1)=(H1 H0 F3 F6)= gpio
	REG32(PEFGHPTYPE_REG)=REG32(PEFGHPTYPE_REG)&(~(0x03<<24)) & (~(0x48<<8) );  //change to GPIO mode
	REG32(PEFGHDIR_REG) = REG32(PEFGHDIR_REG)    &(~(0x03<<24)) & (~(0x48<<8) );;  //0 input, 1 output, set  inpur
	tmp=REG32(PEFGHDAT_REG);
//	dprintf("GPIO HGFE=%08x\r\n",tmp);
//	dprintf("GP4 GP3 GP2 GP1=%01x %01x %01x %01x\r\n", (tmp&(0x02<<24))>>25 , (tmp&(0x01<<24))>>24 ,(tmp&(0x08<<8))>>11, (tmp&(0x40<<8))>>14);
	b4 = (tmp&(0x02<<24))>>25;
	b3 = (tmp&(0x01<<24))>>24;
	b2 = (tmp&(0x08<<8))>>11;
	b1 = (tmp&(0x40<<8))>>14;
	tmp = (b1&0x1) | ((b2<<1)&0x2) |  ((b3<<2)&0x4) | ((b4<<2)&0x8);	
//	dprintf("GPIO val=%08x\r\n",tmp);
	return tmp;	
}
#else
unsigned int read_gpio_hw_setting()
{
	unsigned int tmp;
	int b2;

	REG32(PEFGHCNR_REG)   = REG32(PEFGHCNR_REG)   & (~(0x8<<8));  //set (GP2)=(F3)= gpio
	REG32(PEFGHPTYPE_REG) = REG32(PEFGHPTYPE_REG) & (~(0x8<<8));  //change to GPIO mode
	REG32(PEFGHDIR_REG)   = REG32(PEFGHDIR_REG)   & (~(0x8<<8));  //0 input, 1 output, set inpur
	tmp = REG32(PEFGHDAT_REG);
//	dprintf("GPIO HGFE=%08x\r\n", tmp);
//	dprintf("GP2=%01x\r\n", (tmp&(0x08<<8))>>11);
	b2 = (tmp&(0x08<<8))>>11;
	tmp = (b2<<1)&0x2;	
//	dprintf("GPIO val=%08x\r\n",tmp);
	return tmp;	
}
#endif

#ifdef RTL8186
			//set LED0 On
#define Set_GPIO_LED_ON()	rtl_outl(0x124, (1<<2)); // pin2 as ouput  \
							rtl_outl(0x120, (rtl_inl(0x120)&(~(1<<2))))


#define Set_GPIO_LED_OFF()	rtl_outl(0x124, (1<<2)); //pin2 as ouput \
							rtl_outl(0x120, (rtl_inl(0x120)|(1<<2)))

#endif

#if defined(RTL865X) || defined(RTL8196B)
#ifdef KLD
#define Set_GPIO_LED_ON()	(REG32(PEFGHDAT_REG) =  REG32(PEFGHDAT_REG)  & (~(1<<14)) )
#define Set_GPIO_LED_OFF()	(REG32(PEFGHDAT_REG) =  REG32(PEFGHDAT_REG)  | (1<<14))
#else
#define Set_GPIO_LED_ON()	(REG32(PABCDDAT_REG) =  REG32(PABCDDAT_REG)  & (~(1<<13)) )
#define Set_GPIO_LED_OFF()	(REG32(PABCDDAT_REG) =  REG32(PABCDDAT_REG)  | (1<<13))
#endif
#endif

#if defined(RTL8196B)
	#define Get_GPIO_SW_IN() (!(REG32(PABCDDAT_REG) & (1<<0)) )  //return 0 if non-press
#endif
#if defined(RTL865X) 
	#define Get_GPIO_SW_IN() (!(REG32(PEFGHDAT_REG) & (1<<15)) )  //return 0 if non-press
#endif


//return 1: data ready, 0 not yet ready
#ifdef RTL8186	
	#define  Check_UART_DataReady() (rtl_inb(UART_LSR) & 0x1)
	#define 	Get_UART_Data()  (rtl_inb(UART_RBR) & 0xff)	
#endif
#if defined(RTL865X) || defined(RTL8196B)
	#define  Check_UART_DataReady() (rtl_inl(UART_LSR) & (1<<24))
	#define 	Get_UART_Data() ((rtl_inl(UART_RBR) & 0xff000000)>>24)
	#define REG32(reg) (*(volatile unsigned int *)(reg))
	#define SYS_BASE 0xb8000000
	#define SYS_HW_STRAP (SYS_BASE +0x08)
#endif

#if 1
void delay_ms(unsigned int time_ms)
{
   volatile unsigned int preTime;
   
   preTime = get_timer_jiffies();
   while ( get_timer_jiffies()-preTime < ( time_ms/10) );
}
#endif
//------------------------------------------------------------------------------------------
void start_kernel(void)
{
	int i, ret;
	unsigned long flags;
	unsigned char* str[80];
	char* ptr;
	unsigned long start_addr;
	void	(*jump)(void);
	unsigned long error_code;
	unsigned long return_addr;
	unsigned short *word_ptr;
	volatile int cpu_speed = 0;
#ifdef TR	
	int return_rootfs_status=0;
#endif	
	IMG_HEADER_T header;
	SETTING_HEADER_T setting_header;

#if defined(RTL865X) || defined(RTL8196B)
	// set SDRAM clock to 160M
	REG32(SCCR)= (REG32(SCCR) & ~0x00000007) | 0x04;	
	tick_Delay10ms(1);	
	REG32(DPLCR1)= 0x80000000 |  (29<<5)  |   (24<<0);		//160	
	REG32(SCCR)= (REG32(SCCR) & ~0x00000007) | 0x05;	
	tick_Delay10ms(1);	
	REG32(DPLCR1)= 0x80000000 |  (31<<5)  |   (24<<0);
#if defined(RTL8196B)	
	REG32(SYS_HW_STRAP) = REG32(SYS_HW_STRAP);
#endif
#endif
#ifdef RTL_8652_5PORT
        REG32(DPLCR1)= 0x80000000 |  (27<<5)  |   (24<<0); // 140
#if 1
	// set CPU clock to 300M
		unsigned int cpuclock;
		for(cpuclock=280;cpuclock<=398; cpuclock+=2)
		{
			//unsigned int  s0_down=10-1; //25-1;
			unsigned int  s0_down=17-1; //25-1;
			unsigned int  s0_up=(cpuclock*(s0_down+1)/125)-1;
			
			REG32(DPLCR0)= 0x80000000 |  (( s0_up&0x3f) <<16)  |   ((s0_down&0x1f) <<11) ;
			for(i=0;i<5555;i++) ;
		}
#endif
#endif

	 console_init();

#if defined(RTL865X) || defined(RTL8196B)
	/* Initialize malloc mechanism */
	UINT32 heap_addr=((UINT32)dl_heap&(~7))+8 ;
  	i_alloc((void *)heap_addr, sizeof(dl_heap)-8);
	//dprintf("Heap: [%x - %x] Init\r\n", heap_addr, heap_addr+sizeof(dl_heap));
#endif
	

	cli();  	
	flush_cache(); // david
	#ifdef RTL8196B //jason 0829
	REG32(0xB8000030)= 0x00000300;
	#endif
	// mask all interrupt
	 rtl_outl(GIMR0,0x00);    
	setup_arch();    /*setup the BEV0,and IRQ */
	exception_init();/*Copy handler to 0x80000080*/
	init_IRQ();      /*Allocate IRQfinder to Exception 0*/

	sti();

	cpu_speed = check_cpu_speed();
	//set_bridge_clock(cpu_speed);

	flashinit();
	
#ifdef RTL8181
	prom_printf("\n---RealTek(RTL8181)at %s version %s [%s]\n",BOOT_CODE_TIME,	VERSION, (IS_32BIT ? "32bit" : "16bit") );
#endif
#if RTL8186
	return_addr=*(volatile unsigned int *)0xbd011000;
	prom_printf("\n---RealTek(RTL8186)at %s version %s [%s](%dMHz)\n",	BOOT_CODE_TIME,VERSION, (IS_32BIT ? "32bit" : "16bit"),	cpu_speed);
#endif

#ifdef TR
	prom_printf("\n---TRENet(RTL865x)at %s version %s [%s](%dMHz)\n",	BOOT_CODE_TIME,VERSION, (IS_32BIT ? "32bit" : "16bit"), cpu_speed);	
#elif defined(BK)
	prom_printf("\n---Belkin(RTL865x)at %s version %s [%s](%dMHz)\n",	BOOT_CODE_TIME,VERSION, (IS_32BIT ? "32bit" : "16bit"), cpu_speed);
#elif defined(GR)
	return_addr=0;
	prom_printf("\n---Corega(RTL865x)at %s version %s [%s](%dMHz)\n",	BOOT_CODE_TIME,VERSION, (IS_32BIT ? "32bit" : "16bit"), cpu_speed);
#elif defined(RTL865X)
	#ifdef CONFIG_RTL865X_SC
	prom_printf("\n---SC(RTL865x)at %s version %s [%s](%dMHz)\n",	BOOT_CODE_TIME,VERSION, (IS_32BIT ? "32bit" : "16bit"), cpu_speed);
	#else
	prom_printf("\n---RealTek(RTL865x)at %s version %s [%s](%dMHz)\n",	BOOT_CODE_TIME,VERSION, (IS_32BIT ? "32bit" : "16bit"), cpu_speed);	
	#endif
#elif defined(RTL8196B)
#if defined(RTL8197B)
	return_addr=0;
	prom_printf("\n---RealTek(RTL8197B)at %s %s [%s](%dMHz)\n",	BOOT_CODE_TIME,B_VERSION, (IS_32BIT ? "32bit" : "16bit"), cpu_speed);	
#else
	return_addr=0;
	prom_printf("\n---RealTek(RTL8196B)at %s %s [%s](%dMHz)\n",	BOOT_CODE_TIME,B_VERSION, (IS_32BIT ? "32bit" : "16bit"), cpu_speed);	
#endif	
#endif
	return_addr = (unsigned long)FLASH_BASE+CODE_IMAGE_OFFSET;
	ret = check_system_image((unsigned long)FLASH_BASE+CODE_IMAGE_OFFSET,&header, &setting_header);
#if !defined(BK) && !defined(TR)	
	if(ret==0) {
		return_addr = (unsigned long)FLASH_BASE+CODE_IMAGE_OFFSET2;		
		ret=check_system_image((unsigned long)FLASH_BASE+CODE_IMAGE_OFFSET2,  &header, &setting_header);
	}
	if(ret==0) {
		return_addr = (unsigned long)FLASH_BASE+CODE_IMAGE_OFFSET3;				
		ret=check_system_image((unsigned long)FLASH_BASE+CODE_IMAGE_OFFSET3,  &header, &setting_header);
	}			
#endif	

#ifdef TR	
	return_rootfs_status=check_rootfs_image((unsigned long)FLASH_BASE+ROOT_FS_OFFSET);
#else			
	if(ret==2)
	{
		ret=check_rootfs_image((unsigned long)FLASH_BASE+ROOT_FS_OFFSET);
		if(ret==0)
		ret=check_rootfs_image((unsigned long)FLASH_BASE+ROOT_FS_OFFSET+ROOT_FS_OFFSET_OP1);
		if(ret==0)
		ret=check_rootfs_image((unsigned long)FLASH_BASE+ROOT_FS_OFFSET+ROOT_FS_OFFSET_OP1+ROOT_FS_OFFSET_OP2);
	}
#endif
			
#if defined(RTL865X) || defined(RTL8196B)
	Init_GPIO();
#endif

#ifdef TR
	if (return_rootfs_status && ret)
#else
	if(ret)
#endif	
	{
		switch(user_interrupt(WAIT_TIME_USER_INTERRUPT))
		{
		case 0:
		default:
			word_ptr = (unsigned short *)&header;
			for (i=0; i<sizeof(IMG_HEADER_T); i+=2, word_ptr++)
				*word_ptr = rtl_inw(return_addr + i);
			
			// move image to SDRAM
			flashread( header.startAddr,	(unsigned int)(return_addr-FLASH_BASE+sizeof(header)), 	header.len-2);
			
			if ( !user_interrupt(0) )  // See if user escape during copy image
			{
				outl(0,GIMR0); // mask all interrupt
				Set_GPIO_LED_OFF();
#if defined(RTL8196B)
				REG32(0xb8010000)=0xe4000000;
#endif
				prom_printf("Jump to image start=0x%x...\n", header.startAddr);
				jump = (void *)(header.startAddr);
				
				cli();
				flush_cache(); 
				jump();				 // jump to start
			}
			/*i think i can comment this break*/
			/*if user_interrupt, then go to case 1 is ok too*/
			/*if user_not interrupt, then jump() to start linux image.*/
			//break;
		case 1:
			prom_printf("\n--- Escape booting by user\n");
#if defined(RTL8196B)
			REG32(0xb8000030)=REG32(0xb8000030)&(0xFFFFFFFF-0x00000380);
#endif
			#ifdef RTL_8652_5PORT
			ProbeP5GigaPHYChip();		
			ProbeP1toP4GigaPHYChip();
			#endif
			cli();
			Set_GPIO_LED_ON();
			
			eth_startup(0);
			sti();
			tftpd_entry();
#ifdef DHCP_SERVER			
			dhcps_entry();
#endif
#ifdef HTTP_SERVER
			httpd_entry();
#endif
			monitor();
			break;
		case 2: //Backup mode 
			cli();
			Set_GPIO_LED_OFF();
			eth_startup(0);
			sti();
#if defined(RTL8196B)
                        REG32(0xb8000030)=REG32(0xb8000030)&(0xFFFFFFFF-0x00000380);
#endif
#if defined(RTL8196B)
	                prom_printf("\n Entry Backup Mode System \n");
		        eth_backup_mode = 1;
			do_httpd();
#endif
			break;
		}/*switch case */
	}/*if image correct*/
	else
	{
#ifdef RTL_8652_5PORT
	ProbeP5GigaPHYChip();		
	ProbeP1toP4GigaPHYChip();
#endif
		cli();
		eth_startup(0);	
		sti();
		prom_printf("Do not exist Image and Root File system!\n");
		eth_backup_mode = 1;
		do_httpd();
#if defined(RTL8196B)
		REG32(0xb8000030)=REG32(0xb8000030)&(0xFFFFFFFF-0x00000380);
#endif
		tftpd_entry();
#ifdef DHCP_SERVER			
		dhcps_entry();
#endif
#ifdef HTTP_SERVER
		httpd_entry();
#endif
		monitor();
	}
}

unsigned char tempBuffer[8*1024];

// return,  0: not found, 1: linux found, 2:linux with root found
static int check_system_image(unsigned long addr,IMG_HEADER_Tp pHeader,SETTING_HEADER_Tp setting_header)
{
	// Read header, heck signature and checksum
	int i, ret=0;
	unsigned short sum=0, *word_ptr;
	unsigned short length=0;
	unsigned short temp16=0;

        /*check firmware image.*/
	word_ptr = (unsigned short *)pHeader;
	for (i=0; i<sizeof(IMG_HEADER_T); i+=2, word_ptr++)
		*word_ptr = rtl_inw(addr + i);

	if (!memcmp(pHeader->signature, FW_SIGNATURE, SIG_LEN))
		ret=1;
	else if  (!memcmp(pHeader->signature, FW_SIGNATURE_WITH_ROOT, SIG_LEN))
		ret=2;
	else 
		prom_printf("no sys signature at %X!\n",addr-FLASH_BASE);
	
	if (ret) {
		for (i=0; i<pHeader->len; i+=2) {
			sum += rtl_inw(addr + sizeof(IMG_HEADER_T) + i);
		}	
		if ( sum ) {
			prom_printf("sys checksum error at %X!\n",addr-FLASH_BASE);
			ret=0;
		}
	}
	return (ret);
}

static int check_rootfs_image(unsigned long addr)
{
	// Read header, heck signature and checksum
	int i;
	unsigned short sum=0, *word_ptr;
	unsigned long length=0;
	unsigned char tmpbuf[16];	
	#define SIZE_OF_SQFS_SUPER_BLOCK 640
	#define SIZE_OF_CHECKSUM 2
	#define OFFSET_OF_LEN 2
	
	word_ptr = (unsigned short *)tmpbuf;
	for (i=0; i<16; i+=2, word_ptr++)
		*word_ptr = rtl_inw(addr + i);

	if ( memcmp(tmpbuf, SQSH_SIGNATURE, SIG_LEN)) {
		prom_printf("no rootfs signature at %X!\n",addr-FLASH_BASE);
		return 0;
	}
	length = *(((unsigned long *)tmpbuf) + OFFSET_OF_LEN) + SIZE_OF_SQFS_SUPER_BLOCK + SIZE_OF_CHECKSUM;
	for (i=0; i<length; i+=2) {
		sum += rtl_inw(addr + i);
	}
	if ( sum ) {
		prom_printf("rootfs checksum error at %X!\n",addr-FLASH_BASE);
		return 0;
	}
	return 1;
}

//------------------------------------------------------------------------------------------
#if defined(RTL865X) || defined(RTL8196B)
int user_interrupt(unsigned long time)
{
	int i;

	int button_press_detected=-1;
	int tickStart=0;
	tickStart=get_timer_jiffies();
	//prom_printf("user_interrupt !! \n");
	do {
		if  (Check_UART_DataReady() )
		{
	   		i=Get_UART_Data();
			Get_UART_Data();
            		if( i == ESC )
		       { 
		      		prom_printf("User Press ESC Break Key\r\n");
		       		return 1;
            		}
		}
                if (button_press_detected == -1 ||  button_press_detected == 1) 
		{
#if defined(RTL8196B)
			REG32(RTL_GPIO_MUX) = 0x300;
			REG32(PABCDCNR_REG) = REG32(PABCDCNR_REG)& (~(1<<0) ); //set byte F GPIO7 = gpio
			REG32(PABCDDIR_REG) = REG32(PABCDDIR_REG) & (~(1<<0) );  //0 input, 1 out
#endif	
				//prom_printf("Check push button !\n");
                                if ( Get_GPIO_SW_IN() ) 	
				    {// button pressed
				    	//prom_printf("User Press GPIO Break Key\r\n");
                                        button_press_detected = 1;
					return 2;	//wei add				
                                }
                                else
                                        button_press_detected = 0;
					//prom_printf("button_press_detect = %d \n",button_press_detected);
                }
	} 
	while ( (get_timer_jiffies() - tickStart) < 100  );  // 1 sec
	//prom_printf("button press value = %d \n",button_press_detected);
        if (button_press_detected > 0)
                return 1;
	return 0;
}
#endif

//------------------------------------------------------------------------------------------
 /*Boot Code*/
 /******region 0x0000******/
 /**********************/
 /*16k                 */
 /*            0x4000  */
 /**********************/
 /* 8k                 */
 /*            0x6000  */
 /**********************/
 /******region 0x6000******/

 /**********************/
 /* 8k                 */
 /*            0x8000  */
 /**********************/


 /*            from   0x6000*/
 /*First 1K      to   0x6400*/
 /***************************/
 /*            from   0x6400*/
 /*Next  7K      to   0x8000*/
 /***************************/


 /***************************/
 /* 32k        from   0x8000*/
 /*              to   0x10000*/
 /****************************/

// Cyrus: now check system image will become 3 steps...
// Cyrus: first: first sector, second second sector.
// Cyrus --------------------------------------------------------------------
/*this 8K sector will be Hardware and Default Software setting*/
int check_setting_image(unsigned long addr, SETTING_HEADER_Tp pHeader,char * type)
{
	int i;
	unsigned short *word_ptr;

	unsigned char TARGET;
	unsigned char sum=0;
	word_ptr = (unsigned short *)pHeader;
        /*Get the Header back from FLASH, and we have to use 16-bit access*/
	for (i=0; i<sizeof(SETTING_HEADER_T); i+=2, word_ptr++)
		{
		 *word_ptr = rtl_inw(addr + i);
		 //prom_printf("Read %X\n",*word_ptr);
                 }

	/*Check the Header signature */
	if (memcmp(pHeader->Tag, type,2)) {
		prom_printf("no tag! type %X,%X\n",*type,*(type+1));
		return 0;
	}

	/*Check the setting checksum*/
	for(i=0;i<pHeader->len;i++)/*plus the last byte checksum*/
	   {
	    if ( flashread((unsigned long)&TARGET,addr-(unsigned long)FLASH_BASE+sizeof(SETTING_HEADER_T)+i,1) )
	        {
	         sum=sum+TARGET;
	        //prom_printf("%X,%X,%X\n",TARGET,i,sum);
	        }

	    else
	        return 0;
	   }

            //prom_printf("%X\n",sum);

	if (sum) {
		prom_printf("data checksum error! type %X,%X\n",*type,*(type+1));
		return 0;
	}
        //prom_printf("OK\n");
        if( type == SW_SIGNATURE_C)
          {
           /*Go get the version number.*/
           CSversion=rtl_inw((unsigned long)FLASH_BASE+CS_IMAGE_OFFSET+2);
           //prom_printf("additional check for CSversion %X!\n",CSversion);
           if(DSversion!=CSversion)
              {
               prom_printf("current version error, restore default setting\n");
               return 0;
              }
          }
	return 1;
}
