#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/random.h>
#include <asm/bitops.h>
#include <asm/bootinfo.h>
#include <asm/irq.h>
#include <asm/mipsregs.h>
#include <asm/system.h>
#include <linux/circ_buf.h>
#include <asm/io.h>
#include <asm/rtl865x.h>

#include "etherboot.h"
#include "nic.h"
#include "ethInt_865x.h"  
#include <rtl_types.h>
#include <rtl8650/swCore.h>
#include <rtl8650/swNic_poll.h>
#include <rtl8650/vlanTable.h>


#include "../httpd/uip.h"
#include "../httpd/uip_arp.h"
#define BUF ((struct uip_eth_hdr *)&uip_buf[0])

#define BUF_OFFSET 	4	// descriptor offset of data BUFFER
#define DATA_OFFSET	2	// real data offset of Rx packet in buffer

#define NUM_DESC	2//16//64 //wei del
#define BUF_SIZE	1600	// Byte Counts

typedef struct {
	unsigned long    StsLen;
	unsigned long    DataPtr;
 	unsigned long    VLan;
 	unsigned long    Reserved;	
}desc_t;

struct statistics
{
	unsigned int txpkt;
	unsigned int rxpkt;
	unsigned int txerr;
	unsigned int rxerr;
	unsigned int rxffov;
		
};

struct eth_private
{
	unsigned int nr;
	unsigned int io_addr;
	unsigned int irq;
	unsigned int num_desc;
	Int32 rx_descaddr;
	Int32 tx_descaddr;
	Int32 tx_skbaddr[NUM_DESC];	
	Int32 rx_skbaddr[NUM_DESC];
	struct statistics  res;
	unsigned int cur_rx;
	unsigned int cur_tx;
};

//--------------------------------------------------------------------------------------------
void eth_interrupt(int irq, void *dev_id, struct pt_regs *regs);
void eth_polltx(int etherport);
void SetOwnByNic(Int32* header, int len, int own,int index);
void prepare_txpkt(int etherport,Int16 type,Int8* destaddr,Int8* data ,Int16 len); 

//--------------------------------------------------------------------------------------------

extern void kick_tftpd(void);
extern struct nic nic;
extern struct arptable_t  arptable_tftp[3];
extern int32 swCore_init();
extern void flush_cache(void);
extern void ddump(unsigned char * pData, int len);
//--------------------------------------------------------------------------------------------

char eth0_mac[6]={0x56, 0xaa, 0xa5, 0x5a, 0x7d, 0xe8};
char eth0_mac_httpd[6]={0};
char eth0_ip_httpd[4]={0};
int eth_backup_mode=0;

static Int8 ETH0_tx_buf[NUM_DESC][BUF_SIZE];
static int ETH0_IRQ=15; //wei add for 8196 sw
static unsigned long ETH0_ADD=0x18000;
static struct eth_private ETH[2];
static struct irqaction irq_eth15 = {eth_interrupt, 0, 15,"eth0", NULL, NULL};  
//--------------------------------------------------------------------------------------------

void eth_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
	int status=*(volatile Int32*)(0xb801002c);
	*(volatile Int32*)(0xb801002c)=status;
/*	
  	while (swNic_receive((void **)&nic.packet, &nic.packetlen) == 0) 
  	{
  		swNic_txDone();
		kick_tftpd();  	
  	}
*/
	if(swNic_receive((void **)&nic.packet, &nic.packetlen)==0) {
		if(!eth_backup_mode){ //tftp Mode
			 swNic_txDone();
			 kick_tftpd();
		} else {	      //Backup Mode
			memcpy(BUF, nic.packet, nic.packetlen);
			uip_len = nic.packetlen;
			if ( BUF->type == htons(UIP_ETHTYPE_IP) ) {
				uip_input();
				if ( uip_len > 0 ){
					httpd_eth_send(UIP_ETHTYPE_IP);
					swNic_txDone();
				}
			} else if (BUF->type == htons(UIP_ETHTYPE_ARP) ) {
				uip_arp_arpin();
				if ( uip_len > 0 ) {
					httpd_eth_send(UIP_ETHTYPE_ARP);
					swNic_txDone();
				 }
			}
		}
	}

	swNic_txDone();
}
//---------------------------------------------------------------------------------------

void gethwmac(unsigned char *mac)
{
	unsigned char tmpbuf[6];
	unsigned short len;
	unsigned char *buf;
	unsigned char sum=0;
	int i;
	
	if (flashread(tmpbuf, HW_SETTING_OFFSET,6)==0 ) {
		return;
	}
	if(tmpbuf[0] == 'h')
	{
		memcpy(&len, &tmpbuf[4], 2);
		if(len > 0x2000)
			return;
		if(NULL==(buf=(unsigned char *)malloc(len)))
			return;
		flashread(buf,HW_SETTING_OFFSET+6,len);
		if(len != 0 && len <= 0x2000) {					
			for (i=0;i<len;i++) 
				sum += buf[i];
		}
		else
			sum=1;
		if(0 == sum)
		{			
			memcpy(mac,buf+HW_NIC0_MAC_OFFSET,6);
			if(memcmp(mac,"\x0\x0\x0\x0\x0\x0", 6) && !(mac[0] & 0x1))
			{
				/*normal mac*/
			}
			else
			{
				memset(mac,0x0,6);
			}
		}
		if(buf)
			free(buf);
	}
	return;
}
void getmacandip(unsigned char *mac,unsigned char *ip)
{
	unsigned char tmpbuf[6];
	unsigned short len;
	unsigned char *buf;
	unsigned char sum=0;
	int i;
	
	if (flashread(tmpbuf, CURRENT_SETTING_OFFSET,6)==0 ) {
		return;
	}
#if defined(RTL8196B)
	 if(tmpbuf[0] == '6')
#else
	if(tmpbuf[0] == 'c')
#endif
	{
		/*current setting*/
		memcpy(&len, &tmpbuf[4], 2);
		if(len > 0x4000)
			return;
		/*alloc mem for reading current setting*/
		if(NULL==(buf=(unsigned char *)malloc(len)))
			return;
		flashread(buf,CURRENT_SETTING_OFFSET+6,len);
		if(len != 0 && len <= 0x4000) {					
			for (i=0;i<len;i++) 
				sum += buf[i];
		}
		else
			sum=1;
		if(0 == sum)
		{			
			/*check sum ok*/
			memcpy(ip,buf+CURRENT_IP_ADDR_OFFSET,4);
			memcpy(mac,buf+CURRENT_ELAN_MAC_OFFSET,6);
			if(memcmp(ip,"\x0\x0\x0\x0",4) && !(0xFF==ip[3] ||0x0==ip[3]))
			{
				/*normal ip*/
				if(memcmp(mac,"\x0\x0\x0\x0\x0\x0", 6) && !(mac[0] & 0x1))
				{
					/*normal mac*/
				}
				else
				{
					/*bad mac. user hw setting mac*/
					gethwmac(mac);
				}
			}
			else
			{
				/*use hard code 192.168.1.6*/
				memset(ip,0x0,4);
			}
		}
		if(buf)
			free(buf);
	}
}
//----------------------------------------------------------------------------------------
uint32 rx[6] = {8, 0, 0, 0, 0, 0};
uint32 tx[2] = {4, 2};
void eth_startup(int etherport)
{
	Int32 val;
#ifdef TR
	unsigned char tmpbuf[256];
	unsigned short len;
	unsigned char sum=0;
	int i;
	// try to use eth0 mac address in hw-setting, it should be done before init swCore
	flashread(tmpbuf, 0x6000, 256);
	
	if (tmpbuf[0] == 'h' ) {
		memcpy(&len, &tmpbuf[4], 2);
		if (len != 0 && len <= 256) {					
			for (i=4+2; i<4+2+len; i++) 
				sum += tmpbuf[i];
		}
		else
			sum = 1;		
		if (sum == 0 && memcmp(&tmpbuf[4+2+1], "\x0\x0\x0\x0\x0\x0", 6)) {
			memcpy(arptable_tftp[0].node, &tmpbuf[4+2+1], 6);
			memcpy(eth0_mac, &tmpbuf[4+2+1], 6);
#if defined(RTL8196B)
			memcpy(&(uip_ethaddr.addr), &tmpbuf[4+2+1], 6);
#endif 

		}
	}		
#endif

	/*try to figure out http mac and ip*/
	getmacandip(eth0_mac_httpd,eth0_ip_httpd);
	
	if (swCore_init()) {  	
		printf("\nSwitch core initialization failed!\n");        
		return;
	}
    
	

	/* Initialize NIC module */
	if (swNic_init(rx, 8, tx, MBUF_LEN)) {
		printf("\nSwitch nic initialization failed!\n");            
		return;
	}

    	rtl_vlan_param_t vp;
    	int32 ret;
	rtl_netif_param_t np;
	rtl_acl_param_t ap;
	
	/* Create Netif */
	bzero((void *) &np, sizeof(rtl_netif_param_t));
	np.vid = 8;
	np.valid = 1;
	np.enableRoute = 0;
	np.inAclEnd = 0;
	np.inAclStart = 0;
	np.outAclEnd = 0;
	np.outAclStart = 0;
	memcpy(&np.gMac, &eth0_mac[0], 6);

	np.macAddrNumber = 1;
	np.mtu = 1500;
	ret = swCore_netifCreate(0, &np);
	if (ret != 0) {
		printf( "Creating intif fails:%d\n", ret );
		return;
	}

	/* Create vlan */
	bzero((void *) &vp, sizeof(rtl_vlan_param_t));
	vp.egressUntag = ALL_PORT_MASK;
	vp.memberPort = ALL_PORT_MASK;
	ret = swCore_vlanCreate(8, &vp);
	if (ret != 0) {       
		printf( "Creating vlan fails:%d\n", ret );
       		return;
	}

    /* Set interrupt routing register */
	REG32(IRR1_REG) |= (3<<28); 
	
 	request_IRQ(ETH0_IRQ, &irq_eth15,&(ETH[0]));
}

//----------------------------------------------------------------------------------------
/*Just a start address, and the data length*/
void prepare_txpkt(int etherport, Int16 type, Int8* destaddr, Int8* data, Int16 len) 
{
	char *tx_buffer=&ETH0_tx_buf[0][0];
 	Int16 nstype;	
	int Length=len;
	
	memcpy(tx_buffer,destaddr,6);

	/*Source Address*/
	memcpy(tx_buffer+6,eth0_mac,6);

	/*Payload type*/
	nstype = htons(type);
	memcpy(tx_buffer + 12,(Int8*)&nstype,2);

	/*Payload */
	memcpy(tx_buffer + 14,(Int8*)data,Length);
	Length += 14;

	swNic_send(tx_buffer,Length);
}

//----------------------------------------------------------------------------------------
extern Int8 one_tftp_lock;
void eth_listening()
{
	int tftp_status=0;

   while(1)
   {
		if (swNic_receive((void **)&nic.packet, &nic.packetlen)== 0) {
	 		kick_tftpd();

			if (one_tftp_lock==1 && tftp_status==0)
				tftp_status=1;  //start
			if (one_tftp_lock==0 && tftp_status==1)
					tftp_status=2;	//end	
			swNic_txDone();					
	  	}
		if (tftp_status==2)
			break;
   }
}

