#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel_stat.h>
#include <linux/types.h>
#include <linux/interrupt.h>
#include <linux/random.h>
#include <asm/bitops.h>
#include <asm/bootinfo.h>
#include <asm/irq.h>
#include <asm/mipsregs.h>
#include <asm/system.h>
#include <linux/circ_buf.h>
#include <asm/rtl8181.h>
#include <asm/io.h>

#include "etherboot.h"

#include "nic.h"

#include "eth8670.h"  
extern void _rom_flush_cache();



#define BUF_OFFSET 	4	// descriptor offset of data BUFFER
#define DATA_OFFSET	2	// real data offset of Rx packet in buffer
				// why? don't ask me

int ETH0_IRQ=26; //wei add
unsigned long ETH0_ADD=0x18000;

/*8196 ETH0 start address is 0xb801 8000*/
/*in asm/io.h, #define mips_io_port_base 0xb8000000 */
/*so ETH0 base address is 0x18000*/

/*As in the eth.c, David changed them into ethernet address base rtl_in,out*/
/*Except we define #undef rtl_inb,rtl_inw...*/
/*here is the general rtl_in..just defined in rtl8181.h*/

//#define ETH0_ADD 0x18000
//#define ETH0_IRQ 5

#define NUM_DESC	16//64 //wei del
#define BUF_SIZE	1600	// Byte Counts

static Int32 ETH0_DESC_BASE[2048];/*that is 8k*/


char eth_dummy[256];
static Int8 ETH0_tx_buf[NUM_DESC][BUF_SIZE];
static Int8 ETH0_rx_buf[NUM_DESC][BUF_SIZE];


char eth0_mac[6]={0x56, 0xaa, 0xa5, 0x5a, 0x7d, 0xe8};


typedef struct
{/*
	Int32 header;
	Int32 tag;
	Int32 addr;
	Int32 dummy;
*/
               unsigned long    StsLen;
               unsigned long    DataPtr;
               unsigned long    VLan;
               unsigned long    Reserved;	
}desc_t;



struct statistics
{
	unsigned int txpkt;
	unsigned int rxpkt;
	unsigned int txerr;
	unsigned int rxerr;
	unsigned int rxffov;
		
};

struct eth_private
{
	unsigned int nr;
	unsigned int io_addr;
	unsigned int irq;
	unsigned int num_desc;
	Int32 rx_descaddr;
	Int32 tx_descaddr;
	Int32 tx_skbaddr[NUM_DESC];	
	Int32 rx_skbaddr[NUM_DESC];
	struct statistics  res;
	unsigned int cur_rx;
	unsigned int cur_tx;
};


extern void flush_cache(void);
extern void flush_icache(void);
extern void flush_dcache(void);
extern void flush_WBcache(void);
static struct eth_private ETH[2];

void eth_interrupt(int irq, void *dev_id, struct pt_regs *regs);
void rtl8139_rx_interrupt (struct eth_private *p_ETH, Int32 ioaddr);
void rtl8139_tx_interrupt (struct eth_private *p_ETH, Int32 ioaddr);
struct irqaction irq_eth26 = {eth_interrupt, NULL, 26,"eth0", NULL, NULL};                                   
struct irqaction irq_eth5 = {eth_interrupt, NULL, 5,"eth1", NULL, NULL};                                   


void eth_desc_init(int etherport);
void eth_hw_reset(int etherport);
void eth_hw_test(int etherport);
void eth_driver_object_init(void);
void eth_polltx(int etherport);
void SetOwnByNic(Int32* header, int len, int own,int index);

void parse_rxpkt(Int32 payload_start,Int32 length);
void prepare_txpkt(int etherport,Int16 type,Int8* destaddr,Int8* data ,Int16 len); 

void miiar_write(unsigned char phyaddr,unsigned char regaddr,unsigned short value); //wei add
void miiar_read(unsigned char phyaddr,unsigned char regaddr,unsigned short *value); //wei add
//void eth_startup(int etherport);
unsigned int iocmd_reg;
void re8670_stop_hw(int etherport); //wei add




extern void kick_tftpd(void);
extern struct nic nic;
extern struct arptable_t  arptable_tftp[3];
//--------------------------------------------------------------------------------------------

void eth_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
 /*From dev_id, we will understand which ethernet functions.*/
 Int32 ioaddr;
 Int32 status;
 Int32 val;

 dprintf("IRQ in\n\r");

 struct eth_private *p_ETH; /*this is the ethernet port object*/
 p_ETH = (struct eth_private *)dev_id;
 ioaddr = p_ETH->io_addr;
 
 //prom_printf("***ETH=%x \n",p_ETH);
 status = rtl_inw(ioaddr + NIC_ISR);
 //rtl_outw(ioaddr+NIC_ISR, status);   /*This is ACK the NIC INTERRUPT*/
//prom_printf("INT status=%x\n", status);

 /*status kept here is the REGISTER*/
        	
	if (status & (RxOk |  RxDescUn | RxFIFOFULL | RxERRUNT ))/* Rx interrupt */       
	{	//val=rtl_inl(ioaddr + GIMR0); //wei add
		//rtl_outl(ioaddr + GIMR0, val&(~(1<<ETH0_IRQ)));	//wei add
		rtl8139_rx_interrupt (p_ETH, ioaddr);                                          
	}
	//if (status & (TxOk |  TxDescUn | TxErr))  //wei dell
	if (status & (  TxDescUn )) 
		rtl8139_tx_interrupt (p_ETH, ioaddr);  


	//status = rtl_inw(ioaddr + NIC_ISR);	//wei add
	 rtl_outw(ioaddr+NIC_ISR, status);   /*This is ACK the NIC INTERRUPT*/
dprintf("IRQ out\n");
												
}


//--------------------------------------------------------------------------------------------



//--------------------------------------------------------------------------------------------
void rtl8139_rx_interrupt (struct eth_private *p_ETH, Int32 ioaddr)
{
 Int32 addr,i,status,payaddr;
 Int32 rx_size;
 Int32 val;	


 for(i=0; i< NUM_DESC; i++)
 {
   /*First flush cache*/

       //flush_cache();	   
   //_rom_flush_cache();
//     flush_icache();
//     prom_printf("flush_icache\n");     
//     flush_dcache();
//     prom_printf("flash_cache\n"); 
//cli(); 
  // prom_printf("-Eth=%x \n",p_ETH);
   addr    = (p_ETH->rx_descaddr) + (p_ETH->cur_rx) * 16;
   dprintf("Desc addr = %x \n",addr); 

   //payaddr = (Int32) p_ETH->rx_skbaddr[(p_ETH->cur_rx)];   
   desc_t  *p=(desc_t *)(ETH[0].rx_descaddr+i*16);
   payaddr=Physical2Virtual((Int32)p->DataPtr) ; 

   
    //if ((payaddr < &ETH0_rx_buf[0][0]) || (payaddr >= &ETH0_rx_buf[NUM_DESC-1][BUF_SIZE-1])) 
   //dprintf(" ptr %x invalid, should be %x < ptr < %x\n\r", payaddr, (Int32)&ETH0_rx_buf[0][0], (Int32)&ETH0_rx_buf[NUM_DESC-1][BUF_SIZE-1]);


   status = *(volatile Int32*)(addr);
    rx_size = status & RXLENMASK; 
   dprintf("Desc status = %x \n",status);


   
#if 1
	{
	int i;
	Int8 *sbuf = addr;
	Int32 len=16;
	
		for(i=0;i<len; i++)
		{
			if((i%4)==0)
				dprintf("\n\r");
			dprintf("%02x ", sbuf[i]);
		}
		dprintf("\n\r");
	}
#endif
#if 1
	{
	int i;
	Int8 *sbuf = payaddr;
	Int32 len=rx_size;
	
		for(i=0;i<len; i++)
		{
			if((i%16)==0)
				dprintf("\n\r");
			dprintf("%02x ", sbuf[i]);
		}
		dprintf("\n\r");
	}
#endif

   


   
   if (status & OWNBYNIC)
       {
       //dprintf("Fake interrupt! \n");
       break;/*Due to fake interrupt, perhaps already done the job*/
        }
   if (status & (RXFAE | RXWT | RXES | RXUNT | RXCRC))
	{
	 prom_printf("rx err %X\n", status);
#if 1
         SetOwnByNic((Int32*)(Virtual2NonCache(addr))   ,BUF_SIZE     ,OWNBYNIC     ,p_ETH->cur_rx);	
         *(volatile Int32 *)(Virtual2NonCache(addr+BUF_OFFSET))= Physical2NonCache(payaddr);//Virtual2Physical(payaddr);
         p_ETH->cur_rx++;
         if (p_ETH->cur_rx==p_ETH->num_desc)
             p_ETH->cur_rx=0;
         continue;
#endif
	}		
   /*From here, below is the RxOK INT case*/
   /*IF the packet size ok, we will parse the packet.*/
   rx_size = status & RXLENMASK;    
   //dprintf("rx packet size = %d \n",rx_size);   

   if ((rx_size < 60) || (rx_size > 1514 + 4)) /*minimum size 60, maximum size 1518*/
        {
	 prom_printf("size err!\n");
#if 1	 
         SetOwnByNic((Int32*)(Virtual2NonCache(addr))  ,BUF_SIZE    ,OWNBYNIC       ,p_ETH->cur_rx);	
         *(volatile Int32 *)(Virtual2NonCache(addr+BUF_OFFSET))=Physical2NonCache(payaddr); //Virtual2Physical(payaddr);
		 
         p_ETH->cur_rx++;
         if (p_ETH->cur_rx==p_ETH->num_desc)
             p_ETH->cur_rx=0;
         continue;
#endif
	}
   prom_printf("pkt size = %d\n",rx_size); 
   //parse_rxpkt(payaddr+DATA_OFFSET,rx_size);   	//wei del 

   parse_rxpkt(payaddr+0,rx_size);     




   /*after parsing, Clean and Refill to release this descriptor*/  
   SetOwnByNic((Int32*)(Virtual2NonCache(addr))   ,BUF_SIZE      ,OWNBYNIC        ,p_ETH->cur_rx);	
   *(volatile Int32 *)(Virtual2NonCache(addr+BUF_OFFSET))=Physical2NonCache(payaddr);// Virtual2Physical(payaddr);


	//rtl_outb(ioaddr + NIC_RXDESFIN, p_ETH->cur_rx);  //wei add   
   /*Update descriptor index*/
   p_ETH->cur_rx++;
   if (p_ETH->cur_rx==p_ETH->num_desc)
  	 p_ETH->cur_rx=0;   

 }/*For total checks*/



	
 	//val=rtl_inl(ioaddr + GIMR0); //wei add
	//rtl_outl(ioaddr + GIMR0, (val|(1<<ETH0_IRQ)));	//wei add	



}
//----------------------------------------------------------------------------------------
void rtl8139_tx_interrupt (struct eth_private *p_ETH, Int32 ioaddr)
{
/*Tx interrupt, check descriptor state only */
#if 0
	__asm__ volatile(
		"mtc0 $0,$20\n\t"
		"nop\n\t"
		"nop\n\t"
		"li $8,512\n\t"
		"mtc0 $8,$20\n\t"
		"nop\n\t"
		"nop\n\t"
		"mtc0 $0,$20\n\t"
		"nop\n\t"
		"nop"
		: /* no output */
		: /* no input */
			);
#endif


}
//----------------------------------------------------------------------------------------
void eth_driver_object_init(void)
{
/*Initialize the private driver object of each ethernet port*/
 int i;


 ETH[0].nr=0;	
 ETH[0].io_addr=ETH0_ADD;
 ETH[0].irq=ETH0_IRQ;
 ETH[0].num_desc=NUM_DESC; 



 /*First despritor address must 256byte alignment*/
 ETH[0].rx_descaddr = (((Int32)ETH0_DESC_BASE & (~255)) + 256)  | UNCACHE_MASK;
 ETH[0].tx_descaddr = (((Int32)ETH0_DESC_BASE & (~255)) + 1024) | UNCACHE_MASK;


printf("rx_desc addr =%X\n",(Int32) ETH[0].rx_descaddr);	 
printf("tx_desc addr =%X\n",(Int32)ETH[0].tx_descaddr);	 
 printf("tx_buf addr=%X\n",(Int32)ETH0_tx_buf);	 
 printf("rx_buf addr=%X\n",(Int32)ETH0_rx_buf);	 
 

     for(i=0; i< NUM_DESC; i++)
    {
     ETH[0].rx_skbaddr[i]=((Int32)ETH0_rx_buf + i*BUF_SIZE);
     ETH[0].tx_skbaddr[i]=((Int32)ETH0_tx_buf+ i*BUF_SIZE);   

	 //dprintf("rx addr=%x, tx addr=%x\n", ETH[0].rx_skbaddr[i], ETH[0].tx_skbaddr[i]);
    }	

#if 1
	//wei add

	desc_t  *pRxBDPtr=(desc_t *)(ETH[0].rx_descaddr);
 	for(i=0; i< NUM_DESC; i++)
 	{
         //SetOwnByNic((Int32*)(Virtual2NonCache(p))   ,BUF_SIZE     ,OWNBYNIC     ,i);	
        // *(volatile Int32 *)(Virtual2NonCache(p+BUF_OFFSET))= Virtual2NonCache(ETH[0].rx_skbaddr[i]);
		 
		pRxBDPtr[i].StsLen = 2048+0x80000000 + BUF_SIZE;
		pRxBDPtr[i].VLan = 0;
		pRxBDPtr[i].DataPtr = (unsigned long) (ETH[0].rx_skbaddr[i]) | UNCACHE_MASK;
	}
	pRxBDPtr[NUM_DESC-1].StsLen |= ENDOFRING;
#endif
 


 memset(ETH0_rx_buf, 0x0, NUM_DESC*BUF_SIZE);
 memset(ETH0_tx_buf, 0x0, NUM_DESC*BUF_SIZE);
 
 ETH[0].cur_rx=0;
 ETH[0].cur_tx=0;

}
//--------------------------------------------------------------------------------------------
void eth_hw_reset(int etherport)
{
/*Call ethernet registers*/	
/*Different ports just with different base*/
	Int8 *mac;
	Int32 val;
	Int32 ioaddr;
	int i ;

//-------------------------------

	//rtl_outw(ioaddr + NIC_ISR,0xffff);  // clear all interrupt

//---------------------------------	
	ioaddr = ETH[etherport].io_addr;
	mac=eth0_mac;
	memcpy(&val, mac, 4);	
	//setup NIC_ID first:
	val = (val >> 24) | (val << 24) | (((val << 8) >> 24) << 8) | (((val << 16) >> 24) << 16);
	rtl_outl(ioaddr + NIC_ID1, (val));
        prom_printf("ETH %X,%X,%X",ioaddr,NIC_IMR,val);
	memcpy(&val, mac+4, 2);	
	val = (val >> 16) << 16;
	val = (val >> 24) | (val << 24) | (((val << 8) >> 24) << 8) | (((val << 16) >> 24) << 16);
	rtl_outw(ioaddr + NIC_ID2, (val));
	prom_printf(",%X\n",val);
	 
	rtl_outb (ioaddr + NIC_CR, (rtl_inb (ioaddr + NIC_CR)) | BIT(0));
        /* Check that the chip has finished the reset. */
	for (i = 0xffff; i > 0; i--);

	//wei add
	//val=rtl_inb (ioaddr + NIC_CR);
	//printf("NIC_CR=%x\n",val);
	//
	 
	rtl_outl(ioaddr + NIC_MAR1, 0xffffffff);  /*MAR multicase, 8 byte*/
	rtl_outl(ioaddr + NIC_MAR2, 0xffffffff);
	rtl_outl(ioaddr + NIC_TCR, TXNORMAL );
	rtl_outl(ioaddr + NIC_RCR, RXNORMAL );
	
	//rtl_outl(ioaddr + NIC_IOCMD, CMD_CONFIG);
#if 0	
	prom_printf("Run (1)10M or (2)100M \n");
	val = WaitKey();
	val = val - '0';	
	if(val == 2) 
	rtl_outl(ioaddr + NIC_MII,SETPHY100FULL); 
	else
#endif
//	rtl_outl(ioaddr + NIC_MII,SETPHY10FULL); 
	rtl_outl(ioaddr + NIC_MII,SETPHY100FULL); 

	// set 64 descriptors
	//rtl_outb(ioaddr + NIC_RXRINGNO, 2);
	rtl_outb(ioaddr + NIC_RXRINGNO, 0);  //0:16, 1:32, 2:64  //wei add

	rtl_outb(ioaddr + NIC_RXDESFIN, NUM_DESC-1);  //wei add
	rtl_outb(ioaddr + NIC_DESDIFF, 8);  //wei add
	

	
	// here we use low-queue only
	rtl_outl(ioaddr + NIC_TXFDPL, Virtual2Physical(ETH[etherport].tx_descaddr));
	rtl_outl(ioaddr + NIC_TXCDOL,0);	//wei add
	printf("NIC_TXFDPL=%x\n", Virtual2Physical(ETH[etherport].tx_descaddr) );

	rtl_outl(ioaddr + NIC_RXFDP, Virtual2Physical(ETH[etherport].rx_descaddr));
	rtl_outl(ioaddr + NIC_RXCDO,0);	//wei add
	printf("NIC_RXFDP=%x\n", Virtual2Physical(ETH[etherport].rx_descaddr) );
	
	/*Enable Ethernet Mask for different events.*/
	/*If one does not enable GIMR, still no interrupt happened to our CPU*/
	rtl_outw(ioaddr + NIC_IMR,WITHALLINT); 
	
	rtl_outw(ioaddr + NIC_ISR,WITHALLINT);
        
	rtl_outl(ioaddr + NIC_IOCMD, CMD_CONFIG);
}

//--------------------------------------------------------------------------------------------


/*
static void eth_init_hw (int etherport)	//wei add
{

	u8 status;
	// Kao
	u32 *hwaddr, sicr;
	int i;
	unsigned short regValue;
	unsigned int value;
	ioaddr = ETH[etherport].io_addr;

	eth_hw_reset2(cp);
	
	rtl_outw(ioaddr + NIC_ISR,0xffff);
	rtl_outw(ioaddr + NIC_IMR,	RX_OK | RX_ERR | RX_EMPTY | RX_FIFOOVR |TX_EMPTY;);   	
	rtl_outl(RxFDP,(u32)(cp->rx_ring));	

	rtl_outw(RxCDO,0);
	rtl_outl(TxFDP1,(u32)(cp->tx_hqring));	

	rtl_outw(TxCDO1,0);	
	rtl_outl(TxFDP2,(u32)cp->tx_lqring);
	rtl_outw(TxCDO2,0);
	// Kao
	//RTL_W32(RCR,AcceptAll);		
	rtl_outl(TCR,(u32)(0x0C00));
	rtl_outb(Rx_Pse_Des_Thres,THVAL);
	rtl_outb(EthrntRxCPU_Des_Num,RE8670_RX_RING_SIZE-1);
	rtl_outb(RxRingSize,RINGSIZE);	
	status = rtl_inb(MSR);
	status = status & ~(TXFCE | RXFCE | FORCE_TX);
	rtl_outb(MSR,status);
	// Kao, set hw ID for physical match
	hwaddr = (u32 *)cp->dev->dev_addr;
	rtl_outl(IDR0, *hwaddr);
	hwaddr = (u32 *)(cp->dev->dev_addr+4);
	rtl_outl(IDR4, *hwaddr);
	// Jenny, for internal PHY ethernet LED; set value 101=>Link+Act: On=Link, Off=No link, Flash=Tx or Rx activity
	rtl_outl(MIIAR, FLAG_READ | (1<<MII_PHY_ADDR_SHIFT) | (31 <<MII_REG_ADDR_SHIFT) | (0x0000<<MII_DATA_SHIFT));
	while (!(rtl_inl(MIIAR) & 0x80000000));
	value = rtl_inl(MIIAR);
	regValue = (unsigned short)(value & 0xffff);
	rtl_outl(MIIAR, FLAG_WRITE | (1<<MII_PHY_ADDR_SHIFT) | (31<<MII_REG_ADDR_SHIFT) | (((regValue & 0xfff8) | 0x0005)<<MII_DATA_SHIFT));
	re8670_start_hw(cp);
	__re8670_set_rx_mode(dev);

}
*/

//--------------------------------------------------------------------------------------------
#if 1	
void eth_hw_test(int etherport)
{
/*Call ethernet registers*/	
/*Different ports just with different base*/

	Int32 val,val_in;
	Int8* mac;
	/*here we only compare the first 4 bytes of our mac address*/
	Int32 ioaddr;

	ioaddr = ETH[etherport].io_addr;
        mac=eth0_mac;
	memcpy(&val, mac, 4);	
	val = (val >> 24) | (val << 24) | (((val << 8) >> 24) << 8) | (((val << 16) >> 24) << 16);
	val_in = rtl_inl(ioaddr + NIC_ID1);/*this is first 4 bytes.*/
	if( val_in == val )
	  {
	    memcpy(&val, mac+4, 2);	
	    val = (val >> 16) << 16;
	    val = (val >> 24) | (val << 24) | (((val << 8) >> 24) << 8) | (((val << 16) >> 24) << 16);
	    val_in= rtl_inw(ioaddr + NIC_ID2);
            if( val_in != val )
               {
               prom_printf("NIC mac 1-4 error\n");
                goto NICerror;
                }
          }
	else
          {prom_printf("NIC mac 5-6 error\n");
           goto NICerror;
          }
       
       if (rtl_inl(ioaddr + NIC_MAR1)!=0xffffffff)
         {prom_printf("MAR1 error\n");	 
	   goto NICerror;
         }
       val_in= rtl_inl(ioaddr + NIC_IOCMD);
       val_in &= 0x1fffff;
       if(!( val_in == CMD_CONFIG ))
           {prom_printf("NIC_IOCMD error\n");	 
            goto NICerror;
           } 
       
       val_in= rtl_inl(ioaddr + NIC_TXFDPL);
       if( val_in!= Virtual2Physical(ETH[etherport].tx_descaddr))
	  {prom_printf("NIC_TXFDPL error\n");	 
           goto NICerror;
	  }
       
       val_in= rtl_inl(ioaddr + NIC_RXFDP);
       if( val_in!= Virtual2Physical(ETH[etherport].rx_descaddr))
	  {prom_printf("NIC_RXFDP error\n");
           goto NICerror;
	  }
       
       val_in= rtl_inw(ioaddr + NIC_IMR);	      	  
	if(val_in != WITHALLINT)
           {prom_printf("NIC_IMR error, read in=%X\n",val_in);
            goto NICerror;
           }
          prom_printf("NIC register setting Okay\n"); 
return;
NICerror:            
  prom_printf("NIC register setting error\n");
}
#endif
//----------------------------------------------------------------------------------------
void eth_desc_init(int etherport)
{
 int i;
 Int32 addr_rx;

 addr_rx=ETH[0].rx_descaddr;
  
 for(i=0; i< ETH[0].num_desc; i++)
    {
     /*First 4 bytes are despritor header   0*/	
     /*Next  4 bytes are set 0              4*/	
     /*Next  4 bytes are set buffer address 8*/	
     /*Next  4 bytes are set 0             12*/	
     *(volatile Int32 *)(Virtual2NonCache(addr_rx+8)  )=0x00000000;
     *(volatile Int32 *)(Virtual2NonCache(addr_rx+12) )=0x00000000;
     *(volatile Int32 *)(Virtual2NonCache(addr_rx+BUF_OFFSET))
     = Virtual2Physical(ETH[0].rx_skbaddr[i]);         
     SetOwnByNic((Int32*)(Virtual2NonCache(addr_rx))
                                        ,BUF_SIZE
                                        ,OWNBYNIC
                                        ,i);	
     addr_rx += 16;/*16 byte for 1 descriptor. so go next 16 bytes.*/
   
    }
}
//----------------------------------------------------------------------------------------
void eth_polltx(int etherport)
{
/*This function is to kick ethernet to transmit low queue data*/
 rtl_outl( (ETH[0].io_addr+NIC_IOCMD)
           ,rtl_inl(ETH[0].io_addr + NIC_IOCMD)|TXFNL  );
}
//----------------------------------------------------------------------------------------
void SetOwnByNic(Int32* header, int len, int own,int index)
{
  int tmp = (own | FIRSTSEG | LASTSEG | WCRC | len) ;
  if ( index == NUM_DESC - 1)	
      tmp |= ENDOFRING;
  *(volatile Int32 *)header = tmp;
}
//----------------------------------------------------------------------------------------
void eth_startup(int etherport)
{
 Int32 val;


 //------------
 #if 0
	re8670_stop_hw(0); 
 		// use internal PHY, set and restart the MII register
		// reset
		miiar_write(1, 0, 0x8000); //wei add
		// 10/100/H/F flow control
		miiar_write(1, 4, 0x05e1); //wei add
		// restart
		miiar_write(1, 0, 0x1200);	//wei add

 re8670_init_hw(0);		
#else
//---------------
		
 eth_hw_reset(0);	//wei del
#endif
 
 eth_hw_test(0);
 eth_desc_init(0);
 prom_printf("---123-------------------\n");
 if(ETH0_IRQ==26)
 request_IRQ(ETH0_IRQ, &irq_eth26,&(ETH[0]));

 
}

//----------------------------------------------------------------------------------------
/*Just a start address, and the data length*/
void prepare_txpkt(int etherport,Int16 type,Int8* destaddr,Int8* data ,Int16 len) 
{
 Int32 addr,current_tx;
 Int8* tx_buffer;
 Int16 nstype;


	//dprintf("prepare_tx pkt\n\r");
#if 0
	__asm__ volatile(
		"mtc0 $0,$20\n\t"
		"nop\n\t"
		"nop\n\t"
		"li $8,512\n\t"
		"mtc0 $8,$20\n\t"
		"nop\n\t"
		"nop\n\t"
		"mtc0 $0,$20\n\t"
		"nop\n\t"
		"nop"
		: /* no output */
		: /* no input */
			);
#endif




 current_tx= ETH[0].cur_tx; 
 addr = (ETH[0].tx_descaddr + 16*current_tx ); /*Fill descriptor*/ 

ETH[0].tx_skbaddr[current_tx]=((Int32)ETH0_tx_buf+ current_tx*BUF_SIZE);   //wei add
dprintf("ETH[0].tx_skbaddr addr=%x, val=%x\n\r", &ETH[0].tx_skbaddr[0], ETH[0].tx_skbaddr[0]);
 /*Fill Payload*/
 tx_buffer = (Int8*)(ETH[0].tx_skbaddr[current_tx] |UNCACHE_MASK);  // this is cause data invalid if rx use flush
   	



 *(volatile Int32 *)(addr + BUF_OFFSET) =  Physical2NonCache(tx_buffer);//Virtual2Physical(tx_buffer);
 *(volatile Int32 *)(addr + 8) =  0;
 *(volatile Int32 *)(addr + 12)=  0;
 

 /*Destination Address*/ 
  // if ((tx_buffer < &ETH0_tx_buf[0][0]) || (tx_buffer >= &ETH0_tx_buf[NUM_DESC-1][BUF_SIZE-1])) 
  // dprintf(" ptr %x invalid, should be %x < ptr < %x\n\r", tx_buffer, (Int32)&ETH0_tx_buf[0][0], (Int32)&ETH0_tx_buf[NUM_DESC-1][BUF_SIZE-1]);   

 memcpy(tx_buffer,destaddr,6);

 /*Source Address*/
 memcpy(tx_buffer+6,eth0_mac,6);

 /*Payload type*/
 nstype = htons(type);
 memcpy(tx_buffer + 12,(Int8*)&nstype,2);

 /*Payload */
 memcpy(tx_buffer + 14,(Int8*)data,len);
 len += 14;


 /*Padding */
 while (len < 60) /*minimum packet length*/
       {
        tx_buffer[len++] = '\0';
        }



#if 1
	unsigned char *sbuf = tx_buffer;
	int length=60;
	dprintf("tx p=%x, l=%d\n\r", sbuf, length);	
	{
		int i;		
		for(i=0;i<length; i++)
		{
			if((i%16)==0)
				dprintf("\n\r");
			dprintf("%02x ", sbuf[i]);
			//sbuf[i];
		}
		dprintf("\n\r");
	}
#endif





 
 SetOwnByNic((Int32*)(Virtual2NonCache(addr))      ,len     ,OWNBYNIC      ,current_tx);
  /*kick the ethernet to tx*/
  eth_polltx(0);
 /*Update descriptor index*/
  ETH[0].cur_tx++;
  if (ETH[0].cur_tx==ETH[0].num_desc)
  ETH[0].cur_tx=0;

  //dprintf("leave prepare_tx_pkt\n");
}

//----------------------------------------------------------------------------------------
extern void flush_cache();
//----------------------------------------------------------------------------------------
void parse_rxpkt(Int32 payload_start,Int32 length)
{  
 int i;

 	dprintf("nic.packet addr=%x\n",nic.packet);
	if(nic.packet) 	
 		memcpy(nic.packet,(payload_start),length);
	else
	{	dprintf("error not allocate nic.packet\n");
		nic.packet=payload_start; //wei add
	}
	
 
 nic.packetlen=length;

 kick_tftpd();
}















